/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Color;
import com.supermap.data.ColorGradientType;
import com.supermap.data.DatasetGrid;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandle;
import com.supermap.data.Toolkit;
import com.supermap.mapping.RangeMode;
import com.supermap.mapping.Theme;
import com.supermap.mapping.ThemeGridRangeItem;
import com.supermap.mapping.ThemeGridRangeNative;
import com.supermap.mapping.e;
import com.supermap.mapping.l;
import com.supermap.mapping.u;
import java.util.ArrayList;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ThemeGridRange
extends Theme {
    private ArrayList a = null;

    public ThemeGridRange() {
        long l2 = ThemeGridRangeNative.jni_New();
        this.setHandle(l2, true);
        this.a = new ArrayList();
    }

    public ThemeGridRange(ThemeGridRange themeGridRange) {
        if (themeGridRange == null) {
            String string2 = u.a("themeGridRange", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string2);
        }
        if (themeGridRange.getHandle() == 0L) {
            String string3 = u.a("themeGridRange", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        long l2 = ThemeGridRangeNative.jni_Clone(themeGridRange.getHandle());
        this.setHandle(l2, true);
        this.a = new ArrayList();
        int n2 = themeGridRange.a().size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ThemeGridRangeItem themeGridRangeItem = new ThemeGridRangeItem(this);
            this.a.add(themeGridRangeItem);
        }
    }

    ThemeGridRange(long l2, boolean bl) {
        this.setHandle(l2, bl);
        this.a = new ArrayList();
        int n2 = this.getCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ThemeGridRangeItem themeGridRangeItem = new ThemeGridRangeItem(this);
            this.a.add(themeGridRangeItem);
        }
    }

    public RangeMode getRangeMode() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getRangeMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        int n2 = ThemeGridRangeNative.jni_GetRangeMode(this.getHandle());
        return (RangeMode)Enum.parse(RangeMode.class, (int)n2);
    }

    public ThemeGridRangeItem getItem(int n2) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (n2 < 0 || n2 >= this.getCount()) {
            String string3 = u.a("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        return (ThemeGridRangeItem)this.a.get(n2);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        int n2 = ThemeGridRangeNative.jni_GetCount(this.getHandle());
        int n3 = 0;
        n3 = n2 == 0 || n2 == 1 ? 0 : n2 - 1;
        return n3;
    }

    public boolean addToHead(ThemeGridRangeItem themeGridRangeItem) {
        return this.addToHead(themeGridRangeItem, false);
    }

    public boolean addToTail(ThemeGridRangeItem themeGridRangeItem) {
        return this.addToTail(themeGridRangeItem, false);
    }

    public boolean addToHead(ThemeGridRangeItem themeGridRangeItem, boolean bl) {
        int n2;
        if (this.getHandle() == 0L) {
            String string2 = u.a("addToHead(ThemeGridRangeItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (themeGridRangeItem.getStart() >= themeGridRangeItem.getEnd()) {
            if (bl) {
                if (Toolkit.isZero((double)(themeGridRangeItem.getStart() - themeGridRangeItem.getEnd()))) {
                    return false;
                }
                Double d2 = themeGridRangeItem.getStart();
                themeGridRangeItem.setStart(themeGridRangeItem.getEnd());
                themeGridRangeItem.setEnd(d2);
            } else {
                String string3 = u.a("item", "ThemeGridRange_TheEndShouldBeBiggerTheStart", "mapping_resources");
                throw new IllegalArgumentException(string3);
            }
        }
        if ((n2 = this.getCount()) > 0) {
            double d3;
            double d4 = ThemeGridRangeNative.jni_GetValueAt(this.getHandle(), 0);
            double d5 = themeGridRangeItem.getEnd();
            double d6 = d5 - d4;
            boolean bl2 = Toolkit.isZero((double)d6);
            if (!bl2) {
                if (bl) {
                    themeGridRangeItem.setEnd(d4);
                } else {
                    String string4 = u.a("item.getEnd()", "ThemeGridRange_InvalidEndOfItem", "mapping_resources");
                    throw new IllegalArgumentException(string4);
                }
            }
            if ((bl2 = Toolkit.isZero((double)(d6 = (d3 = themeGridRangeItem.getStart()) - d4))) || d3 > d4) {
                return false;
            }
        }
        ThemeGridRangeItem themeGridRangeItem2 = new ThemeGridRangeItem(themeGridRangeItem);
        boolean bl3 = ThemeGridRangeNative.jni_AddToHead(this.getHandle(), themeGridRangeItem2.getCaption(), themeGridRangeItem2.isVisible(), themeGridRangeItem2.getColor().getRGB(), themeGridRangeItem2.getStart(), themeGridRangeItem2.getEnd());
        if (bl3) {
            ThemeGridRangeItem themeGridRangeItem3 = new ThemeGridRangeItem(this);
            this.a.add(0, themeGridRangeItem3);
        }
        return bl3;
    }

    public boolean addToTail(ThemeGridRangeItem themeGridRangeItem, boolean bl) {
        int n2;
        if (this.getHandle() == 0L) {
            String string2 = u.a("addToTail(ThemeGridRangeItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (themeGridRangeItem.getStart() >= themeGridRangeItem.getEnd()) {
            if (bl) {
                if (Toolkit.isZero((double)(themeGridRangeItem.getStart() - themeGridRangeItem.getEnd()))) {
                    return false;
                }
                Double d2 = themeGridRangeItem.getStart();
                themeGridRangeItem.setStart(themeGridRangeItem.getEnd());
                themeGridRangeItem.setEnd(d2);
            } else {
                String string3 = u.a("item", "ThemeGridRange_TheEndShouldBeBiggerTheStart", "mapping_resources");
                throw new IllegalArgumentException(string3);
            }
        }
        if ((n2 = this.getCount()) > 0) {
            double d3;
            double d4 = ThemeGridRangeNative.jni_GetValueAt(this.getHandle(), n2);
            double d5 = themeGridRangeItem.getStart();
            double d6 = d5 - d4;
            boolean bl2 = Toolkit.isZero((double)d6);
            if (!bl2) {
                if (bl) {
                    themeGridRangeItem.setStart(d4);
                } else {
                    String string4 = u.a("item.getStart()", "ThemeGridRange_InavlidStartOfItem", "mapping_resources");
                    throw new IllegalArgumentException(string4);
                }
            }
            if ((bl2 = Toolkit.isZero((double)(d6 = d4 - (d3 = themeGridRangeItem.getEnd())))) || d3 < d4) {
                return false;
            }
        }
        ThemeGridRangeItem themeGridRangeItem2 = new ThemeGridRangeItem(themeGridRangeItem);
        boolean bl3 = ThemeGridRangeNative.jni_AddToTail(this.getHandle(), themeGridRangeItem2.getCaption(), themeGridRangeItem2.isVisible(), themeGridRangeItem2.getColor().getRGB(), themeGridRangeItem2.getStart(), themeGridRangeItem2.getEnd());
        if (bl3) {
            ThemeGridRangeItem themeGridRangeItem3 = new ThemeGridRangeItem(this);
            this.a.add(themeGridRangeItem3);
        }
        return bl3;
    }

    public boolean split(int n2, double d2, Color color, String string2, Color color2, String string3) {
        if (this.getHandle() == 0L) {
            String string4 = u.a("split()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string4);
        }
        int n3 = this.getCount();
        if (n2 < 0 || n2 >= n3) {
            String string5 = u.a("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string5);
        }
        if (color == null) {
            String string6 = u.a("color1", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string6);
        }
        if (color2 == null) {
            String string7 = u.a("color2", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string7);
        }
        double d3 = ThemeGridRangeNative.jni_GetValueAt(this.getHandle(), n2);
        double d4 = ThemeGridRangeNative.jni_GetValueAt(this.getHandle(), n2 + 1);
        if (d2 <= d3 || d2 >= d4) {
            String string8 = u.a("splitValue", "ThemeGridRange_InvalidSplitValue", "mapping_resources");
            throw new IllegalArgumentException(string8);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string9 = u.a("caption1", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string9);
        }
        if (string3 == null || string3.trim().length() == 0) {
            String string10 = u.a("caption2", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string10);
        }
        boolean bl = ThemeGridRangeNative.jni_Split(this.getHandle(), n2, d2, color.getRGB(), string2, color2.getRGB(), string3);
        if (bl) {
            ThemeGridRangeItem themeGridRangeItem = (ThemeGridRangeItem)this.a.get(n2);
            themeGridRangeItem.setEnd(d2);
            themeGridRangeItem.setCaption(string2);
            themeGridRangeItem.setColor(color);
            ThemeGridRangeItem themeGridRangeItem2 = new ThemeGridRangeItem(this);
            this.a.add(n2 + 1, themeGridRangeItem2);
        }
        return bl;
    }

    public boolean merge(int n2, int n3, Color color, String string2) {
        if (this.getHandle() == 0L) {
            String string3 = u.a("merge(int index1, int count, Color color, String caption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        int n4 = this.getCount();
        if (n2 < 0 || n2 >= n4) {
            String string4 = u.a("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string4);
        }
        if (n2 + n3 < n2 || n2 + n3 > n4) {
            String string5 = u.a("count", "ThemeGridRange_TheCountIsInvalid", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        if (color == null) {
            String string6 = u.a("color", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string6);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string7 = u.a("name", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string7);
        }
        boolean bl = false;
        if (n3 == 0) {
            bl = true;
        } else {
            bl = ThemeGridRangeNative.jni_Merge(this.getHandle(), n2, n3, color.getRGB(), string2);
            if (bl) {
                ThemeGridRangeItem themeGridRangeItem = (ThemeGridRangeItem)this.a.get(n2);
                double d2 = ThemeGridRangeNative.jni_GetValueAt(this.getHandle(), n2 + 1);
                themeGridRangeItem.setEnd(d2);
                themeGridRangeItem.setCaption(string2);
                themeGridRangeItem.setColor(color);
                for (int i2 = 0; i2 < n3 - 1; ++i2) {
                    this.a.remove(n2 + 1);
                }
            }
        }
        return bl;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("clear()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        ThemeGridRangeNative.jni_Clear(this.getHandle());
        if (this.a != null) {
            this.a.clear();
        }
    }

    public static ThemeGridRange makeDefault(DatasetGrid datasetGrid, RangeMode rangeMode, double d2, ColorGradientType colorGradientType) {
        if (datasetGrid == null) {
            String string2 = u.a("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string2);
        }
        long l2 = l.getHandle((InternalHandle)datasetGrid);
        if (l2 == 0L) {
            String string3 = u.a("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (rangeMode == null) {
            String string4 = u.a("rangeMode", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (rangeMode.equals((Object)RangeMode.STDDEVIATION) || rangeMode.equals((Object)RangeMode.QUANTILE)) {
            String string5 = u.a("rangeMode", "ThemeGridRange_TheRangeModeIsUnsupported", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        if ((rangeMode.equals((Object)RangeMode.EQUALINTERVAL) || rangeMode.equals((Object)RangeMode.SQUAREROOT) || rangeMode.equals((Object)RangeMode.LOGARITHM)) && d2 < 1.0) {
            String string6 = u.a("rangeParameter", "ThemeGridRange_TheArgumentOfRangeParameterShouldNotBeLessThanOneRange", "mapping_resources");
            throw new IllegalArgumentException(string6);
        }
        if (rangeMode.equals((Object)RangeMode.CUSTOMINTERVAL) && d2 < 0.0) {
            String string7 = u.a("rangeParameter", "ThemeGridRange_TheArgumentOfRangeParameterShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string7);
        }
        if (colorGradientType == null) {
            colorGradientType = ColorGradientType.TERRAIN;
        }
        int n2 = e.a(rangeMode);
        int n3 = e.a((Enum)colorGradientType);
        long l3 = ThemeGridRangeNative.jni_MakeDefault(l2, n2, d2, n3);
        ThemeGridRange themeGridRange = null;
        if (l3 != 0L) {
            themeGridRange = new ThemeGridRange(l3, true);
        }
        return themeGridRange;
    }

    public static ThemeGridRange makeDefault(DatasetGrid datasetGrid, RangeMode rangeMode, double d2) {
        return ThemeGridRange.makeDefault(datasetGrid, rangeMode, d2, null);
    }

    public int indexOf(double d2) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("indexOf(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        int n2 = ThemeGridRangeNative.jni_GetCount(this.getHandle());
        double[] dArray = new double[n2];
        ThemeGridRangeNative.jni_GetValues(this.getHandle(), dArray);
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            if (!(dArray[i2] <= d2) || !(d2 < dArray[i2 + 1])) continue;
            return i2;
        }
        return -1;
    }

    public void reverseColor() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("reverseColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        ThemeGridRangeNative.jni_ReverseColor(this.getHandle());
    }

    @Override
    public String toString() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Count = ");
        stringBuffer.append(this.getCount());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string2 = u.a("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string2);
        }
        if (this.getHandle() != 0L) {
            ThemeGridRangeNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fromXML(String string2) {
        boolean bl = false;
        bl = super.fromXML(string2);
        if (bl) {
            this.a();
        }
        return bl;
    }

    @Override
    protected void clearHandle() {
        if (this.a != null) {
            this.a.clear();
            this.a = null;
        }
        this.setHandle(0L);
    }

    ArrayList a() {
        return this.a;
    }

    private void a() {
        if (this.a != null) {
            this.a.clear();
        }
        int n2 = this.getCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ThemeGridRangeItem themeGridRangeItem = new ThemeGridRangeItem(this);
            this.a.add(themeGridRangeItem);
        }
    }

    public void setSpecialValueTransparent(boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setSpecialValueTransparent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        ThemeGridRangeNative.jni_SetSpecialValueTransparent1(this.getHandle(), bl);
    }

    public boolean isSpecialValueTransparent() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("isSpecialValueTransparent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return ThemeGridRangeNative.jni_IsSpecialValueTransparent1(this.getHandle());
    }

    public void setSpecialValue(int n2) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setSpecialValueTransparent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        ThemeGridRangeNative.jni_SetSpecialValue1(this.getHandle(), n2);
    }

    public int GetSpecialValue() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("isSpecialValueTransparent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return ThemeGridRangeNative.jni_GetSpecialValue1(this.getHandle());
    }
}

