/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.ColorGradientType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Enum;
import com.supermap.data.GeoStyle;
import com.supermap.data.InternalHandle;
import com.supermap.data.JoinItems;
import com.supermap.data.Toolkit;
import com.supermap.mapping.RangeMode;
import com.supermap.mapping.Theme;
import com.supermap.mapping.ThemeRangeItem;
import com.supermap.mapping.ThemeRangeNative;
import com.supermap.mapping.e;
import com.supermap.mapping.l;
import com.supermap.mapping.u;
import java.util.ArrayList;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ThemeRange
extends Theme {
    private ArrayList a;
    private RangeMode a = null;

    public ThemeRange() {
        long l2 = ThemeRangeNative.jni_New();
        this.setHandle(l2, true);
        this.setRangeExpression("");
        this.a = new ArrayList();
        this.a = RangeMode.NONE;
    }

    public ThemeRange(ThemeRange themeRange) {
        if (themeRange == null) {
            String string2 = u.a("themeRange", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string2);
        }
        if (themeRange.getHandle() == 0L) {
            String string3 = u.a("themeRange", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        long l2 = ThemeRangeNative.jni_Clone(themeRange.getHandle());
        this.setHandle(l2, true);
        this.a = new ArrayList();
        int n2 = themeRange.a().size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ThemeRangeItem themeRangeItem = new ThemeRangeItem(this);
            this.a.add(themeRangeItem);
        }
        this.a = themeRange.getRangeMode();
    }

    ThemeRange(long l2, boolean bl) {
        int n2;
        this.setHandle(l2, bl);
        int n3 = ThemeRangeNative.jni_GetValueCount(this.getHandle());
        this.a = new ArrayList();
        int n4 = n3 - 1;
        for (n2 = 0; n2 < n4; ++n2) {
            ThemeRangeItem themeRangeItem = new ThemeRangeItem(this);
            this.a.add(themeRangeItem);
        }
        n2 = ThemeRangeNative.jni_GetRangeMethod(this.getHandle());
        this.a = (RangeMode)RangeMode.parse(RangeMode.class, (int)n2);
    }

    public ThemeRangeItem getItem(int n2) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        int n3 = this.getCount();
        if (n2 < 0 || n2 >= n3) {
            String string3 = u.a("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        return (ThemeRangeItem)this.a.get(n2);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        int n2 = ThemeRangeNative.jni_GetCount(this.getHandle());
        int n3 = 0;
        n3 = n2 == 0 || n2 == 1 ? 0 : n2 - 1;
        return n3;
    }

    public String getRangeExpression() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getRangeExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return ThemeRangeNative.jni_GetRangeExpression(this.getHandle());
    }

    public void setRangeExpression(String string2) {
        if (this.getHandle() == 0L) {
            String string3 = u.a("setRangeExpression(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        if (string2 == null) {
            string2 = "";
        }
        ThemeRangeNative.jni_SetRangeExpression(this.getHandle(), string2);
    }

    public boolean addToHead(ThemeRangeItem themeRangeItem) {
        return this.addToHead(themeRangeItem, false);
    }

    public boolean addToTail(ThemeRangeItem themeRangeItem) {
        return this.addToTail(themeRangeItem, false);
    }

    public boolean addToHead(ThemeRangeItem themeRangeItem, boolean bl) {
        int n2;
        if (this.getHandle() == 0L) {
            String string2 = u.a("addToHead(ThemeRangeItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (themeRangeItem.getStart() >= themeRangeItem.getEnd()) {
            if (bl) {
                if (Toolkit.isZero((double)(themeRangeItem.getStart() - themeRangeItem.getEnd()))) {
                    return false;
                }
                Double d2 = themeRangeItem.getStart();
                themeRangeItem.setStart(themeRangeItem.getEnd());
                themeRangeItem.setEnd(d2);
            } else {
                String string3 = u.a("item", "ThemeRange_TheEndShouldBeBiggerTheStart", "mapping_resources");
                throw new IllegalArgumentException(string3);
            }
        }
        if ((n2 = this.getCount()) > 0) {
            double d3;
            double d4 = ThemeRangeNative.jni_GetValueAt(this.getHandle(), 0);
            double d5 = ThemeRangeNative.jni_FormatThemeRangeValue(this.getHandle(), themeRangeItem.getEnd());
            double d6 = d5 - d4;
            boolean bl2 = Toolkit.isZero((double)d6);
            if (!bl2) {
                if (bl) {
                    themeRangeItem.setEnd(d4);
                } else {
                    String string4 = u.a("item.getEnd()", "ThemeRange_InvalidEndOfItem", "mapping_resources");
                    throw new IllegalArgumentException(string4);
                }
            }
            if ((bl2 = Toolkit.isZero((double)(d6 = (d3 = ThemeRangeNative.jni_FormatThemeRangeValue(this.getHandle(), themeRangeItem.getStart())) - d4))) || d3 > d4) {
                return false;
            }
        }
        ThemeRangeItem themeRangeItem2 = new ThemeRangeItem(themeRangeItem);
        long l2 = l.getHandle((InternalHandle)themeRangeItem2.getStyle());
        boolean bl3 = ThemeRangeNative.jni_AddToHead(this.getHandle(), themeRangeItem2.getCaption(), themeRangeItem2.isVisible(), l2, themeRangeItem2.getStart(), themeRangeItem2.getEnd());
        if (bl3) {
            ThemeRangeItem themeRangeItem3 = new ThemeRangeItem(this);
            this.a.add(0, themeRangeItem3);
            this.c();
        }
        return bl3;
    }

    public boolean addToTail(ThemeRangeItem themeRangeItem, boolean bl) {
        int n2;
        if (this.getHandle() == 0L) {
            String string2 = u.a("addToTail(ThemeRangeItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (themeRangeItem.getStart() >= themeRangeItem.getEnd()) {
            if (bl) {
                if (Toolkit.isZero((double)(themeRangeItem.getStart() - themeRangeItem.getEnd()))) {
                    return false;
                }
                Double d2 = themeRangeItem.getStart();
                themeRangeItem.setStart(themeRangeItem.getEnd());
                themeRangeItem.setEnd(d2);
            } else {
                String string3 = u.a("item", "ThemeRange_TheEndShouldBeBiggerTheStart", "mapping_resources");
                throw new IllegalArgumentException(string3);
            }
        }
        if ((n2 = this.getCount()) > 0) {
            double d3;
            double d4 = ThemeRangeNative.jni_GetValueAt(this.getHandle(), n2);
            double d5 = ThemeRangeNative.jni_FormatThemeRangeValue(this.getHandle(), themeRangeItem.getStart());
            double d6 = d5 - d4;
            boolean bl2 = Toolkit.isZero((double)d6);
            if (!bl2) {
                if (bl) {
                    themeRangeItem.setStart(d4);
                } else {
                    String string4 = u.a("item.getStart()", "ThemeRange_InavlidStartOfItem", "mapping_resources");
                    throw new IllegalArgumentException(string4);
                }
            }
            if ((bl2 = Toolkit.isZero((double)(d6 = d4 - (d3 = ThemeRangeNative.jni_FormatThemeRangeValue(this.getHandle(), themeRangeItem.getEnd()))))) || d3 < d4) {
                return false;
            }
        }
        ThemeRangeItem themeRangeItem2 = new ThemeRangeItem(themeRangeItem);
        long l2 = l.getHandle((InternalHandle)themeRangeItem2.getStyle());
        boolean bl3 = ThemeRangeNative.jni_AddToTail(this.getHandle(), themeRangeItem2.getCaption(), themeRangeItem2.isVisible(), l2, themeRangeItem2.getStart(), themeRangeItem2.getEnd());
        if (bl3) {
            ThemeRangeItem themeRangeItem3 = new ThemeRangeItem(this);
            this.a.add(themeRangeItem3);
            this.c();
        }
        return bl3;
    }

    public boolean split(int n2, double d2, GeoStyle geoStyle, String string2, GeoStyle geoStyle2, String string3) {
        if (this.getHandle() == 0L) {
            String string4 = u.a("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string4);
        }
        int n3 = this.getCount();
        if (n2 < 0 || n2 >= n3) {
            String string5 = u.a("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string5);
        }
        if (geoStyle == null) {
            String string6 = u.a("style1", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string6);
        }
        long l2 = InternalHandle.getHandle((InternalHandle)geoStyle);
        if (l2 == 0L) {
            String string7 = u.a("style1", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string7);
        }
        if (geoStyle2 == null) {
            String string8 = u.a("style2", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string8);
        }
        long l3 = InternalHandle.getHandle((InternalHandle)geoStyle2);
        if (l3 == 0L) {
            String string9 = u.a("style2", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string9);
        }
        double d3 = ThemeRangeNative.jni_GetValueAt(this.getHandle(), n2);
        double d4 = ThemeRangeNative.jni_GetValueAt(this.getHandle(), n2 + 1);
        if (d2 <= d3 || d2 >= d4) {
            String string10 = u.a("splitValue", "ThemeRange_InvalidSplitValue", "mapping_resources");
            throw new IllegalArgumentException(string10);
        }
        long l4 = InternalHandle.getHandle((InternalHandle)geoStyle.clone());
        long l5 = InternalHandle.getHandle((InternalHandle)geoStyle2.clone());
        if (string2 == null || string2.trim().length() == 0) {
            String string11 = u.a("caption1", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string11);
        }
        if (string3 == null || string3.trim().length() == 0) {
            String string12 = u.a("caption2", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string12);
        }
        boolean bl = ThemeRangeNative.jni_Split(this.getHandle(), n2, d2, l4, string2, l5, string3);
        if (bl) {
            ThemeRangeItem themeRangeItem = new ThemeRangeItem(this);
            this.a.add(n2 + 1, themeRangeItem);
            this.c();
        }
        return bl;
    }

    public boolean merge(int n2, int n3, GeoStyle geoStyle, String string2) {
        if (this.getHandle() == 0L) {
            String string3 = u.a("merge(int index, int count, GeoStyle style, String caption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        int n4 = this.getCount();
        if (n2 < 0 || n2 >= n4) {
            String string4 = u.a("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string4);
        }
        if (n2 + n3 < n2 || n2 + n3 > n4) {
            String string5 = u.a("count", "ThemeRange_TheCountIsInvalid", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        if (geoStyle == null) {
            String string6 = u.a("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string6);
        }
        long l2 = InternalHandle.getHandle((InternalHandle)geoStyle);
        if (l2 == 0L) {
            String string7 = u.a("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string7);
        }
        if (n3 == 0) {
            return true;
        }
        long l3 = InternalHandle.getHandle((InternalHandle)geoStyle.clone());
        if (string2 == null || string2.trim().length() == 0) {
            String string8 = u.a("caption", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string8);
        }
        boolean bl = ThemeRangeNative.jni_Merge(this.getHandle(), n2, n3, l3, string2);
        if (bl) {
            ThemeRangeItem themeRangeItem = (ThemeRangeItem)this.a.get(n2);
            double d2 = ThemeRangeNative.jni_GetValueAt(this.getHandle(), n2 + 1);
            themeRangeItem.setEnd(d2);
            themeRangeItem.setCaption(string2);
            themeRangeItem.setStyle(geoStyle.clone());
            for (int i2 = 0; i2 < n3 - 1; ++i2) {
                ThemeRangeItem themeRangeItem2 = (ThemeRangeItem)this.a.get(n2 + 1);
                themeRangeItem2.a();
                this.a.remove(n2 + 1);
            }
            this.c();
        }
        return bl;
    }

    public static ThemeRange makeDefault(DatasetVector datasetVector, String string2, RangeMode rangeMode, double d2) {
        return ThemeRange.makeDefault(datasetVector, string2, rangeMode, d2, null, null);
    }

    public static ThemeRange makeDefault(DatasetVector datasetVector, String string2, RangeMode rangeMode, double d2, ColorGradientType colorGradientType) {
        return ThemeRange.makeDefault(datasetVector, string2, rangeMode, d2, colorGradientType, null);
    }

    public static ThemeRange makeDefault(DatasetVector datasetVector, String string2, RangeMode rangeMode, double d2, ColorGradientType colorGradientType, JoinItems joinItems) {
        return ThemeRange.makeDefault(datasetVector, string2, rangeMode, d2, colorGradientType, joinItems, 0.1);
    }

    public static ThemeRange makeDefault(DatasetVector datasetVector, String string2, RangeMode rangeMode, double d2, ColorGradientType colorGradientType, JoinItems joinItems, double d3) {
        int n2;
        int n3;
        long l2;
        long l3;
        long l4 = l.getHandle((InternalHandle)datasetVector);
        if (l4 == 0L) {
            String string3 = u.a("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string4 = u.a("rangeExpression", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (joinItems == null) {
            joinItems = new JoinItems();
        }
        if ((l3 = l.getHandle((InternalHandle)joinItems)) == 0L) {
            String string5 = u.a("joinItems", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        if (rangeMode == null) {
            String string6 = u.a("rangeMode", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string6);
        }
        if ((rangeMode.equals((Object)RangeMode.EQUALINTERVAL) || rangeMode.equals((Object)RangeMode.SQUAREROOT) || rangeMode.equals((Object)RangeMode.LOGARITHM) || rangeMode.equals((Object)RangeMode.QUANTILE)) && d2 < 1.0) {
            String string7 = u.a("rangeParameter", "ThemeRange_TheArgumentOfRangeParameterShouldNotBeLessThanOneRange", "mapping_resources");
            throw new IllegalArgumentException(string7);
        }
        if (rangeMode.equals((Object)RangeMode.CUSTOMINTERVAL) && d2 < 0.0) {
            String string8 = u.a("rangeParameter", "ThemeRange_TheArgumentOfRangeParameterShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string8);
        }
        if (colorGradientType == null) {
            colorGradientType = ColorGradientType.YELLOWRED;
        }
        if ((l2 = ThemeRangeNative.jni_MakeDefault(l4, string2, l3, n3 = e.a(rangeMode), d2, n2 = e.a((Enum)colorGradientType), d3)) == 0L) {
            return null;
        }
        ThemeRange themeRange = new ThemeRange(l2, true);
        themeRange.a(rangeMode);
        return themeRange;
    }

    public double getPrecision() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getPrecision()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return ThemeRangeNative.jni_GetPrecision(this.getHandle());
    }

    public void setPrecision(double d2) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setPrecision(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        ThemeRangeNative.jni_SetPrecision(this.getHandle(), d2);
    }

    public int indexOf(double d2) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("indexOf(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        int n2 = ThemeRangeNative.jni_GetValueCount(this.getHandle());
        double[] dArray = new double[n2];
        ThemeRangeNative.jni_GetValues(this.getHandle(), dArray);
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            if (!(dArray[i2] <= d2) || !(d2 < dArray[i2 + 1])) continue;
            return i2;
        }
        return -1;
    }

    public void reverseStyle() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("reverseStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        ThemeRangeNative.jni_ReverseStyle(this.getHandle());
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("clear()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        ThemeRangeNative.jni_Clear(this.getHandle());
        if (this.a != null) {
            int n2 = this.a.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ThemeRangeItem themeRangeItem = (ThemeRangeItem)this.a.get(i2);
                themeRangeItem.a();
            }
            this.a.clear();
        }
    }

    @Override
    public String toString() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        int n2 = this.getCount();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Count = ");
        stringBuffer.append(n2);
        stringBuffer.append(",RangeExpression = ");
        stringBuffer.append(this.getRangeExpression());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    @Override
    public boolean fromXML(String string2) {
        boolean bl = super.fromXML(string2);
        if (bl) {
            this.b();
        }
        return bl;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string2 = u.a("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string2);
        }
        if (this.getHandle() != 0L) {
            ThemeRangeNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        if (this.a != null) {
            this.a();
            this.a = null;
        }
        this.setHandle(0L);
    }

    public RangeMode getRangeMode() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return this.a;
    }

    ArrayList a() {
        return this.a;
    }

    private void a() {
        int n2 = this.a.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ThemeRangeItem themeRangeItem = (ThemeRangeItem)this.a.get(i2);
            themeRangeItem.a();
        }
        this.a.clear();
    }

    private void b() {
        if (this.a != null) {
            this.a();
        }
        int n2 = this.getCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ThemeRangeItem themeRangeItem = new ThemeRangeItem(this);
            this.a.add(themeRangeItem);
        }
    }

    private void c() {
        int n2 = this.getCount();
        long[] lArray = new long[n2];
        ThemeRangeNative.jni_GetStylesHandle(this.getHandle(), lArray);
        for (int i2 = 0; i2 < n2; ++i2) {
            ThemeRangeItem themeRangeItem = this.getItem(i2);
            themeRangeItem.a(lArray[i2]);
        }
    }

    private void a(RangeMode rangeMode) {
        this.a = rangeMode;
    }

    public String getOffsetX() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getOffsetX()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return ThemeRangeNative.jni_GetOffsetX(this.getHandle());
    }

    public void setOffsetX(String string2) {
        if (this.getHandle() == 0L) {
            String string3 = u.a("setOffsetX(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        if (string2 == null) {
            string2 = "";
        }
        ThemeRangeNative.jni_SetOffsetX(this.getHandle(), string2);
    }

    public String getOffsetY() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getOffsetY()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return ThemeRangeNative.jni_GetOffsetY(this.getHandle());
    }

    public void setOffsetY(String string2) {
        if (this.getHandle() == 0L) {
            String string3 = u.a("setOffsetY(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        if (string2 == null) {
            string2 = "";
        }
        ThemeRangeNative.jni_SetOffsetY(this.getHandle(), string2);
    }

    public boolean isOffsetFixed() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("isOffsetFixed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return ThemeRangeNative.jni_GetOffsetFixed(this.getHandle());
    }

    public void setOffsetFixed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setOffsetFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        ThemeRangeNative.jni_SetOffsetFixed(this.getHandle(), bl);
    }

    public double getCustomInterval() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getCustomInterval()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return ThemeRangeNative.jni_GetCustomInterval(this.getHandle());
    }
}

