/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping.collect;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Paint;
import android.location.LocationManager;
import android.os.Handler;
import android.os.Message;
import android.widget.Toast;
import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Enum;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldType;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandle;
import com.supermap.data.Point2D;
import com.supermap.data.Recordset;
import com.supermap.mapping.Map;
import com.supermap.mapping.MapControl;
import com.supermap.mapping.MapView;
import com.supermap.mapping.collect.CollectionChangedListener;
import com.supermap.mapping.collect.CollectorElement;
import com.supermap.mapping.collect.CollectorNative;
import com.supermap.mapping.collect.a;
import com.supermap.mapping.collect.b;
import com.supermap.mapping.collect.c;
import com.supermap.mapping.collect.d;
import com.supermap.plugin.LocationChangedListener;
import com.supermap.plugin.LocationManagePlugin;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Collector {
    private Context a;
    private long a;
    private GeometryType a;
    private long b;
    private CollectionChangedListener a;
    boolean a;
    Point2D a;
    private Paint a;
    private MapView a;
    private MapControl a;
    private Map a;
    private Recordset a;
    private Dataset a;
    private LocationManagePlugin a;
    private LocationManager a;
    private CollectorElement a;
    private Bitmap a;
    private float a;
    private int a;
    private Runnable a;
    private LocationChangedListener a;
    private Handler a = new Handler(){

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    break;
                }
            }
        }
    };

    protected Collector(Context context) {
    }

    public static Collector createInstance(long l2, Context context, long l3) {
        return new Collector(l2, context, l3);
    }

    private Collector(long l2, Context context, long l3) {
        this.a = l2;
        this.b = l3;
        this.a = context;
        this.a = new Paint();
        this.a = context.getResources().getDisplayMetrics().density;
        this.a = (LocationManager)context.getSystemService("location");
        this.a = new LocationManagePlugin();
        this.a.addLocationChangedListener(this.a);
    }

    public void setMapView(MapView mapView) {
        if (mapView != null) {
            this.a = mapView;
            this.a = mapView.getMapControl();
            this.a = mapView.getMapControl().getMap();
        }
    }

    public void setMapControl(MapControl mapControl) {
        this.a = mapControl;
    }

    public boolean setCollectionChangedListener(CollectionChangedListener collectionChangedListener) {
        if (collectionChangedListener != null) {
            this.a = collectionChangedListener;
            return true;
        }
        return false;
    }

    public void moveToCurrent() {
        if (this.a == 0L) {
            return;
        }
        Point2D point2D = this.getGPSPoint();
        CollectorNative.jni_MoveToCurrent(this.a, point2D.getX(), point2D.getY(), 500);
    }

    public Point2D getGPSPoint() {
        Point2D point2D = new Point2D(this.a);
        if (point2D.getX() == 0.0 && point2D.getY() == 0.0) {
            this.showInfo("\u5f53\u524d\u5b9a\u4f4d\u5931\u8d25");
            return null;
        }
        return point2D;
    }

    public void setDataset(Dataset dataset) {
        this.a = dataset;
        if (this.a != null) {
            long l2 = d.a((InternalHandle)dataset);
            CollectorNative.jni_SetDataset(this.a, l2);
        }
        this.a = ((DatasetVector)this.a).getRecordset(false, CursorType.DYNAMIC);
    }

    public boolean createElement(CollectorElement.GPSElementType gPSElementType) {
        boolean bl = false;
        if (this.a != 0L) {
            GeometryType geometryType = null;
            switch (gPSElementType) {
                case POINT: {
                    geometryType = GeometryType.GEOPOINT;
                    break;
                }
                case LINE: {
                    geometryType = GeometryType.GEOLINE;
                    break;
                }
                case POLYGON: {
                    geometryType = GeometryType.GEOREGION;
                    break;
                }
            }
            if (geometryType != null) {
                long l2;
                this.a = geometryType;
                int n2 = com.supermap.mapping.collect.a.a((Enum)geometryType);
                CollectorNative.jni_CreateGeometry(this.a, n2);
                if (this.a != 0L && (l2 = CollectorNative.jni_GetCurGeometry(this.a)) != 0L) {
                    Geometry geometry = c.a(l2);
                    this.a.a(geometry);
                    this.a.a(this);
                    bl = true;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public Geometry getCurGeometry() {
        if (this.a != null) {
            return this.a.getGeometry();
        }
        return null;
    }

    public boolean addGPSPoint(Point2D point2D) {
        boolean bl = false;
        if (this.a != 0L && this.a(point2D)) {
            CollectorNative.jni_AddGPSPoint(this.a, point2D.getX(), point2D.getY());
            bl = true;
        }
        return bl;
    }

    public boolean addGPSPoint() {
        boolean bl = false;
        Point2D point2D = this.getGPSPoint();
        if (this.a != 0L && this.a(point2D)) {
            CollectorNative.jni_AddGPSPoint(this.a, point2D.getX(), point2D.getY());
            bl = true;
        }
        return bl;
    }

    public void showInfo(String string2) {
        Toast toast = Toast.makeText((Context)this.a, (CharSequence)string2, (int)0);
        toast.show();
    }

    public void undo() {
        if (this.a != 0L) {
            CollectorNative.jni_Undo(this.a);
        }
    }

    public void redo() {
        if (this.a != 0L) {
            CollectorNative.jni_Redo(this.a);
        }
    }

    public void setSingleTapEnable(boolean bl) {
        if (this.a == 0L) {
            return;
        }
        CollectorNative.jni_SetSingleTapEnable(this.a, bl);
    }

    public boolean IsSingleTapEnable() {
        if (this.a == 0L) {
            return false;
        }
        return CollectorNative.jni_IsSingleTapEnable(this.a);
    }

    public void setStyle(GeoStyle geoStyle) {
        if (this.a == 0L || geoStyle == null) {
            return;
        }
        GeoStyle geoStyle2 = geoStyle.clone();
        long l2 = d.a((InternalHandle)geoStyle2);
        CollectorNative.jni_SetStyle(this.a, l2);
    }

    public GeoStyle getStyle() {
        if (this.a == 0L) {
            return null;
        }
        long l2 = CollectorNative.jni_GetStyle(this.a);
        GeoStyle geoStyle = null;
        if (l2 != 0L) {
            geoStyle = com.supermap.mapping.collect.b.a(l2);
        }
        return geoStyle;
    }

    public boolean openGPS() {
        boolean bl = this.a.openGpsDevice(this.a);
        return bl;
    }

    public void closeGPS() {
        this.a.closeGpsDevice();
    }

    private boolean a(Dataset dataset) {
        return true;
    }

    private boolean a(Point2D point2D) {
        return point2D.getX() != 0.0 || point2D.getY() != 0.0;
    }

    private void a() {
        FieldInfo fieldInfo;
        FieldInfos fieldInfos = ((DatasetVector)this.a).getFieldInfos();
        boolean bl = false;
        if (fieldInfos.indexOf("NAME") == -1) {
            fieldInfo = new FieldInfo();
            fieldInfo.setCaption("NAME");
            fieldInfo.setName("NAME");
            if (this.a != null && this.a.getName() != null) {
                fieldInfo.setDefaultValue(this.a.getName());
            }
            fieldInfo.setType(FieldType.TEXT);
            fieldInfos.add(fieldInfo);
            bl = true;
        }
        if (fieldInfos.indexOf("NOTES") == -1) {
            fieldInfo = new FieldInfo();
            fieldInfo.setCaption("NOTES");
            fieldInfo.setName("NOTES");
            if (this.a != null && this.a.getNotes() != null) {
                fieldInfo.setDefaultValue(this.a.getNotes());
            }
            fieldInfo.setType(FieldType.TEXT);
            fieldInfos.add(fieldInfo);
            bl = true;
        }
        if (bl) {
            if (this.a != null) {
                this.a.dispose();
            }
            this.a = ((DatasetVector)this.a).getRecordset(false, CursorType.DYNAMIC);
        }
    }

    private void b() {
        if (this.a == null) {
            return;
        }
        Geometry geometry = this.getCurGeometry();
        if (geometry != null && !geometry.isEmpty()) {
            this.a();
            if (this.a.getDataset().getType() == DatasetType.CAD) {
                geometry.setStyle(this.getStyle());
            }
            this.a.addNew(geometry);
            boolean bl = this.a(this.a);
            if (bl && this.a != null) {
                if (this.a.getName() != null) {
                    this.a.setFieldValue("NAME", (Object)this.a.getName());
                }
                if (this.a.getNotes() != null) {
                    this.a.setFieldValue("NOTES", (Object)this.a.getNotes());
                }
            }
            this.a.update();
        }
    }

    private void c() {
        CollectorNative.jni_DeleteCurGeometry(this.a);
        if (this.a != null) {
            this.a.a((Geometry)null);
        }
    }

    public CollectorElement getElement() {
        return this.a;
    }

    public boolean submit() {
        if (this.a == 0L) {
            return false;
        }
        if (this.a == null) {
            return false;
        }
        boolean bl = false;
        if (this.a == GeometryType.GEOPOINT && this.a.getDataset().getType() == DatasetType.POINT || this.a == GeometryType.GEOLINE && this.a.getDataset().getType() == DatasetType.LINE || this.a == GeometryType.GEOREGION && this.a.getDataset().getType() == DatasetType.REGION || this.a.getDataset().getType() == DatasetType.CAD) {
            bl = true;
        }
        if (!bl) {
            return false;
        }
        this.b();
        this.c();
        return true;
    }
}

