/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping.dyn;

import com.supermap.mapping.dyn.Animator;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AlphaAnimator
extends Animator {
    private int mToAlpha = 255;
    private int mCurrentAlpha = 0;
    private int mStartAlpha = 0;
    private int mDeltaAlpha = 0;

    public AlphaAnimator(int n2, int n3, int n4) {
        if (n2 < 0 || n2 > 255 || n3 < 0 || n3 > 255) {
            throw new IllegalArgumentException("Alpha value must be between 0 to 255");
        }
        this.mStartAlpha = n2;
        this.mToAlpha = n3;
        this.mDuration = n4;
        this.mDeltaAlpha = this.mToAlpha - this.mStartAlpha;
        this.a = 1;
    }

    public AlphaAnimator(AlphaAnimator alphaAnimator) {
        this.mStartAlpha = alphaAnimator.mStartAlpha;
        this.mToAlpha = alphaAnimator.mToAlpha;
        this.mDuration = alphaAnimator.mDuration;
        this.mDeltaAlpha = alphaAnimator.mDeltaAlpha;
        this.a = 1;
    }

    @Override
    void a() {
        this.isStarted = true;
        this.mStartTime = System.currentTimeMillis();
        this.mElement.getStyle().setAlpha(this.mStartAlpha);
        this.mCurrentAlpha = this.mElement.getStyle().getAlpha();
    }

    @Override
    boolean a() {
        if (!this.isStarted) {
            return false;
        }
        long l2 = System.currentTimeMillis() - this.mStartTime;
        if (this.mCurrentAlpha == this.mToAlpha) {
            this.isStarted = false;
            return false;
        }
        this.mCurrentAlpha = l2 <= (long)this.mDuration ? this.mStartAlpha + (int)((float)l2 * 1.0f / (float)this.getDuration() * (float)this.mDeltaAlpha) : this.mToAlpha;
        this.mElement.getStyle().setAlpha(this.mCurrentAlpha);
        return true;
    }

    @Override
    protected Animator clone() {
        return new AlphaAnimator(this);
    }
}

