/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping.dyn;

import com.supermap.data.GeoCircle;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;
import com.supermap.mapping.dyn.DynamicElement;

public class DynamicCircle
extends DynamicElement {
    double a = 0.0;

    public DynamicCircle() {
        this.mType = DynamicElement.ElementType.GEOCIRCLE;
    }

    @Override
    public boolean fromGeometry(Geometry geometry) {
        if (geometry == null) {
            return false;
        }
        if (geometry.getType() != GeometryType.GEOCIRCLE) {
            return false;
        }
        if (geometry instanceof GeoCircle) {
            this.mPoints.clear();
            this.mBounds = null;
            GeoCircle geoCircle = (GeoCircle)geometry;
            Point2D point2D = new Point2D(geoCircle.getCenter());
            this.addPoint(point2D);
            this.updateBounds();
            this.a = geoCircle.getRadius();
            return true;
        }
        return false;
    }

    public void setRadius(double d2) {
        this.a = d2;
    }

    public double getRadius() {
        return this.a;
    }

    public void setPoint(Point2D point2D) {
        if (this.mPoints.getCount() == 0) {
            this.mPoints.add(point2D);
        } else {
            this.mPoints.setItem(0, point2D);
        }
        this.mParts.set(0, this.mPoints.getCount());
        Rectangle2D rectangle2D = new Rectangle2D(point2D, point2D);
        if (this.mBounds == null) {
            this.mBounds = rectangle2D;
        } else {
            this.mBounds.union(rectangle2D);
        }
        this.updatePoint(0, point2D);
    }
}

