/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping.dyn;

import com.supermap.data.GeoPoint;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;
import com.supermap.mapping.dyn.DynamicAlignment;
import com.supermap.mapping.dyn.DynamicElement;

public class DynamicPoint
extends DynamicElement {
    private DynamicAlignment b;
    float f = 0.0f;
    float g = 0.0f;

    public DynamicPoint() {
        this.mType = DynamicElement.ElementType.POINT;
        this.b = DynamicAlignment.CENTER;
    }

    @Override
    public boolean fromGeometry(Geometry geometry) {
        if (geometry == null) {
            return false;
        }
        if (geometry.getType() != GeometryType.GEOPOINT) {
            return false;
        }
        if (geometry instanceof GeoPoint) {
            this.mPoints.clear();
            this.mBounds = null;
            GeoPoint geoPoint = (GeoPoint)geometry;
            Point2D point2D = new Point2D(geoPoint.getX(), geoPoint.getY());
            this.addPoint(point2D);
            this.updateBounds();
            this.b = DynamicAlignment.CENTER;
            return true;
        }
        return false;
    }

    public void setAlignment(DynamicAlignment dynamicAlignment) {
        this.b = dynamicAlignment;
    }

    public DynamicAlignment getAlignment() {
        return this.b;
    }

    public void setOffsetX(float f2) {
        this.f = f2;
    }

    public float getOffsetX() {
        return this.f;
    }

    public void setOffsetY(float f2) {
        this.g = f2;
    }

    public float getOffsetY() {
        return this.g;
    }

    public void setPoint(Point2D point2D) {
        if (this.mPoints.getCount() == 0) {
            this.mPoints.add(point2D);
        } else {
            this.mPoints.setItem(0, point2D);
        }
        this.mParts.set(0, this.mPoints.getCount());
        Rectangle2D rectangle2D = new Rectangle2D(point2D, point2D);
        if (this.mBounds == null) {
            this.mBounds = rectangle2D;
        } else {
            this.mBounds.union(rectangle2D);
        }
        this.updatePoint(0, point2D);
    }
}

