/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.List;
import org.achartengine.model.Point;
import org.achartengine.model.SeriesSelection;
import org.achartengine.renderer.DefaultRenderer;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;

public abstract class AbstractChart
implements Serializable {
    public abstract void draw(Canvas var1, int var2, int var3, int var4, int var5, Paint var6);

    protected void drawBackground(DefaultRenderer defaultRenderer, Canvas canvas, int n2, int n3, int n4, int n5, Paint paint, boolean bl, int n6) {
        if (defaultRenderer.isApplyBackgroundColor() || bl) {
            if (bl) {
                paint.setColor(n6);
            } else {
                paint.setColor(defaultRenderer.getBackgroundColor());
            }
            paint.setStyle(Paint.Style.FILL);
            canvas.drawRect((float)n2, (float)n3, (float)(n2 + n4), (float)(n3 + n5), paint);
        }
    }

    protected int drawLegend(Canvas canvas, DefaultRenderer defaultRenderer, String[] stringArray, int n2, int n3, int n4, int n5, int n6, int n7, Paint paint, boolean bl) {
        float f2 = 32.0f;
        if (defaultRenderer.isShowLegend()) {
            float f3 = n2;
            float f4 = (float)(n4 + n6 - n7) + f2;
            paint.setTextAlign(Paint.Align.LEFT);
            paint.setTextSize(defaultRenderer.getLegendTextSize());
            int n8 = Math.min(stringArray.length, defaultRenderer.getSeriesRendererCount());
            for (int i2 = 0; i2 < n8; ++i2) {
                SimpleSeriesRenderer simpleSeriesRenderer = defaultRenderer.getSeriesRendererAt(i2);
                float f5 = this.getLegendShapeWidth(i2);
                if (!simpleSeriesRenderer.isShowLegendItem()) continue;
                String string2 = stringArray[i2];
                if (stringArray.length == defaultRenderer.getSeriesRendererCount()) {
                    paint.setColor(simpleSeriesRenderer.getColor());
                } else {
                    paint.setColor(-3355444);
                }
                float[] fArray = new float[string2.length()];
                paint.getTextWidths(string2, fArray);
                float f6 = 0.0f;
                for (float f7 : fArray) {
                    f6 += f7;
                }
                float f8 = f5 + 10.0f + f6;
                float f9 = f3 + f8;
                if (i2 > 0 && this.getExceed(f9, defaultRenderer, n3, n5)) {
                    f3 = n2;
                    f4 += defaultRenderer.getLegendTextSize();
                    f2 += defaultRenderer.getLegendTextSize();
                    f9 = f3 + f8;
                }
                if (this.getExceed(f9, defaultRenderer, n3, n5)) {
                    float f10 = (float)n3 - f3 - f5 - 10.0f;
                    if (this.isVertical(defaultRenderer)) {
                        f10 = (float)n5 - f3 - f5 - 10.0f;
                    }
                    int n9 = paint.breakText(string2, true, f10, fArray);
                    string2 = string2.substring(0, n9) + "...";
                }
                if (!bl) {
                    this.drawLegendShape(canvas, simpleSeriesRenderer, f3, f4, i2, paint);
                    this.drawString(canvas, string2, f3 + f5 + 5.0f, f4 + 5.0f, paint);
                }
                f3 += f8;
            }
        }
        return Math.round(f2 + defaultRenderer.getLegendTextSize());
    }

    protected void drawString(Canvas canvas, String string2, float f2, float f3, Paint paint) {
        if (string2 != null) {
            String[] stringArray = string2.split("\n");
            Rect rect = new Rect();
            int n2 = 0;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                canvas.drawText(stringArray[i2], f2, f3 + (float)n2, paint);
                paint.getTextBounds(stringArray[i2], 0, stringArray[i2].length(), rect);
                n2 = n2 + rect.height() + 5;
            }
        }
    }

    protected boolean getExceed(float f2, DefaultRenderer defaultRenderer, int n2, int n3) {
        boolean bl;
        boolean bl2 = bl = f2 > (float)n2;
        if (this.isVertical(defaultRenderer)) {
            bl = f2 > (float)n3;
        }
        return bl;
    }

    public boolean isVertical(DefaultRenderer defaultRenderer) {
        return defaultRenderer instanceof XYMultipleSeriesRenderer && ((XYMultipleSeriesRenderer)defaultRenderer).getOrientation() == XYMultipleSeriesRenderer.Orientation.VERTICAL;
    }

    protected String getLabel(NumberFormat numberFormat, double d2) {
        String string2 = "";
        string2 = numberFormat != null ? numberFormat.format(d2) : (d2 == (double)Math.round(d2) ? Math.round(d2) + "" : d2 + "");
        return string2;
    }

    private static float[] calculateDrawPoints(float f2, float f3, float f4, float f5, int n2, int n3) {
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        if (f3 > (float)n2) {
            f10 = (f5 - f3) / (f4 - f2);
            f9 = ((float)n2 - f3 + f10 * f2) / f10;
            f8 = n2;
            if (f9 < 0.0f) {
                f9 = 0.0f;
                f8 = f3 - f10 * f2;
            } else if (f9 > (float)n3) {
                f9 = n3;
                f8 = f10 * (float)n3 + f3 - f10 * f2;
            }
        } else if (f3 < 0.0f) {
            f10 = (f5 - f3) / (f4 - f2);
            f9 = (-f3 + f10 * f2) / f10;
            f8 = 0.0f;
            if (f9 < 0.0f) {
                f9 = 0.0f;
                f8 = f3 - f10 * f2;
            } else if (f9 > (float)n3) {
                f9 = n3;
                f8 = f10 * (float)n3 + f3 - f10 * f2;
            }
        } else {
            f9 = f2;
            f8 = f3;
        }
        if (f5 > (float)n2) {
            f10 = (f5 - f3) / (f4 - f2);
            f7 = ((float)n2 - f3 + f10 * f2) / f10;
            f6 = n2;
            if (f7 < 0.0f) {
                f7 = 0.0f;
                f6 = f3 - f10 * f2;
            } else if (f7 > (float)n3) {
                f7 = n3;
                f6 = f10 * (float)n3 + f3 - f10 * f2;
            }
        } else if (f5 < 0.0f) {
            f10 = (f5 - f3) / (f4 - f2);
            f7 = (-f3 + f10 * f2) / f10;
            f6 = 0.0f;
            if (f7 < 0.0f) {
                f7 = 0.0f;
                f6 = f3 - f10 * f2;
            } else if (f7 > (float)n3) {
                f7 = n3;
                f6 = f10 * (float)n3 + f3 - f10 * f2;
            }
        } else {
            f7 = f4;
            f6 = f5;
        }
        return new float[]{f9, f8, f7, f6};
    }

    protected void drawPath(Canvas canvas, List<Float> list, Paint paint, boolean bl) {
        Path path = new Path();
        int n2 = canvas.getHeight();
        int n3 = canvas.getWidth();
        if (list.size() < 4) {
            return;
        }
        float[] fArray = AbstractChart.calculateDrawPoints(list.get(0).floatValue(), list.get(1).floatValue(), list.get(2).floatValue(), list.get(3).floatValue(), n2, n3);
        path.moveTo(fArray[0], fArray[1]);
        path.lineTo(fArray[2], fArray[3]);
        int n4 = list.size();
        for (int i2 = 4; i2 < n4; i2 += 2) {
            if (list.get(i2 - 1).floatValue() < 0.0f && list.get(i2 + 1).floatValue() < 0.0f || list.get(i2 - 1).floatValue() > (float)n2 && list.get(i2 + 1).floatValue() > (float)n2) continue;
            fArray = AbstractChart.calculateDrawPoints(list.get(i2 - 2).floatValue(), list.get(i2 - 1).floatValue(), list.get(i2).floatValue(), list.get(i2 + 1).floatValue(), n2, n3);
            if (!bl) {
                path.moveTo(fArray[0], fArray[1]);
            }
            path.lineTo(fArray[2], fArray[3]);
        }
        if (bl) {
            path.lineTo(list.get(0).floatValue(), list.get(1).floatValue());
        }
        canvas.drawPath(path, paint);
    }

    protected void drawPath(Canvas canvas, float[] fArray, Paint paint, boolean bl) {
        Path path = new Path();
        int n2 = canvas.getHeight();
        int n3 = canvas.getWidth();
        if (fArray.length < 4) {
            return;
        }
        float[] fArray2 = AbstractChart.calculateDrawPoints(fArray[0], fArray[1], fArray[2], fArray[3], n2, n3);
        path.moveTo(fArray2[0], fArray2[1]);
        path.lineTo(fArray2[2], fArray2[3]);
        int n4 = fArray.length;
        for (int i2 = 4; i2 < n4; i2 += 2) {
            if (fArray[i2 - 1] < 0.0f && fArray[i2 + 1] < 0.0f || fArray[i2 - 1] > (float)n2 && fArray[i2 + 1] > (float)n2) continue;
            fArray2 = AbstractChart.calculateDrawPoints(fArray[i2 - 2], fArray[i2 - 1], fArray[i2], fArray[i2 + 1], n2, n3);
            if (!bl) {
                path.moveTo(fArray2[0], fArray2[1]);
            }
            path.lineTo(fArray2[2], fArray2[3]);
        }
        if (bl) {
            path.lineTo(fArray[0], fArray[1]);
        }
        canvas.drawPath(path, paint);
    }

    public abstract int getLegendShapeWidth(int var1);

    public abstract void drawLegendShape(Canvas var1, SimpleSeriesRenderer var2, float var3, float var4, int var5, Paint var6);

    private String a(String string2, float f2, Paint paint) {
        String string3 = string2;
        int n2 = string2.length();
        int n3 = 0;
        while (paint.measureText(string3) > f2 && n3 < n2) {
            string3 = string2.substring(0, n2 - ++n3) + "...";
        }
        if (n3 == n2) {
            string3 = "...";
        }
        return string3;
    }

    protected int getLegendSize(DefaultRenderer defaultRenderer, int n2, float f2) {
        int n3 = defaultRenderer.getLegendHeight();
        if (defaultRenderer.isShowLegend() && n3 == 0) {
            n3 = n2;
        }
        if (!defaultRenderer.isShowLegend() && defaultRenderer.isShowLabels()) {
            n3 = (int)(defaultRenderer.getLabelsTextSize() * 4.0f / 3.0f + f2);
        }
        return n3;
    }

    protected void drawLabel(Canvas canvas, String string2, DefaultRenderer defaultRenderer, List<RectF> list, int n2, int n3, float f2, float f3, float f4, float f5, int n4, int n5, int n6, Paint paint, boolean bl, boolean bl2) {
        if (defaultRenderer.isShowLabels() || bl2) {
            paint.setColor(n6);
            double d2 = Math.toRadians(90.0f - (f4 + f5 / 2.0f));
            double d3 = Math.sin(d2);
            double d4 = Math.cos(d2);
            int n7 = Math.round((float)n2 + (float)((double)f2 * d3));
            int n8 = Math.round((float)n3 + (float)((double)f2 * d4));
            int n9 = Math.round((float)n2 + (float)((double)f3 * d3));
            int n10 = Math.round((float)n3 + (float)((double)f3 * d4));
            float f6 = defaultRenderer.getLabelsTextSize();
            float f7 = Math.max(f6 / 2.0f, 10.0f);
            paint.setTextAlign(Paint.Align.LEFT);
            if (n7 > n9) {
                f7 = -f7;
                paint.setTextAlign(Paint.Align.RIGHT);
            }
            float f8 = (float)n9 + f7;
            float f9 = n10;
            float f10 = (float)n5 - f8;
            if (n7 > n9) {
                f10 = f8 - (float)n4;
            }
            string2 = this.a(string2, f10, paint);
            float f11 = paint.measureText(string2);
            boolean bl3 = false;
            while (!bl3 && bl) {
                boolean bl4 = false;
                int n11 = list.size();
                for (int i2 = 0; i2 < n11 && !bl4; ++i2) {
                    RectF rectF = list.get(i2);
                    if (!rectF.intersects(f8, f9, f8 + f11, f9 + f6)) continue;
                    bl4 = true;
                    f9 = Math.max(f9, rectF.bottom);
                }
                bl3 = !bl4;
            }
            if (bl) {
                n10 = (int)(f9 - f6 / 2.0f);
                canvas.drawLine((float)n7, (float)n8, (float)n9, (float)n10, paint);
                canvas.drawLine((float)n9, (float)n10, (float)n9 + f7, (float)n10, paint);
            } else {
                paint.setTextAlign(Paint.Align.CENTER);
            }
            canvas.drawText(string2, f8, f9, paint);
            if (bl) {
                list.add(new RectF(f8, f9, f8 + f11, f9 + f6));
            }
        }
    }

    public boolean isNullValue(double d2) {
        return Double.isNaN(d2) || Double.isInfinite(d2) || d2 == Double.MAX_VALUE;
    }

    public SeriesSelection getSeriesAndPointForScreenCoordinate(Point point) {
        return null;
    }
}

