/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import java.util.ArrayList;
import java.util.List;
import org.achartengine.chart.ClickableArea;
import org.achartengine.chart.PointStyle;
import org.achartengine.chart.ScatterChart;
import org.achartengine.chart.XYChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.renderer.XYSeriesRenderer;

public class LineChart
extends XYChart {
    public static final String TYPE = "Line";
    private ScatterChart a;

    LineChart() {
    }

    public LineChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        super(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        this.a = new ScatterChart(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
    }

    @Override
    protected void setDatasetRenderer(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        super.setDatasetRenderer(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        this.a = new ScatterChart(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, List<Float> list, SimpleSeriesRenderer simpleSeriesRenderer, float f2, int n2, int n3) {
        XYSeriesRenderer.FillOutsideLine[] fillOutsideLineArray;
        XYSeriesRenderer xYSeriesRenderer = (XYSeriesRenderer)simpleSeriesRenderer;
        float f3 = paint.getStrokeWidth();
        paint.setStrokeWidth(xYSeriesRenderer.getLineWidth());
        for (XYSeriesRenderer.FillOutsideLine fillOutsideLine : fillOutsideLineArray = xYSeriesRenderer.getFillOutsideLine()) {
            int n4;
            float f4;
            if (fillOutsideLine.getType() == XYSeriesRenderer.FillOutsideLine.Type.NONE) continue;
            paint.setColor(fillOutsideLine.getColor());
            ArrayList<Float> arrayList = new ArrayList<Float>();
            int[] nArray = fillOutsideLine.getFillRange();
            if (nArray == null) {
                arrayList.addAll(list);
            } else {
                arrayList.addAll(list.subList(nArray[0] * 2, nArray[1] * 2));
            }
            switch (fillOutsideLine.getType()) {
                case BOUNDS_ALL: {
                    f4 = f2;
                    break;
                }
                case BOUNDS_BELOW: {
                    f4 = f2;
                    break;
                }
                case BOUNDS_ABOVE: {
                    f4 = f2;
                    break;
                }
                case BELOW: {
                    f4 = canvas.getHeight();
                    break;
                }
                case ABOVE: {
                    f4 = 0.0f;
                    break;
                }
                default: {
                    throw new RuntimeException("You have added a new type of filling but have not implemented.");
                }
            }
            if (fillOutsideLine.getType() == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_ABOVE || fillOutsideLine.getType() == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_BELOW) {
                ArrayList arrayList2 = new ArrayList();
                n4 = 0;
                if (fillOutsideLine.getType() == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_ABOVE && ((Float)arrayList.get(1)).floatValue() < f4 || fillOutsideLine.getType() == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_BELOW && ((Float)arrayList.get(1)).floatValue() > f4) {
                    arrayList2.add(arrayList.get(0));
                    arrayList2.add(arrayList.get(1));
                    n4 = 1;
                }
                for (int i2 = 3; i2 < arrayList.size(); i2 += 2) {
                    float f5 = ((Float)arrayList.get(i2 - 2)).floatValue();
                    float f6 = ((Float)arrayList.get(i2)).floatValue();
                    if (f5 < f4 && f6 > f4 || f5 > f4 && f6 < f4) {
                        float f7 = ((Float)arrayList.get(i2 - 3)).floatValue();
                        float f8 = ((Float)arrayList.get(i2 - 1)).floatValue();
                        arrayList2.add(Float.valueOf(f7 + (f8 - f7) * (f4 - f5) / (f6 - f5)));
                        arrayList2.add(Float.valueOf(f4));
                        if (fillOutsideLine.getType() == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_ABOVE && f6 > f4 || fillOutsideLine.getType() == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_BELOW && f6 < f4) {
                            i2 += 2;
                            n4 = 0;
                            continue;
                        }
                        arrayList2.add(Float.valueOf(f8));
                        arrayList2.add(Float.valueOf(f6));
                        n4 = 1;
                        continue;
                    }
                    if (!(n4 != 0 || fillOutsideLine.getType() == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_ABOVE && f6 < f4) && (fillOutsideLine.getType() != XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_BELOW || !(f6 > f4))) continue;
                    arrayList2.add(arrayList.get(i2 - 1));
                    arrayList2.add(Float.valueOf(f6));
                }
                arrayList.clear();
                arrayList.addAll(arrayList2);
            }
            int n5 = arrayList.size();
            arrayList.set(0, Float.valueOf(((Float)arrayList.get(0)).floatValue() + 1.0f));
            arrayList.add((Float)arrayList.get(n5 - 2));
            arrayList.add(Float.valueOf(f4));
            arrayList.add((Float)arrayList.get(0));
            arrayList.add((Float)arrayList.get(n5 + 1));
            for (n4 = 0; n4 < n5 + 4; n4 += 2) {
                if (!(((Float)arrayList.get(n4 + 1)).floatValue() < 0.0f)) continue;
                arrayList.set(n4 + 1, Float.valueOf(0.0f));
            }
            paint.setStyle(Paint.Style.FILL);
            this.drawPath(canvas, arrayList, paint, true);
        }
        paint.setColor(simpleSeriesRenderer.getColor());
        paint.setStyle(Paint.Style.STROKE);
        this.drawPath(canvas, list, paint, false);
        paint.setStrokeWidth(f3);
    }

    @Override
    protected ClickableArea[] clickableAreasForPoints(List<Float> list, List<Double> list2, float f2, int n2, int n3) {
        int n4 = list.size();
        ClickableArea[] clickableAreaArray = new ClickableArea[n4 / 2];
        for (int i2 = 0; i2 < n4; i2 += 2) {
            int n5 = this.mRenderer.getSelectableBuffer();
            clickableAreaArray[i2 / 2] = new ClickableArea(new RectF(list.get(i2).floatValue() - (float)n5, list.get(i2 + 1).floatValue() - (float)n5, list.get(i2).floatValue() + (float)n5, list.get(i2 + 1).floatValue() + (float)n5), list2.get(i2), list2.get(i2 + 1));
        }
        return clickableAreaArray;
    }

    @Override
    public int getLegendShapeWidth(int n2) {
        return 30;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer simpleSeriesRenderer, float f2, float f3, int n2, Paint paint) {
        canvas.drawLine(f2, f3, f2 + 30.0f, f3, paint);
        if (this.isRenderPoints(simpleSeriesRenderer)) {
            this.a.drawLegendShape(canvas, simpleSeriesRenderer, f2 + 5.0f, f3, n2, paint);
        }
    }

    @Override
    public boolean isRenderPoints(SimpleSeriesRenderer simpleSeriesRenderer) {
        return ((XYSeriesRenderer)simpleSeriesRenderer).getPointStyle() != PointStyle.POINT;
    }

    @Override
    public ScatterChart getPointsChart() {
        return this.a;
    }

    @Override
    public String getChartType() {
        return TYPE;
    }
}

