/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import java.util.ArrayList;
import org.achartengine.chart.PieMapper;
import org.achartengine.chart.RoundChart;
import org.achartengine.model.CategorySeries;
import org.achartengine.model.Point;
import org.achartengine.model.SeriesSelection;
import org.achartengine.renderer.DefaultRenderer;
import org.achartengine.renderer.SimpleSeriesRenderer;

public class PieChart
extends RoundChart {
    private PieMapper a = new PieMapper();

    public PieChart(CategorySeries categorySeries, DefaultRenderer defaultRenderer) {
        super(categorySeries, defaultRenderer);
    }

    @Override
    public void draw(Canvas canvas, int n2, int n3, int n4, int n5, Paint paint) {
        boolean bl;
        int n6;
        paint.setAntiAlias(this.mRenderer.isAntialiasing());
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize(this.mRenderer.getLabelsTextSize());
        int n7 = this.getLegendSize(this.mRenderer, n5 / 5, 0.0f);
        int n8 = n2;
        int n9 = n3;
        int n10 = n2 + n4;
        int n11 = this.mDataset.getItemCount();
        double d2 = 0.0;
        String[] stringArray = new String[n11];
        for (n6 = 0; n6 < n11; ++n6) {
            d2 += this.mDataset.getValue(n6);
            stringArray[n6] = this.mDataset.getCategory(n6);
        }
        if (this.mRenderer.isFitLegend()) {
            n7 = this.drawLegend(canvas, this.mRenderer, stringArray, n8, n10, n3, n4, n5, n7, paint, true);
        }
        n6 = n3 + n5 - n7;
        this.drawBackground(this.mRenderer, canvas, n2, n3, n4, n5, paint, false, 0);
        float f2 = this.mRenderer.getStartAngle();
        int n12 = Math.min(Math.abs(n10 - n8), Math.abs(n6 - n9));
        int n13 = (int)((double)n12 * 0.35 * (double)this.mRenderer.getScale());
        if (this.mCenterX == Integer.MAX_VALUE) {
            this.mCenterX = (n8 + n10) / 2;
        }
        if (this.mCenterY == Integer.MAX_VALUE) {
            this.mCenterY = (n6 + n9) / 2;
        }
        this.a.setDimensions(n13, this.mCenterX, this.mCenterY);
        boolean bl2 = bl = !this.a.areAllSegmentPresent(n11);
        if (bl) {
            this.a.clearPieSegments();
        }
        float f3 = (float)n13 * 0.9f;
        float f4 = (float)n13 * 1.1f;
        RectF rectF = new RectF((float)(this.mCenterX - n13), (float)(this.mCenterY - n13), (float)(this.mCenterX + n13), (float)(this.mCenterY + n13));
        ArrayList<RectF> arrayList = new ArrayList<RectF>();
        for (int i2 = 0; i2 < n11; ++i2) {
            SimpleSeriesRenderer simpleSeriesRenderer = this.mRenderer.getSeriesRendererAt(i2);
            if (simpleSeriesRenderer.isGradientEnabled()) {
                RadialGradient radialGradient = new RadialGradient((float)this.mCenterX, (float)this.mCenterY, f4, simpleSeriesRenderer.getGradientStartColor(), simpleSeriesRenderer.getGradientStopColor(), Shader.TileMode.MIRROR);
                paint.setShader((Shader)radialGradient);
            } else {
                paint.setColor(simpleSeriesRenderer.getColor());
            }
            float f5 = (float)this.mDataset.getValue(i2);
            float f6 = (float)((double)f5 / d2 * 360.0);
            if (simpleSeriesRenderer.isHighlighted()) {
                double d3 = Math.toRadians(90.0f - (f2 + f6 / 2.0f));
                float f7 = (float)((double)n13 * 0.1 * Math.sin(d3));
                float f8 = (float)((double)n13 * 0.1 * Math.cos(d3));
                rectF.offset(f7, f8);
                canvas.drawArc(rectF, f2, f6, true, paint);
                rectF.offset(-f7, -f8);
            } else {
                canvas.drawArc(rectF, f2, f6, true, paint);
            }
            paint.setColor(simpleSeriesRenderer.getColor());
            paint.setShader(null);
            this.drawLabel(canvas, this.mDataset.getCategory(i2), this.mRenderer, arrayList, this.mCenterX, this.mCenterY, f3, f4, f2, f6, n8, n10, this.mRenderer.getLabelsColor(), paint, true, false);
            if (this.mRenderer.isDisplayValues()) {
                this.drawLabel(canvas, this.getLabel(this.mRenderer.getSeriesRendererAt(i2).getChartValuesFormat(), this.mDataset.getValue(i2)), this.mRenderer, arrayList, this.mCenterX, this.mCenterY, f3 / 2.0f, f4 / 2.0f, f2, f6, n8, n10, this.mRenderer.getLabelsColor(), paint, false, true);
            }
            if (bl) {
                this.a.addPieSegment(i2, f5, f2, f6);
            }
            f2 += f6;
        }
        arrayList.clear();
        this.drawLegend(canvas, this.mRenderer, stringArray, n8, n10, n3, n4, n5, n7, paint, false);
        this.drawTitle(canvas, n2, n3, n4, paint);
    }

    @Override
    public SeriesSelection getSeriesAndPointForScreenCoordinate(Point point) {
        return this.a.getSeriesAndPointForScreenCoordinate(point);
    }
}

