/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.achartengine.chart.PieSegment;
import org.achartengine.model.Point;
import org.achartengine.model.SeriesSelection;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class PieMapper
implements Serializable {
    private List<PieSegment> a;
    private int a = new ArrayList<PieSegment>();
    private int b;
    private int c;

    public void setDimensions(int n2, int n3, int n4) {
        this.a = n2;
        this.b = n3;
        this.c = n4;
    }

    public boolean areAllSegmentPresent(int n2) {
        return this.a.size() == n2;
    }

    public void addPieSegment(int n2, float f2, float f3, float f4) {
        this.a.add(new PieSegment(n2, f2, f3, f4));
    }

    public void clearPieSegments() {
        this.a.clear();
    }

    public double getAngle(Point point) {
        double d2 = point.getX() - (float)this.b;
        double d3 = -(point.getY() - (float)this.c);
        double d4 = Math.atan2(d3, d2);
        d4 = d4 < 0.0 ? Math.abs(d4) : Math.PI * 2 - d4;
        return Math.toDegrees(d4);
    }

    public boolean isOnPieChart(Point point) {
        double d2;
        double d3 = Math.pow((float)this.b - point.getX(), 2.0) + Math.pow((float)this.c - point.getY(), 2.0);
        boolean bl = d3 <= (d2 = (double)(this.a * this.a));
        return bl;
    }

    public SeriesSelection getSeriesAndPointForScreenCoordinate(Point point) {
        if (this.isOnPieChart(point)) {
            double d2 = this.getAngle(point);
            for (PieSegment pieSegment : this.a) {
                if (!pieSegment.isInSegment(d2)) continue;
                return new SeriesSelection(0, pieSegment.getDataIndex(), pieSegment.getValue(), pieSegment.getValue());
            }
        }
        return null;
    }
}

