/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.util.List;
import org.achartengine.chart.BarChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.model.XYSeries;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;

public class RangeBarChart
extends BarChart {
    public static final String TYPE = "RangeBar";

    RangeBarChart() {
    }

    RangeBarChart(BarChart.Type type) {
        super(type);
    }

    public RangeBarChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, BarChart.Type type) {
        super(xYMultipleSeriesDataset, xYMultipleSeriesRenderer, type);
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, List<Float> list, SimpleSeriesRenderer simpleSeriesRenderer, float f2, int n2, int n3) {
        int n4 = this.mDataset.getSeriesCount();
        int n5 = list.size();
        paint.setColor(simpleSeriesRenderer.getColor());
        paint.setStyle(Paint.Style.FILL);
        float f3 = this.getHalfDiffX(list, n5, n4);
        int n6 = 0;
        if (n3 > 0) {
            n6 = 2;
        }
        for (int i2 = n6; i2 < n5; i2 += 4) {
            if (list.size() <= i2 + 3) continue;
            float f4 = list.get(i2).floatValue();
            float f5 = list.get(i2 + 1).floatValue();
            float f6 = list.get(i2 + 2).floatValue();
            float f7 = list.get(i2 + 3).floatValue();
            this.drawBar(canvas, f4, f5, f6, f7, f3, n4, n2, paint);
        }
        paint.setColor(simpleSeriesRenderer.getColor());
    }

    @Override
    protected void drawChartValuesText(Canvas canvas, XYSeries xYSeries, SimpleSeriesRenderer simpleSeriesRenderer, Paint paint, List<Float> list, int n2, int n3) {
        int n4 = this.mDataset.getSeriesCount();
        float f2 = this.getHalfDiffX(list, list.size(), n4);
        int n5 = 0;
        if (n3 > 0) {
            n5 = 2;
        }
        for (int i2 = n5; i2 < list.size(); i2 += 4) {
            int n6 = n3 + i2 / 2;
            float f3 = list.get(i2).floatValue();
            if (this.mType == BarChart.Type.DEFAULT) {
                f3 += (float)(n2 * 2) * f2 - ((float)n4 - 1.5f) * f2;
            }
            if (!this.isNullValue(xYSeries.getY(n6 + 1)) && list.size() > i2 + 3) {
                this.drawText(canvas, this.getLabel(simpleSeriesRenderer.getChartValuesFormat(), xYSeries.getY(n6 + 1)), f3, list.get(i2 + 3).floatValue() - simpleSeriesRenderer.getChartValuesSpacing(), paint, 0.0f);
            }
            if (this.isNullValue(xYSeries.getY(n6)) || list.size() <= i2 + 1) continue;
            this.drawText(canvas, this.getLabel(simpleSeriesRenderer.getChartValuesFormat(), xYSeries.getY(n6)), f3, list.get(i2 + 1).floatValue() + simpleSeriesRenderer.getChartValuesTextSize() + simpleSeriesRenderer.getChartValuesSpacing() - 3.0f, paint, 0.0f);
        }
    }

    @Override
    protected float getCoeficient() {
        return 0.5f;
    }

    @Override
    public String getChartType() {
        return TYPE;
    }
}

