/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import org.achartengine.chart.AbstractChart;
import org.achartengine.model.CategorySeries;
import org.achartengine.renderer.DefaultRenderer;
import org.achartengine.renderer.SimpleSeriesRenderer;

public abstract class RoundChart
extends AbstractChart {
    protected static final int SHAPE_WIDTH = 10;
    protected CategorySeries mDataset;
    protected DefaultRenderer mRenderer;
    protected static final int NO_VALUE = Integer.MAX_VALUE;
    protected int mCenterX = Integer.MAX_VALUE;
    protected int mCenterY = Integer.MAX_VALUE;

    public RoundChart(CategorySeries categorySeries, DefaultRenderer defaultRenderer) {
        this.mDataset = categorySeries;
        this.mRenderer = defaultRenderer;
    }

    public void drawTitle(Canvas canvas, int n2, int n3, int n4, Paint paint) {
        if (this.mRenderer.isShowLabels()) {
            paint.setColor(this.mRenderer.getLabelsColor());
            paint.setTextAlign(Paint.Align.CENTER);
            paint.setTextSize(this.mRenderer.getChartTitleTextSize());
            this.drawString(canvas, this.mRenderer.getChartTitle(), n2 + n4 / 2, (float)n3 + this.mRenderer.getChartTitleTextSize(), paint);
        }
    }

    @Override
    public int getLegendShapeWidth(int n2) {
        return 10;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer simpleSeriesRenderer, float f2, float f3, int n2, Paint paint) {
        canvas.drawRect(f2, f3 - 5.0f, f2 + 10.0f, f3 + 5.0f, paint);
    }

    public DefaultRenderer getRenderer() {
        return this.mRenderer;
    }

    public int getCenterX() {
        return this.mCenterX;
    }

    public int getCenterY() {
        return this.mCenterY;
    }

    public void setCenterX(int n2) {
        this.mCenterX = n2;
    }

    public void setCenterY(int n2) {
        this.mCenterY = n2;
    }
}

