/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import java.util.List;
import org.achartengine.chart.ClickableArea;
import org.achartengine.chart.XYChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.renderer.XYSeriesRenderer;

public class ScatterChart
extends XYChart {
    public static final String TYPE = "Scatter";
    private float a = 3.0f;

    ScatterChart() {
    }

    public ScatterChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        super(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        this.a = xYMultipleSeriesRenderer.getPointSize();
    }

    @Override
    protected void setDatasetRenderer(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        super.setDatasetRenderer(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        this.a = xYMultipleSeriesRenderer.getPointSize();
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, List<Float> list, SimpleSeriesRenderer simpleSeriesRenderer, float f2, int n2, int n3) {
        XYSeriesRenderer xYSeriesRenderer = (XYSeriesRenderer)simpleSeriesRenderer;
        paint.setColor(xYSeriesRenderer.getColor());
        float f3 = paint.getStrokeWidth();
        if (xYSeriesRenderer.isFillPoints()) {
            paint.setStyle(Paint.Style.FILL);
        } else {
            paint.setStrokeWidth(xYSeriesRenderer.getPointStrokeWidth());
            paint.setStyle(Paint.Style.STROKE);
        }
        int n4 = list.size();
        switch (xYSeriesRenderer.getPointStyle()) {
            case X: {
                paint.setStrokeWidth(xYSeriesRenderer.getPointStrokeWidth());
                for (int i2 = 0; i2 < n4; i2 += 2) {
                    this.a(canvas, paint, list.get(i2).floatValue(), list.get(i2 + 1).floatValue());
                }
                break;
            }
            case CIRCLE: {
                for (int i3 = 0; i3 < n4; i3 += 2) {
                    this.b(canvas, paint, list.get(i3).floatValue(), list.get(i3 + 1).floatValue());
                }
                break;
            }
            case TRIANGLE: {
                float[] fArray = new float[6];
                for (int i4 = 0; i4 < n4; i4 += 2) {
                    this.a(canvas, paint, fArray, list.get(i4).floatValue(), list.get(i4 + 1).floatValue());
                }
                break;
            }
            case SQUARE: {
                for (int i5 = 0; i5 < n4; i5 += 2) {
                    this.c(canvas, paint, list.get(i5).floatValue(), list.get(i5 + 1).floatValue());
                }
                break;
            }
            case DIAMOND: {
                float[] fArray = new float[8];
                for (int i6 = 0; i6 < n4; i6 += 2) {
                    this.b(canvas, paint, fArray, list.get(i6).floatValue(), list.get(i6 + 1).floatValue());
                }
                break;
            }
            case POINT: {
                for (int i7 = 0; i7 < n4; i7 += 2) {
                    canvas.drawPoint(list.get(i7).floatValue(), list.get(i7 + 1).floatValue(), paint);
                }
                break;
            }
        }
        paint.setStrokeWidth(f3);
    }

    @Override
    protected ClickableArea[] clickableAreasForPoints(List<Float> list, List<Double> list2, float f2, int n2, int n3) {
        int n4 = list.size();
        ClickableArea[] clickableAreaArray = new ClickableArea[n4 / 2];
        for (int i2 = 0; i2 < n4; i2 += 2) {
            int n5 = this.mRenderer.getSelectableBuffer();
            clickableAreaArray[i2 / 2] = new ClickableArea(new RectF(list.get(i2).floatValue() - (float)n5, list.get(i2 + 1).floatValue() - (float)n5, list.get(i2).floatValue() + (float)n5, list.get(i2 + 1).floatValue() + (float)n5), list2.get(i2), list2.get(i2 + 1));
        }
        return clickableAreaArray;
    }

    @Override
    public int getLegendShapeWidth(int n2) {
        return 10;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer simpleSeriesRenderer, float f2, float f3, int n2, Paint paint) {
        if (((XYSeriesRenderer)simpleSeriesRenderer).isFillPoints()) {
            paint.setStyle(Paint.Style.FILL);
        } else {
            paint.setStyle(Paint.Style.STROKE);
        }
        switch (((XYSeriesRenderer)simpleSeriesRenderer).getPointStyle()) {
            case X: {
                this.a(canvas, paint, f2 + 10.0f, f3);
                break;
            }
            case CIRCLE: {
                this.b(canvas, paint, f2 + 10.0f, f3);
                break;
            }
            case TRIANGLE: {
                this.a(canvas, paint, new float[6], f2 + 10.0f, f3);
                break;
            }
            case SQUARE: {
                this.c(canvas, paint, f2 + 10.0f, f3);
                break;
            }
            case DIAMOND: {
                this.b(canvas, paint, new float[8], f2 + 10.0f, f3);
                break;
            }
            case POINT: {
                canvas.drawPoint(f2 + 10.0f, f3, paint);
            }
        }
    }

    private void a(Canvas canvas, Paint paint, float f2, float f3) {
        canvas.drawLine(f2 - this.a, f3 - this.a, f2 + this.a, f3 + this.a, paint);
        canvas.drawLine(f2 + this.a, f3 - this.a, f2 - this.a, f3 + this.a, paint);
    }

    private void b(Canvas canvas, Paint paint, float f2, float f3) {
        canvas.drawCircle(f2, f3, this.a, paint);
    }

    private void a(Canvas canvas, Paint paint, float[] fArray, float f2, float f3) {
        fArray[0] = f2;
        fArray[1] = f3 - this.a - this.a / 2.0f;
        fArray[2] = f2 - this.a;
        fArray[3] = f3 + this.a;
        fArray[4] = f2 + this.a;
        fArray[5] = fArray[3];
        this.drawPath(canvas, fArray, paint, true);
    }

    private void c(Canvas canvas, Paint paint, float f2, float f3) {
        canvas.drawRect(f2 - this.a, f3 - this.a, f2 + this.a, f3 + this.a, paint);
    }

    private void b(Canvas canvas, Paint paint, float[] fArray, float f2, float f3) {
        fArray[0] = f2;
        fArray[1] = f3 - this.a;
        fArray[2] = f2 - this.a;
        fArray[3] = f3;
        fArray[4] = f2;
        fArray[5] = f3 + this.a;
        fArray[6] = f2 + this.a;
        fArray[7] = f3;
        this.drawPath(canvas, fArray, paint, true);
    }

    @Override
    public String getChartType() {
        return TYPE;
    }
}

