/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.tools;

import org.achartengine.chart.AbstractChart;
import org.achartengine.chart.XYChart;
import org.achartengine.renderer.XYMultipleSeriesRenderer;

public abstract class AbstractTool {
    protected AbstractChart mChart;
    protected XYMultipleSeriesRenderer mRenderer;

    public AbstractTool(AbstractChart abstractChart) {
        this.mChart = abstractChart;
        if (abstractChart instanceof XYChart) {
            this.mRenderer = ((XYChart)abstractChart).getRenderer();
        }
    }

    public double[] getRange(int n2) {
        double d2 = this.mRenderer.getXAxisMin(n2);
        double d3 = this.mRenderer.getXAxisMax(n2);
        double d4 = this.mRenderer.getYAxisMin(n2);
        double d5 = this.mRenderer.getYAxisMax(n2);
        return new double[]{d2, d3, d4, d5};
    }

    public void checkRange(double[] dArray, int n2) {
        double[] dArray2;
        if (this.mChart instanceof XYChart && (dArray2 = ((XYChart)this.mChart).getCalcRange(n2)) != null) {
            if (!this.mRenderer.isMinXSet(n2)) {
                dArray[0] = dArray2[0];
                this.mRenderer.setXAxisMin(dArray[0], n2);
            }
            if (!this.mRenderer.isMaxXSet(n2)) {
                dArray[1] = dArray2[1];
                this.mRenderer.setXAxisMax(dArray[1], n2);
            }
            if (!this.mRenderer.isMinYSet(n2)) {
                dArray[2] = dArray2[2];
                this.mRenderer.setYAxisMin(dArray[2], n2);
            }
            if (!this.mRenderer.isMaxYSet(n2)) {
                dArray[3] = dArray2[3];
                this.mRenderer.setYAxisMax(dArray[3], n2);
            }
        }
    }

    protected void setXRange(double d2, double d3, int n2) {
        this.mRenderer.setXAxisMin(d2, n2);
        this.mRenderer.setXAxisMax(d3, n2);
    }

    protected void setYRange(double d2, double d3, int n2) {
        this.mRenderer.setYAxisMin(d2, n2);
        this.mRenderer.setYAxisMax(d3, n2);
    }
}

