/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.tools;

import org.achartengine.chart.AbstractChart;
import org.achartengine.chart.RoundChart;
import org.achartengine.chart.XYChart;
import org.achartengine.model.XYSeries;
import org.achartengine.renderer.DefaultRenderer;
import org.achartengine.tools.AbstractTool;

public class FitZoom
extends AbstractTool {
    public FitZoom(AbstractChart abstractChart) {
        super(abstractChart);
    }

    public void apply() {
        if (this.mChart instanceof XYChart) {
            if (((XYChart)this.mChart).getDataset() == null) {
                return;
            }
            int n2 = this.mRenderer.getScalesCount();
            if (this.mRenderer.isInitialRangeSet()) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (!this.mRenderer.isInitialRangeSet(i2)) continue;
                    this.mRenderer.setRange(this.mRenderer.getInitialRange(i2), i2);
                }
            } else {
                XYSeries[] xYSeriesArray = ((XYChart)this.mChart).getDataset().getSeries();
                double[] dArray = null;
                int n3 = xYSeriesArray.length;
                if (n3 > 0) {
                    for (int i3 = 0; i3 < n2; ++i3) {
                        dArray = new double[]{Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308};
                        for (int i4 = 0; i4 < n3; ++i4) {
                            if (i3 != xYSeriesArray[i4].getScaleNumber()) continue;
                            dArray[0] = Math.min(dArray[0], xYSeriesArray[i4].getMinX());
                            dArray[1] = Math.max(dArray[1], xYSeriesArray[i4].getMaxX());
                            dArray[2] = Math.min(dArray[2], xYSeriesArray[i4].getMinY());
                            dArray[3] = Math.max(dArray[3], xYSeriesArray[i4].getMaxY());
                        }
                        double d2 = Math.abs(dArray[1] - dArray[0]) / 40.0;
                        double d3 = Math.abs(dArray[3] - dArray[2]) / 40.0;
                        this.mRenderer.setRange(new double[]{dArray[0] - d2, dArray[1] + d2, dArray[2] - d3, dArray[3] + d3}, i3);
                    }
                }
            }
        } else {
            DefaultRenderer defaultRenderer = ((RoundChart)this.mChart).getRenderer();
            defaultRenderer.setScale(defaultRenderer.getOriginalScale());
        }
    }
}

