/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.util;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class MathHelper {
    public static final double NULL_VALUE = Double.MAX_VALUE;
    private static final NumberFormat a = NumberFormat.getNumberInstance();

    private MathHelper() {
    }

    public static double[] minmax(List<Double> list) {
        double d2;
        if (list.size() == 0) {
            return new double[2];
        }
        double d3 = d2 = list.get(0).doubleValue();
        int n2 = list.size();
        for (int i2 = 1; i2 < n2; ++i2) {
            double d4 = list.get(i2);
            d2 = Math.min(d2, d4);
            d3 = Math.max(d3, d4);
        }
        return new double[]{d2, d3};
    }

    public static List<Double> getLabels(double d2, double d3, int n2) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (n2 <= 0) {
            return arrayList;
        }
        a.setMaximumFractionDigits(5);
        double[] dArray = MathHelper.computeLabels(d2, d3, n2);
        int n3 = 1 + (int)((dArray[1] - dArray[0]) / dArray[2]);
        for (int i2 = 0; i2 < n3; ++i2) {
            double d4 = dArray[0] + (double)i2 * dArray[2];
            try {
                d4 = a.parse(a.format(d4)).doubleValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            arrayList.add(d4);
        }
        return arrayList;
    }

    private static double[] computeLabels(double d2, double d3, int n2) {
        double d4;
        if (Math.abs(d2 - d3) < (double)1.0E-7f) {
            return new double[]{d2, d2, 0.0};
        }
        double d5 = d2;
        double d6 = d3;
        boolean bl = false;
        if (d5 > d6) {
            bl = true;
            d4 = d5;
            d5 = d6;
            d6 = d4;
        }
        d4 = MathHelper.roundUp(Math.abs(d5 - d6) / (double)n2);
        double d7 = d4 * Math.ceil(d5 / d4);
        double d8 = d4 * Math.floor(d6 / d4);
        if (bl) {
            return new double[]{d8, d7, -1.0 * d4};
        }
        return new double[]{d7, d8, d4};
    }

    private static double roundUp(double d2) {
        int n2 = (int)Math.floor(Math.log10(d2));
        double d3 = d2 * Math.pow(10.0, -n2);
        if (d3 > 5.0) {
            d3 = 10.0;
        } else if (d3 > 2.0) {
            d3 = 5.0;
        } else if (d3 > 1.0) {
            d3 = 2.0;
        }
        return d3 *= Math.pow(10.0, n2);
    }
}

