/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime;

import org.apache.http.entity.mime.Header;
import org.apache.http.entity.mime.MinimalField;
import org.apache.http.entity.mime.content.ContentBody;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class FormBodyPart {
    private final String a;
    private final Header a;
    private final ContentBody a;

    public FormBodyPart(String string, ContentBody contentBody) {
        if (string == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        if (contentBody == null) {
            throw new IllegalArgumentException("Body may not be null");
        }
        this.a = string;
        this.a = contentBody;
        this.a = new Header();
        this.generateContentDisp(contentBody);
        this.generateContentType(contentBody);
        this.generateTransferEncoding(contentBody);
    }

    public String getName() {
        return this.a;
    }

    public ContentBody getBody() {
        return this.a;
    }

    public Header getHeader() {
        return this.a;
    }

    public void addField(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Field name may not be null");
        }
        this.a.addField(new MinimalField(string, string2));
    }

    protected void generateContentDisp(ContentBody contentBody) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("form-data; name=\"");
        stringBuilder.append(this.getName());
        stringBuilder.append("\"");
        if (contentBody.getFilename() != null) {
            stringBuilder.append("; filename=\"");
            stringBuilder.append(contentBody.getFilename());
            stringBuilder.append("\"");
        }
        this.addField("Content-Disposition", stringBuilder.toString());
    }

    protected void generateContentType(ContentBody contentBody) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(contentBody.getMimeType());
        if (contentBody.getCharset() != null) {
            stringBuilder.append("; charset=");
            stringBuilder.append(contentBody.getCharset());
        }
        this.addField("Content-Type", stringBuilder.toString());
    }

    protected void generateTransferEncoding(ContentBody contentBody) {
        this.addField("Content-Transfer-Encoding", contentBody.getTransferEncoding());
    }
}

