/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.Header;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MIME;
import org.apache.http.entity.mime.MinimalField;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.util.ByteArrayBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class HttpMultipart {
    private static final ByteArrayBuffer a = HttpMultipart.encode(MIME.DEFAULT_CHARSET, ": ");
    private static final ByteArrayBuffer b = HttpMultipart.encode(MIME.DEFAULT_CHARSET, "\r\n");
    private static final ByteArrayBuffer c = HttpMultipart.encode(MIME.DEFAULT_CHARSET, "--");
    private final String a;
    private final Charset a;
    private final String b;
    private final List<FormBodyPart> a;
    private final HttpMultipartMode a;

    private static ByteArrayBuffer encode(Charset charset, String string) {
        ByteBuffer byteBuffer = charset.encode(CharBuffer.wrap(string));
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(byteBuffer.remaining());
        byteArrayBuffer.append(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining());
        return byteArrayBuffer;
    }

    private static void writeBytes(ByteArrayBuffer byteArrayBuffer, OutputStream outputStream) throws IOException {
        outputStream.write(byteArrayBuffer.buffer(), 0, byteArrayBuffer.length());
    }

    private static void writeBytes(String string, Charset charset, OutputStream outputStream) throws IOException {
        ByteArrayBuffer byteArrayBuffer = HttpMultipart.encode(charset, string);
        HttpMultipart.writeBytes(byteArrayBuffer, outputStream);
    }

    private static void writeBytes(String string, OutputStream outputStream) throws IOException {
        ByteArrayBuffer byteArrayBuffer = HttpMultipart.encode(MIME.DEFAULT_CHARSET, string);
        HttpMultipart.writeBytes(byteArrayBuffer, outputStream);
    }

    private static void writeField(MinimalField minimalField, OutputStream outputStream) throws IOException {
        HttpMultipart.writeBytes(minimalField.getName(), outputStream);
        HttpMultipart.writeBytes(a, outputStream);
        HttpMultipart.writeBytes(minimalField.getBody(), outputStream);
        HttpMultipart.writeBytes(b, outputStream);
    }

    private static void writeField(MinimalField minimalField, Charset charset, OutputStream outputStream) throws IOException {
        HttpMultipart.writeBytes(minimalField.getName(), charset, outputStream);
        HttpMultipart.writeBytes(a, outputStream);
        HttpMultipart.writeBytes(minimalField.getBody(), charset, outputStream);
        HttpMultipart.writeBytes(b, outputStream);
    }

    public HttpMultipart(String string, Charset charset, String string2, HttpMultipartMode httpMultipartMode) {
        if (string == null) {
            throw new IllegalArgumentException("Multipart subtype may not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Multipart boundary may not be null");
        }
        this.a = string;
        this.a = charset != null ? charset : MIME.DEFAULT_CHARSET;
        this.b = string2;
        this.a = new ArrayList();
        this.a = httpMultipartMode;
    }

    public HttpMultipart(String string, Charset charset, String string2) {
        this(string, charset, string2, HttpMultipartMode.STRICT);
    }

    public HttpMultipart(String string, String string2) {
        this(string, null, string2);
    }

    public String getSubType() {
        return this.a;
    }

    public Charset getCharset() {
        return this.a;
    }

    public HttpMultipartMode getMode() {
        return this.a;
    }

    public List<FormBodyPart> getBodyParts() {
        return this.a;
    }

    public void addBodyPart(FormBodyPart formBodyPart) {
        if (formBodyPart == null) {
            return;
        }
        this.a.add(formBodyPart);
    }

    public String getBoundary() {
        return this.b;
    }

    private void a(HttpMultipartMode httpMultipartMode, OutputStream outputStream, boolean bl) throws IOException {
        ByteArrayBuffer byteArrayBuffer = HttpMultipart.encode(this.a, this.getBoundary());
        for (FormBodyPart formBodyPart : this.a) {
            HttpMultipart.writeBytes(c, outputStream);
            HttpMultipart.writeBytes(byteArrayBuffer, outputStream);
            HttpMultipart.writeBytes(b, outputStream);
            Header header = formBodyPart.getHeader();
            switch (httpMultipartMode) {
                case STRICT: {
                    for (Object object : header) {
                        HttpMultipart.writeField((MinimalField)object, outputStream);
                    }
                    break;
                }
                case BROWSER_COMPATIBLE: {
                    Object object;
                    MinimalField minimalField = formBodyPart.getHeader().getField("Content-Disposition");
                    HttpMultipart.writeField(minimalField, this.a, outputStream);
                    object = formBodyPart.getBody().getFilename();
                    if (object == null) break;
                    MinimalField minimalField2 = formBodyPart.getHeader().getField("Content-Type");
                    HttpMultipart.writeField(minimalField2, this.a, outputStream);
                }
            }
            HttpMultipart.writeBytes(b, outputStream);
            if (bl) {
                formBodyPart.getBody().writeTo(outputStream);
            }
            HttpMultipart.writeBytes(b, outputStream);
        }
        HttpMultipart.writeBytes(c, outputStream);
        HttpMultipart.writeBytes(byteArrayBuffer, outputStream);
        HttpMultipart.writeBytes(c, outputStream);
        HttpMultipart.writeBytes(b, outputStream);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.a(this.a, outputStream, true);
    }

    public long getTotalLength() {
        long l = 0L;
        for (Object object : this.a) {
            ContentBody contentBody = ((FormBodyPart)object).getBody();
            long l2 = contentBody.getContentLength();
            if (l2 >= 0L) {
                l += l2;
                continue;
            }
            return -1L;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Object object;
            this.a(this.a, byteArrayOutputStream, false);
            object = byteArrayOutputStream.toByteArray();
            return l + (long)((Object)object).length;
        }
        catch (IOException iOException) {
            return -1L;
        }
    }
}

