/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.AltitudeMode;
import com.supermap.realspace.i;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Camera {
    private double a;
    private double b;
    private double c;
    private double d;
    private double e;
    private AltitudeMode a = AltitudeMode.RELATIVE_TO_GROUND;

    public Camera() {
    }

    public Camera(Camera camera) {
        this(camera.getLongitude(), camera.getLatitude(), camera.getAltitude(), camera.getAltitudeMode(), camera.getHeading(), camera.getTilt());
    }

    public Camera(double d2, double d3, double d4) {
        this(d2, d3, d4, AltitudeMode.ABSOLUTE, 0.0, 0.0);
    }

    public Camera(double d2, double d3, double d4, AltitudeMode altitudeMode, double d5, double d6) {
        this.a = d4;
        this.c = d3;
        this.b = d5;
        this.e = d6;
        this.d = d2;
        this.a = altitudeMode;
    }

    public double getAltitude() {
        return this.a;
    }

    public void setAltitude(double d2) {
        this.a = d2;
    }

    public double getHeading() {
        return this.b;
    }

    public void setHeading(double d2) {
        if (d2 < 0.0 || d2 > 360.0) {
            String string2 = i.a("value", "Camera_HeadingOutOfRange", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        this.b = d2;
    }

    public double getLatitude() {
        return this.c;
    }

    public void setLatitude(double d2) {
        if (d2 < -90.0 || d2 > 90.0) {
            String string2 = i.a("value", "Camera_LatitudeOutOfRange", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        this.c = d2;
    }

    public double getLongitude() {
        return this.d;
    }

    public void setLongitude(double d2) {
        if (d2 < -180.0 || d2 > 180.0) {
            String string2 = i.a("value", "Camera_LongitudeOutOfRange", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        this.d = d2;
    }

    public double getTilt() {
        return this.e;
    }

    public void setTilt(double d2) {
        if (d2 < -180.0 || d2 > 180.0) {
            String string2 = i.a("value", "Camera_TiltOutOfRange", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        this.e = d2;
    }

    public AltitudeMode getAltitudeMode() {
        return this.a;
    }

    public void setAltitudeMode(AltitudeMode altitudeMode) {
        if (altitudeMode == null) {
            String string2 = i.a("value", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        this.a = altitudeMode;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Altitude=");
        stringBuffer.append(this.getAltitude());
        stringBuffer.append(",Heading=");
        stringBuffer.append(this.getHeading());
        stringBuffer.append(",Latitude=");
        stringBuffer.append(this.getLatitude());
        stringBuffer.append(",Longitude=");
        stringBuffer.append(this.getLongitude());
        stringBuffer.append(",Tilt=");
        stringBuffer.append(this.getTilt());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    static double computeDistance(double d2, double d3) {
        double d4 = Math.PI - d3 * (Math.PI / 180);
        double d5 = 4.0680631590769E13;
        double d6 = Math.cos(d4);
        double d7 = d6 * d6;
        double d8 = d5 * (d7 - 1.0) + (6378137.0 + d2) * (6378137.0 + d2);
        double d9 = Math.sqrt(d8);
        double d10 = 6378137.0 * (1.0 + d6) + d9 - 6378137.0;
        return d10;
    }

    static double computeAltitude(double d2, double d3) {
        double d4 = Math.PI - d3 * (Math.PI / 180);
        double d5 = 4.0680631590769E13;
        double d6 = Math.cos(d4);
        double d7 = d6 * d6;
        double d8 = d2 + 6378137.0 - 6378137.0 * (1.0 + d6);
        double d9 = Math.sqrt(d8 * d8 - d5 * (d7 - 1.0)) - 6378137.0;
        return d9;
    }
}

