/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import android.graphics.Bitmap;
import android.graphics.Point;
import android.os.SystemClock;
import android.util.Log;
import com.supermap.data.AltitudeMode;
import com.supermap.data.Enum;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Point3D;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Workspace;
import com.supermap.realspace.Camera;
import com.supermap.realspace.FlyManager;
import com.supermap.realspace.GlobalImage;
import com.supermap.realspace.Layer3D;
import com.supermap.realspace.Layer3Ds;
import com.supermap.realspace.MultiViewportMode;
import com.supermap.realspace.OLAccountManager;
import com.supermap.realspace.PixelToGlobeMode;
import com.supermap.realspace.SceneControl;
import com.supermap.realspace.SceneNative;
import com.supermap.realspace.TerrainLayers;
import com.supermap.realspace.TrackingLayer3D;
import com.supermap.realspace.a;
import com.supermap.realspace.i;
import java.io.File;
import java.util.Date;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Scene
extends InternalHandleDisposable {
    private Workspace a;
    private Layer3Ds a;
    private TrackingLayer3D a;
    private TerrainLayers a;
    SceneControl a;
    private FlyManager a;
    private String a;
    private boolean a;
    private boolean b = false;
    private GlobalImage a = true;
    private boolean c = false;
    private boolean d = false;
    private boolean e = false;
    private boolean f = false;
    private boolean g = false;

    public Scene() {
        this(null);
    }

    Scene(Workspace workspace) {
        long l2 = SceneNative.jni_New("");
        this.setHandle(l2, true);
        if (workspace != null) {
            long l3 = InternalHandle.getHandle((InternalHandle)workspace);
            if (l3 == 0L) {
                String string2 = i.a("workspace", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalArgumentException(string2);
            }
            this.setWorkspace(workspace);
        }
    }

    Scene(long l2, SceneControl sceneControl) {
        this.setHandle(l2, false);
        this.a = sceneControl;
        SceneNative.jni_NewSelfEventHandle(this.a.getHandle(), this);
        SceneNative.jni_SetDrawMode(this.getHandle());
    }

    public Camera getCamera() {
        if (this.getHandle() == 0L) {
            String string2 = i.a("getCamera()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        double[] dArray = new double[6];
        long l2 = SceneNative.jni_GetCamera(this.getHandle(), dArray);
        Camera camera = null;
        if (l2 != 0L) {
            camera = new Camera(dArray[0] * 57.29577951308232, dArray[1] * 57.29577951308232, Camera.computeAltitude(dArray[2], dArray[5] * 57.29577951308232), (AltitudeMode)com.supermap.realspace.a.parse(AltitudeMode.class, (int)((int)dArray[3])), dArray[4] * 57.29577951308232, dArray[5] * 57.29577951308232);
        }
        return camera;
    }

    public void setCamera(Camera camera) {
        if (this.getHandle() == 0L) {
            String string2 = i.a("setCamera(camera)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (camera == null) {
            String string3 = i.a("camera", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string3);
        }
        SceneNative.jni_SetCameraValue(this.getHandle(), camera.getLongitude() * (Math.PI / 180), camera.getLatitude() * (Math.PI / 180), Camera.computeDistance(camera.getAltitude(), camera.getTilt()), camera.getHeading() * (Math.PI / 180), camera.getTilt() * (Math.PI / 180));
    }

    public TerrainLayers getTerrainLayers() {
        long l2;
        if (this.getHandle() == 0L) {
            String string2 = i.a("GetTerrainLayers()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (this.a == null && (l2 = SceneNative.jni_getTerrainLayers(this.getHandle())) != 0L) {
            this.a = TerrainLayers.createInstance(this, l2);
        }
        return this.a;
    }

    public TrackingLayer3D getTrackingLayer() {
        long l2;
        if (this.getHandle() == 0L) {
            String string2 = i.a("getTrackingLayer()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (this.a == null && (l2 = SceneNative.jni_GetTrackingLayer(this.getHandle())) != 0L) {
            this.a = TrackingLayer3D.createInstance(l2, this);
        }
        return this.a;
    }

    public Workspace getWorkspace() {
        if (this.getHandle() == 0L) {
            String string2 = i.a("getWorkspace()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        return this.a;
    }

    public void setWorkspace(Workspace workspace) {
        long l2;
        if (this.getHandle() == 0L) {
            String string2 = i.a("setWorkspace(Workspace workspace)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (this.getWorkspace() != null && this.getWorkspace().equals(workspace)) {
            return;
        }
        String string3 = "";
        if (this.a != null) {
            l2 = InternalHandle.getHandle((InternalHandle)this.a);
            if (l2 == 0L) {
                String string4 = i.a("setWorkspace()", "Map_DontDisposeOldWorkspace", "realspace_resources");
                throw new IllegalStateException(string4);
            }
            string3 = this.a();
        }
        this.a = false;
        this.sceneReset();
        while (!this.a) {
            SystemClock.sleep((long)500L);
        }
        this.a = false;
        if (workspace == null) {
            this.a = null;
        } else {
            l2 = InternalHandle.getHandle((InternalHandle)workspace);
            if (l2 == 0L) {
                String string5 = i.a("workspace", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalArgumentException(string5);
            }
            SceneNative.jni_SetWorkspace(this.getHandle(), l2);
            this.a = workspace;
        }
        if (!string3.trim().equals("")) {
            this.a(string3);
        }
    }

    public Layer3Ds getLayers() {
        long l2;
        if (this.getHandle() == 0L) {
            String string2 = i.a("getLayers()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (this.a == null && (l2 = SceneNative.jni_GetLayers(this.getHandle())) != 0L) {
            this.a = Layer3Ds.createInstance(l2, this);
        }
        return this.a;
    }

    public void flyToPoint(Point3D point3D) {
        if (this.getHandle() == 0L) {
            String string2 = i.a("flyTo(Object targetObject, FlyingMode flyingMode, boolean isDirect)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        SceneNative.jni_FlyToPoint(this.getHandle(), point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public void flyToPoint(Point3D point3D, int n2) {
        if (this.getHandle() == 0L) {
            String string2 = i.a("flyToPoint(Point3D point,int milliseconds)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        SceneNative.jni_FlyToPointTime(this.getHandle(), point3D.getX(), point3D.getY(), point3D.getZ(), n2);
    }

    public void flyToCamera(Camera camera, int n2, boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = i.a("flyToCamera(Camera camera,int altitudeMode,boolean isDirect)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        SceneNative.jni_FlyToCameraDirect(this.getHandle(), camera.getLongitude() * (Math.PI / 180), camera.getLatitude() * (Math.PI / 180), Camera.computeDistance(camera.getAltitude(), camera.getTilt()), n2, camera.getHeading() * (Math.PI / 180), camera.getTilt() * (Math.PI / 180), bl);
    }

    public void flyToCamera(Camera camera, int n2, int n3) {
        if (this.getHandle() == 0L) {
            String string2 = i.a("flyToCamera(Camera camera,int altitudeMode,int milliseconds)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        SceneNative.jni_FlyToBymillisecondsCameraDirect(this.getHandle(), camera.getLongitude() * (Math.PI / 180), camera.getLatitude() * (Math.PI / 180), Camera.computeDistance(camera.getAltitude(), camera.getTilt()), n2, camera.getHeading() * (Math.PI / 180), camera.getTilt() * (Math.PI / 180), n3);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string2 = i.a("dispose()", "Handle_UndisposableObject", "realspace_resources");
            throw new UnsupportedOperationException(string2);
        }
        if (this.getHandle() != 0L) {
            SceneNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public void viewEntire() {
        if (this.getHandle() == 0L) {
            String string2 = i.a("viewEntire()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        SceneNative.jni_ViewEntire(this.getHandle());
    }

    public void refresh() {
        if (this.getHandle() == 0L) {
            String string2 = i.a("refresh()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        SceneNative.jni_Refresh(this.getHandle());
    }

    String a() {
        String string2;
        File file;
        if (this.getHandle() == 0L) {
            String string3 = i.a("toXML()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string3);
        }
        if (!this.a()) {
            String string4 = i.a("toXML()", "Map_WorkspaceIsEmpty", "realspace_resources");
            throw new IllegalStateException(string4);
        }
        String string5 = "";
        if (this.getWorkspace() != null && (file = new File(string2 = this.getWorkspace().getConnectionInfo().getServer())).exists()) {
            string5 = file.getParent();
        }
        return SceneNative.jni_ToXML(this.getHandle(), string5);
    }

    boolean a(String string2) {
        if (this.getHandle() == 0L) {
            String string3 = i.a("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string3);
        }
        if (this.a == null || InternalHandle.getHandle((InternalHandle)this.a) == 0L) {
            String string4 = i.a("fromXML(String xml)", "Map_WorkspaceIsEmpty", "realspace_resources");
            throw new IllegalStateException(string4);
        }
        boolean bl = false;
        if (string2 != null && string2.trim().length() != 0) {
            String string5;
            File file;
            String string6 = "";
            if (this.getWorkspace() != null && (file = new File(string5 = this.getWorkspace().getConnectionInfo().getServer())).exists()) {
                string6 = file.getParent();
            }
            long l2 = 0L;
            if (this.getWorkspace() != null) {
                l2 = InternalHandle.getHandle((InternalHandle)this.getWorkspace());
            }
            if (bl = SceneNative.jni_FromXML(this.getHandle(), string2, string6, l2)) {
                this.a();
                this.getLayers();
                this.getTerrainLayers();
            }
        }
        return bl;
    }

    public boolean open(String string2) {
        if (this.getHandle() == 0L) {
            String string3 = i.a("open()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string3);
        }
        if (this.a == null) {
            String string4 = i.a("workspace", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalStateException(string4);
        }
        long l2 = InternalHandle.getHandle((InternalHandle)this.a);
        if (l2 == 0L) {
            String string5 = i.a("workspace", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string5);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string6 = i.a("name", "Scene_NameIsInvalid", "realspace_resources");
            throw new IllegalStateException(string6);
        }
        int n2 = this.a.getScenes().indexOf(string2);
        if (n2 == -1) {
            String string7 = i.a("name", "Scene_SpecifiedNameNotExists", "realspace_resources");
            throw new IllegalStateException(string7);
        }
        final String string8 = this.a.getScenes().getSceneXML(n2);
        SceneControl.mRenderThread.b();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Scene.this.f = Scene.this.a(string8);
                Scene.this.g = true;
            }
        };
        SceneControl.mRenderThread.a.post(runnable);
        SceneControl.mRenderThread.a();
        while (!this.g) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (this.f) {
            this.a = "";
        }
        this.g = false;
        return this.f;
    }

    public boolean open(String string2, String string3) {
        if (this.getHandle() == 0L) {
            String string4 = i.a("open()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string4);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string5 = i.a("strServerUrl", "Scene_NameIsInvalid", "realspace_resources");
            throw new IllegalStateException(string5);
        }
        if (string3 == null || string3.trim().length() == 0) {
            String string6 = i.a("strSceneName", "Scene_NameIsInvalid", "realspace_resources");
            throw new IllegalStateException(string6);
        }
        SceneControl.mRenderThread.b();
        boolean bl = SceneNative.jni_Open(this.getHandle(), string2, string3);
        SceneControl.mRenderThread.a();
        if (bl) {
            this.a = string2;
        }
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        return bl;
    }

    public boolean open(final String string2, final String string3, final String string4) {
        if (this.getHandle() == 0L) {
            String string5 = i.a("open()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string5);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string6 = i.a("strServerUrl", "Scene_NameIsInvalid", "realspace_resources");
            throw new IllegalStateException(string6);
        }
        if (string3 == null || string3.trim().length() == 0) {
            String string7 = i.a("strSceneName", "Scene_NameIsInvalid", "realspace_resources");
            throw new IllegalStateException(string7);
        }
        SceneControl.mRenderThread.b();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Scene.this.e = SceneNative.jni_Open2(Scene.this.getHandle(), string2, string3, string4);
                Scene.this.g = true;
            }
        };
        SceneControl.mRenderThread.a.post(runnable);
        SceneControl.mRenderThread.a();
        while (!this.g) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (this.e) {
            this.a = string2;
        }
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        this.g = false;
        return this.e;
    }

    public boolean openPrivateSceneWithUrl(final String string2, final String string3) {
        if (this.getHandle() == 0L) {
            String string4 = i.a("open()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string4);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string5 = i.a("strServerUrl", "Scene_NameIsInvalid", "realspace_resources");
            throw new IllegalStateException(string5);
        }
        if (string3 == null || string3.trim().length() == 0) {
            String string6 = i.a("strSceneName", "Scene_NameIsInvalid", "realspace_resources");
            throw new IllegalStateException(string6);
        }
        OLAccountManager.readAccount();
        final String string7 = OLAccountManager.OnlineKey;
        if (string7 == null || string7 == "") {
            Log.e((String)"supermap", (String)"please login again");
            return false;
        }
        Date date = new Date();
        boolean bl = Scene.differentByMinute(date, OLAccountManager.StringFormatDate(OLAccountManager.OnlineDate));
        if (bl) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String string22 = OLAccountManager.OnlineUsername;
                        String string32 = OLAccountManager.OnlinePassword;
                        OLAccountManager.loginWithUsernameComplete(string22, string32, new OLAccountManager.LoginCallBackListenner(){

                            @Override
                            public void onFailure(String string2) {
                                Log.e((String)"supermap", (String)"login failed");
                            }

                            @Override
                            public void onSuccess(String string2) {
                                SceneControl cfr_ignored_0 = Scene.this.a;
                                SceneControl.mRenderThread.b();
                                Scene.this.c = SceneNative.jni_Open3(Scene.this.getHandle(), string2, string3, string7);
                                SceneControl cfr_ignored_1 = Scene.this.a;
                                SceneControl.mRenderThread.a();
                                if (Scene.this.c) {
                                    Scene.this.a = string2;
                                }
                                if (Scene.this.a != null) {
                                    Scene.this.a.clearHandle();
                                    Scene.this.a = null;
                                }
                                if (Scene.this.a != null) {
                                    Scene.this.a.clearHandle();
                                    Scene.this.a = null;
                                }
                                Scene.this.d = true;
                            }
                        });
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }).start();
            while (!this.d) {
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            return this.c;
        }
        SceneControl.mRenderThread.b();
        this.c = SceneNative.jni_Open3(this.getHandle(), string2, string3, string7);
        SceneControl.mRenderThread.a();
        if (this.c) {
            this.a = string2;
        }
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        return this.c;
    }

    public void close() {
        if (this.getHandle() == 0L) {
            String string2 = i.a("close()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SceneNative.jni_Reset(Scene.this.getHandle());
                SceneNative.jni_SetDrawMode(Scene.this.getHandle());
                Scene.this.a = true;
            }
        };
        SceneControl.mRenderThread.a.post(runnable);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string2 = i.a("getName()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        return SceneNative.jni_getName(this.getHandle());
    }

    public String getUrl() {
        return this.a;
    }

    public void ensureVisible(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string2 = i.a("ensureVisible(Rectangle2D visibleBounds)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        SceneNative.jni_EnsureVisible(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
    }

    public void ensureVisible(Layer3D layer3D) {
        if (this.getHandle() == 0L) {
            String string2 = i.a("ensureVisible(Layer3D layer3d)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (layer3D == null) {
            String string3 = i.a("layer3d", "Global_ArgumentNull", "realspace_resources");
            throw new IndexOutOfBoundsException(string3);
        }
        SceneNative.jni_EnsureVisible3(this.getHandle(), InternalHandle.getHandle((InternalHandle)layer3D));
    }

    static void flownCallBack(Scene scene) {
        if (scene != null) {
            // empty if block
        }
    }

    private boolean a() {
        boolean bl = true;
        if (this.a == null) {
            bl = false;
        } else {
            long l2 = InternalHandle.getHandle((InternalHandle)this.a);
            if (l2 == 0L) {
                bl = false;
            }
        }
        return bl;
    }

    protected static void clearHandle(Scene scene) {
        scene.clearHandle();
    }

    protected static Scene createInstance(long l2, SceneControl sceneControl) {
        return new Scene(l2, sceneControl);
    }

    private void a() {
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
    }

    protected void clearHandle() {
        if (this.a != null) {
            this.a.stop();
        }
        this.a = null;
        this.a = null;
        this.setHandle(0L);
    }

    protected static void InternalClearHandle(Scene scene) {
        Scene.clearHandle(scene);
    }

    public FlyManager getFlyManager() {
        if (this.getHandle() == 0L) {
            String string2 = i.a("setFirstPersonCamera(Camera camera)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (this.a == null) {
            this.a = new FlyManager();
            this.a.setScene(this);
        }
        return this.a;
    }

    public Point3D pixelToGlobe(Point point) {
        if (this.getHandle() == 0L) {
            String string2 = i.a("pixelToGlobe(Point point)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        Point3D point3D = new Point3D();
        double[] dArray = new double[]{Double.NaN, Double.NaN, Double.NaN};
        if (this.a != null) {
            double[] dArray2 = new double[]{point.x, point.y};
            SceneNative.jni_PixelToScene(this.getHandle(), this.a.getHandle(), dArray2, dArray);
        }
        point3D.setX(dArray[0] * 57.29577951308232);
        point3D.setY(dArray[1] * 57.29577951308232);
        point3D.setZ(dArray[2]);
        return point3D;
    }

    public Point3D pixelToGlobe(Point point, final PixelToGlobeMode pixelToGlobeMode) {
        if (this.getHandle() == 0L) {
            String string2 = i.a("pixelToGlobe(Point point, PixelToGlobeMode mode)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        Point3D point3D = new Point3D();
        final double[] dArray = new double[]{Double.NaN, Double.NaN, Double.NaN};
        if (this.a != null) {
            final double[] dArray2 = new double[]{point.x, point.y};
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SceneNative.jni_PixelToWorld(Scene.this.getHandle(), Scene.this.a.getHandle(), dArray2, pixelToGlobeMode.value(), dArray);
                    Scene.this.b = true;
                }
            };
            SceneControl.mRenderThread.a.post(runnable);
        }
        while (!this.b) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        point3D.setX(dArray[0] * 57.29577951308232);
        point3D.setY(dArray[1] * 57.29577951308232);
        point3D.setZ(dArray[2]);
        this.b = false;
        return point3D;
    }

    public Point globeToPixel(Point3D point3D) {
        if (this.getHandle() == 0L) {
            String string2 = i.a("globeToPixel(Point3D point)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        double[] dArray = new double[]{point3D.getX(), point3D.getY(), point3D.getZ()};
        double[] dArray2 = new double[2];
        if (this.a != null) {
            SceneNative.jni_SceneToPixel(this.getHandle(), this.a.getHandle(), dArray, dArray2);
        }
        Point point = new Point();
        point.x = (int)dArray2[0];
        point.y = (int)dArray2[1];
        return point;
    }

    public Bitmap outputSceneToBitmap() {
        if (this.getHandle() == 0L) {
            String string2 = i.a("outputMapToBitmap", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (this.a == null) {
            String string3 = i.a("outputMapToBitmap", "Scene_RenderEnvironmentInvalid", "realspace_resources");
            throw new UnsupportedOperationException(string3);
        }
        int[] nArray = new int[2];
        SceneNative.jni_GetImageBounds(this.getHandle(), nArray);
        int n2 = nArray[0];
        int n3 = nArray[1];
        Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        SceneNative.jni_OutputSceneToBitmap(this.getHandle(), bitmap);
        return bitmap;
    }

    public void zoom(double d2) {
        if (this.getHandle() == 0L) {
            String string2 = i.a("zoom()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        SceneNative.jni_Zoom(this.a.getHandle(), d2);
    }

    public void setPitch(double d2) {
        if (this.getHandle() == 0L) {
            String string2 = i.a("setPitch()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        SceneNative.jni_SetPitch(this.getHandle(), d2);
    }

    public void setRollEye(double d2) {
        if (this.getHandle() == 0L) {
            String string2 = i.a("setRollEye()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        SceneNative.jni_SetRollEye(this.getHandle(), d2);
    }

    public void stopCameraInteria() {
        if (this.getHandle() == 0L) {
            String string2 = i.a("stopCameraInteria()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        SceneNative.jni_StopCameraInteria(this.getHandle());
    }

    public void flyCircle(Geometry geometry, double d2) {
        if (this.getHandle() == 0L) {
            String string2 = i.a("FlyCircle(geometry,speedRatio)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (geometry == null) {
            String string3 = i.a("geometry", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string3);
        }
        long l2 = InternalHandle.getHandle((InternalHandle)geometry);
        if (l2 == 0L) {
            String string4 = i.a("geometry", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string4);
        }
        Geometry geometry2 = geometry.clone();
        InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)geometry2, (boolean)false);
        long l3 = InternalHandle.getHandle((InternalHandle)geometry2);
        SceneNative.jni_FlyCircle(this.getHandle(), l3, d2);
    }

    public Camera getFirstPersonCamera() {
        if (this.getHandle() == 0L) {
            String string2 = i.a("getFirstPersonCamera()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        double[] dArray = new double[6];
        long l2 = SceneNative.jni_GetFirstPersonCamera(this.getHandle(), dArray);
        Camera camera = null;
        if (l2 != 0L) {
            camera = new Camera(dArray[0] * 57.29577951308232, dArray[1] * 57.29577951308232, dArray[2], (AltitudeMode)com.supermap.realspace.a.parse(AltitudeMode.class, (int)((int)dArray[3])), dArray[4] * 57.29577951308232, dArray[5] * 57.29577951308232);
        }
        return camera;
    }

    public void setFirstPersonCamera(Camera camera) {
        if (this.getHandle() == 0L) {
            String string2 = i.a("setFirstPersonCamera(Camera camera)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (camera == null) {
            String string3 = i.a("camera", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string3);
        }
        SceneNative.jni_SetFirstPersonCameraValue(this.getHandle(), camera.getLongitude() * (Math.PI / 180), camera.getLatitude() * (Math.PI / 180), Camera.computeDistance(camera.getAltitude(), camera.getTilt()), com.supermap.realspace.a.a((Enum)camera.getAltitudeMode()), camera.getHeading() * (Math.PI / 180), camera.getTilt() * (Math.PI / 180), camera.getAltitude());
    }

    public void pan(double d2, double d3) {
        if (this.getHandle() == 0L) {
            String string2 = i.a("Pan(double offsetLongitude, double offsetLatitude)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        SceneNative.jni_Pan(this.getHandle(), d2, d3);
    }

    public void sceneReset() {
        if (this.getHandle() == 0L) {
            String string2 = i.a("sceneReset()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SceneNative.jni_Reset(Scene.this.getHandle());
                Scene.this.a = true;
            }
        };
        SceneControl.mRenderThread.a.post(runnable);
    }

    public boolean isZoomFlyPitching() {
        if (this.getHandle() == 0L) {
            String string2 = i.a("isZoomFlyPitching()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = SceneNative.jni_IsZoomFlyPitching(this.getHandle());
        return bl;
    }

    public void setZoomFlyPitching(boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = i.a("setZoomFlyPitching()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        SceneNative.jni_SetZoomFlyPitching(this.getHandle(), bl);
    }

    public void setMultiViewportMode(final MultiViewportMode multiViewportMode) {
        if (this.getHandle() == 0L) {
            String string2 = i.a("setMultiViewportMode(multiViewportMode))", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SceneNative.jni_SetMultiViewportMode(Scene.this.getHandle(), multiViewportMode.value());
            }
        };
        SceneControl.mRenderThread.a.post(runnable);
    }

    public MultiViewportMode getMultiViewportMode() {
        if (this.getHandle() == 0L) {
            String string2 = i.a("getMultiViewportMode()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        int n2 = SceneNative.jni_GetMultiViewportMode(this.getHandle());
        return (MultiViewportMode)com.supermap.realspace.a.parse(MultiViewportMode.class, (int)n2);
    }

    public GlobalImage getGlobalImage() {
        if (this.getHandle() == 0L) {
            String string2 = i.a("GlobalImage getGlobalImage()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (this.a == null) {
            this.a = new GlobalImage(this);
        }
        return this.a;
    }

    public boolean getAtmosphereVisible() {
        if (this.getHandle() == 0L) {
            String string2 = i.a("getAtmosphereVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        bl = SceneNative.jni_GetAtmosphereVisible(this.getHandle());
        return bl;
    }

    public void setAtmosphereVisible(boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = i.a(" setAtmosphereVisible(boolean atmosphereVisible)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        SceneNative.jni_SetAtmosphereVisible(this.getHandle(), bl);
    }

    public void setCreateSkirt(final boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = i.a(" setCreateSkirt(boolean createSkirt)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SceneNative.jni_SetCreateSkirt(Scene.this.getHandle(), bl);
            }
        };
        SceneControl.mRenderThread.a.post(runnable);
    }

    public boolean getCreateSkirt() {
        if (this.getHandle() == 0L) {
            String string2 = i.a("getCreateSkirt()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        bl = SceneNative.jni_GetCreateSkirt(this.getHandle());
        return bl;
    }

    private static boolean differentByMinute(Date date, Date date2) {
        int n2 = (int)((date.getTime() - date2.getTime()) / 60000L);
        return n2 > 30;
    }
}

