/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.onlineservices;

import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.onlineservices.GeocodingData;
import com.supermap.onlineservices.GeocodingParameter;
import com.supermap.onlineservices.NetworkErrorInfo;
import com.supermap.onlineservices.ParseUtils;
import java.net.URLEncoder;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Geocoding {
    private static int a = 0;
    private String a;
    private final int b = 0;
    private final int c = 1;
    private final int d = 2;
    private final int e = 3;
    private List<GeocodingCallback> a;
    private Handler a = new Handler(){

        public void handleMessage(Message message) {
            switch (message.what) {
                case 2: {
                    for (GeocodingCallback geocodingCallback : Geocoding.this.a) {
                        geocodingCallback.geocodeFailed((String)message.obj);
                    }
                    break;
                }
                case 3: {
                    for (GeocodingCallback geocodingCallback : Geocoding.this.a) {
                        geocodingCallback.geocodeFailed((String)message.obj);
                    }
                    break;
                }
                case 0: {
                    for (GeocodingCallback geocodingCallback : Geocoding.this.a) {
                        geocodingCallback.geocodeSuccess((List)message.obj);
                    }
                    break;
                }
                case 1: {
                    for (GeocodingCallback geocodingCallback : Geocoding.this.a) {
                        geocodingCallback.reverseGeocodeSuccess((GeocodingData)message.obj);
                    }
                    break;
                }
            }
        }
    };

    protected String getKey() {
        return this.a;
    }

    public void setKey(String string) {
        this.a = string;
    }

    public void geocoding(GeocodingParameter geocodingParameter) {
        String string;
        if (TextUtils.isEmpty((CharSequence)geocodingParameter.getLandmark())) {
            string = InternalResource.loadString((String)"Address", (String)"Handle_ObjectHasBeenDisposed", (String)"data_resources");
            Log.e((String)"Address", (String)string);
        }
        if (TextUtils.isEmpty((CharSequence)geocodingParameter.getCity())) {
            string = InternalResource.loadString((String)"City", (String)"Handle_ObjectHasBeenDisposed", (String)"data_resources");
            Log.e((String)"City", (String)string);
        }
        if (TextUtils.isEmpty((CharSequence)this.getKey())) {
            string = InternalResource.loadString((String)"Key", (String)"Handle_ObjectHasBeenDisposed", (String)"data_resources");
            throw new IllegalStateException(string);
        }
        string = "http://www.supermapol.com/iserver/services/location-china/rest/locationanalyst/China/geocoding.json?address=" + geocodingParameter.getLandmark() + "&city=" + geocodingParameter.getCity() + "&maxResult=" + geocodingParameter.getMaxResult() + "&to=" + geocodingParameter.getCoordinateType().a() + "&key=" + this.getKey();
        a = 1;
        this.networkRequest(string);
    }

    public void reverseGeocoding(Point2D point2D) {
        if (point2D == null) {
            String string = InternalResource.loadString((String)"location", (String)"Handle_ObjectHasBeenDisposed", (String)"data_resources");
            throw new IllegalStateException(string);
        }
        if (TextUtils.isEmpty((CharSequence)this.getKey())) {
            String string = InternalResource.loadString((String)"Key", (String)"Handle_ObjectHasBeenDisposed", (String)"data_resources");
            throw new IllegalStateException(string);
        }
        String string = "http://www.supermapol.com/iserver/services/location-china/rest/locationanalyst/China/geodecoding.json?location=" + URLEncoder.encode("{\"x\":" + point2D.getX() + "," + "\"" + "y" + "\"" + ":" + point2D.getY() + "}") + "&key=" + this.getKey();
        a = 2;
        this.networkRequest(string);
    }

    public boolean setGeocodingCallback(GeocodingCallback geocodingCallback) {
        if (this.a.contains(geocodingCallback)) {
            return false;
        }
        this.a.add(geocodingCallback);
        return true;
    }

    protected void networkRequest(final String string) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
                try {
                    HttpGet httpGet = new HttpGet(string);
                    HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet);
                    HttpEntity httpEntity = httpResponse.getEntity();
                    String string3 = EntityUtils.toString((HttpEntity)httpEntity, (String)"utf-8");
                    int n = httpResponse.getStatusLine().getStatusCode();
                    if (n == 200) {
                        if (a == 1) {
                            List<GeocodingData> list = ParseUtils.AnalyticForwardGeocoding(string3);
                            Message message = Message.obtain();
                            message.obj = list;
                            message.what = 0;
                            Geocoding.this.a.sendMessage(message);
                        } else if (a == 2) {
                            GeocodingData geocodingData = ParseUtils.AnalyticalReverseGeocoding(string3);
                            Message message = Message.obtain();
                            message.obj = geocodingData;
                            message.what = 1;
                            Geocoding.this.a.sendMessage(message);
                        }
                    } else {
                        String string2 = NetworkErrorInfo.getErrorInfo(string3, n);
                        Geocoding.this.a(string2, 2);
                    }
                }
                catch (Exception exception) {
                    String string4 = exception.getMessage().toString();
                    Geocoding.this.a(string4, 2);
                }
            }
        }).start();
    }

    private void a(String string, int n) {
        Message message = Message.obtain();
        message.what = n;
        message.obj = string;
        this.a.sendMessage(message);
    }

    public static interface GeocodingCallback {
        public void geocodeSuccess(List<GeocodingData> var1);

        public void reverseGeocodeSuccess(GeocodingData var1);

        public void geocodeFailed(String var1);
    }
}

