/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.services;

import android.os.Message;
import com.supermap.data.CursorType;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldType;
import com.supermap.data.Geometry;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.QueryParameter;
import com.supermap.data.Recordset;
import com.supermap.services.Feature;
import com.supermap.services.ServiceBase;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DataUploadService
extends ServiceBase {
    public DataUploadService(String string) {
        super(string);
    }

    public void addFeature(final String string, final Feature feature) {
        if (string == null || feature == null) {
            throw new NullPointerException(" One or more params are null.");
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
                    defaultHttpClient.getParams().setIntParameter("http.socket.timeout", 60000);
                    defaultHttpClient.getParams().setIntParameter("http.connection.timeout", 5000);
                    HttpPost httpPost = new HttpPost();
                    URI uRI = new URI(string + "/features.json");
                    httpPost.setURI(uRI);
                    JSONObject jSONObject = new JSONObject(feature.toJson());
                    JSONArray jSONArray = new JSONArray();
                    jSONArray.put((Object)jSONObject);
                    StringEntity stringEntity = new StringEntity(jSONArray.toString(), "UTF-8");
                    httpPost.setEntity((HttpEntity)stringEntity);
                    HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
                    String string3 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
                    StatusLine statusLine = httpResponse.getStatusLine();
                    if (statusLine.getStatusCode() != 200 && statusLine.getStatusCode() != 201) {
                        JSONObject jSONObject2 = new JSONObject(string3);
                        String string2 = jSONObject2.getJSONObject("error").getString("errorMsg");
                        Message message = DataUploadService.this.mHandle.obtainMessage(163);
                        message.obj = string2;
                        DataUploadService.this.mHandle.sendMessage(message);
                        ServiceBase.a.a().b(this);
                        return;
                    }
                    DataUploadService.this.mHandle.obtainMessage(164).sendToTarget();
                    ServiceBase.a.a().b(this);
                }
                catch (Exception exception) {
                    Message message = DataUploadService.this.mHandle.obtainMessage(163);
                    message.obj = exception;
                    DataUploadService.this.mHandle.sendMessage(message);
                    ServiceBase.a.a().b(this);
                }
            }
        };
        ServiceBase.a.a().a(runnable);
    }

    public void addFeature(String string, String string2, String string3, Feature feature) {
        if (string == null || string2 == null || string3 == null) {
            throw new NullPointerException(" One or more params are null.");
        }
        String string4 = this.mUrl + "/services/" + string + "/data/datasources/" + string2 + "/datasets/" + string3;
        this.addFeature(string4, feature);
    }

    public void deleteFeature(final String string, final int[] nArray) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
                    defaultHttpClient.getParams().setIntParameter("http.socket.timeout", 60000);
                    defaultHttpClient.getParams().setIntParameter("http.connection.timeout", 5000);
                    HttpPost httpPost = new HttpPost();
                    URI uRI = new URI(string + "/features.json?_method=DELETE");
                    httpPost.setURI(uRI);
                    JSONArray jSONArray = new JSONArray();
                    for (int i = 0; i < nArray.length; ++i) {
                        jSONArray.put(nArray[i]);
                    }
                    StringEntity stringEntity = new StringEntity(jSONArray.toString(), "UTF-8");
                    httpPost.setEntity((HttpEntity)stringEntity);
                    HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
                    String string3 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
                    StatusLine statusLine = httpResponse.getStatusLine();
                    if (statusLine.getStatusCode() != 200 && statusLine.getStatusCode() != 201) {
                        JSONObject jSONObject = new JSONObject(string3);
                        String string2 = jSONObject.getJSONObject("error").getString("errorMsg");
                        Message message = DataUploadService.this.mHandle.obtainMessage(163);
                        message.obj = string2;
                        DataUploadService.this.mHandle.sendMessage(message);
                        ServiceBase.a.a().b(this);
                        return;
                    }
                    DataUploadService.this.mHandle.obtainMessage(164).sendToTarget();
                    ServiceBase.a.a().b(this);
                }
                catch (Exception exception) {
                    Message message = DataUploadService.this.mHandle.obtainMessage(163);
                    message.obj = exception;
                    DataUploadService.this.mHandle.sendMessage(message);
                    ServiceBase.a.a().b(this);
                }
            }
        };
        ServiceBase.a.a().a(runnable);
    }

    public void deleteFeature(String string, String string2, String string3, int[] nArray) {
        if (string == null || string2 == null || string3 == null) {
            throw new NullPointerException(" One or more params are null.");
        }
        String string4 = this.mUrl + "/services/" + string + "/data/datasources/" + string2 + "/datasets/" + string3;
        this.deleteFeature(string4, nArray);
    }

    public void deleteFeature(final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
                    defaultHttpClient.getParams().setIntParameter("http.socket.timeout", 60000);
                    defaultHttpClient.getParams().setIntParameter("http.connection.timeout", 5000);
                    HttpPost httpPost = new HttpPost();
                    URI uRI = new URI(string + ".json?_method=DELETE");
                    httpPost.setURI(uRI);
                    HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
                    String string3 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
                    StatusLine statusLine = httpResponse.getStatusLine();
                    if (statusLine.getStatusCode() != 200 && statusLine.getStatusCode() != 201) {
                        JSONObject jSONObject = new JSONObject(string3);
                        String string2 = jSONObject.getJSONObject("error").getString("errorMsg");
                        Message message = DataUploadService.this.mHandle.obtainMessage(163);
                        message.obj = string2;
                        DataUploadService.this.mHandle.sendMessage(message);
                        ServiceBase.a.a().b(this);
                        return;
                    }
                    DataUploadService.this.mHandle.obtainMessage(164).sendToTarget();
                    ServiceBase.a.a().b(this);
                }
                catch (Exception exception) {
                    Message message = DataUploadService.this.mHandle.obtainMessage(163);
                    message.obj = exception;
                    DataUploadService.this.mHandle.sendMessage(message);
                    ServiceBase.a.a().b(this);
                }
            }
        };
        ServiceBase.a.a().a(runnable);
    }

    public void modifyFeature(final String string, final int n, final Feature feature) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject jSONObject;
                    DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
                    defaultHttpClient.getParams().setIntParameter("http.socket.timeout", 60000);
                    defaultHttpClient.getParams().setIntParameter("http.connection.timeout", 5000);
                    HttpPost httpPost = new HttpPost();
                    URI uRI = new URI(string + "/features.json?_method=PUT");
                    httpPost.setURI(uRI);
                    JSONObject jSONObject2 = new JSONObject(feature.toJson());
                    jSONObject2.put("ID", n);
                    if (jSONObject2.has("geometry")) {
                        jSONObject = jSONObject2.getJSONObject("geometry");
                        jSONObject.put("id", n);
                    }
                    jSONObject = new JSONArray();
                    jSONObject.put((Object)jSONObject2);
                    StringEntity stringEntity = new StringEntity(jSONObject.toString(), "UTF-8");
                    httpPost.setEntity((HttpEntity)stringEntity);
                    HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
                    String string3 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
                    StatusLine statusLine = httpResponse.getStatusLine();
                    if (statusLine.getStatusCode() != 200 && statusLine.getStatusCode() != 201) {
                        JSONObject jSONObject3 = new JSONObject(string3);
                        String string2 = jSONObject3.getJSONObject("error").getString("errorMsg");
                        Message message = DataUploadService.this.mHandle.obtainMessage(163);
                        message.obj = string2;
                        DataUploadService.this.mHandle.sendMessage(message);
                        ServiceBase.a.a().b(this);
                        return;
                    }
                    DataUploadService.this.mHandle.obtainMessage(164).sendToTarget();
                    ServiceBase.a.a().b(this);
                }
                catch (Exception exception) {
                    Message message = DataUploadService.this.mHandle.obtainMessage(163);
                    message.obj = exception;
                    DataUploadService.this.mHandle.sendMessage(message);
                    ServiceBase.a.a().b(this);
                }
            }
        };
        ServiceBase.a.a().a(runnable);
    }

    public void modifyFeature(String string, String string2, String string3, int n, Feature feature) {
        if (string == null || string2 == null || string3 == null) {
            throw new NullPointerException(" One or more params are null.");
        }
        String string4 = this.mUrl + "/services/" + string + "/data/datasources/" + string2 + "/datasets/" + string3;
        this.modifyFeature(string4, n, feature);
    }

    public void addRecordset(final String string, final Recordset recordset) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Message message = new Message();
                    JSONObject jSONObject = null;
                    recordset.moveFirst();
                    while (!recordset.isEOF()) {
                        Geometry geometry = recordset.getGeometry();
                        FieldInfos fieldInfos = recordset.getFieldInfos();
                        int n = fieldInfos.getCount();
                        String[] stringArray = new String[n];
                        String[] stringArray2 = new String[n];
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                        for (int i = 0; i < n; ++i) {
                            String string3;
                            String string2;
                            FieldInfo fieldInfo = fieldInfos.get(i);
                            stringArray[i] = string2 = fieldInfo.getName();
                            Object object = recordset.getFieldValue(i);
                            if (object != null) {
                                string3 = object.toString();
                                if (fieldInfo.getType() == FieldType.DATETIME) {
                                    string3 = simpleDateFormat.format((Date)object).toString();
                                }
                            } else {
                                string3 = "";
                            }
                            stringArray2[i] = string3;
                        }
                        Feature feature = new Feature(stringArray, stringArray2, geometry);
                        jSONObject = DataUploadService.this.addFeatureOnService(string, feature, message);
                        if (jSONObject == null) {
                            DataUploadService.this.mHandle.sendMessage(message);
                            ServiceBase.a.a().b(this);
                        }
                        recordset.moveNext();
                        fieldInfos.dispose();
                        geometry.dispose();
                    }
                    DataUploadService.this.mHandle.obtainMessage(164).sendToTarget();
                    ServiceBase.a.a().b(this);
                }
                catch (Exception exception) {
                    Message message = DataUploadService.this.mHandle.obtainMessage(163);
                    message.obj = exception;
                    DataUploadService.this.mHandle.sendMessage(message);
                    ServiceBase.a.a().b(this);
                }
            }
        };
        ServiceBase.a.a().a(runnable);
    }

    public boolean addRecordset(String string, String string2, String string3, Recordset recordset) {
        if (string == null || string2 == null || string3 == null) {
            throw new NullPointerException(" One or more params are null.");
        }
        String string4 = this.mUrl + "/services/" + string + "/data/datasources/" + string2 + "/datasets/" + string3;
        this.addRecordset(string4, recordset);
        return true;
    }

    public void addDataset(final String string, final String string2, final DatasetType datasetType) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
                    defaultHttpClient.getParams().setIntParameter("http.socket.timeout", 60000);
                    defaultHttpClient.getParams().setIntParameter("http.connection.timeout", 25000);
                    HttpPost httpPost = new HttpPost();
                    URI uRI = new URI(string + "/datasets.json");
                    httpPost.setURI(uRI);
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("datasetType", (Object)datasetType.toString());
                    jSONObject.put("datasetName", (Object)string2);
                    StringEntity stringEntity = new StringEntity(jSONObject.toString(), "UTF-8");
                    httpPost.setEntity((HttpEntity)stringEntity);
                    HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
                    String string3 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
                    StatusLine statusLine = httpResponse.getStatusLine();
                    if (statusLine.getStatusCode() != 200 && statusLine.getStatusCode() != 201) {
                        JSONObject jSONObject2 = new JSONObject(string3);
                        String string22 = jSONObject2.getJSONObject("error").getString("errorMsg");
                        Message message = DataUploadService.this.mHandle.obtainMessage(163);
                        message.obj = string22;
                        DataUploadService.this.mHandle.sendMessage(message);
                        ServiceBase.a.a().b(this);
                        return;
                    }
                    DataUploadService.this.mHandle.obtainMessage(164).sendToTarget();
                    ServiceBase.a.a().b(this);
                }
                catch (Exception exception) {
                    Message message = DataUploadService.this.mHandle.obtainMessage(163);
                    message.obj = exception;
                    DataUploadService.this.mHandle.sendMessage(message);
                    ServiceBase.a.a().b(this);
                }
            }
        };
        ServiceBase.a.a().a(runnable);
    }

    public void addDataset(String string, String string2, String string3, DatasetType datasetType) {
        if (string == null || string2 == null || string3 == null) {
            throw new NullPointerException(" One or more params are null.");
        }
        String string4 = this.mUrl + "/services/" + string + "/data/datasources/" + string2;
        this.addDataset(string4, string3, datasetType);
    }

    public void addDataset(final String string, final String string2, final String string3, final String string4, final String string5) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
                    defaultHttpClient.getParams().setIntParameter("http.socket.timeout", 60000);
                    defaultHttpClient.getParams().setIntParameter("http.connection.timeout", 25000);
                    HttpPost httpPost = new HttpPost();
                    URI uRI = new URI(DataUploadService.this.mUrl + "/services/" + string + "/data/datasources/" + string2 + "/datasets.json");
                    httpPost.setURI(uRI);
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("srcDatasourceName", (Object)string4);
                    jSONObject.put("srcDatasetName", (Object)string5);
                    jSONObject.put("destDatasetName", (Object)string3);
                    StringEntity stringEntity = new StringEntity(jSONObject.toString(), "UTF-8");
                    httpPost.setEntity((HttpEntity)stringEntity);
                    HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
                    String string6 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
                    StatusLine statusLine = httpResponse.getStatusLine();
                    if (statusLine.getStatusCode() != 200 && statusLine.getStatusCode() != 201) {
                        JSONObject jSONObject2 = new JSONObject(string6);
                        String string22 = jSONObject2.getJSONObject("error").getString("errorMsg");
                        Message message = DataUploadService.this.mHandle.obtainMessage(163);
                        message.obj = string22;
                        DataUploadService.this.mHandle.sendMessage(message);
                        ServiceBase.a.a().b(this);
                        return;
                    }
                    DataUploadService.this.mHandle.obtainMessage(164).sendToTarget();
                    ServiceBase.a.a().b(this);
                }
                catch (Exception exception) {
                    Message message = DataUploadService.this.mHandle.obtainMessage(163);
                    message.obj = exception;
                    DataUploadService.this.mHandle.sendMessage(message);
                    ServiceBase.a.a().b(this);
                }
            }
        };
        ServiceBase.a.a().a(runnable);
    }

    public void deleteDataset(final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
                    defaultHttpClient.getParams().setIntParameter("http.socket.timeout", 60000);
                    defaultHttpClient.getParams().setIntParameter("http.connection.timeout", 25000);
                    HttpPost httpPost = new HttpPost();
                    URI uRI = new URI(string + ".json?_method=DELETE");
                    httpPost.setURI(uRI);
                    HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
                    String string3 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
                    StatusLine statusLine = httpResponse.getStatusLine();
                    if (statusLine.getStatusCode() != 200 && statusLine.getStatusCode() != 201) {
                        JSONObject jSONObject = new JSONObject(string3);
                        String string2 = jSONObject.getJSONObject("error").getString("errorMsg");
                        Message message = DataUploadService.this.mHandle.obtainMessage(163);
                        message.obj = string2;
                        DataUploadService.this.mHandle.sendMessage(message);
                        ServiceBase.a.a().b(this);
                        return;
                    }
                    DataUploadService.this.mHandle.obtainMessage(164).sendToTarget();
                    ServiceBase.a.a().b(this);
                }
                catch (Exception exception) {
                    Message message = DataUploadService.this.mHandle.obtainMessage(163);
                    message.obj = exception;
                    DataUploadService.this.mHandle.sendMessage(message);
                    ServiceBase.a.a().b(this);
                }
            }
        };
        ServiceBase.a.a().a(runnable);
    }

    public void deleteDataset(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            throw new NullPointerException(" One or more params are null.");
        }
        String string4 = this.mUrl + "/services/" + string + "/data/datasources/" + string2 + "/datasets/" + string3;
        this.deleteDataset(string4);
    }

    public void commitDataset(final String string, final DatasetVector datasetVector) {
        if (this.isDataServiceRunning) {
            Message message = new Message();
            message.what = 165;
            message.obj = "\u6b63\u5728\u4e0a\u4f20\u6570\u636e\u96c6\uff0c\u8bf7\u5728\u7ed3\u675f\u540e\u518d\u6b21\u4e0a\u4f20";
            this.mHandle.sendMessage(message);
        } else {
            this.isDataServiceRunning = true;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Message message = new Message();
                    message = DataUploadService.this.commitDatasetToServer(string, datasetVector);
                    DataUploadService.this.mHandle.sendMessage(message);
                    ServiceBase.a.a().b(this);
                    DataUploadService.this.isDataServiceRunning = false;
                }
            };
            ServiceBase.a.a().a(runnable);
        }
    }

    protected Message commitDatasetToServer(String string, DatasetVector datasetVector) {
        Message message = new Message();
        if (string == null || datasetVector == null) {
            message = this.mHandle.obtainMessage(163);
            message.obj = new String("IllegalArguements: urlDataset or dataset are null,  when committing dataset.");
            return message;
        }
        try {
            if (this.commitEnable(string, datasetVector, message)) {
                DatasetVector datasetVector2 = (DatasetVector)datasetVector.getDatasource().getDatasets().get(datasetVector.getName() + "_Table");
                boolean bl = this.commitToWebDataset(string, datasetVector, message);
                if (bl) {
                    bl = this.commitToWebDatasetTable(string + "_Table", datasetVector2, message);
                }
                if (bl) {
                    message = this.mHandle.obtainMessage(165);
                    message.obj = new String("Commit Dataset successfully.");
                } else {
                    Object object = message.obj;
                    message = this.mHandle.obtainMessage(163);
                    message.obj = object;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            message = this.mHandle.obtainMessage(163);
            message.obj = exception;
        }
        return message;
    }

    protected boolean commitEnable(String string, DatasetVector datasetVector, Message message) throws Exception {
        if (!this.isUrlDatasetExisted(string, message)) {
            return false;
        }
        boolean bl = this.isUrlDatasetExisted(string + "_Table", message);
        if (!bl) {
            return false;
        }
        JSONObject jSONObject = this.downloadJSONObject(string, "GET", message, null);
        JSONObject jSONObject2 = null;
        String string2 = null;
        jSONObject2 = jSONObject.getJSONObject("datasetInfo");
        string2 = jSONObject2.getString("type");
        DatasetType datasetType = this.getDatasetType(string2);
        if (!datasetVector.getType().equals((Object)datasetType)) {
            message.what = 163;
            message.obj = new String("Local dataset's type doesn't match with that of which dataset is on server.");
            return false;
        }
        String string3 = datasetVector.getName();
        DatasetVector datasetVector2 = (DatasetVector)datasetVector.getDatasource().getDatasets().get(string3 + "_Table");
        if (datasetVector2 == null) {
            message.what = 163;
            message.obj = new String("dataset: " + string3 + "_Table" + " does not exists.");
            return false;
        }
        QueryParameter queryParameter = new QueryParameter();
        String[] stringArray = new String[]{"MAX(SmUserID)"};
        queryParameter.setResultFields(stringArray);
        queryParameter.setCursorType(CursorType.DYNAMIC);
        Recordset recordset = datasetVector.query(queryParameter);
        int n = recordset.getInt32("MAX(SmUserID)");
        queryParameter.dispose();
        recordset.dispose();
        int[] nArray = new int[]{n};
        JSONObject jSONObject3 = new JSONObject();
        jSONObject3.put("ID", n);
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)jSONObject3);
        JSONObject jSONObject4 = this.downloadJSONObject(string + "/features", "GET", message, jSONArray);
        if (jSONObject4 == null) {
            return false;
        }
        JSONArray jSONArray2 = null;
        jSONArray2 = jSONObject4.getJSONArray("childUriList");
        int n2 = 0;
        if (jSONArray2.length() != 0) {
            String string4 = jSONArray2.get(0).toString();
            jSONObject4 = this.downloadJSONObject(string4 = string4.substring(0, string4.lastIndexOf("-") + 1) + (jSONObject4.getInt("featureCount") - 1), "GET", message, null);
            n2 = jSONObject4.getInt("ID");
            if (n2 < n) {
                // empty if block
            }
        }
        queryParameter = new QueryParameter();
        stringArray[0] = "MAX(SmInnerFeatureID)";
        queryParameter.setResultFields(stringArray);
        queryParameter.setCursorType(CursorType.DYNAMIC);
        recordset = datasetVector2.query(queryParameter);
        n = recordset.getInt32("MAX(SmInnerFeatureID)");
        queryParameter.dispose();
        recordset.dispose();
        nArray[0] = n;
        jSONArray = new JSONArray();
        jSONArray.put(n + 1);
        jSONArray = null;
        jSONObject4 = this.downloadJSONObject(string + "_Table/features", "GET", message, jSONArray);
        if (jSONObject4 == null) {
            return false;
        }
        jSONArray2 = null;
        jSONArray2 = jSONObject4.getJSONArray("childUriList");
        if (jSONArray2.length() == 0 || (n2 = Integer.parseInt((jSONObject4 = this.downloadJSONObject(jSONArray2.get(jSONArray2.length() - 1).toString(), "GET", message, null)).get("ID").toString())) < n) {
            // empty if block
        }
        return true;
    }

    protected boolean commitToWebDatasetTable(String string, DatasetVector datasetVector, Message message) throws Exception {
        int n;
        QueryParameter queryParameter = new QueryParameter();
        queryParameter.setAttributeFilter("SmInnerFeatureID==0");
        queryParameter.setCursorType(CursorType.DYNAMIC);
        Recordset recordset = datasetVector.query(queryParameter);
        ArrayList<Feature> arrayList = this.transRecordsetToFeatureList(recordset);
        if (arrayList == null) {
            message.what = 163;
            message.obj = new String("IllegalArguements");
        }
        int n2 = arrayList.size();
        recordset.moveFirst();
        JSONObject jSONObject = null;
        for (n = 0; n < n2; ++n) {
            jSONObject = this.addFeatureOnService(string, arrayList.get(n), message);
            if (jSONObject == null) continue;
            recordset.edit();
            recordset.setFieldValue("SmInnerFeatureID", jSONObject.get("ID"));
            recordset.update();
            recordset.moveNext();
        }
        for (n = 0; n < arrayList.size(); ++n) {
            arrayList.get(n).getGeometry().dispose();
        }
        queryParameter.setAttributeFilter("SmInnerFeatureID==-1");
        queryParameter.setCursorType(CursorType.DYNAMIC);
        recordset.dispose();
        recordset = datasetVector.query(queryParameter);
        recordset.deleteAll();
        recordset.update();
        recordset.dispose();
        queryParameter.dispose();
        return true;
    }

    protected boolean commitToWebDataset(String string, DatasetVector datasetVector, Message message) throws Exception {
        int n;
        QueryParameter queryParameter = new QueryParameter();
        QueryParameter queryParameter2 = new QueryParameter();
        DatasetVector datasetVector2 = null;
        Recordset recordset = null;
        Recordset recordset2 = null;
        int n2 = 0;
        int n3 = 0;
        JSONObject jSONObject = null;
        this.uploadDatasetInformation(string, datasetVector);
        datasetVector2 = (DatasetVector)datasetVector.getDatasource().getDatasets().get(datasetVector.getName() + "_Table");
        queryParameter2.setAttributeFilter("SmInnerFeatureID==-1");
        queryParameter2.setCursorType(CursorType.DYNAMIC);
        recordset2 = datasetVector2.query(queryParameter2);
        recordset2.moveFirst();
        n2 = recordset2.getRecordCount();
        int[] nArray = new int[n2];
        recordset2.moveFirst();
        for (n3 = 0; n3 < n2; ++n3) {
            nArray[n3] = recordset2.getInt32("SmUserID");
            recordset2.moveNext();
        }
        jSONObject = this.modifyFeatureOnService(string, nArray, null, message, "DELETE");
        recordset2.dispose();
        queryParameter2.setAttributeFilter("SmInnerFeatureID==0");
        recordset2 = datasetVector2.query(queryParameter2);
        n2 = recordset2.getRecordCount();
        int n4 = 0;
        ArrayList<Feature> arrayList = new ArrayList<Feature>();
        nArray = new int[n2];
        queryParameter.setCursorType(CursorType.DYNAMIC);
        recordset2.moveFirst();
        for (n3 = 0; n3 < n2; ++n3) {
            n4 = recordset2.getInt32("SmUserID");
            queryParameter.setAttributeFilter("SmUserID==" + n4);
            recordset = datasetVector.query(queryParameter);
            if (recordset.getRecordCount() <= 0) continue;
            nArray[n3] = n4;
            arrayList.add(this.transRecordsetToFeatureList(recordset).get(0));
            recordset.dispose();
            recordset2.moveNext();
        }
        recordset2.dispose();
        this.modifyFeatureOnService(string, nArray, arrayList, message, "PUT");
        queryParameter.setAttributeFilter("SmUserID==0");
        recordset = datasetVector.query(queryParameter);
        if (recordset.isEmpty()) {
            recordset.dispose();
            return true;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.get(i).getGeometry().dispose();
        }
        arrayList.clear();
        arrayList = this.transRecordsetToFeatureList(recordset);
        recordset.moveFirst();
        jSONObject = this.addFeaturesOnService(string, arrayList, message);
        JSONArray jSONArray = jSONObject.getJSONArray("ID");
        for (n = 0; n < arrayList.size(); ++n) {
            arrayList.get(n).getGeometry().dispose();
        }
        arrayList.clear();
        arrayList = null;
        n = jSONArray.length();
        recordset.addNew(null);
        Recordset.BatchEditor batchEditor = recordset.getBatch();
        batchEditor.begin();
        for (n3 = 0; n3 < n; ++n3) {
            recordset.edit();
            recordset.setFieldValue("SmUserID", jSONArray.get(n3));
            recordset.moveNext();
        }
        batchEditor.update();
        recordset.update();
        recordset.close();
        recordset.dispose();
        jSONArray = null;
        jSONObject = null;
        batchEditor = null;
        queryParameter.dispose();
        queryParameter2.dispose();
        return true;
    }

    protected JSONObject addFeatureOnService(String string, Feature feature, Message message) throws Exception {
        StatusLine statusLine;
        if (string == null || feature == null || message == null) {
            message.what = 163;
            message.obj = "IllegalArgument for addFeatureOnserver";
            return null;
        }
        JSONObject jSONObject = null;
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        defaultHttpClient.getParams().setIntParameter("http.socket.timeout", 60000);
        defaultHttpClient.getParams().setIntParameter("http.connection.timeout", 25000);
        HttpPost httpPost = new HttpPost();
        URI uRI = new URI(string + "/features.json?returnContent=true");
        httpPost.setURI(uRI);
        JSONObject jSONObject2 = new JSONObject(feature.toJson());
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)jSONObject2);
        StringEntity stringEntity = new StringEntity(jSONArray.toString(), "UTF-8");
        httpPost.setEntity((HttpEntity)stringEntity);
        HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
        String string2 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        int n = string2.indexOf("]");
        if (n != -1) {
            string2 = "{\"ID\":" + string2.substring(1, n) + "}";
        }
        if ((statusLine = httpResponse.getStatusLine()).getStatusCode() != 200 && statusLine.getStatusCode() != 201) {
            JSONObject jSONObject3 = new JSONObject(string2);
            String string3 = jSONObject3.getJSONObject("error").getString("errorMsg");
            message.what = 163;
            message.obj = string3;
            return null;
        }
        jSONObject = new JSONObject(string2);
        return jSONObject;
    }

    protected ArrayList<Feature> transRecordsetToFeatureList(Recordset recordset) {
        ArrayList<Feature> arrayList = null;
        if (recordset == null) {
            return null;
        }
        FieldInfos fieldInfos = recordset.getFieldInfos();
        int n = fieldInfos.getCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < fieldInfos.getCount(); ++i) {
            stringArray[i] = fieldInfos.get(i).getName();
        }
        arrayList = new ArrayList<Feature>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        recordset.moveFirst();
        while (!recordset.isEOF()) {
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                Object object = recordset.getFieldValue(i);
                if (object != null) {
                    if (fieldInfos.get(i).getType() == FieldType.DATETIME) {
                        stringArray2[i] = simpleDateFormat.format((Date)object).toString();
                        continue;
                    }
                    stringArray2[i] = object.toString();
                    continue;
                }
                stringArray2[i] = "";
            }
            Feature feature = new Feature(stringArray, stringArray2, recordset.getGeometry());
            arrayList.add(feature);
            recordset.moveNext();
        }
        return arrayList;
    }

    protected JSONObject addFeaturesOnService(String string, ArrayList<Feature> arrayList, Message message) throws Exception {
        if (string == null || arrayList == null || message == null) {
            message.what = 163;
            message.obj = "IllegalArgument for addFeatureOnserver";
            return null;
        }
        JSONObject jSONObject = null;
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        defaultHttpClient.getParams().setIntParameter("http.socket.timeout", 60000);
        defaultHttpClient.getParams().setIntParameter("http.connection.timeout", 25000);
        HttpPost httpPost = new HttpPost();
        URI uRI = new URI(string + "/features.json?returnContent=true");
        httpPost.setURI(uRI);
        JSONObject jSONObject2 = null;
        JSONArray jSONArray = new JSONArray();
        int n = 0;
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            jSONObject2 = new JSONObject(arrayList.get(n).toJson());
            jSONArray.put((Object)jSONObject2);
        }
        StringEntity stringEntity = new StringEntity(jSONArray.toString(), "UTF-8");
        httpPost.setEntity((HttpEntity)stringEntity);
        HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
        String string2 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        string2 = "{\"ID\":" + string2 + "}";
        string2.replaceAll(",", "\",\"");
        StatusLine statusLine = httpResponse.getStatusLine();
        if (statusLine.getStatusCode() != 200 && statusLine.getStatusCode() != 201) {
            JSONObject jSONObject3 = new JSONObject(string2);
            String string3 = jSONObject3.getJSONObject("error").getString("errorMsg");
            message.what = 163;
            message.obj = string3;
            return null;
        }
        jSONObject = new JSONObject(string2);
        return jSONObject;
    }

    protected JSONObject modifyFeatureOnService(String string, int[] nArray, ArrayList<Feature> arrayList, Message message, String string2) throws Exception {
        JSONObject jSONObject = null;
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        defaultHttpClient.getParams().setIntParameter("http.socket.timeout", 60000);
        defaultHttpClient.getParams().setIntParameter("http.connection.timeout", 25000);
        HttpPost httpPost = new HttpPost();
        URI uRI = new URI(string + "/features.json?_method=" + string2);
        httpPost.setURI(uRI);
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = null;
        int n = 0;
        if (string2.equals("DELETE")) {
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] <= 0) continue;
                jSONArray.put(nArray[n]);
            }
        } else if (string2.equals("PUT")) {
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] <= 0) continue;
                jSONObject2 = new JSONObject(arrayList.get(n).toJson());
                jSONObject2.put("ID", nArray[n]);
            }
            jSONArray.put(jSONObject2);
        }
        StringEntity stringEntity = new StringEntity(jSONArray.toString(), "UTF-8");
        httpPost.setEntity((HttpEntity)stringEntity);
        HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
        String string3 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        StatusLine statusLine = httpResponse.getStatusLine();
        if (statusLine.getStatusCode() != 200 && statusLine.getStatusCode() != 201) {
            JSONObject jSONObject3 = new JSONObject(string3);
            String string4 = jSONObject3.getJSONObject("error").getString("errorMsg");
            message.what = 163;
            message.obj = string4;
            return null;
        }
        jSONObject = new JSONObject(string3);
        return jSONObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean uploadDatasetInformation(String string, DatasetVector datasetVector) {
        if (string == null || datasetVector == null) {
            return false;
        }
        String string2 = datasetVector.getDescription();
        PrjCoordSys prjCoordSys = datasetVector.getPrjCoordSys();
        String string3 = "{\"description\":\"" + string2 + "\",\"prjCoordSys\":{\"type\":\"" + prjCoordSys.getType().toString() + "\"}}";
        try {
            JSONObject jSONObject = new JSONObject(string3);
            Message message = new Message();
            JSONObject jSONObject2 = this.uploadJSONObject(string, "PUT", message, jSONObject);
            if (jSONObject2 != null) return true;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return true;
    }

    protected JSONObject uploadJSONObject(String string, String string2, Message message, JSONObject jSONObject) {
        JSONObject jSONObject2 = null;
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        defaultHttpClient.getParams().setIntParameter("http.socket.timeout", 60000);
        defaultHttpClient.getParams().setIntParameter("http.connection.timeout", 5000);
        HttpPost httpPost = new HttpPost();
        URI uRI = null;
        try {
            HttpResponse httpResponse;
            uRI = new URI(string + ".json?_method=" + string2);
            httpPost.setURI(uRI);
            if (jSONObject != null) {
                httpResponse = new StringEntity(jSONObject.toString(), "UTF-8");
                httpPost.setEntity((HttpEntity)httpResponse);
            }
            httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
            String string3 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
            StatusLine statusLine = httpResponse.getStatusLine();
            if (statusLine.getStatusCode() != 200 && statusLine.getStatusCode() != 201) {
                JSONObject jSONObject3 = new JSONObject(string3);
                String string4 = jSONObject3.getJSONObject("error").getString("errorMsg");
                message.what = 163;
                message.obj = string4;
                return null;
            }
            jSONObject2 = new JSONObject(string3);
        }
        catch (Exception exception) {
            message.obj = exception;
            return null;
        }
        return jSONObject2;
    }
}

