/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.services;

import android.os.Message;
import android.util.Log;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldType;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoPoint3D;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoRegion3D;
import com.supermap.data.GeoText;
import com.supermap.data.Geometry;
import com.supermap.imb.jsonlib.SiJsonArray;
import com.supermap.imb.jsonlib.SiJsonObject;
import com.supermap.services.FeatureSet;
import com.supermap.services.QueryMode;
import com.supermap.services.QueryOption;
import com.supermap.services.ServiceBase;
import com.supermap.services.ServiceQueryParameter;
import java.net.URI;
import java.util.Date;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

public class QueryService
extends ServiceBase {
    public QueryService(String string) {
        super(string);
    }

    public void query(final String string, final ServiceQueryParameter serviceQueryParameter, final QueryMode queryMode) {
        if (serviceQueryParameter == null || string == null || queryMode == null) {
            throw new NullPointerException(" One or more params are null.");
        }
        final Geometry geometry = serviceQueryParameter.getQueryGeomety() == null ? null : serviceQueryParameter.getQueryGeomety().clone();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
                    defaultHttpClient.getParams().setIntParameter("http.socket.timeout", 60000);
                    defaultHttpClient.getParams().setIntParameter("http.connection.timeout", 25000);
                    HttpPost httpPost = new HttpPost();
                    URI uRI = new URI(string + "/queryResults.json?returnPostAction=true&getMethodForm=true&returnContent=true");
                    httpPost.setURI(uRI);
                    SiJsonObject siJsonObject = new SiJsonObject(serviceQueryParameter.toJson());
                    if (geometry != null) {
                        siJsonObject.put("geometry", geometry.toJson());
                        geometry.dispose();
                    }
                    String string4 = "";
                    if (queryMode == QueryMode.BoundsQuery) {
                        string4 = "BoundsQuery";
                    } else if (queryMode == QueryMode.DistanceQuery) {
                        string4 = "DistanceQuery";
                    } else if (queryMode == QueryMode.FindNearest) {
                        string4 = "FindNearest";
                    } else if (queryMode == QueryMode.SpatialQuery) {
                        string4 = "SpatialQuery";
                    } else if (queryMode == QueryMode.SqlQuery) {
                        string4 = "SqlQuery";
                    }
                    siJsonObject.put("queryMode", string4);
                    StringEntity stringEntity = new StringEntity(siJsonObject.toString(), "UTF-8");
                    siJsonObject.dispose();
                    httpPost.setEntity((HttpEntity)stringEntity);
                    HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
                    StatusLine statusLine = httpResponse.getStatusLine();
                    String string2 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"utf-8");
                    if (statusLine.getStatusCode() != 200 && statusLine.getStatusCode() != 201) {
                        SiJsonObject siJsonObject2 = new SiJsonObject(string2);
                        String string3 = siJsonObject2.getJsonObject("error").getString("errorMsg");
                        Message message = QueryService.this.mHandle.obtainMessage(163);
                        message.obj = string3;
                        QueryService.this.mHandle.sendMessage(message);
                        siJsonObject2.dispose();
                        ServiceBase.a.a().b(this);
                        return;
                    }
                    boolean bl = false;
                    boolean bl2 = false;
                    if (serviceQueryParameter.getQueryOption() == QueryOption.ATTRIBUTE) {
                        bl2 = true;
                        bl = false;
                    } else if (serviceQueryParameter.getQueryOption() == QueryOption.GEOMETRY) {
                        bl2 = false;
                        bl = true;
                    }
                    if (serviceQueryParameter.getQueryOption() == QueryOption.ATTRIBUTEANDGEOMETRY) {
                        bl2 = true;
                        bl = true;
                    }
                    FeatureSet featureSet = QueryService.this.a(string2, bl2, bl);
                    QueryService.this.mHandle.obtainMessage(164).sendToTarget();
                    Message message = QueryService.this.mHandle.obtainMessage(162);
                    message.obj = featureSet;
                    QueryService.this.mHandle.sendMessage(message);
                    ServiceBase.a.a().b(this);
                }
                catch (Exception exception) {
                    Message message = QueryService.this.mHandle.obtainMessage(163);
                    message.obj = exception;
                    QueryService.this.mHandle.sendMessage(message);
                    ServiceBase.a.a().b(this);
                }
            }
        };
        ServiceBase.a.a().a(runnable);
    }

    public void query(ServiceQueryParameter serviceQueryParameter, QueryMode queryMode) {
        if (serviceQueryParameter == null) {
            throw new NullPointerException(" The param is null.");
        }
        String string = this.mUrl + "/services/" + serviceQueryParameter.getQueryServiceName() + "/maps/" + serviceQueryParameter.getQueryMapName();
        this.query(string, serviceQueryParameter, queryMode);
    }

    private FeatureSet a(String string, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        Object object3;
        FeatureSet.a a2;
        int n;
        FeatureSet featureSet = null;
        SiJsonObject siJsonObject = new SiJsonObject(string);
        int n2 = siJsonObject.getInt("currentCount");
        if (n2 == 0) {
            Log.i((String)"QueryService", (String)"nothing to be queryed");
            siJsonObject.dispose();
            siJsonObject = null;
            return featureSet;
        }
        SiJsonArray siJsonArray = siJsonObject.getJsonArray("recordsets");
        SiJsonObject siJsonObject2 = siJsonArray.getJsonObject(0);
        SiJsonArray siJsonArray2 = siJsonObject2.getJsonArray("features");
        SiJsonArray siJsonArray3 = null;
        SiJsonArray siJsonArray4 = null;
        SiJsonArray siJsonArray5 = null;
        FieldInfos fieldInfos = new FieldInfos();
        if (bl) {
            siJsonArray3 = siJsonObject2.getJsonArray("fields");
            siJsonArray4 = siJsonObject2.getJsonArray("fieldTypes");
            siJsonArray5 = siJsonObject2.getJsonArray("fieldCaptions");
            for (n = 0; n < siJsonArray3.getArraySize(); ++n) {
                a2 = new FieldInfo();
                object3 = siJsonArray3.getString(n);
                object2 = siJsonArray4.getString(n);
                object = siJsonArray5.getString(n);
                a2.setName((String)object3);
                a2.setType((FieldType)FieldType.parse(FieldType.class, (String)object2));
                a2.setCaption((String)object);
                fieldInfos.add((FieldInfo)a2);
            }
        }
        featureSet = new FeatureSet(fieldInfos);
        for (n = 0; n < n2; ++n) {
            a2 = new FeatureSet.a();
            object3 = siJsonArray2.getJsonObject(n);
            if (bl) {
                object2 = object3.getJsonArray("fieldNames");
                object = object3.getJsonArray("fieldValues");
                for (int i = 0; i < object2.getArraySize(); ++i) {
                    String string2;
                    String string3 = object2.getString(i);
                    String string4 = object.getString(i);
                    Object object4 = "";
                    if (!string4.equals("")) {
                        string2 = siJsonArray4.getString(i);
                        if (string2.equals("INT16")) {
                            object4 = Short.valueOf(string4.toString());
                        } else if (string2.equals("INT32")) {
                            object4 = Integer.valueOf(string4.toString());
                        } else if (string2.equals("INT64")) {
                            object4 = Long.valueOf(string4.toString());
                        } else if (string2.equals("SINGLE")) {
                            object4 = Float.valueOf(string4.toString());
                        } else if (string2.equals("DOUBLE")) {
                            object4 = Double.valueOf(string4.toString());
                        } else if (string2.equals("DATETIME")) {
                            object4 = Date.parse(string4.toString());
                        } else if (string2.equals("TEXT")) {
                            object4 = string4.toString();
                        } else if (string2.equals("BYTE")) {
                            object4 = Byte.valueOf(string4.toString());
                        } else if (string2.equals("BOOLEAN")) {
                            object4 = Boolean.valueOf(string4.toString());
                        } else if (string2.equals("WTEXT")) {
                            object4 = string4;
                        } else if (string2.equals("CHAR")) {
                            object4 = string4;
                        }
                    }
                    string2 = fieldInfos.get(string3);
                    a2.put(string2, object4);
                }
                object2.dispose();
                object.dispose();
            }
            if (bl2) {
                object2 = null;
                object = object3.getJsonObject("geometry");
                String string5 = object.getString("type");
                if (string5.equals("POINT")) {
                    object2 = new GeoPoint();
                } else if (string5.equals("LINE")) {
                    object2 = new GeoLine();
                } else if (string5.equals("REGION")) {
                    object2 = new GeoRegion();
                } else if (string5.equals("TEXT")) {
                    object2 = new GeoText();
                }
                if (string5.equals("POINT3D")) {
                    object2 = new GeoPoint3D();
                }
                if (string5.equals("LINE3D")) {
                    object2 = new GeoLine3D();
                }
                if (string5.equals("REGION3D")) {
                    object2 = new GeoRegion3D();
                }
                if (object2.fromJson((SiJsonObject)object)) {
                    a2.a((Geometry)object2);
                }
                object.dispose();
            }
            featureSet.a(a2);
            object3.dispose();
        }
        if (siJsonArray5 != null) {
            siJsonArray5.dispose();
        }
        if (siJsonArray3 != null) {
            siJsonArray3.dispose();
        }
        if (siJsonArray4 != null) {
            siJsonArray4.dispose();
        }
        siJsonObject2.dispose();
        siJsonArray2.dispose();
        siJsonArray.dispose();
        siJsonObject.dispose();
        return featureSet;
    }
}

