/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.services;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.supermap.data.DatasetType;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoPoint3D;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoRegion3D;
import com.supermap.data.GeoText;
import com.supermap.data.Geometry;
import com.supermap.services.FeatureSet;
import com.supermap.services.ResponseCallback;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class ServiceBase {
    protected String mUrl;
    protected ResponseCallback mCallback = null;
    public static final int Connect_Faild = 160;
    public static final int Connect_Success = 161;
    public static final int Rosponse_Success = 162;
    public static final int Request_Faild = 163;
    public static final int Request_Success = 164;
    public static final int DataService_Finished = 165;
    protected boolean isDataServiceRunning = false;
    protected Handler mHandle = new Handler(){

        public void handleMessage(Message message) {
            if (ServiceBase.this.mCallback == null) {
                Log.e((String)"Service", (String)"ResponseCallback is null");
                return;
            }
            switch (message.what) {
                case 160: {
                    break;
                }
                case 161: {
                    break;
                }
                case 163: {
                    ServiceBase.this.mCallback.requestFailed(message.obj.toString());
                    break;
                }
                case 162: {
                    ServiceBase.this.mCallback.receiveResponse((FeatureSet)message.obj);
                    break;
                }
                case 164: {
                    ServiceBase.this.mCallback.requestSuccess();
                    break;
                }
                case 165: {
                    ServiceBase.this.mCallback.dataServiceFinished(message.obj.toString());
                    break;
                }
            }
        }
    };

    public ServiceBase(String string) {
        if (string == null) {
            return;
        }
        this.mUrl = this.a(string);
        if (!string.contains("/iserver") && !string.contains("/iportal")) {
            Log.w((String)"ServiceBase", (String)"Default server name is 'iserver'. if it has been changed, call setServerName()");
            this.mUrl = this.mUrl + "/iserver";
        }
    }

    public void setUrl(String string) {
        if (string == null) {
            return;
        }
        this.mUrl = this.a(string);
        if (!string.contains("/iserver") && !string.contains("/iportal")) {
            Log.w((String)"ServiceBase", (String)"Default server name is 'iserver'. if it has been changed, call setServerName()");
            this.mUrl = this.mUrl + "/iserver";
        }
    }

    public String getUrl() {
        return this.mUrl;
    }

    public boolean setResponseCallback(ResponseCallback responseCallback) {
        if (responseCallback != null) {
            this.mCallback = responseCallback;
            return true;
        }
        return false;
    }

    public ResponseCallback getResponseCallback() {
        return this.mCallback;
    }

    private String a(String string) {
        Pattern pattern = Pattern.compile("[\u4e00-\u9fa5]+");
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            try {
                matcher.appendReplacement(stringBuffer, URLEncoder.encode(matcher.group(0), "utf-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    protected JSONObject downloadJSONObject(String string, String string2, Message message, JSONArray jSONArray) {
        JSONObject jSONObject = null;
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        defaultHttpClient.getParams().setIntParameter("http.socket.timeout", 60000);
        defaultHttpClient.getParams().setIntParameter("http.connection.timeout", 25000);
        HttpPost httpPost = new HttpPost();
        URI uRI = null;
        try {
            HttpResponse httpResponse;
            uRI = new URI(string + ".json?_method=" + string2);
            httpPost.setURI(uRI);
            if (jSONArray != null) {
                httpResponse = new StringEntity(jSONArray.toString(), "UTF-8");
                httpPost.setEntity((HttpEntity)httpResponse);
            }
            httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
            String string3 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
            StatusLine statusLine = httpResponse.getStatusLine();
            if (statusLine.getStatusCode() != 200 && statusLine.getStatusCode() != 201) {
                JSONObject jSONObject2 = new JSONObject(string3);
                String string4 = jSONObject2.getJSONObject("error").getString("errorMsg");
                message.what = 163;
                message.obj = string4;
                return null;
            }
            jSONObject = new JSONObject(string3);
        }
        catch (Exception exception) {
            message.obj = exception;
            return null;
        }
        return jSONObject;
    }

    protected DatasetType getDatasetType(String string) {
        if (string == null) {
            return null;
        }
        DatasetType datasetType = null;
        if (string.equals("POINT")) {
            datasetType = DatasetType.POINT;
        }
        if (string.equals("LINE")) {
            datasetType = DatasetType.LINE;
        }
        if (string.equals("REGION")) {
            datasetType = DatasetType.REGION;
        }
        if (string.equals("TEXT")) {
            datasetType = DatasetType.TEXT;
        }
        if (string.equals("CAD")) {
            datasetType = DatasetType.CAD;
        }
        if (string.equals("IMAGE")) {
            datasetType = DatasetType.IMAGE;
        }
        if (string.equals("NETWORK")) {
            datasetType = DatasetType.NETWORK;
        }
        if (string.equals("TABULAR")) {
            datasetType = DatasetType.TABULAR;
        }
        if (string.equals("GRID")) {
            datasetType = DatasetType.GRID;
        }
        if (string.equals("POINT3D")) {
            datasetType = DatasetType.POINT3D;
        } else if (string.equals("LINE3D")) {
            datasetType = DatasetType.LINE3D;
        } else if (string.equals("REGION3D")) {
            datasetType = DatasetType.REGION3D;
        }
        return datasetType;
    }

    protected boolean isUrlDatasetExisted(String string, Message message) throws Exception {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        defaultHttpClient.getParams().setIntParameter("http.socket.timeout", 60000);
        defaultHttpClient.getParams().setIntParameter("http.connection.timeout", 5000);
        HttpGet httpGet = new HttpGet();
        URI uRI = new URI(string + ".json");
        httpGet.setURI(uRI);
        HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet);
        String string2 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        StatusLine statusLine = httpResponse.getStatusLine();
        if (statusLine.getStatusCode() != 200 && statusLine.getStatusCode() != 201) {
            if (statusLine.getStatusCode() == 404) {
                message.what = 163;
                message.obj = new String("Not Found: " + string);
            } else {
                JSONObject jSONObject = new JSONObject(string2);
                String string3 = jSONObject.getJSONObject("error").getString("errorMsg");
                message.what = 163;
                message.obj = string3;
            }
            return false;
        }
        return true;
    }

    protected boolean addDatasetOnServer(String string, String string2, DatasetType datasetType, Message message) throws Exception {
        if (string == null || string2 == null || datasetType == null || message == null) {
            message = this.mHandle.obtainMessage(163);
            message.obj = "IllegalArgument for createDatasetOnserver";
            return false;
        }
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        defaultHttpClient.getParams().setIntParameter("http.socket.timeout", 60000);
        defaultHttpClient.getParams().setIntParameter("http.connection.timeout", 5000);
        HttpPost httpPost = new HttpPost();
        URI uRI = new URI(string + "/datasets.json");
        httpPost.setURI(uRI);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("datasetType", (Object)datasetType.toString());
        jSONObject.put("datasetName", (Object)string2);
        StringEntity stringEntity = new StringEntity(jSONObject.toString(), "UTF-8");
        httpPost.setEntity((HttpEntity)stringEntity);
        HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
        String string3 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        StatusLine statusLine = httpResponse.getStatusLine();
        if (statusLine.getStatusCode() != 200 && statusLine.getStatusCode() != 201) {
            JSONObject jSONObject2 = new JSONObject(string3);
            String string4 = jSONObject2.getJSONObject("error").getString("errorMsg");
            message.what = 163;
            message.obj = string4;
            return false;
        }
        return true;
    }

    protected Geometry createGeoByType(String string) {
        GeoPoint geoPoint = null;
        if (string.equals("POINT")) {
            geoPoint = new GeoPoint();
        } else if (string.equals("LINE")) {
            geoPoint = new GeoLine();
        } else if (string.equals("REGION")) {
            geoPoint = new GeoRegion();
        } else if (string.equals("TEXT")) {
            geoPoint = new GeoText();
        }
        if (string.equals("POINT3D")) {
            geoPoint = new GeoPoint3D();
        }
        if (string.equals("LINE3D")) {
            geoPoint = new GeoLine3D();
        }
        if (string.equals("REGION3D")) {
            geoPoint = new GeoRegion3D();
        }
        return geoPoint;
    }

    public void setServerName(String string) {
        if (string != null && !string.isEmpty()) {
            this.mUrl = this.mUrl.substring(0, this.mUrl.lastIndexOf(47) + 1) + string;
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class NamesInUrl {
        private String a = null;
        private String b = null;
        private String c = null;
        private String d = null;

        public NamesInUrl(String string) {
            this.a(string);
        }

        private void a(String string) {
            if (string == null) {
                return;
            }
            int n = -1;
            int n2 = -1;
            n = 0;
            n2 = string.indexOf("/services/");
            if (n2 < 0) {
                Log.e((String)"DataDownloadService", (String)(string + " is not a correct iServer Data url"));
                return;
            }
            String string2 = string.substring(n, n2);
            n = n2 + "/services/".length();
            n2 = string.indexOf("/data/datasources/");
            if (n2 < 0) {
                Log.e((String)"DataDownloadService", (String)(string + " is not a correct iServer Data url of service"));
                return;
            }
            this.a = string.substring(n, n2);
            n = n2 + "/data/datasources/".length();
            n2 = string.indexOf("/datasets/");
            if (n2 < 0) {
                Log.e((String)"DataDownloadService", (String)(string + " is not a correct iServer Data url of datasource"));
                return;
            }
            this.b = string.substring(n, n2);
            this.d = string.substring(0, n2);
            n = n2 + "/datasets/".length();
            if (n2 < 0 || n == n2) {
                Log.e((String)"DataDownloadService", (String)(string + " is not a correct iServer Data url of dataset"));
                return;
            }
            this.c = string.substring(n);
        }

        public String getseviceName() {
            return this.a;
        }

        public String getDatasourceName() {
            return this.b;
        }

        public String getDatasetName() {
            return this.c;
        }

        public String getDatasourceUrl() {
            return this.d;
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    static class a {
        private Vector<Runnable> a = new Vector();
        private Vector<Runnable> b = new Vector();
        private static a a = null;

        private a() {
        }

        public static a a() {
            if (a == null) {
                a = new a();
            }
            return a;
        }

        public boolean a(Runnable runnable) {
            if (runnable != null) {
                this.a.add(runnable);
            }
            if (this.b.size() < 3) {
                this.a();
            }
            return true;
        }

        private void a() {
            if (!this.a.isEmpty()) {
                Runnable runnable = this.a.remove(0);
                this.b.add(runnable);
                Thread thread = new Thread(runnable);
                thread.start();
            }
        }

        public boolean b(Runnable runnable) {
            this.b.remove(runnable);
            this.a();
            return true;
        }
    }
}

