/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomaslanger.chalk;

public final class Ansi {
    private Ansi() {
    }

    public static String cursorUp() {
        return Ansi.cursorUp(1);
    }

    public static String cursorUp(int rows) {
        return Ansi.escape('A', rows);
    }

    public static String cursorDown() {
        return Ansi.cursorDown(1);
    }

    public static String cursorDown(int rows) {
        return Ansi.escape('B', rows);
    }

    public static String cursorRight() {
        return Ansi.cursorRight(1);
    }

    public static String cursorRight(int cols) {
        return Ansi.escape('C', cols);
    }

    public static String cursorLeft() {
        return Ansi.cursorLeft(1);
    }

    public static String cursorLeft(int cols) {
        return Ansi.escape('D', cols);
    }

    public static String setCursorPosition(int x, int y) {
        return Ansi.escape('H', y, x);
    }

    public static String eraseScreen() {
        return Ansi.escape('J', 2);
    }

    public static String eraseScreenDown() {
        return Ansi.escape('J', 0);
    }

    public static String eraseScreenUp() {
        return Ansi.escape('J', 1);
    }

    public static String eraseLine() {
        return Ansi.escape('K', 2);
    }

    public static String eraseLineStart() {
        return Ansi.escape('K', 1);
    }

    public static String eraseLineEnd() {
        return Ansi.escape('K', 0);
    }

    private static String escape(char command, int ... options) {
        StringBuilder sb = new StringBuilder(6);
        sb.append('\u001b');
        sb.append('[');
        Ansi.optionsToValue(sb, options);
        sb.append(command);
        return sb.toString();
    }

    private static void optionsToValue(StringBuilder sb, int[] options) {
        if (options.length == 1) {
            sb.append(options[0]);
        } else {
            sb.append(options[0]);
            for (int i = 1; i < options.length; ++i) {
                sb.append(';');
                sb.append(options[i]);
            }
        }
    }

    public static enum BgColor implements AnsiCode
    {
        BLACK(40),
        RED(41),
        GREEN(42),
        YELLOW(43),
        BLUE(44),
        MAGENTA(45),
        CYAN(46),
        WHITE(47);

        final int begin;
        final int end = 49;

        private BgColor(int begin) {
            this.begin = begin;
        }

        @Override
        public int getBeginInt() {
            return this.begin;
        }

        @Override
        public int getEndInt() {
            return 49;
        }
    }

    public static enum Color implements AnsiCode
    {
        BLACK(30),
        RED(31),
        GREEN(32),
        YELLOW(33),
        BLUE(34),
        MAGENTA(35),
        CYAN(36),
        WHITE(37),
        GRAY(90),
        GREY(90);

        final int begin;
        final int end = 39;

        private Color(int begin) {
            this.begin = begin;
        }

        @Override
        public int getBeginInt() {
            return this.begin;
        }

        @Override
        public int getEndInt() {
            return 39;
        }
    }

    public static enum Modifier implements AnsiCode
    {
        BOLD(1, 22),
        UNDERLINE(4, 24),
        INVERSE(7, 27);

        final int begin;
        final int end;

        private Modifier(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        @Override
        public int getBeginInt() {
            return this.begin;
        }

        @Override
        public int getEndInt() {
            return this.end;
        }
    }

    public static interface AnsiCode {
        public int getBeginInt();

        public int getEndInt();

        default public String getStart() {
            return "\u001b[" + this.getBeginInt() + "m";
        }

        default public String getEnd() {
            return "\u001b[" + this.getEndInt() + "m";
        }
    }
}

