/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomaslanger.chalk;

import com.github.tomaslanger.chalk.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class Chalk {
    private static boolean colorEnabled;
    private static boolean commandEnabled;
    private String text;

    private Chalk(String text) {
        this.text = text;
    }

    public static Chalk on(String text) {
        String theText;
        String string = theText = null == text ? "null" : text;
        if (colorEnabled) {
            return new Chalk(theText);
        }
        return new NoOpChalk(theText);
    }

    public static synchronized void setColorEnabled(boolean colorEnabled) {
        Chalk.colorEnabled = colorEnabled;
    }

    public Chalk apply(Ansi.AnsiCode modifier) {
        this.text = modifier.getStart() + this.text + modifier.getEnd();
        return this;
    }

    public String toString() {
        return this.text;
    }

    public Chalk black() {
        return this.apply(Ansi.Color.BLACK);
    }

    public Chalk red() {
        return this.apply(Ansi.Color.RED);
    }

    public Chalk green() {
        return this.apply(Ansi.Color.GREEN);
    }

    public Chalk yellow() {
        return this.apply(Ansi.Color.YELLOW);
    }

    public Chalk blue() {
        return this.apply(Ansi.Color.BLUE);
    }

    public Chalk magenta() {
        return this.apply(Ansi.Color.MAGENTA);
    }

    public Chalk cyan() {
        return this.apply(Ansi.Color.CYAN);
    }

    public Chalk white() {
        return this.apply(Ansi.Color.WHITE);
    }

    public Chalk gray() {
        return this.apply(Ansi.Color.GRAY);
    }

    public Chalk bold() {
        return this.apply(Ansi.Modifier.BOLD);
    }

    public Chalk inverse() {
        return this.apply(Ansi.Modifier.INVERSE);
    }

    public Chalk underline() {
        return this.apply(Ansi.Modifier.UNDERLINE);
    }

    public Chalk bgBlack() {
        return this.apply(Ansi.BgColor.BLACK);
    }

    public Chalk bgRed() {
        return this.apply(Ansi.BgColor.RED);
    }

    public Chalk bgGreen() {
        return this.apply(Ansi.BgColor.GREEN);
    }

    public Chalk bgYellow() {
        return this.apply(Ansi.BgColor.YELLOW);
    }

    public Chalk bgBlue() {
        return this.apply(Ansi.BgColor.BLUE);
    }

    public Chalk bgMagenta() {
        return this.apply(Ansi.BgColor.MAGENTA);
    }

    public Chalk bgCyan() {
        return this.apply(Ansi.BgColor.CYAN);
    }

    public Chalk bgWhite() {
        return this.apply(Ansi.BgColor.WHITE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Chalk)) {
            return false;
        }
        Chalk chalk = (Chalk)o;
        return this.text.equals(chalk.text);
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    public static boolean isColorEnabled() {
        return colorEnabled;
    }

    public static boolean isCommandEnabled() {
        return commandEnabled;
    }

    static {
        try {
            AnsiConsole.systemInstall();
            colorEnabled = AnsiConsole.isColorEnabled();
            commandEnabled = AnsiConsole.isCommandEnabled();
        }
        catch (UnsatisfiedLinkError e) {
            commandEnabled = colorEnabled = !Boolean.getBoolean("jansi.strip");
        }
    }

    private static class NoOpChalk
    extends Chalk {
        public NoOpChalk(String text) {
            super(text);
        }

        @Override
        public Chalk apply(Ansi.AnsiCode modifier) {
            return this;
        }
    }
}

