/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.jansi;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Properties;
import org.fusesource.jansi.AnsiOutputStream;
import org.fusesource.jansi.WindowsAnsiOutputStream;
import org.fusesource.jansi.internal.CLibrary;

public class AnsiConsole {
    private static boolean isColorEnabled = true;
    private static boolean isCommandEnabled = true;
    public static final PrintStream system_out = System.out;
    public static final PrintStream out = new PrintStream(AnsiConsole.wrapOutputStream(system_out));
    public static final PrintStream system_err = System.err;
    public static final PrintStream err = new PrintStream(AnsiConsole.wrapOutputStream(system_err, CLibrary.STDERR_FILENO));
    private static int installed;

    public static OutputStream wrapOutputStream(OutputStream stream) {
        return AnsiConsole.wrapOutputStream(stream, CLibrary.STDOUT_FILENO);
    }

    public static OutputStream wrapOutputStream(OutputStream stream, int fileno) {
        if (Boolean.getBoolean("jansi.passthrough")) {
            return stream;
        }
        if (Boolean.getBoolean("jansi.strip")) {
            isColorEnabled = false;
            isCommandEnabled = false;
            return new AnsiOutputStream(stream);
        }
        Map<String, String> env = System.getenv();
        if (env.containsKey("HUDSON_URL") || env.containsKey("JENKINS_URL")) {
            isCommandEnabled = false;
            return stream;
        }
        Properties sysProps = System.getProperties();
        if (sysProps.containsKey("idea.launcher.bin.path")) {
            isCommandEnabled = false;
            return stream;
        }
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            try {
                return new WindowsAnsiOutputStream(stream);
            }
            catch (Throwable throwable) {
                isColorEnabled = false;
                isCommandEnabled = false;
                return new AnsiOutputStream(stream);
            }
        }
        try {
            boolean forceColored = Boolean.getBoolean("jansi.force");
            int rc = CLibrary.isatty(fileno);
            if (!forceColored && rc == 0) {
                isColorEnabled = false;
                isCommandEnabled = false;
                return new AnsiOutputStream(stream);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        return new FilterOutputStream(stream){

            @Override
            public void close() throws IOException {
                this.write(AnsiOutputStream.REST_CODE);
                this.flush();
                super.close();
            }
        };
    }

    public static PrintStream out() {
        return out;
    }

    public static PrintStream err() {
        return err;
    }

    public static synchronized void systemInstall() {
        if (++installed == 1) {
            System.setOut(out);
            System.setErr(err);
        }
    }

    public static synchronized void systemUninstall() {
        if (--installed == 0) {
            System.setOut(system_out);
            System.setErr(system_err);
        }
    }

    public static boolean isColorEnabled() {
        return isColorEnabled;
    }

    public static boolean isCommandEnabled() {
        return isCommandEnabled;
    }
}

