/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.api.utils;

import cn.jiguang.api.JResponse;
import cn.jiguang.cd.d;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class ByteBufferUtils {
    private static final String TAG = "ByteBufferUtils";
    public static final int ERROR_CODE = 10000;

    public static int getInt(ByteBuffer byteBuffer, JResponse jResponse) {
        try {
            return byteBuffer.getInt();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            ByteBufferUtils.onException(bufferUnderflowException.fillInStackTrace(), jResponse, byteBuffer);
        }
        catch (BufferOverflowException bufferOverflowException) {
            ByteBufferUtils.onException(bufferOverflowException.fillInStackTrace(), jResponse, byteBuffer);
        }
        catch (Exception exception) {
            ByteBufferUtils.onException(exception.fillInStackTrace(), jResponse, byteBuffer);
        }
        if (jResponse != null) {
            jResponse.code = 10000;
        }
        return -1;
    }

    public static short getShort(ByteBuffer byteBuffer, JResponse jResponse) {
        try {
            return byteBuffer.getShort();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            ByteBufferUtils.onException(bufferUnderflowException.fillInStackTrace(), jResponse, byteBuffer);
        }
        catch (BufferOverflowException bufferOverflowException) {
            ByteBufferUtils.onException(bufferOverflowException.fillInStackTrace(), jResponse, byteBuffer);
        }
        catch (Exception exception) {
            ByteBufferUtils.onException(exception.fillInStackTrace(), jResponse, byteBuffer);
        }
        if (jResponse != null) {
            jResponse.code = 10000;
        }
        return -1;
    }

    public static ByteBuffer get(ByteBuffer byteBuffer, byte[] byArray, JResponse jResponse) {
        try {
            return byteBuffer.get(byArray);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            ByteBufferUtils.onException(bufferUnderflowException.fillInStackTrace(), jResponse, byteBuffer);
        }
        catch (BufferOverflowException bufferOverflowException) {
            ByteBufferUtils.onException(bufferOverflowException.fillInStackTrace(), jResponse, byteBuffer);
        }
        catch (Exception exception) {
            ByteBufferUtils.onException(exception.fillInStackTrace(), jResponse, byteBuffer);
        }
        if (jResponse != null) {
            jResponse.code = 10000;
        }
        return null;
    }

    public static Byte get(ByteBuffer byteBuffer, JResponse jResponse) {
        try {
            return byteBuffer.get();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            ByteBufferUtils.onException(bufferUnderflowException.fillInStackTrace(), jResponse, byteBuffer);
        }
        catch (BufferOverflowException bufferOverflowException) {
            ByteBufferUtils.onException(bufferOverflowException.fillInStackTrace(), jResponse, byteBuffer);
        }
        catch (Exception exception) {
            ByteBufferUtils.onException(exception.fillInStackTrace(), jResponse, byteBuffer);
        }
        if (jResponse != null) {
            jResponse.code = 10000;
        }
        return null;
    }

    public static long getLong(ByteBuffer byteBuffer, JResponse jResponse) {
        try {
            return byteBuffer.getLong();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            ByteBufferUtils.onException(bufferUnderflowException.fillInStackTrace(), jResponse, byteBuffer);
        }
        catch (BufferOverflowException bufferOverflowException) {
            ByteBufferUtils.onException(bufferOverflowException.fillInStackTrace(), jResponse, byteBuffer);
        }
        catch (Exception exception) {
            ByteBufferUtils.onException(exception.fillInStackTrace(), jResponse, byteBuffer);
        }
        if (jResponse != null) {
            jResponse.code = 10000;
        }
        return 0L;
    }

    private static void onException(Throwable throwable, JResponse jResponse, ByteBuffer byteBuffer) {
        ByteBufferUtils.generalExtraStr(throwable, jResponse, byteBuffer);
    }

    private static String generalExtraStr(Throwable throwable, JResponse jResponse, ByteBuffer byteBuffer) {
        StringBuilder stringBuilder = new StringBuilder();
        if (jResponse != null) {
            stringBuilder.append(jResponse.toString());
            stringBuilder.append("|bytebuffer:" + (byteBuffer == null ? "byteBuffer is null" : byteBuffer.toString()));
        }
        d.f(TAG, "byteBuffer info:" + stringBuilder.toString());
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            String string = stringWriter.toString();
            d.f(TAG, "parse data error stackTrace:" + string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuilder.toString();
    }
}

