/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.android.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class JPushCollectControl
implements Serializable {
    private static final long serialVersionUID = -3135447319267654288L;
    private ArrayList<Integer> mEnableDatas = new ArrayList();
    private ArrayList<Integer> mDisableDatas = new ArrayList();
    private static final int GPS = 1000;
    private static final int APP_LISTS = 1001;
    private static final int IMEI = 1003;
    private static final int MAC = 1005;
    private static final int SSID = 1006;
    private static final int BSSID = 1007;
    private static final int CELL = 1008;
    public static final int IMSI = 1010;
    public static final int WIFI = 1012;
    public static final int APP_RUNNING = 1013;

    public JPushCollectControl(Builder builder) {
        if (null != builder.mDisableDatas && !builder.mDisableDatas.isEmpty()) {
            this.mDisableDatas.addAll(builder.mDisableDatas);
        }
        if (null != builder.mEnableDatas && !builder.mEnableDatas.isEmpty()) {
            this.mEnableDatas.addAll(builder.mEnableDatas);
        }
    }

    public ArrayList<Integer> getEnableDatas() {
        return this.mEnableDatas;
    }

    public ArrayList<Integer> getDisableDatas() {
        return this.mDisableDatas;
    }

    public static class Builder {
        private Set<Integer> mEnableDatas = new HashSet<Integer>();
        private Set<Integer> mDisableDatas = new HashSet<Integer>();

        private void enable(int n) {
            this.mDisableDatas.remove(n);
            this.mEnableDatas.add(n);
        }

        private void disable(int n) {
            this.mEnableDatas.remove(n);
            this.mDisableDatas.add(n);
        }

        private void set(boolean bl, int n) {
            if (bl) {
                this.enable(n);
            } else {
                this.disable(n);
            }
        }

        public Builder gps(boolean bl) {
            int n = 1000;
            this.set(bl, n);
            return this;
        }

        public Builder appList(boolean bl) {
            int n = 1001;
            this.set(bl, n);
            this.set(bl, 1013);
            return this;
        }

        public Builder imei(boolean bl) {
            int n = 1003;
            this.set(bl, n);
            return this;
        }

        public Builder mac(boolean bl) {
            int n = 1005;
            this.set(bl, n);
            return this;
        }

        public Builder ssid(boolean bl) {
            int n = 1006;
            this.set(bl, n);
            if (!bl) {
                this.wifi(false);
            }
            return this;
        }

        public Builder bssid(boolean bl) {
            int n = 1007;
            this.set(bl, n);
            if (!bl) {
                this.wifi(false);
            }
            return this;
        }

        public Builder cell(boolean bl) {
            int n = 1008;
            this.set(bl, n);
            return this;
        }

        public Builder imsi(boolean bl) {
            int n = 1010;
            this.set(bl, n);
            return this;
        }

        public Builder wifi(boolean bl) {
            int n = 1012;
            this.set(bl, n);
            return this;
        }

        public JPushCollectControl build() {
            return new JPushCollectControl(this);
        }
    }
}

