/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.plugins.push;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import cn.jiguang.plugins.push.common.JLogger;
import cn.jiguang.plugins.push.helper.JPushHelper;
import cn.jiguang.plugins.push.receiver.JPushBroadcastReceiver;
import cn.jpush.android.api.BasicPushNotificationBuilder;
import cn.jpush.android.api.JPushInterface;
import cn.jpush.android.api.PushNotificationBuilder;
import cn.jpush.android.data.JPushLocalNotification;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import java.util.HashSet;
import java.util.Map;
import org.json.JSONObject;

public class JPushModule
extends ReactContextBaseJavaModule {
    public static ReactApplicationContext reactContext;
    public static boolean isAppForeground;

    public JPushModule(ReactApplicationContext reactApplicationContext) {
        super(reactContext);
        reactContext = reactApplicationContext;
    }

    public String getName() {
        return "JPushModule";
    }

    @ReactMethod
    public void setDebugMode(boolean enable) {
        JPushInterface.setDebugMode((boolean)enable);
        JLogger.setLoggerEnable(enable);
    }

    @ReactMethod
    public void init() {
        JPushInterface.setDebugMode((boolean)true);
        JPushInterface.init((Context)reactContext);
        if (JPushBroadcastReceiver.NOTIFICATION_BUNDLE != null) {
            WritableMap writableMap = JPushHelper.convertNotificationBundleToMap("notificationOpened", JPushBroadcastReceiver.NOTIFICATION_BUNDLE);
            JPushHelper.sendEvent("NotificationEvent", writableMap);
            JPushBroadcastReceiver.NOTIFICATION_BUNDLE = null;
        }
    }

    @ReactMethod
    public void stopPush() {
        JPushInterface.stopPush((Context)reactContext);
    }

    @ReactMethod
    public void resumePush() {
        JPushInterface.resumePush((Context)reactContext);
    }

    @ReactMethod
    public void isPushStopped(Callback callback) {
        boolean isPushStopped = JPushInterface.isPushStopped((Context)reactContext);
        if (callback == null) {
            JLogger.w("callback cant be null");
            return;
        }
        callback.invoke(new Object[]{isPushStopped});
    }

    @ReactMethod
    public void setChannel(ReadableMap readableMap) {
        if (readableMap == null) {
            JLogger.w("params cant be null");
            return;
        }
        String channel = readableMap.getString("channel");
        if (TextUtils.isEmpty((CharSequence)channel)) {
            JLogger.w("params illegal");
        } else {
            JPushInterface.setChannel((Context)reactContext, (String)channel);
        }
    }

    @ReactMethod
    public void setBadgeNumber(ReadableMap readableMap) {
        if (readableMap == null) {
            JLogger.w("params cant be null");
            return;
        }
        if (readableMap.hasKey("badge")) {
            int number = readableMap.getInt("badge");
            JPushInterface.setBadgeNumber((Context)reactContext, (int)number);
        } else {
            JLogger.w("there are no badge");
        }
    }

    @ReactMethod
    public void setPushTime(ReadableMap readableMap) {
        if (readableMap == null) {
            JLogger.w("params cant be null");
            return;
        }
        ReadableArray readableArray = readableMap.getArray("pushTimeDays");
        int startHour = readableMap.getInt("pushTimeStartHour");
        int endHour = readableMap.getInt("pushTimeEndHour");
        if (readableArray == null || startHour == 0 || endHour == 0) {
            JLogger.w("params cant be null");
            return;
        }
        HashSet<Integer> days = new HashSet<Integer>();
        for (int i = 0; i < readableArray.size(); ++i) {
            int day = readableArray.getInt(i);
            if (day > 6 || day < 0) {
                JLogger.w("params cant be null");
                return;
            }
            days.add(day);
        }
        JPushInterface.setPushTime((Context)reactContext, days, (int)startHour, (int)endHour);
    }

    @ReactMethod
    public void setSilenceTime(ReadableMap readableMap) {
        if (readableMap == null) {
            JLogger.w("params cant be null");
            return;
        }
        int startHour = readableMap.getInt("silenceTimeStartHour");
        int startMinute = readableMap.getInt("silenceTimeStartMinute");
        int endHour = readableMap.getInt("silenceTimeEndHour");
        int endMinute = readableMap.getInt("silenceTimeEndMinute");
        if (startHour == 0 || startMinute == 0 || endHour == 0 || endMinute == 0) {
            JLogger.w("params cant be null");
            return;
        }
        JPushInterface.setSilenceTime((Context)reactContext, (int)startHour, (int)startMinute, (int)endHour, (int)endMinute);
    }

    @ReactMethod
    public void getRegistrationID(Callback callback) {
        if (callback == null) {
            JLogger.w("callback cant be null");
            return;
        }
        String registrationID = JPushInterface.getRegistrationID((Context)reactContext);
        WritableMap writableMap = Arguments.createMap();
        writableMap.putString("registerID", registrationID);
        callback.invoke(new Object[]{writableMap});
    }

    @ReactMethod
    public void getUdid(Callback callback) {
        if (callback == null) {
            JLogger.w("callback cant be null");
            return;
        }
        String udid = JPushInterface.getUdid((Context)reactContext);
        callback.invoke(new Object[]{udid});
    }

    @ReactMethod
    public void setLatestNotificationNumber(ReadableMap readableMap) {
        if (readableMap == null) {
            JLogger.w("params cant be null");
            return;
        }
        if (readableMap.hasKey("notificationMaxNumber")) {
            int maxNumber = readableMap.getInt("notificationMaxNumber");
            JPushInterface.setLatestNotificationNumber((Context)reactContext, (int)maxNumber);
        } else {
            JLogger.w("there are no notificationMaxNumber");
        }
    }

    @ReactMethod
    public void setDefaultPushNotificationBuilder(ReadableMap readableMap) {
        if (readableMap == null) {
            JLogger.w("params cant be null");
            return;
        }
        BasicPushNotificationBuilder builder = new BasicPushNotificationBuilder((Context)reactContext);
        JPushInterface.setDefaultPushNotificationBuilder((PushNotificationBuilder)builder);
    }

    @ReactMethod
    public void filterValidTags(ReadableMap readableMap, Callback callback) {
        if (readableMap == null) {
            JLogger.w("params cant be null");
            return;
        }
        if (readableMap.hasKey("tags")) {
            ReadableArray tags = readableMap.getArray("tags");
            HashSet<String> tagSet = new HashSet<String>();
            for (int i = 0; i < tags.size(); ++i) {
                String tag = tags.getString(i);
                tagSet.add(tag);
            }
            JPushInterface.filterValidTags(tagSet);
        } else {
            JLogger.w("there are no tags");
        }
    }

    @ReactMethod
    public void setTags(ReadableMap readableMap) {
        if (readableMap == null) {
            JLogger.w("params cant be null");
            return;
        }
        if (readableMap.hasKey("tags")) {
            ReadableArray tags = readableMap.getArray("tags");
            int sequence = readableMap.getInt("sequence");
            HashSet<String> tagSet = new HashSet<String>();
            for (int i = 0; i < tags.size(); ++i) {
                String tag = tags.getString(i);
                tagSet.add(tag);
            }
            JPushInterface.setTags((Context)reactContext, (int)sequence, tagSet);
        } else {
            JLogger.w("there are no tags");
        }
    }

    @ReactMethod
    public void addTags(ReadableMap readableMap) {
        if (readableMap == null) {
            JLogger.w("params cant be null");
            return;
        }
        if (readableMap.hasKey("tags")) {
            ReadableArray tags = readableMap.getArray("tags");
            int sequence = readableMap.getInt("sequence");
            HashSet<String> tagSet = new HashSet<String>();
            for (int i = 0; i < tags.size(); ++i) {
                String tag = tags.getString(i);
                tagSet.add(tag);
            }
            JPushInterface.addTags((Context)reactContext, (int)sequence, tagSet);
        } else {
            JLogger.w("there are no tags");
        }
    }

    @ReactMethod
    public void deleteTags(ReadableMap readableMap) {
        if (readableMap == null) {
            JLogger.w("params cant be null");
            return;
        }
        if (readableMap.hasKey("tags")) {
            ReadableArray tags = readableMap.getArray("tags");
            int sequence = readableMap.getInt("sequence");
            HashSet<String> tagSet = new HashSet<String>();
            for (int i = 0; i < tags.size(); ++i) {
                String tag = tags.getString(i);
                tagSet.add(tag);
            }
            JPushInterface.deleteTags((Context)reactContext, (int)sequence, tagSet);
        } else {
            JLogger.w("there are no tags");
        }
    }

    @ReactMethod
    public void cleanTags(ReadableMap readableMap) {
        if (readableMap == null) {
            JLogger.w("params cant be null");
            return;
        }
        int sequence = readableMap.getInt("sequence");
        JPushInterface.cleanTags((Context)reactContext, (int)sequence);
    }

    @ReactMethod
    public void getAllTags(ReadableMap readableMap) {
        if (readableMap == null) {
            JLogger.w("params cant be null");
            return;
        }
        int sequence = readableMap.getInt("sequence");
        JPushInterface.getAllTags((Context)reactContext, (int)sequence);
    }

    @ReactMethod
    public void checkTagBindState(ReadableMap readableMap) {
        if (readableMap == null) {
            JLogger.w("params cant be null");
            return;
        }
        int sequence = readableMap.getInt("sequence");
        String tag = readableMap.getString("tag");
        JPushInterface.checkTagBindState((Context)reactContext, (int)sequence, (String)tag);
    }

    @ReactMethod
    public void setAlias(ReadableMap readableMap) {
        if (readableMap == null) {
            JLogger.w("params cant be null");
            return;
        }
        int sequence = readableMap.getInt("sequence");
        String alias = readableMap.getString("alias");
        JPushInterface.setAlias((Context)reactContext, (int)sequence, (String)alias);
    }

    @ReactMethod
    public void deleteAlias(ReadableMap readableMap) {
        if (readableMap == null) {
            JLogger.w("params cant be null");
            return;
        }
        int sequence = readableMap.getInt("sequence");
        JPushInterface.deleteAlias((Context)reactContext, (int)sequence);
    }

    @ReactMethod
    public void getAlias(ReadableMap readableMap) {
        if (readableMap == null) {
            JLogger.w("params cant be null");
            return;
        }
        int sequence = readableMap.getInt("sequence");
        JPushInterface.getAlias((Context)reactContext, (int)sequence);
    }

    @ReactMethod
    public void setMobileNumber(ReadableMap readableMap) {
        if (readableMap == null) {
            JLogger.w("params cant be null");
            return;
        }
        int sequence = readableMap.getInt("sequence");
        String mobileNumber = readableMap.getString("mobileNumber");
        JPushInterface.setMobileNumber((Context)reactContext, (int)sequence, (String)mobileNumber);
    }

    @ReactMethod
    public void onResume() {
        JPushInterface.onResume((Context)reactContext);
    }

    @ReactMethod
    public void onPause() {
        JPushInterface.onPause((Context)reactContext);
    }

    @ReactMethod
    public void onKillProcess() {
        JPushInterface.onKillProcess((Context)reactContext);
    }

    @ReactMethod
    public void initCrashHandler() {
        JPushInterface.initCrashHandler((Context)reactContext);
    }

    @ReactMethod
    public void stopCrashHandler() {
        JPushInterface.stopCrashHandler((Context)reactContext);
    }

    @ReactMethod
    public void addLocalNotification(ReadableMap readableMap) {
        if (readableMap == null) {
            JLogger.w("params cant be null");
            return;
        }
        if (!readableMap.hasKey("messageID")) {
            JLogger.w("params illegal");
            return;
        }
        String notificationID = readableMap.getString("messageID");
        if (notificationID == null || TextUtils.isEmpty((CharSequence)notificationID)) {
            JLogger.w("params illegal");
            return;
        }
        int id2 = Integer.valueOf(notificationID);
        String notificationTitle = readableMap.hasKey("title") ? readableMap.getString("title") : reactContext.getPackageName();
        String notificationContent = readableMap.hasKey("content") ? readableMap.getString("content") : reactContext.getPackageName();
        JPushLocalNotification notification = new JPushLocalNotification();
        notification.setNotificationId((long)id2);
        notification.setTitle(notificationTitle);
        notification.setContent(notificationContent);
        if (readableMap.hasKey("extras")) {
            ReadableMap notificationExtra = readableMap.getMap("extras");
            JSONObject notificationExtraJson = new JSONObject((Map)notificationExtra.toHashMap());
            notification.setExtras(notificationExtraJson.toString());
        }
        JPushInterface.addLocalNotification((Context)reactContext, (JPushLocalNotification)notification);
    }

    @ReactMethod
    public void removeLocalNotification(ReadableMap readableMap) {
        if (readableMap == null) {
            JLogger.w("params cant be null");
            return;
        }
        if (readableMap.hasKey("messageID")) {
            String notificationID = readableMap.getString("messageID");
            if (notificationID == null || TextUtils.isEmpty((CharSequence)notificationID)) {
                JLogger.w("params illegal");
                return;
            }
            int id2 = Integer.valueOf(notificationID);
            JPushInterface.removeLocalNotification((Context)reactContext, (long)id2);
        } else {
            JLogger.w("there are no messageID");
        }
    }

    @ReactMethod
    public void clearLocalNotifications() {
        JPushInterface.clearLocalNotifications((Context)reactContext);
    }

    @ReactMethod
    public void requestPermission() {
        JPushInterface.requestPermission((Context)reactContext);
    }

    @ReactMethod
    public void setGeofenceInterval(ReadableMap readableMap) {
        if (readableMap == null) {
            JLogger.w("params cant be null");
            return;
        }
        if (readableMap.hasKey("geoFenceInterval")) {
            int interval = readableMap.getInt("geoFenceInterval");
            JPushInterface.setGeofenceInterval((Context)reactContext, (long)interval);
        } else {
            JLogger.w("there are no geoFenceInterval");
        }
    }

    @ReactMethod
    public void setMaxGeofenceNumber(ReadableMap readableMap) {
        if (readableMap == null) {
            JLogger.w("params cant be null");
            return;
        }
        if (readableMap.hasKey("geoFenceMaxNumber")) {
            int maxNumber = readableMap.getInt("geoFenceMaxNumber");
            JPushInterface.setMaxGeofenceNumber((Context)reactContext, (int)maxNumber);
        } else {
            JLogger.w("there are no geoFenceMaxNumber");
        }
    }

    @ReactMethod
    public void deleteGeofence(ReadableMap readableMap) {
        if (readableMap == null) {
            JLogger.w("params cant be null");
            return;
        }
        if (readableMap.hasKey("geoFenceID")) {
            String id2 = readableMap.getString("geoFenceID");
            JPushInterface.deleteGeofence((Context)reactContext, (String)id2);
        } else {
            JLogger.w("there are no geoFenceID");
        }
    }

    @ReactMethod
    public void clearAllNotifications() {
        JPushInterface.clearAllNotifications((Context)reactContext);
    }

    @ReactMethod
    public void clearNotificationById(ReadableMap readableMap) {
        if (readableMap == null) {
            JLogger.w("params cant be null");
            return;
        }
        if (readableMap.hasKey("notificationId")) {
            Integer id2 = readableMap.getInt("notificationId");
            JPushInterface.clearNotificationById((Context)reactContext, (int)id2);
        } else {
            JLogger.w("there are no geoFenceID");
        }
    }

    @ReactMethod
    public void setPowerSaveMode(boolean bool2) {
        JPushInterface.setPowerSaveMode((Context)reactContext, (boolean)bool2);
    }

    @ReactMethod
    public void isNotificationEnabled(Callback callback) {
        Integer isEnabled = JPushInterface.isNotificationEnabled((Context)reactContext);
        if (callback == null) {
            JLogger.w("callback cant be null");
            return;
        }
        callback.invoke(new Object[]{isEnabled});
    }

    public static void registerActivityLifecycle(Application application) {
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle bundle) {
                JLogger.d("onActivityCreated");
            }

            public void onActivityStarted(Activity activity) {
                JLogger.d("onActivityStarted");
            }

            public void onActivityResumed(Activity activity) {
                JLogger.d("onActivityResumed");
                isAppForeground = true;
            }

            public void onActivityPaused(Activity activity) {
                JLogger.d("onActivityPaused");
                isAppForeground = false;
            }

            public void onActivityStopped(Activity activity) {
                JLogger.d("onActivityStopped");
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
                JLogger.d("onActivitySaveInstanceState");
            }

            public void onActivityDestroyed(Activity activity) {
                JLogger.d("onActivityDestroyed");
            }
        });
    }

    static {
        isAppForeground = false;
    }
}

