/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.plugins.push.helper;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import cn.jiguang.plugins.push.JPushModule;
import cn.jiguang.plugins.push.common.JLogger;
import cn.jpush.android.api.CustomMessage;
import cn.jpush.android.api.JPushMessage;
import cn.jpush.android.api.NotificationMessage;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONObject;

public class JPushHelper {
    public static void sendEvent(String eventName, WritableMap params) {
        try {
            ((DeviceEventManagerModule.RCTDeviceEventEmitter)JPushModule.reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit(eventName, (Object)params);
        }
        catch (Throwable throwable) {
            JLogger.e("sendEvent error:" + throwable.getMessage());
        }
    }

    public static WritableMap convertNotificationToMap(String eventType, NotificationMessage message) {
        WritableMap writableMap = Arguments.createMap();
        writableMap.putString("notificationEventType", eventType);
        writableMap.putString("messageID", message.msgId);
        writableMap.putString("title", message.notificationTitle);
        writableMap.putString("content", message.notificationContent);
        JPushHelper.convertExtras(message.notificationExtras, writableMap);
        return writableMap;
    }

    public static WritableMap convertNotificationBundleToMap(String eventType, Bundle bundle) {
        WritableMap writableMap = Arguments.createMap();
        writableMap.putString("notificationEventType", eventType);
        writableMap.putString("messageID", bundle.getString("cn.jpush.android.MSG_ID", ""));
        writableMap.putString("title", bundle.getString("cn.jpush.android.NOTIFICATION_CONTENT_TITLE", ""));
        writableMap.putString("content", bundle.getString("cn.jpush.android.ALERT", ""));
        JPushHelper.convertExtras(bundle.getString("cn.jpush.android.EXTRA", ""), writableMap);
        return writableMap;
    }

    public static WritableMap convertCustomMessage(CustomMessage customMessage) {
        WritableMap writableMap = Arguments.createMap();
        writableMap.putString("messageID", customMessage.messageId);
        writableMap.putString("title", customMessage.title);
        writableMap.putString("content", customMessage.message);
        JPushHelper.convertExtras(customMessage.extra, writableMap);
        return writableMap;
    }

    public static WritableMap convertJPushMessageToMap(int type, JPushMessage message) {
        WritableMap writableMap = Arguments.createMap();
        writableMap.putInt("code", message.getErrorCode());
        writableMap.putInt("sequence", message.getSequence());
        switch (type) {
            case 1: {
                Set tags = message.getTags();
                WritableArray tagsArray = Arguments.createArray();
                if (tags == null || tags.isEmpty()) {
                    JLogger.d("tags is empty");
                } else {
                    for (String tag : tags) {
                        tagsArray.pushString(tag);
                    }
                }
                writableMap.putArray("tags", (ReadableArray)tagsArray);
                break;
            }
            case 2: {
                writableMap.putBoolean("tagEnable", message.getTagCheckStateResult());
                writableMap.putString("tag", message.getCheckTag());
                break;
            }
            case 3: {
                writableMap.putString("alias", message.getAlias());
            }
        }
        return writableMap;
    }

    public static void convertExtras(String extras, WritableMap writableMap) {
        if (TextUtils.isEmpty((CharSequence)extras) || extras.equals("{}")) {
            return;
        }
        try {
            WritableMap extrasMap = Arguments.createMap();
            JSONObject jsonObject = new JSONObject(extras);
            Iterator it = jsonObject.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = jsonObject.getString(key);
                extrasMap.putString(key, value);
            }
            writableMap.putMap("extras", (ReadableMap)extrasMap);
        }
        catch (Throwable throwable) {
            JLogger.w("convertExtras error:" + throwable.getMessage());
        }
    }

    public static void launchApp(Context context) {
        try {
            Intent intent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
            intent.setFlags(0x34000000);
            context.startActivity(intent);
        }
        catch (Throwable throwable) {
            JLogger.e("");
        }
    }
}

