/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.plugins.push.receiver;

import android.content.Context;
import cn.jiguang.plugins.push.JPushModule;
import cn.jiguang.plugins.push.common.JLogger;
import cn.jiguang.plugins.push.helper.JPushHelper;
import cn.jpush.android.api.CmdMessage;
import cn.jpush.android.api.CustomMessage;
import cn.jpush.android.api.JPushMessage;
import cn.jpush.android.api.NotificationMessage;
import cn.jpush.android.service.JPushMessageService;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableMap;

public class JPushModuleReceiver
extends JPushMessageService {
    public void onMessage(Context context, CustomMessage customMessage) {
        JLogger.d("onMessage:" + customMessage.toString());
        WritableMap writableMap = JPushHelper.convertCustomMessage(customMessage);
        JPushHelper.sendEvent("CustomMessageEvent", writableMap);
    }

    public void onNotifyMessageArrived(Context context, NotificationMessage notificationMessage) {
        JLogger.d("onNotifyMessageArrived:" + notificationMessage.toString());
        WritableMap writableMap = JPushHelper.convertNotificationToMap("notificationArrived", notificationMessage);
        if (notificationMessage.notificationType != 1) {
            JPushHelper.sendEvent("NotificationEvent", writableMap);
        } else {
            JPushHelper.sendEvent("LocalNotificationEvent", writableMap);
        }
    }

    public void onNotifyMessageOpened(Context context, NotificationMessage notificationMessage) {
        JLogger.d("onNotifyMessageOpened:" + notificationMessage.toString());
        if (JPushModule.reactContext != null) {
            if (!JPushModule.isAppForeground) {
                JPushHelper.launchApp(context);
            }
            WritableMap writableMap = JPushHelper.convertNotificationToMap("notificationOpened", notificationMessage);
            JPushHelper.sendEvent("NotificationEvent", writableMap);
        } else {
            super.onNotifyMessageOpened(context, notificationMessage);
        }
    }

    public void onNotifyMessageDismiss(Context context, NotificationMessage notificationMessage) {
        JLogger.d("onNotifyMessageDismiss:" + notificationMessage.toString());
        WritableMap writableMap = JPushHelper.convertNotificationToMap("notificationDismissed", notificationMessage);
        JPushHelper.sendEvent("NotificationEvent", writableMap);
    }

    public void onRegister(Context context, String registrationId) {
        JLogger.d("onRegister:" + registrationId);
    }

    public void onConnected(Context context, boolean state) {
        JLogger.d("onConnected state:" + state);
        WritableMap writableMap = Arguments.createMap();
        writableMap.putBoolean("connectEnable", state);
        JPushHelper.sendEvent("ConnectEvent", writableMap);
    }

    public void onCommandResult(Context context, CmdMessage message) {
        JLogger.d("onCommandResult:" + message.toString());
        WritableMap writableMap = Arguments.createMap();
        writableMap.putInt("command", message.cmd);
        writableMap.putString("commandExtra", message.extra.toString());
        writableMap.putString("commandMessage", message.msg);
        writableMap.putInt("commandResult", message.errorCode);
        JPushHelper.sendEvent("CommandEvent", writableMap);
    }

    public void onTagOperatorResult(Context context, JPushMessage jPushMessage) {
        JLogger.d("onTagOperatorResult:" + jPushMessage.toString());
        WritableMap writableMap = JPushHelper.convertJPushMessageToMap(1, jPushMessage);
        JPushHelper.sendEvent("TagAliasEvent", writableMap);
    }

    public void onCheckTagOperatorResult(Context context, JPushMessage jPushMessage) {
        JLogger.d("onCheckTagOperatorResult:" + jPushMessage.toString());
        WritableMap writableMap = JPushHelper.convertJPushMessageToMap(2, jPushMessage);
        JPushHelper.sendEvent("TagAliasEvent", writableMap);
    }

    public void onAliasOperatorResult(Context context, JPushMessage jPushMessage) {
        JLogger.d("onAliasOperatorResult:" + jPushMessage.toString());
        WritableMap writableMap = JPushHelper.convertJPushMessageToMap(3, jPushMessage);
        JPushHelper.sendEvent("TagAliasEvent", writableMap);
    }

    public void onMobileNumberOperatorResult(Context context, JPushMessage jPushMessage) {
        JLogger.d("onMobileNumberOperatorResult:" + jPushMessage.toString());
        WritableMap writableMap = Arguments.createMap();
        writableMap.putInt("code", jPushMessage.getErrorCode());
        writableMap.putInt("sequence", jPushMessage.getSequence());
        JPushHelper.sendEvent("MobileNumberEvent", writableMap);
    }
}

