/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.android.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.ImageView;

public class RoundedImageView
extends ImageView {
    private float width;
    private float height;
    private int defaultRadius = 45;
    private int radius;
    private int leftTopRadius;
    private int rightTopRadius;
    private int rightBottomRadius;
    private int leftBottomRadius;

    public RoundedImageView(Context context) {
        this(context, null);
        this.init(context, null);
    }

    public RoundedImageView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.init(context, attributeSet);
    }

    public RoundedImageView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.init(context, attributeSet);
    }

    private void init(Context context, AttributeSet attributeSet) {
        if (Build.VERSION.SDK_INT < 18) {
            this.setLayerType(1, null);
        }
        this.leftTopRadius = this.defaultRadius;
        this.rightTopRadius = this.defaultRadius;
        this.rightBottomRadius = this.defaultRadius;
        this.leftBottomRadius = this.defaultRadius;
    }

    public void setRadius(int n2, int n3, int n4, int n5) {
        this.leftTopRadius = n2;
        this.rightTopRadius = n3;
        this.rightBottomRadius = n4;
        this.leftBottomRadius = n5;
        this.invalidate();
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        super.onLayout(bl, n2, n3, n4, n5);
        this.width = this.getWidth();
        this.height = this.getHeight();
    }

    protected void onDraw(Canvas canvas) {
        int n2 = Math.max(this.leftTopRadius, this.leftBottomRadius);
        int n3 = Math.max(this.rightTopRadius, this.rightBottomRadius);
        int n4 = n2 + n3;
        int n5 = Math.max(this.leftTopRadius, this.rightTopRadius);
        int n6 = Math.max(this.leftBottomRadius, this.rightBottomRadius);
        int n7 = n5 + n6;
        if (this.width >= (float)n4 && this.height > (float)n7) {
            Path path = new Path();
            path.moveTo((float)this.leftTopRadius, 0.0f);
            path.lineTo(this.width - (float)this.rightTopRadius, 0.0f);
            path.quadTo(this.width, 0.0f, this.width, (float)this.rightTopRadius);
            path.lineTo(this.width, this.height - (float)this.rightBottomRadius);
            path.quadTo(this.width, this.height, this.width - (float)this.rightBottomRadius, this.height);
            path.lineTo((float)this.leftBottomRadius, this.height);
            path.quadTo(0.0f, this.height, 0.0f, this.height - (float)this.leftBottomRadius);
            path.lineTo(0.0f, (float)this.leftTopRadius);
            path.quadTo(0.0f, 0.0f, (float)this.leftTopRadius, 0.0f);
            canvas.clipPath(path);
        }
        super.onDraw(canvas);
    }
}

