/*
 * Decompiled with CFR 0.152.
 */
package com.juggleim;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.util.Log;
import androidx.core.content.FileProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertContentUriToFile(Context context, String contentUri) {
        if (!contentUri.startsWith("content://")) {
            return contentUri;
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        File tempFile = null;
        try {
            int length;
            ContentResolver resolver = context.getContentResolver();
            inputStream = resolver.openInputStream(Uri.parse((String)contentUri));
            tempFile = new File(context.getCacheDir(), System.currentTimeMillis() + "temp_image.jpg");
            if (tempFile.exists()) {
                tempFile.delete();
            }
            outputStream = new FileOutputStream(tempFile);
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, length);
            }
            outputStream.flush();
        }
        catch (Exception e) {
            Log.e((String)"FileUtils", (String)"Error converting content Uri to file", (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception e) {
                Log.e((String)"FileUtils", (String)"Error closing streams", (Throwable)e);
            }
        }
        return tempFile.getAbsolutePath();
    }

    public static boolean deleteTempFile(File tempFile) {
        if (tempFile != null && tempFile.exists()) {
            return tempFile.delete();
        }
        return false;
    }

    public static Uri createTmpImageFile(Context context) {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault()).format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_";
        File storageDir = context.getCacheDir();
        try {
            File photoFile = File.createTempFile(imageFileName, ".jpg", storageDir);
            String authority = context.getPackageName() + ".fileprovider";
            Uri photoURI = FileProvider.getUriForFile((Context)context, (String)authority, (File)photoFile);
            return photoURI;
        }
        catch (Exception e) {
            Log.e((String)"FileUtils", (String)"Error creating temp file", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

