/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.plugins.example;

import android.util.Log;
import java.util.LinkedList;
import java.util.Queue;

public class CalculateTargetFps {
    private static final String TAG = "CalculateTargetFps";
    private int mDefaultFps;
    private long mLastFrameTimestamp = 0L;
    private final Queue<Long> mIntervalQueue = new LinkedList<Long>();
    private int mQueueCapacity;
    private long mCurrentMaxInterval = 0L;
    private long mTargetMaxInterval = 0L;
    private long mTransitionStartTime = 0L;
    private static final long TRANSITION_DURATION_MS = 30000L;
    private static final long MIN_VALID_INTERVAL_MS = 5L;

    public CalculateTargetFps(int defaultFps) {
        this.mDefaultFps = defaultFps;
        this.mQueueCapacity = defaultFps * 60;
        Log.d((String)TAG, (String)("\u521d\u59cb\u5316\u5e27\u7387\u8ba1\u7b97\u5668\uff0c\u9ed8\u8ba4\u5e27\u7387: " + defaultFps + ", \u961f\u5217\u5bb9\u91cf: " + this.mQueueCapacity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultFps(int fps) {
        if (fps <= 0) {
            Log.e((String)TAG, (String)("\u65e0\u6548\u7684\u5e27\u7387\u8bbe\u7f6e: " + fps));
            return;
        }
        this.mDefaultFps = fps;
        this.mQueueCapacity = fps * 60;
        Queue<Long> queue = this.mIntervalQueue;
        synchronized (queue) {
            this.mIntervalQueue.clear();
            this.mLastFrameTimestamp = 0L;
            this.mCurrentMaxInterval = 0L;
            this.mTargetMaxInterval = 0L;
            this.mTransitionStartTime = 0L;
        }
        Log.d((String)TAG, (String)("\u66f4\u65b0\u9ed8\u8ba4\u5e27\u7387: " + fps + ", \u65b0\u961f\u5217\u5bb9\u91cf: " + this.mQueueCapacity));
    }

    public long getLastFrameTs() {
        return this.mLastFrameTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNewFrame(long setInterval) {
        long currentTime = System.currentTimeMillis();
        Queue<Long> queue = this.mIntervalQueue;
        synchronized (queue) {
            long interval = 0L;
            if (setInterval < 0L) {
                if (this.mLastFrameTimestamp == 0L) {
                    this.mLastFrameTimestamp = currentTime;
                    return;
                }
                interval = currentTime - this.mLastFrameTimestamp;
                this.mLastFrameTimestamp = currentTime;
            } else {
                interval = setInterval;
            }
            if (interval < 5L) {
                return;
            }
            this.mIntervalQueue.offer(interval);
            while (this.mIntervalQueue.size() > this.mQueueCapacity) {
                this.mIntervalQueue.poll();
            }
            long queueMaxInterval = 0L;
            for (Long i : this.mIntervalQueue) {
                queueMaxInterval = Math.max(queueMaxInterval, i);
            }
            if (queueMaxInterval > this.mCurrentMaxInterval) {
                this.mCurrentMaxInterval = queueMaxInterval;
                this.mTargetMaxInterval = queueMaxInterval;
                this.mTransitionStartTime = 0L;
                float multiplier = (float)queueMaxInterval / 1000.0f;
                Log.d((String)TAG, (String)String.format("\u68c0\u6d4b\u5230\u5e27\u95f4\u9694\u7a81\u589e: %dms, \u4e58\u6570: %.2f (1 + %d/1000), \u65b0\u76ee\u6807\u5e27\u7387: %d fps", queueMaxInterval, Float.valueOf(multiplier), queueMaxInterval, Math.round((float)this.mDefaultFps * multiplier)));
            } else if (queueMaxInterval < this.mCurrentMaxInterval && (this.mTransitionStartTime == 0L || this.mTargetMaxInterval != queueMaxInterval)) {
                this.mTargetMaxInterval = queueMaxInterval;
                this.mTransitionStartTime = currentTime;
                float currentMultiplier = 1.0f + (float)this.mCurrentMaxInterval / 1000.0f;
                float targetMultiplier = 1.0f + (float)queueMaxInterval / 1000.0f;
                Log.d((String)TAG, (String)String.format("\u5f00\u59cb\u5e73\u6ed1\u8fc7\u6e21\uff0c\u5f53\u524d\u95f4\u9694: %dms (\u4e58\u6570: %.2f), \u76ee\u6807\u95f4\u9694: %dms (\u4e58\u6570: %.2f), \u8fc7\u6e21\u65f6\u95f4: %ds", this.mCurrentMaxInterval, Float.valueOf(currentMultiplier), this.mTargetMaxInterval, Float.valueOf(targetMultiplier), 30L));
            }
            if (this.mTransitionStartTime > 0L) {
                float progress = (float)(currentTime - this.mTransitionStartTime) / 30000.0f;
                progress = Math.max(0.0f, Math.min(1.0f, progress));
                long oldValue = this.mCurrentMaxInterval;
                this.mCurrentMaxInterval = Math.round((float)this.mCurrentMaxInterval - (float)(this.mCurrentMaxInterval - this.mTargetMaxInterval) * progress);
                if (Math.abs(oldValue - this.mCurrentMaxInterval) > 10L) {
                    Log.d((String)TAG, (String)String.format("\u5e73\u6ed1\u8fc7\u6e21\u4e2d: \u8fdb\u5ea6=%.2f, \u5f53\u524d\u95f4\u9694=%dms, \u76ee\u6807\u95f4\u9694=%dms, \u5df2\u4e0b\u964d=%.1f%%", Float.valueOf(progress), this.mCurrentMaxInterval, this.mTargetMaxInterval, Float.valueOf(progress * 100.0f)));
                }
                if (progress >= 1.0f) {
                    this.mCurrentMaxInterval = this.mTargetMaxInterval;
                    this.mTransitionStartTime = 0L;
                    Log.d((String)TAG, (String)("\u5e73\u6ed1\u8fc7\u6e21\u5b8c\u6210\uff0c\u6700\u5927\u95f4\u9694\u5df2\u66f4\u65b0\u4e3a: " + this.mCurrentMaxInterval + "ms"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTargetFps() {
        Queue<Long> queue = this.mIntervalQueue;
        synchronized (queue) {
            if (this.mIntervalQueue.size() < 10 || this.mCurrentMaxInterval <= 0L) {
                return this.mDefaultFps;
            }
            float multiplier = (float)this.mCurrentMaxInterval / 1000.0f;
            int calculatedFps = Math.round((float)this.mDefaultFps * multiplier);
            calculatedFps = Math.min(calculatedFps, this.mDefaultFps * 3);
            return calculatedFps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentMaxInterval() {
        Queue<Long> queue = this.mIntervalQueue;
        synchronized (queue) {
            return this.mCurrentMaxInterval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        Queue<Long> queue = this.mIntervalQueue;
        synchronized (queue) {
            return this.mIntervalQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Queue<Long> queue = this.mIntervalQueue;
        synchronized (queue) {
            this.mIntervalQueue.clear();
            this.mLastFrameTimestamp = 0L;
            this.mCurrentMaxInterval = 0L;
            this.mTargetMaxInterval = 0L;
            this.mTransitionStartTime = 0L;
        }
        Log.d((String)TAG, (String)"\u5e27\u7387\u8ba1\u7b97\u5668\u5df2\u91cd\u7f6e");
    }

    public void runTest() {
        new Thread(() -> {
            Log.d((String)TAG, (String)"\u5f00\u59cb\u6d4b\u8bd5\u5e27\u7387\u8ba1\u7b97\u5668...");
            Log.d((String)TAG, (String)("\u9ed8\u8ba4\u5e27\u7387: " + this.mDefaultFps + ", \u6b63\u5e38\u5e27\u95f4\u9694: " + 1000.0f / (float)this.mDefaultFps + "ms"));
            this.reset();
            try {
                float multiplier;
                int fps;
                int i;
                Log.d((String)TAG, (String)"===== \u9636\u6bb51: \u6b63\u5e38\u5e27\u7387 (33ms\u95f4\u9694\uff0c\u7ea630fps) =====");
                for (i = 0; i < 60; ++i) {
                    this.onNewFrame(-1L);
                    fps = this.getTargetFps();
                    if (i % 10 == 0) {
                        multiplier = 1.0f + (float)this.getCurrentMaxInterval() / 1000.0f;
                        Log.d((String)TAG, (String)String.format("\u6b63\u5e38\u5e27\u7387\u9636\u6bb5: \u5e27 #%d, \u76ee\u6807\u5e27\u7387=%d fps, \u6700\u5927\u95f4\u9694=%d ms, \u4e58\u6570=%.2f", i, fps, this.getCurrentMaxInterval(), Float.valueOf(multiplier)));
                    }
                    Thread.sleep(33L);
                }
                Log.d((String)TAG, (String)"===== \u9636\u6bb52: \u7a81\u7136\u53d8\u6162 (300ms\u95f4\u9694\uff0c\u7ea63fps) - \u5e94\u8be5\u8fc5\u901f\u63d0\u9ad8\u76ee\u6807\u5e27\u7387 =====");
                for (i = 0; i < 10; ++i) {
                    this.onNewFrame(-1L);
                    fps = this.getTargetFps();
                    multiplier = 1.0f + (float)this.getCurrentMaxInterval() / 1000.0f;
                    Log.d((String)TAG, (String)String.format("\u53d8\u6162\u9636\u6bb5: \u5e27 #%d, \u76ee\u6807\u5e27\u7387=%d fps, \u6700\u5927\u95f4\u9694=%d ms, \u4e58\u6570=%.2f", i, fps, this.getCurrentMaxInterval(), Float.valueOf(multiplier)));
                    Thread.sleep(300L);
                }
                Log.d((String)TAG, (String)"===== \u9636\u6bb53: \u6062\u590d\u6b63\u5e38 (33ms\u95f4\u9694\uff0c\u7ea630fps) - \u5e94\u8be5\u7f13\u6162\u964d\u4f4e\u76ee\u6807\u5e27\u7387 =====");
                for (i = 0; i < 1200; ++i) {
                    this.onNewFrame(-1L);
                    fps = this.getTargetFps();
                    multiplier = 1.0f + (float)this.getCurrentMaxInterval() / 1000.0f;
                    if (i < 10 || i % 10 == 0 || i > 900 && i % 30 == 0) {
                        Log.d((String)TAG, (String)String.format("\u6062\u590d\u9636\u6bb5: \u5e27 #%d (%.1f\u79d2), \u76ee\u6807\u5e27\u7387=%d fps, \u6700\u5927\u95f4\u9694=%d ms, \u4e58\u6570=%.2f", i, Float.valueOf((float)i * 0.033f), fps, this.getCurrentMaxInterval(), Float.valueOf(multiplier)));
                    }
                    Thread.sleep(33L);
                }
                Log.d((String)TAG, (String)"===== \u9636\u6bb54: \u7a81\u53d1\u5361\u987f\u540e\u6062\u590d (2000ms\u5361\u987f) =====");
                this.onNewFrame(-1L);
                Thread.sleep(2000L);
                this.onNewFrame(-1L);
                int fps2 = this.getTargetFps();
                multiplier = 1.0f + (float)this.getCurrentMaxInterval() / 1000.0f;
                Log.d((String)TAG, (String)String.format("\u5361\u987f\u540e: \u76ee\u6807\u5e27\u7387=%d fps, \u6700\u5927\u95f4\u9694=%d ms, \u4e58\u6570=%.2f", fps2, this.getCurrentMaxInterval(), Float.valueOf(multiplier)));
                Log.d((String)TAG, (String)"===== \u9636\u6bb54.2: \u5361\u987f\u540e\u6062\u590d\u6b63\u5e38 =====");
                for (int i2 = 0; i2 < 1200; ++i2) {
                    this.onNewFrame(-1L);
                    fps2 = this.getTargetFps();
                    multiplier = 1.0f + (float)this.getCurrentMaxInterval() / 1000.0f;
                    if (i2 < 10 || i2 % 10 == 0 || i2 > 900 && i2 % 30 == 0) {
                        Log.d((String)TAG, (String)String.format("\u5361\u987f\u6062\u590d\u9636\u6bb5: \u5e27 #%d (%.1f\u79d2), \u76ee\u6807\u5e27\u7387=%d fps, \u6700\u5927\u95f4\u9694=%d ms, \u4e58\u6570=%.2f", i2, Float.valueOf((float)i2 * 0.033f), fps2, this.getCurrentMaxInterval(), Float.valueOf(multiplier)));
                    }
                    Thread.sleep(33L);
                }
                Log.d((String)TAG, (String)"\u5e27\u7387\u8ba1\u7b97\u5668\u6d4b\u8bd5\u5b8c\u6210");
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)"\u6d4b\u8bd5\u88ab\u4e2d\u65ad", (Throwable)e);
            }
        }).start();
    }
}

