/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.plugins.example;

import android.util.Log;

public class FrameRateController {
    private static final String TAG = "FrameRateController";
    private int targetFrameRate = 30;
    private int videoFps = 30;
    private int queuedFrames = 0;
    private long lastFrameTime = System.currentTimeMillis();
    private long lastProcessTime = System.currentTimeMillis();
    private boolean isPlaying = false;
    private final int initialBufferMs = 1000;
    private final int reconnectTimeoutMs = 3000;
    private final int targetBufferCoverageMs = 3000;
    private long targetFrameCompleteTime = 0L;

    public void setTargetFrameRate(int frameRate, int videoFps) {
        this.targetFrameRate = frameRate;
        this.videoFps = videoFps;
        Log.d((String)TAG, (String)("\u8bbe\u7f6e\u76ee\u6807\u5e27\u7387: " + frameRate + ",\u89c6\u9891\u5e27\u7387:" + videoFps));
    }

    public void setDynamicTargetFrameRate(int dynamicFrameRate) {
        if (dynamicFrameRate > 0 && this.targetFrameRate != dynamicFrameRate) {
            Log.d((String)TAG, (String)("\u66f4\u65b0\u52a8\u6001\u76ee\u6807\u5e27\u7387: " + dynamicFrameRate + " (\u539f\u5e27\u7387: " + this.targetFrameRate + ")"));
            this.targetFrameRate = dynamicFrameRate;
        }
    }

    public void onFrameReceived() {
        ++this.queuedFrames;
        this.lastFrameTime = System.currentTimeMillis();
        if (!this.isPlaying && this.queuedFrames >= this.targetFrameRate) {
            this.isPlaying = true;
            Log.d((String)TAG, (String)("\u521d\u59cb\u7f13\u51b2\u5b8c\u6210\uff0c\u5f00\u59cb\u64ad\u653e\uff0c\u5f53\u524d\u961f\u5217\u5e27\u6570: " + this.queuedFrames));
        }
    }

    public void onFrameConsumed() {
        if (this.queuedFrames > 0) {
            --this.queuedFrames;
        }
    }

    public boolean shouldProcessNextFrame() {
        if (!this.isPlaying) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastFrameTime > 3000L) {
            return false;
        }
        if (this.queuedFrames >= this.targetFrameRate) {
            this.targetFrameCompleteTime = 0L;
            this.lastProcessTime = currentTime;
            return true;
        }
        if (this.targetFrameCompleteTime == 0L) {
            float normalFrameIntervalMs = 1000.0f / (float)this.targetFrameRate;
            float maxWaitTimeMs = 6000.0f / (float)this.targetFrameRate;
            float waitRatio = 1.0f - (float)this.queuedFrames / (float)this.targetFrameRate;
            long additionalWaitTimeMs = Math.round(waitRatio * maxWaitTimeMs);
            additionalWaitTimeMs = Math.min(additionalWaitTimeMs, 300L);
            this.targetFrameCompleteTime = this.lastProcessTime + (long)normalFrameIntervalMs + additionalWaitTimeMs;
            if (currentTime >= this.targetFrameCompleteTime) {
                this.lastProcessTime = currentTime;
                this.targetFrameCompleteTime = 0L;
                return true;
            }
            return false;
        }
        if (currentTime >= this.targetFrameCompleteTime) {
            this.lastProcessTime = currentTime;
            this.targetFrameCompleteTime = 0L;
            return true;
        }
        return false;
    }

    public int getQueuedFrames() {
        return this.queuedFrames;
    }

    public void reset() {
        this.queuedFrames = 0;
        this.isPlaying = false;
        this.lastFrameTime = System.currentTimeMillis();
        this.lastProcessTime = System.currentTimeMillis();
        this.targetFrameCompleteTime = 0L;
        Log.d((String)TAG, (String)"\u5e27\u7387\u63a7\u5236\u5668\u5df2\u91cd\u7f6e");
    }

    public static void testWaitTimeAccumulation(int[] testFrameRates) {
        Log.d((String)TAG, (String)"\u5f00\u59cb\u6d4b\u8bd530\u5e27\u548c60\u5e27\u4e0b\u7684\u7d2f\u79ef\u7b49\u5f85\u65f6\u95f4...");
        for (int frameRate : testFrameRates) {
            float maxWaitTimeMs = 6000.0f / (float)frameRate;
            float totalWaitTimeMs = 0.0f;
            int[] keyPoints = new int[]{0, frameRate / 4, frameRate / 2, frameRate * 3 / 4, frameRate - 1};
            for (int queueSize = 0; queueSize < frameRate; ++queueSize) {
                float waitRatio = 1.0f - (float)queueSize / (float)frameRate;
                float additionalWaitTimeMs = waitRatio * maxWaitTimeMs;
                additionalWaitTimeMs = Math.min(additionalWaitTimeMs, 300.0f);
                totalWaitTimeMs += additionalWaitTimeMs;
                boolean isKeyPoint = false;
                for (int point : keyPoints) {
                    if (queueSize != point) continue;
                    isKeyPoint = true;
                    break;
                }
                if (!isKeyPoint) continue;
                Log.d((String)TAG, (String)String.format("\u5e27\u7387=%d, \u961f\u5217=%d, \u7b49\u5f85\u65f6\u95f4=%.2fms", frameRate, queueSize, Float.valueOf(additionalWaitTimeMs)));
            }
            Log.d((String)TAG, (String)String.format("\u5e27\u7387=%d, \u7d2f\u79ef\u7b49\u5f85\u65f6\u95f4=%.2fms (\u76ee\u6807=3000ms), \u8bef\u5dee=%.2f%%", frameRate, Float.valueOf(totalWaitTimeMs), Float.valueOf((totalWaitTimeMs - 3000.0f) / 30.0f)));
        }
    }

    public float calculateAdditionalWaitTime() {
        if (this.queuedFrames >= this.targetFrameRate) {
            return 0.0f;
        }
        float maxWaitTimeMs = 6000.0f / (float)this.targetFrameRate;
        float waitRatio = 1.0f - (float)this.queuedFrames / (float)this.targetFrameRate;
        float additionalWaitTime = waitRatio * maxWaitTimeMs;
        return Math.min(additionalWaitTime, 300.0f);
    }

    public void startSimpleTest() {
        new Thread(() -> {
            int[] testFrameRates;
            Log.d((String)TAG, (String)"\u5f00\u59cb\u7b80\u5355\u6d4b\u8bd5...");
            for (int frameRate : testFrameRates = new int[]{30, 60}) {
                this.testFrameRate(frameRate);
            }
            Log.d((String)TAG, (String)"\u7b80\u5355\u6d4b\u8bd5\u5b8c\u6210");
        }).start();
    }

    private void testFrameRate(int frameRate) {
        Log.d((String)TAG, (String)("\u6d4b\u8bd5\u5e27\u7387: " + frameRate));
        this.reset();
        this.setTargetFrameRate(frameRate, frameRate);
        float maxWaitTimeMs = 6000.0f / (float)frameRate;
        float totalWaitTimeMs = 0.0f;
        for (int queueSize = 0; queueSize < frameRate; ++queueSize) {
            float waitRatio = 1.0f - (float)queueSize / (float)frameRate;
            float additionalWaitTimeMs = waitRatio * maxWaitTimeMs;
            additionalWaitTimeMs = Math.min(additionalWaitTimeMs, 300.0f);
            totalWaitTimeMs += additionalWaitTimeMs;
        }
        Log.d((String)TAG, (String)String.format("\u7406\u8bba\u8ba1\u7b97: \u5e27\u7387=%d, \u7d2f\u79ef\u7b49\u5f85\u65f6\u95f4=%.2fms (\u76ee\u6807=3000ms), \u8bef\u5dee=%.2f%%", frameRate, Float.valueOf(totalWaitTimeMs), Float.valueOf((totalWaitTimeMs - 3000.0f) / 30.0f)));
        this.reset();
        this.setTargetFrameRate(frameRate, frameRate);
        for (int i = 0; i < frameRate; ++i) {
            this.onFrameReceived();
        }
        long startTime = System.currentTimeMillis();
        int callCount = 0;
        int frameProcessed = 0;
        while (this.getQueuedFrames() > 0) {
            ++callCount;
            if (this.shouldProcessNextFrame()) {
                this.onFrameConsumed();
                ++frameProcessed;
                this.lastFrameTime = System.currentTimeMillis();
                if (this.getQueuedFrames() < 5) {
                    Log.d((String)TAG, (String)String.format("\u5904\u7406\u5e27\uff1a\u961f\u5217=%d/%d, \u5df2\u5904\u7406=%d/%d", this.getQueuedFrames(), this.targetFrameRate, frameProcessed, frameRate));
                } else if (frameProcessed % 5 == 0) {
                    Log.d((String)TAG, (String)String.format("\u5904\u7406\u5e27\uff1a\u961f\u5217=%d/%d, \u5df2\u5904\u7406=%d/%d", this.getQueuedFrames(), this.targetFrameRate, frameProcessed, frameRate));
                }
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (System.currentTimeMillis() - startTime <= 5000L) continue;
            Log.e((String)TAG, (String)("\u6d4b\u8bd5\u8d85\u65f6\uff01\u5df2\u5904\u7406" + frameProcessed + "\u5e27\uff0c\u5269\u4f59" + this.getQueuedFrames() + "\u5e27"));
            break;
        }
        long endTime = System.currentTimeMillis();
        long actualTimeMs = endTime - startTime;
        Log.d((String)TAG, (String)String.format("\u5b9e\u9645\u6a21\u62df: \u5e27\u7387=%d, \u603b\u7528\u65f6=%dms, \u7406\u8bba\u76ee\u6807=3000ms, \u8bef\u5dee=%.2f%%, \u603b\u8c03\u7528\u6b21\u6570=%d", frameRate, actualTimeMs, Float.valueOf((float)(actualTimeMs - 3000L) / 30.0f), callCount));
        Log.d((String)TAG, (String)String.format("\u6700\u7ec8\u72b6\u6001: \u5df2\u5904\u7406%d\u5e27, \u5269\u4f59\u961f\u5217=%d", frameProcessed, this.getQueuedFrames()));
    }
}

