/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.plugins.example;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.util.Log;
import android.view.Surface;
import com.mycompany.plugins.example.CalculateTargetFps;
import com.mycompany.plugins.example.FrameRateController;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingQueue;

public class H264Decoder {
    private static final String TAG = "H264Decoder";
    private MediaCodec mDecoder;
    private MediaFormat mFormat;
    private Surface mSurface;
    private int mVideoWidth = 1920;
    private int mVideoHeight = 1080;
    private int mFps = 30;
    private boolean mIsDecoderConfigured = false;
    private int buf_queue_num = 360;
    private final LinkedBlockingQueue<byte[]> mDataQueue = new LinkedBlockingQueue(this.buf_queue_num);
    private volatile boolean mIsRunning = false;
    private boolean mIsAsync = false;
    private FrameRateController mFrameRateController;
    private CalculateTargetFps mFpsCalculator;
    private long mLastStatTime = 0L;
    private int mFrameCount = 0;
    private float mCurrentFps = 0.0f;
    private long mLastFrameTimestamp = 0L;
    private long mFrameIntervalThreshold = 300L;
    private long mTotalFramesReceived = 0L;
    private long mTotalFramesDropped = 0L;
    private long mLastQueueLogTime = 0L;
    private long mLastInputLogTime = 0L;
    private long mLastOutputLogTime = 0L;
    private DecoderCallback mCallback;
    private final int[] mStatusCount = new int[4];
    private long mLastResetTime = 0L;
    private int mConsecutiveTryAgain = 0;

    public H264Decoder(Surface surface) {
        this.mSurface = surface;
        this.init();
    }

    private void init() {
        this.mLastStatTime = System.currentTimeMillis();
        this.mFrameCount = 0;
        this.mCurrentFps = 0.0f;
        this.mLastFrameTimestamp = 0L;
        this.mTotalFramesReceived = 0L;
        this.mTotalFramesDropped = 0L;
        this.mLastQueueLogTime = 0L;
        this.mFrameRateController = new FrameRateController();
        this.mFrameRateController.setTargetFrameRate(this.mFps, this.mFps);
        this.mFpsCalculator = new CalculateTargetFps(this.mFps);
        Log.i((String)TAG, (String)"H264Decoder\u521d\u59cb\u5316\u5b8c\u6210");
    }

    public void reset() {
        if (this.mFrameRateController != null) {
            this.mFrameRateController.reset();
        }
        if (this.mFpsCalculator != null) {
            this.mFpsCalculator.reset();
        }
        this.mLastStatTime = System.currentTimeMillis();
        this.mFrameCount = 0;
        this.mCurrentFps = 0.0f;
        this.mLastFrameTimestamp = 0L;
        this.mTotalFramesReceived = 0L;
        this.mTotalFramesDropped = 0L;
        this.mLastQueueLogTime = 0L;
        Log.i((String)TAG, (String)"H264Decoder\u5df2\u91cd\u7f6e");
    }

    public void setCallback(DecoderCallback callback) {
    }

    public void setVideoSize(int width, int height, int fps) {
        if (width <= 0 || height <= 0) {
            Log.e((String)TAG, (String)("\u65e0\u6548\u7684\u89c6\u9891\u5c3a\u5bf8: " + width + "x" + height));
            return;
        }
        Log.i((String)TAG, (String)("\u8bbe\u7f6e\u89c6\u9891\u5c3a\u5bf8: " + width + "x" + height + ",fps:" + fps));
        this.mVideoWidth = width;
        this.mVideoHeight = height;
        this.mFps = fps;
        if (this.mFpsCalculator != null) {
            this.mFpsCalculator.setDefaultFps(fps);
        }
        if (this.mIsDecoderConfigured) {
            this.releaseDecoder();
            this.initDecoder();
        }
    }

    public void setFrameIntervalThreshold(long threshold) {
        this.mFrameIntervalThreshold = threshold;
    }

    public void queueH264Data(byte[] data) {
        long now;
        if (data == null || data.length == 0) {
            return;
        }
        ++this.mTotalFramesReceived;
        if (this.mFrameRateController != null) {
            this.mFrameRateController.onFrameReceived();
        }
        if (this.mFpsCalculator != null) {
            this.mFpsCalculator.onNewFrame(-1L);
        }
        if (this.mDataQueue.size() >= this.buf_queue_num) {
            this.mDataQueue.poll();
            ++this.mTotalFramesDropped;
            if (this.mTotalFramesDropped % 10L == 0L) {
                Log.w((String)TAG, (String)String.format("\u89e3\u7801\u961f\u5217\u6ea2\u51fa: \u5df2\u4e22\u5f03 %d \u5e27\uff0c\u603b\u63a5\u6536 %d \u5e27\uff0c\u4e22\u5e27\u7387 %.2f%%", this.mTotalFramesDropped, this.mTotalFramesReceived, Float.valueOf((float)this.mTotalFramesDropped * 100.0f / (float)this.mTotalFramesReceived)));
            }
        }
        if ((now = System.currentTimeMillis()) - this.mLastQueueLogTime > 5000L) {
            this.mLastQueueLogTime = now;
        }
        byte[] copy = new byte[data.length];
        System.arraycopy(data, 0, copy, 0, data.length);
        try {
            this.mDataQueue.offer(copy);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"\u6dfb\u52a0\u6570\u636e\u5230\u961f\u5217\u5931\u8d25", (Throwable)e);
        }
    }

    public void start() {
        if (this.mSurface == null) {
            Log.e((String)TAG, (String)"Surface\u672a\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u542f\u52a8\u89e3\u7801\u5668");
            return;
        }
        this.initDecoder();
    }

    public void stop() {
        this.stopDecoder();
        this.releaseDecoder();
        this.reset();
    }

    public float getCurrentFps() {
        return this.mCurrentFps;
    }

    public float getCurrentDynamicFps() {
        if (this.mFpsCalculator != null) {
            return this.mFpsCalculator.getTargetFps();
        }
        return this.mFps;
    }

    private void initDecoder() {
        try {
            Log.i((String)TAG, (String)("\u5f00\u59cb\u521d\u59cb\u5316H.264\u89e3\u7801\u5668, \u76ee\u6807\u5206\u8fa8\u7387: " + this.mVideoWidth + "x" + this.mVideoHeight));
            this.mDecoder = MediaCodec.createDecoderByType((String)"video/avc");
            this.mFormat = MediaFormat.createVideoFormat((String)"video/avc", (int)this.mVideoWidth, (int)this.mVideoHeight);
            this.mFormat.setInteger("max-input-size", 0x100000);
            this.mFormat.setInteger("priority", 0);
            try {
                this.mFormat.setInteger("operating-rate", Short.MAX_VALUE);
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)("\u4e0d\u652f\u6301\u8bbe\u7f6e\u6700\u5927\u5904\u7406\u901f\u7387: " + e.getMessage()));
            }
            long startTime = System.currentTimeMillis();
            if (this.mIsAsync) {
                this.configureAsyncDecoder();
            }
            long endTime = System.currentTimeMillis();
            Log.i((String)TAG, (String)("\u89e3\u7801\u5668\u521d\u59cb\u5316\u6210\u529f\uff0c\u8017\u65f6: " + (endTime - startTime) + " ms, \u5206\u8fa8\u7387: " + this.mVideoWidth + "x" + this.mVideoHeight + ", \u6a21\u5f0f: " + (this.mIsAsync ? "\u5f02\u6b65" : "\u540c\u6b65")));
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"\u521d\u59cb\u5316\u89e3\u7801\u5668\u5931\u8d25", (Throwable)e);
        }
    }

    private void configureAsyncDecoder() {
        try {
            if (this.mSurface == null) {
                Log.e((String)TAG, (String)"Surface\u4e3anull\uff0c\u65e0\u6cd5\u914d\u7f6e\u89e3\u7801\u5668");
                return;
            }
            if (!this.mSurface.isValid()) {
                Log.e((String)TAG, (String)"Surface\u65e0\u6548\uff0c\u65e0\u6cd5\u914d\u7f6e\u89e3\u7801\u5668");
                return;
            }
            if (this.mIsDecoderConfigured) {
                Log.w((String)TAG, (String)"\u89e3\u7801\u5668\u5df2\u7ecf\u914d\u7f6e\uff0c\u5148\u91ca\u653e\u518d\u91cd\u65b0\u914d\u7f6e");
                this.releaseDecoder();
                this.initDecoder();
                return;
            }
            Log.d((String)TAG, (String)("\u5f00\u59cb\u914d\u7f6e\u5f02\u6b65\u89e3\u7801\u5668\uff0cSurface: " + this.mSurface + ", \u6709\u6548: " + this.mSurface.isValid()));
            final long[] lastOutputTime = new long[]{0L};
            final int[] consecutiveDelays = new int[]{0};
            final int[] outputBufferCount = new int[]{0};
            final int[] inputBufferCount = new int[]{0};
            final int[] tryAgainCount = new int[]{0};
            final long[] lastInputCallTime = new long[]{0L};
            this.mDecoder.setCallback(new MediaCodec.Callback(){

                public void onInputBufferAvailable(MediaCodec codec, int index) {
                    long diff;
                    try {
                        long startTime = System.currentTimeMillis();
                        long currentTime = System.currentTimeMillis();
                        long interval = currentTime - lastInputCallTime[0];
                        lastInputCallTime[0] = currentTime;
                        ByteBuffer inputBuffer = codec.getInputBuffer(index);
                        if (inputBuffer == null) {
                            Log.e((String)H264Decoder.TAG, (String)("\u83b7\u53d6\u8f93\u5165\u7f13\u51b2\u533a\u5931\u8d25\uff0c\u7d22\u5f15: " + index));
                            return;
                        }
                        if (H264Decoder.this.mFrameRateController != null && !H264Decoder.this.mFrameRateController.shouldProcessNextFrame()) {
                            try {
                                codec.queueInputBuffer(index, 0, 0, 0L, 0);
                                Thread.sleep(2L);
                            }
                            catch (IllegalStateException e) {
                                Log.e((String)H264Decoder.TAG, (String)"\u63d0\u4ea4\u7a7a\u7f13\u51b2\u533a\u5931\u8d25\uff0c\u89e3\u7801\u5668\u53ef\u80fd\u5904\u4e8e\u65e0\u6548\u72b6\u6001", (Throwable)e);
                            }
                            return;
                        }
                        byte[] data = H264Decoder.this.mDataQueue.poll();
                        if (data != null) {
                            long frameInterval;
                            long currentTimestamp = System.currentTimeMillis();
                            H264Decoder.this.mLastInputLogTime = startTime;
                            if (H264Decoder.this.mLastFrameTimestamp > 0L && (frameInterval = currentTimestamp - H264Decoder.this.mLastFrameTimestamp) > H264Decoder.this.mFrameIntervalThreshold) {
                                Log.i((String)H264Decoder.TAG, (String)("\u89e3\u7801\u5e27\u95f4\u9694\u8fc7\u5927: " + frameInterval + " ms\uff0c\u5f53\u524d\u65f6\u95f4\u6233: " + currentTimestamp));
                            }
                            H264Decoder.this.mLastFrameTimestamp = currentTimestamp;
                            inputBuffer.clear();
                            inputBuffer.put(data);
                            long presentationTimeUs = System.nanoTime() / 1000L;
                            try {
                                codec.queueInputBuffer(index, 0, data.length, presentationTimeUs, 0);
                                inputBufferCount[0] = inputBufferCount[0] + 1;
                                if (H264Decoder.this.mFrameRateController != null) {
                                    H264Decoder.this.mFrameRateController.onFrameConsumed();
                                }
                                tryAgainCount[0] = 0;
                            }
                            catch (IllegalStateException e) {
                                Log.e((String)H264Decoder.TAG, (String)"\u63d0\u4ea4\u8f93\u5165\u7f13\u51b2\u533a\u5931\u8d25\uff0c\u89e3\u7801\u5668\u53ef\u80fd\u5904\u4e8e\u65e0\u6548\u72b6\u6001", (Throwable)e);
                                H264Decoder.this.releaseDecoder();
                                H264Decoder.this.initDecoder();
                            }
                        } else {
                            try {
                                codec.queueInputBuffer(index, 0, 0, 0L, 0);
                                Thread.sleep(33L);
                            }
                            catch (IllegalStateException e) {
                                Log.e((String)H264Decoder.TAG, (String)"\u63d0\u4ea4\u7a7a\u7f13\u51b2\u533a\u5931\u8d25\uff0c\u89e3\u7801\u5668\u53ef\u80fd\u5904\u4e8e\u65e0\u6548\u72b6\u6001", (Throwable)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)H264Decoder.TAG, (String)("\u5904\u7406\u8f93\u5165\u7f13\u51b2\u533a\u5931\u8d25: " + e.getMessage()), (Throwable)e);
                    }
                    if (H264Decoder.this.mFpsCalculator != null && (diff = System.currentTimeMillis() - H264Decoder.this.mFpsCalculator.getLastFrameTs()) > 500L) {
                        H264Decoder.this.mFpsCalculator.onNewFrame(diff);
                    }
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void onOutputBufferAvailable(MediaCodec codec, int index, MediaCodec.BufferInfo info) {
                    try {
                        long delay;
                        long startTime;
                        H264Decoder.this.mLastOutputLogTime = startTime = System.currentTimeMillis();
                        if (H264Decoder.this.mSurface == null || !H264Decoder.this.mSurface.isValid()) {
                            Log.e((String)H264Decoder.TAG, (String)"Surface\u65e0\u6548\uff0c\u65e0\u6cd5\u6e32\u67d3\u8f93\u51fa\u7f13\u51b2\u533a");
                            try {
                                codec.releaseOutputBuffer(index, false);
                                return;
                            }
                            catch (IllegalStateException e) {
                                Log.e((String)H264Decoder.TAG, (String)"\u91ca\u653e\u8f93\u51fa\u7f13\u51b2\u533a\u5931\u8d25\uff0c\u89e3\u7801\u5668\u53ef\u80fd\u5904\u4e8e\u65e0\u6548\u72b6\u6001", (Throwable)e);
                            }
                            return;
                        }
                        if (H264Decoder.this.mDataQueue.size() <= 0) {
                            Log.e((String)H264Decoder.TAG, (String)String.format("onOutputBufferAvailable mDataQueue: 0", H264Decoder.this.mDataQueue.size()));
                        }
                        outputBufferCount[0] = outputBufferCount[0] + 1;
                        long now = System.currentTimeMillis();
                        if (lastOutputTime[0] > 0L && (delay = now - lastOutputTime[0]) > H264Decoder.this.mFrameIntervalThreshold) {
                            Log.w((String)H264Decoder.TAG, (String)String.format("\u5f02\u6b65\u8f93\u51fa\u7f13\u51b2\u533a\u5ef6\u8fdf: %d ms, \u7d22\u5f15: %d, \u5927\u5c0f: %d \u5b57\u8282,mDataQueue:%d", delay, index, info.size, H264Decoder.this.mDataQueue.size()));
                        }
                        lastOutputTime[0] = now;
                        consecutiveDelays[0] = 0;
                        tryAgainCount[0] = 0;
                        if ((info.flags & 4) != 0) {
                            Log.i((String)H264Decoder.TAG, (String)"\u63a5\u6536\u5230\u6d41\u7ed3\u675f\u6807\u5fd7");
                            codec.releaseOutputBuffer(index, false);
                            return;
                        }
                        if (info.size == 0) {
                            Log.d((String)H264Decoder.TAG, (String)"\u63a5\u6536\u5230\u7a7a\u8f93\u51fa\u7f13\u51b2\u533a\uff0c\u4e0d\u6e32\u67d3");
                            codec.releaseOutputBuffer(index, false);
                            return;
                        }
                        try {
                            codec.releaseOutputBuffer(index, true);
                            H264Decoder.this.updateFrameStats();
                            if (inputBufferCount[0] - outputBufferCount[0] <= 30) return;
                            return;
                        }
                        catch (IllegalStateException e) {
                            Log.e((String)H264Decoder.TAG, (String)"\u6e32\u67d3\u8f93\u51fa\u7f13\u51b2\u533a\u5931\u8d25\uff0c\u89e3\u7801\u5668\u53ef\u80fd\u5904\u4e8e\u65e0\u6548\u72b6\u6001", (Throwable)e);
                            try {
                                codec.releaseOutputBuffer(index, false);
                                return;
                            }
                            catch (Exception ex) {
                                Log.e((String)H264Decoder.TAG, (String)"\u91ca\u653e\u8f93\u51fa\u7f13\u51b2\u533a\u4e5f\u5931\u8d25", (Throwable)ex);
                                return;
                            }
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)H264Decoder.TAG, (String)("\u5904\u7406\u8f93\u51fa\u7f13\u51b2\u533a\u5931\u8d25: " + e.getMessage()), (Throwable)e);
                    }
                }

                public void onError(MediaCodec codec, MediaCodec.CodecException e) {
                    Log.e((String)H264Decoder.TAG, (String)("\u89e3\u7801\u5668\u9519\u8bef: " + e.getDiagnosticInfo()), (Throwable)e);
                    try {
                        H264Decoder.this.releaseDecoder();
                        H264Decoder.this.initDecoder();
                    }
                    catch (Exception ex) {
                        Log.e((String)H264Decoder.TAG, (String)"\u91cd\u7f6e\u89e3\u7801\u5668\u5931\u8d25", (Throwable)ex);
                    }
                }

                public void onOutputFormatChanged(MediaCodec codec, MediaFormat format) {
                    Log.i((String)H264Decoder.TAG, (String)("\u8f93\u51fa\u683c\u5f0f\u5df2\u66f4\u6539: " + format));
                    if (H264Decoder.this.mDataQueue.size() <= 0) {
                        Log.w((String)H264Decoder.TAG, (String)String.format("onOutputFormatChanged", H264Decoder.this.mDataQueue.size()));
                    }
                    if (format.containsKey("width") && format.containsKey("height")) {
                        int width = format.getInteger("width");
                        int height = format.getInteger("height");
                        if (width != H264Decoder.this.mVideoWidth || height != H264Decoder.this.mVideoHeight) {
                            H264Decoder.this.mVideoWidth = width;
                            H264Decoder.this.mVideoHeight = height;
                            if (H264Decoder.this.mCallback != null) {
                                H264Decoder.this.mCallback.onVideoSizeChanged(width, height);
                            }
                            Log.i((String)H264Decoder.TAG, (String)("\u66f4\u65b0\u89c6\u9891\u5c3a\u5bf8: " + width + "x" + height));
                        }
                    }
                    if (format.containsKey("frame-rate")) {
                        float frameRate = format.getInteger("frame-rate");
                        Log.i((String)H264Decoder.TAG, (String)("\u89e3\u7801\u5668\u62a5\u544a\u7684\u5e27\u7387: " + frameRate));
                    }
                    if (format.containsKey("bitrate")) {
                        int bitRate = format.getInteger("bitrate");
                        Log.i((String)H264Decoder.TAG, (String)("\u89e3\u7801\u5668\u62a5\u544a\u7684\u7801\u7387: " + bitRate));
                    }
                }
            });
            try {
                this.mFormat.setInteger("max-input-size", 0x400000);
                if (!this.mSurface.isValid()) {
                    Log.e((String)TAG, (String)"\u914d\u7f6e\u89e3\u7801\u5668\u524dSurface\u5df2\u53d8\u4e3a\u65e0\u6548");
                    return;
                }
                this.mDecoder.configure(this.mFormat, this.mSurface, null, 0);
                this.mDecoder.start();
                this.mIsDecoderConfigured = true;
                this.startMonitorThread();
                Log.i((String)TAG, (String)"\u5f02\u6b65\u89e3\u7801\u5668\u914d\u7f6e\u6210\u529f\uff0c\u4f18\u5316\u4e864K\u89c6\u9891\u5904\u7406\u53c2\u6570");
            }
            catch (IllegalArgumentException e) {
                Log.e((String)TAG, (String)("\u914d\u7f6e\u5f02\u6b65\u89e3\u7801\u5668\u5931\u8d25: " + e.getMessage() + ", \u5c1d\u8bd5\u4f7f\u7528\u540c\u6b65\u6a21\u5f0f"), (Throwable)e);
                this.mIsAsync = false;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("\u914d\u7f6e\u5f02\u6b65\u89e3\u7801\u5668\u5931\u8d25: " + e.getMessage()), (Throwable)e);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("\u914d\u7f6e\u5f02\u6b65\u89e3\u7801\u5668\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38: " + e.getMessage()), (Throwable)e);
        }
    }

    private void optimizeDecoderForHighResolution() {
        try {
            try {
                this.mFormat.setInteger("vendor.qti-ext-dec-low-latency.enable", 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.mFormat.setInteger("priority", 0);
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)("\u4e0d\u652f\u6301\u8bbe\u7f6e\u89e3\u7801\u5668\u4f18\u5148\u7ea7: " + e.getMessage()));
            }
            try {
                this.mFormat.setInteger("operating-rate", 120);
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)("\u4e0d\u652f\u6301\u8bbe\u7f6e\u64cd\u4f5c\u901f\u7387: " + e.getMessage()));
            }
            try {
                this.mFormat.setInteger("latency", 0);
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)("\u4e0d\u652f\u6301\u8bbe\u7f6e\u5ef6\u8fdf\u6a21\u5f0f: " + e.getMessage()));
            }
            Log.i((String)TAG, (String)"\u5df2\u5e94\u7528\u9ad8\u5206\u8fa8\u7387\u89c6\u9891\u89e3\u7801\u4f18\u5316\u53c2\u6570");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("\u5e94\u7528\u89e3\u7801\u5668\u4f18\u5316\u53c2\u6570\u5931\u8d25: " + e.getMessage()));
        }
    }

    private void stopDecoder() {
        this.mIsRunning = false;
        this.mDataQueue.clear();
    }

    private void releaseDecoder() {
        this.stopDecoder();
        if (this.mDecoder != null) {
            try {
                MediaCodec decoder = this.mDecoder;
                this.mDecoder = null;
                try {
                    decoder.stop();
                }
                catch (IllegalStateException e) {
                    Log.w((String)TAG, (String)("\u505c\u6b62\u89e3\u7801\u5668\u5931\u8d25\uff0c\u53ef\u80fd\u5df2\u7ecf\u505c\u6b62: " + e.getMessage()));
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("\u505c\u6b62\u89e3\u7801\u5668\u65f6\u53d1\u751f\u5f02\u5e38: " + e.getMessage()));
                }
                try {
                    decoder.release();
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("\u91ca\u653e\u89e3\u7801\u5668\u8d44\u6e90\u65f6\u53d1\u751f\u5f02\u5e38: " + e.getMessage()));
                }
                Log.i((String)TAG, (String)"\u89e3\u7801\u5668\u5df2\u91ca\u653e");
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"\u91ca\u653e\u89e3\u7801\u5668\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
            finally {
                this.mDecoder = null;
                this.mIsDecoderConfigured = false;
            }
        } else {
            this.mIsDecoderConfigured = false;
            Log.i((String)TAG, (String)"\u89e3\u7801\u5668\u5df2\u4e3anull\uff0c\u65e0\u9700\u91ca\u653e");
        }
    }

    private void updateFrameStats() {
        ++this.mFrameCount;
        long now = System.currentTimeMillis();
        long diff = now - this.mLastStatTime;
        if (diff >= 1000L) {
            float previousFps = this.mCurrentFps;
            this.mCurrentFps = (float)this.mFrameCount * 1000.0f / (float)diff;
            Log.d((String)TAG, (String)String.format("\u5e27\u7387\u7edf\u8ba1: \u5f53\u524d\u5e27\u7387: %.2f fps (\u4e0a\u4e00\u6b21: %.2f fps), \u7d2f\u8ba1\u5e27\u6570: %d, \u95f4\u9694: %d ms,mIsAsync:%b", Float.valueOf(this.mCurrentFps), Float.valueOf(previousFps), this.mFrameCount, diff, this.mIsAsync));
            if (this.mCurrentFps < 15.0f && this.mFrameCount > 5) {
                Log.w((String)TAG, (String)String.format("\u5e27\u7387\u5f02\u5e38\u4f4e: %.2f fps\uff0c\u53ef\u80fd\u5b58\u5728\u6027\u80fd\u95ee\u9898", Float.valueOf(this.mCurrentFps)));
            }
            if (this.mCallback != null) {
                this.mCallback.onFrameRateUpdate(this.mCurrentFps);
            }
            this.updateDynamicFrameRate();
            this.mFrameCount = 0;
            this.mLastStatTime = now;
        }
    }

    private void updateDynamicFrameRate() {
        if (this.mFpsCalculator != null && this.mFrameRateController != null) {
            int targetFps = this.mFpsCalculator.getTargetFps();
            this.mFrameRateController.setDynamicTargetFrameRate(targetFps);
            long maxInterval = this.mFpsCalculator.getCurrentMaxInterval();
            int queueSize = this.mFpsCalculator.getQueueSize();
            if (targetFps != this.mFps) {
                Log.d((String)TAG, (String)String.format("\u52a8\u6001\u5e27\u7387\u66f4\u65b0: %d/%d fps (\u9ed8\u8ba4: %d fps), \u6700\u5927\u95f4\u9694: %d ms, \u961f\u5217\u5927\u5c0f: %d", this.mDataQueue.size(), targetFps, this.mFps, maxInterval, queueSize));
            }
        }
    }

    private String getOutputBufferStatusString(int status) {
        switch (status) {
            case -1: {
                return "\u9700\u8981\u91cd\u8bd5 (INFO_TRY_AGAIN_LATER)";
            }
            case -2: {
                return "\u8f93\u51fa\u683c\u5f0f\u53d8\u5316 (INFO_OUTPUT_FORMAT_CHANGED)";
            }
            case -3: {
                return "\u8f93\u51fa\u7f13\u51b2\u533a\u53d8\u5316 (INFO_OUTPUT_BUFFERS_CHANGED)";
            }
        }
        if (status >= 0) {
            return "\u6709\u6548\u7f13\u51b2\u533a\u7d22\u5f15: " + status;
        }
        return "\u672a\u77e5\u72b6\u6001: " + status;
    }

    public void setAsyncMode(boolean async) {
        if (this.mIsAsync == async) {
            return;
        }
        if (this.mIsDecoderConfigured) {
            this.releaseDecoder();
        }
        this.mIsAsync = async;
        Log.i((String)TAG, (String)("\u8bbe\u7f6e\u89e3\u7801\u6a21\u5f0f: " + (async ? "\u5f02\u6b65" : "\u540c\u6b65")));
    }

    private void startMonitorThread() {
        Thread monitorThread = new Thread(() -> {
            Log.i((String)TAG, (String)"\u89e3\u7801\u5668\u76d1\u63a7\u7ebf\u7a0b\u542f\u52a8");
            long lastLogTime = 0L;
            boolean tryAgainCount = false;
            boolean totalFrames = false;
            boolean consecutiveTryAgainCount = false;
            long lastTryAgainTime = 0L;
            while (this.mIsDecoderConfigured && this.mIsAsync) {
                try {
                    long delay;
                    Thread.sleep(100L);
                    long now = System.currentTimeMillis();
                    if (now - lastLogTime > 5000L) {
                        lastLogTime = now;
                        tryAgainCount = false;
                    }
                    if ((delay = now - this.mLastInputLogTime) > this.mFrameIntervalThreshold) {
                        Log.w((String)TAG, (String)String.format("\u7ebf\u7a0b\u5f02\u6b65\u8f93\u5165\u7f13\u51b2\u533a\u5ef6\u8fdf: %d ms,mDataQueue:%d", delay, this.mDataQueue.size()));
                    }
                    if ((delay = now - this.mLastOutputLogTime) <= this.mFrameIntervalThreshold) continue;
                    Log.w((String)TAG, (String)String.format("\u7ebf\u7a0b\u5f02\u6b65\u8f93\u51fa\u7f13\u51b2\u533a\u5ef6\u8fdf: %d ms,mDataQueue:%d", delay, this.mDataQueue.size()));
                }
                catch (InterruptedException e) {
                    Log.w((String)TAG, (String)"\u89e3\u7801\u5668\u76d1\u63a7\u7ebf\u7a0b\u88ab\u4e2d\u65ad");
                    break;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("\u89e3\u7801\u5668\u76d1\u63a7\u7ebf\u7a0b\u5f02\u5e38: " + e.getMessage()));
                }
            }
            Log.i((String)TAG, (String)"\u89e3\u7801\u5668\u76d1\u63a7\u7ebf\u7a0b\u7ed3\u675f");
        });
        monitorThread.setDaemon(true);
        monitorThread.start();
    }

    private boolean handleDecoderOutputStatus(int status) {
        if (status >= 0) {
            this.mStatusCount[0] = this.mStatusCount[0] + 1;
            this.mConsecutiveTryAgain = 0;
            return false;
        }
        if (status == -1) {
            long now;
            this.mStatusCount[1] = this.mStatusCount[1] + 1;
            ++this.mConsecutiveTryAgain;
            if (this.mConsecutiveTryAgain > 20 && (now = System.currentTimeMillis()) - this.mLastResetTime > 10000L) {
                Log.w((String)TAG, (String)String.format("\u8fde\u7eed%d\u6b21\u83b7\u53d6\u4e0d\u5230\u8f93\u51fa\u7f13\u51b2\u533a\uff0c\u8003\u8651\u91cd\u7f6e\u89e3\u7801\u5668", this.mConsecutiveTryAgain));
                this.mLastResetTime = now;
                return true;
            }
            if (this.mConsecutiveTryAgain > 5) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return false;
        }
        if (status == -2) {
            this.mStatusCount[2] = this.mStatusCount[2] + 1;
            this.mConsecutiveTryAgain = 0;
            return false;
        }
        if (status == -3) {
            this.mStatusCount[3] = this.mStatusCount[3] + 1;
            this.mConsecutiveTryAgain = 0;
            return false;
        }
        return false;
    }

    public static interface DecoderCallback {
        public void onFrameRateUpdate(float var1);

        public void onVideoSizeChanged(int var1, int var2);
    }
}

