/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.plugins.example;

import android.app.Activity;
import android.content.Context;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.mycompany.plugins.example.H264Decoder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class rtsp_view {
    private static final String TAG = "RtspView";
    private FrameLayout overlayContainer;
    private OverlaySurfaceView overlaySurfaceView;
    private Handler mainHandler;
    private boolean isOverlayShowing = false;
    private int currentColorIndex = 0;
    private String[] colorNames = new String[]{"\u7ea2\u8272", "\u7eff\u8272", "\u84dd\u8272", "\u9ec4\u8272", "\u54c1\u7ea2", "\u9752\u8272"};
    private int[] colors = new int[]{-65536, -16711936, -16776961, -256, -65281, -16711681};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeBinaryChunkByJava(String url, byte[] data, int length, boolean replace, boolean append) {
        boolean dirCreated;
        Log.i((String)TAG, (String)("\u5f00\u59cb\u5199\u5165\u4e8c\u8fdb\u5236\u6570\u636e\u5757\u5230: " + url + ", \u6570\u636e\u957f\u5ea6: " + length + ", \u662f\u5426\u8986\u76d6: " + replace + ", \u662f\u5426\u8ffd\u52a0: " + append));
        if (url == null || url.isEmpty() || data == null || length <= 0) {
            Log.e((String)TAG, (String)("\u53c2\u6570\u65e0\u6548: url=" + url + ", data=" + (data == null ? "null" : "not null") + ", length=" + length));
            return 0;
        }
        int dataLength = Math.min(length, data.length);
        File file = new File(url);
        File parentDir = file.getParentFile();
        if (parentDir != null && !parentDir.exists() && !(dirCreated = parentDir.mkdirs())) {
            Log.e((String)TAG, (String)("\u521b\u5efa\u76ee\u5f55\u5931\u8d25: " + parentDir.getAbsolutePath()));
            return 0;
        }
        if (!append && file.exists() && !replace) {
            Log.i((String)TAG, (String)("\u6587\u4ef6\u5df2\u5b58\u5728\u4e14\u4e0d\u9700\u8981\u8986\u76d6: " + url));
            return 0;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file, append);
            fos.write(data, 0, dataLength);
            fos.flush();
            Log.i((String)TAG, (String)("\u6210\u529f\u5199\u5165\u4e8c\u8fdb\u5236\u6570\u636e\u5757\u5230: " + url + ", \u5b9e\u9645\u6570\u636e\u957f\u5ea6: " + dataLength + ", \u662f\u5426\u8ffd\u52a0\u6a21\u5f0f: " + append));
            int n = 1;
            return n;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("\u5199\u5165\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()), (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("\u5173\u95ed\u6587\u4ef6\u6d41\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeBinaryByJava(String url, byte[] data, int length, boolean replace) {
        boolean dirCreated;
        Log.i((String)TAG, (String)("\u5f00\u59cb\u5199\u5165\u4e8c\u8fdb\u5236\u6570\u636e\u5230: " + url + ", \u6570\u636e\u957f\u5ea6: " + length + ", \u662f\u5426\u8986\u76d6: " + replace));
        if (url == null || url.isEmpty() || data == null || length <= 0) {
            Log.e((String)TAG, (String)("\u53c2\u6570\u65e0\u6548: url=" + url + ", data=" + (data == null ? "null" : "not null") + ", length=" + length));
            return 0;
        }
        int dataLength = Math.min(length, data.length);
        File file = new File(url);
        File parentDir = file.getParentFile();
        if (parentDir != null && !parentDir.exists() && !(dirCreated = parentDir.mkdirs())) {
            Log.e((String)TAG, (String)("\u521b\u5efa\u76ee\u5f55\u5931\u8d25: " + parentDir.getAbsolutePath()));
            return 0;
        }
        if (file.exists() && !replace) {
            Log.i((String)TAG, (String)("\u6587\u4ef6\u5df2\u5b58\u5728\u4e14\u4e0d\u9700\u8981\u8986\u76d6: " + url));
            return 0;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(data, 0, dataLength);
            fos.flush();
            Log.i((String)TAG, (String)("\u6210\u529f\u5199\u5165\u4e8c\u8fdb\u5236\u6570\u636e\u5230: " + url + ", \u5b9e\u9645\u6570\u636e\u957f\u5ea6: " + dataLength));
            int n = 1;
            return n;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("\u5199\u5165\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()), (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("\u5173\u95ed\u6587\u4ef6\u6d41\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    public void showOverlayView(Activity activity, int x, int y, int width, int height, int videoWidth, int videoHeight, int fps) {
        if (this.isOverlayShowing) {
            return;
        }
        if (this.mainHandler == null) {
            this.mainHandler = new Handler(Looper.getMainLooper());
        }
        this.mainHandler.post(() -> {
            try {
                ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView().findViewById(0x1020002);
                ViewGroup webViewParent = this.findWebViewParent(decorView);
                if (webViewParent == null) {
                    Log.w((String)TAG, (String)"\ud83d\udd27 \u672a\u627e\u5230WebView\u7236\u5bb9\u5668\uff0c\u4f7f\u7528\u6839\u89c6\u56fe\u4f5c\u4e3a\u5907\u9009");
                    webViewParent = decorView;
                } else {
                    Log.i((String)TAG, (String)("\ud83d\udd27 RTSP\u627e\u5230WebView\u7236\u5bb9\u5668: " + webViewParent.getClass().getSimpleName()));
                }
                ViewGroup finalWebViewParent = webViewParent;
                this.overlayContainer = new FrameLayout((Context)activity);
                this.overlayContainer.setBackgroundColor(0);
                this.overlaySurfaceView = new OverlaySurfaceView((Context)activity);
                this.overlayContainer.addView((View)this.overlaySurfaceView);
                FrameLayout.LayoutParams containerParams = new FrameLayout.LayoutParams(width, height);
                containerParams.leftMargin = x;
                containerParams.topMargin = y;
                this.overlayContainer.setLayoutParams((ViewGroup.LayoutParams)containerParams);
                finalWebViewParent.addView((View)this.overlayContainer, 0);
                Log.i((String)TAG, (String)"\ud83d\udd27 RTSP\u5bb9\u5668\u5df2\u6dfb\u52a0\u5230\u6700\u5e95\u5c42\uff08index=0\uff09\uff0c\u548c\u76f8\u673a\u9884\u89c8\u5b8c\u5168\u4e00\u81f4");
                Log.i((String)TAG, (String)"\u2705 RTSP SurfaceView\u5728\u4e0b\u5c42\uff0cHTML\u5728\u4e0a\u5c42");
                this.mainHandler.post(() -> {
                    FrameLayout finalOverlayContainer = this.overlayContainer;
                    int[] location = new int[2];
                    finalOverlayContainer.getLocationOnScreen(location);
                    Log.i((String)TAG, (String)"=== \ud83d\udd27 RTSP\u5bb9\u5668\u5c42\u7ea7\u9a8c\u8bc1 ===");
                    Log.i((String)TAG, (String)String.format("\u5c4f\u5e55\u7edd\u5bf9\u4f4d\u7f6e: (%d, %d)", location[0], location[1]));
                    Log.i((String)TAG, (String)String.format("\u5bb9\u5668\u5b9e\u9645\u5c3a\u5bf8: %dx%d", finalOverlayContainer.getWidth(), finalOverlayContainer.getHeight()));
                    Log.i((String)TAG, (String)String.format("\u9884\u671f\u4f4d\u7f6e: (%d, %d)", x, y));
                    Log.i((String)TAG, (String)String.format("\u4f4d\u7f6e\u504f\u5dee: X\u8f74=%d, Y\u8f74=%d", location[0] - x, location[1] - y));
                    Log.i((String)TAG, (String)String.format("\u89c6\u9891\u53c2\u6570: %dx%d@%dfps", videoWidth, videoHeight, fps));
                    Log.i((String)TAG, (String)String.format("\u7236\u5bb9\u5668\u5b50\u89c6\u56fe\u6570\u91cf: %d", finalWebViewParent.getChildCount()));
                    Log.i((String)TAG, (String)String.format("RTSP\u5bb9\u5668\u5728\u7236\u5bb9\u5668\u4e2d\u7684\u7d22\u5f15: %d", finalWebViewParent.indexOfChild((View)finalOverlayContainer)));
                    Log.i((String)TAG, (String)"=== \ud83d\udd27 SurfaceView\u5c42\u7ea7\u8be6\u7ec6\u9a8c\u8bc1 ===");
                    if (this.overlaySurfaceView != null) {
                        Log.i((String)TAG, (String)("SurfaceView\u7c7b\u578b: " + this.overlaySurfaceView.getClass().getSimpleName()));
                        SurfaceHolder holder = this.overlaySurfaceView.getHolder();
                        Log.i((String)TAG, (String)("SurfaceHolder\u683c\u5f0f: " + holder.getSurfaceFrame()));
                        Log.i((String)TAG, (String)("\u7236\u5bb9\u5668\u7c7b\u578b: " + finalWebViewParent.getClass().getSimpleName()));
                        int childCount = finalWebViewParent.getChildCount();
                        for (int i = 0; i < childCount; ++i) {
                            View child = finalWebViewParent.getChildAt(i);
                            String childType = child.getClass().getSimpleName();
                            boolean isRtspContainer = child == finalOverlayContainer;
                            Log.i((String)TAG, (String)String.format("\u5b50\u89c6\u56fe[%d]: %s %s", i, childType, isRtspContainer ? "(RTSP\u5bb9\u5668)" : ""));
                        }
                        try {
                            Log.i((String)TAG, (String)"\u2705 SurfaceView ZOrder\u9a8c\u8bc1: \u5e94\u8be5\u5728\u4e0b\u5c42\uff0cHTML\u5728\u4e0a\u5c42");
                        }
                        catch (Exception e) {
                            Log.w((String)TAG, (String)("\u65e0\u6cd5\u9a8c\u8bc1ZOrder\u8bbe\u7f6e: " + e.getMessage()));
                        }
                    }
                    Log.i((String)TAG, (String)"=== \ud83d\udd27 RTSP\u5c42\u7ea7\u9a8c\u8bc1\u7ed3\u675f ===");
                });
                this.isOverlayShowing = true;
                Log.i((String)TAG, (String)"\u2705 RTSP\u80cc\u666f\u5c42\u663e\u793a\u5b8c\u6210\uff0c\u5c42\u7ea7\u5df2\u4fee\u590d");
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"\u663e\u793aRTSP\u80cc\u666f\u5c42\u5931\u8d25", (Throwable)e);
            }
            this.setVideoResolution(videoWidth, videoHeight, fps);
        });
    }

    private ViewGroup findWebViewParent(ViewGroup viewGroup) {
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            ViewGroup result;
            View child = viewGroup.getChildAt(i);
            if (child.getClass().getSimpleName().contains("WebView")) {
                Log.i((String)TAG, (String)("\ud83d\udd0d \u627e\u5230WebView: " + child.getClass().getSimpleName()));
                return viewGroup;
            }
            if (!(child instanceof ViewGroup) || (result = this.findWebViewParent((ViewGroup)child)) == null) continue;
            return result;
        }
        return null;
    }

    public void closeOverlayView(Activity activity) {
        if (!this.isOverlayShowing) {
            return;
        }
        if (this.mainHandler == null) {
            this.mainHandler = new Handler(Looper.getMainLooper());
        }
        this.mainHandler.post(() -> {
            try {
                if (this.overlaySurfaceView != null) {
                    this.overlaySurfaceView.stopDecoder();
                }
                if (this.overlayContainer != null && this.overlayContainer.getParent() != null) {
                    ((ViewGroup)this.overlayContainer.getParent()).removeView((View)this.overlayContainer);
                    this.overlayContainer = null;
                }
                this.overlaySurfaceView = null;
                this.isOverlayShowing = false;
                Log.i((String)TAG, (String)"\u539f\u751f\u8986\u76d6\u5c42\u5df2\u5173\u95ed");
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"\u5173\u95ed\u539f\u751f\u8986\u76d6\u5c42\u5931\u8d25", (Throwable)e);
            }
        });
    }

    public void submitH264Data(byte[] data) {
        if (this.overlaySurfaceView != null) {
            this.overlaySurfaceView.submitH264Data(data);
        } else {
            Log.e((String)TAG, (String)"\u65e0\u6cd5\u63d0\u4ea4H.264\u6570\u636e\uff0cSurfaceView\u672a\u521d\u59cb\u5316");
        }
    }

    public void setVideoResolution(int width, int height, int fps) {
        if (this.overlaySurfaceView != null) {
            this.overlaySurfaceView.setVideoSize(width, height, fps);
            Log.i((String)TAG, (String)("\u89c6\u9891\u5206\u8fa8\u7387\u5df2\u8bbe\u7f6e: " + width + "x" + height));
        } else {
            Log.e((String)TAG, (String)"\u65e0\u6cd5\u8bbe\u7f6e\u89c6\u9891\u5206\u8fa8\u7387\uff0cSurfaceView\u672a\u521d\u59cb\u5316");
        }
    }

    public float getCurrentFrameRate() {
        if (this.overlaySurfaceView != null) {
            return this.overlaySurfaceView.getCurrentFps();
        }
        return 0.0f;
    }

    public float getCurrentDynamicFrameRate() {
        if (this.overlaySurfaceView != null) {
            return this.overlaySurfaceView.getCurrentDynamicFps();
        }
        return 0.0f;
    }

    public String getBufferStatus() {
        if (this.overlaySurfaceView != null && this.overlaySurfaceView.mDecoder != null) {
            return "\u76ee\u6807\u5e27\u7387: " + this.overlaySurfaceView.getCurrentDynamicFps() + " fps, \u5b9e\u9645\u5e27\u7387: " + this.overlaySurfaceView.getCurrentFps() + " fps";
        }
        return "\u89e3\u7801\u5668\u672a\u521d\u59cb\u5316";
    }

    private class OverlaySurfaceView
    extends SurfaceView
    implements SurfaceHolder.Callback,
    H264Decoder.DecoderCallback {
        private H264Decoder mDecoder;
        private Paint mPaint;
        private Rect mDstRect;
        private int mVideoWidth;
        private int mVideoHeight;
        private int mFps;

        public OverlaySurfaceView(Context context) {
            super(context);
            this.mVideoWidth = 3840;
            this.mVideoHeight = 2160;
            this.mFps = 30;
            this.init();
        }

        private void init() {
            SurfaceHolder holder = this.getHolder();
            holder.addCallback((SurfaceHolder.Callback)this);
            this.setZOrderOnTop(false);
            this.setZOrderMediaOverlay(true);
            holder.setFormat(-1);
            Log.i((String)rtsp_view.TAG, (String)"\ud83d\udd27 RTSP SurfaceView\u4fee\u590d: setZOrderOnTop(false) + setZOrderMediaOverlay(true)");
            Log.i((String)rtsp_view.TAG, (String)"\ud83c\udfa8 RTSP\u5c42\u7ea7\u8bbe\u7f6e: Native\u5728\u4e0b\u5c42\uff0cHTML\u5728\u4e0a\u5c42\uff0c\u5141\u8bb8\u900f\u660e\u7a7f\u900f");
            this.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.mPaint = new Paint();
            this.mPaint.setAntiAlias(true);
            this.mDstRect = new Rect();
            Log.i((String)rtsp_view.TAG, (String)"\u2705 RTSP OverlaySurfaceView\u5c42\u7ea7\u4fee\u590d\u5b8c\u6210\uff0c\u4e0e\u76f8\u673a\u9884\u89c8\u5b8c\u5168\u4e00\u81f4");
        }

        public void setVideoSize(int width, int height, int fps) {
            if (width <= 0 || height <= 0) {
                Log.e((String)rtsp_view.TAG, (String)("\u65e0\u6548\u7684\u89c6\u9891\u5c3a\u5bf8: " + width + "x" + height));
                return;
            }
            Log.i((String)rtsp_view.TAG, (String)("\u8bbe\u7f6e\u89c6\u9891\u5c3a\u5bf8: " + width + "x" + height));
            this.mVideoWidth = width;
            this.mVideoHeight = height;
            this.mFps = fps;
            if (this.mDecoder != null) {
                this.mDecoder.setVideoSize(width, height, fps);
            }
            this.updateDestinationRect();
        }

        private void updateDestinationRect() {
            if (this.getWidth() == 0 || this.getHeight() == 0) {
                return;
            }
            int viewWidth = this.getWidth();
            int viewHeight = this.getHeight();
            this.mDstRect.set(0, 0, viewWidth, viewHeight);
            Log.i((String)rtsp_view.TAG, (String)"=== \ud83d\udcfa RTSP\u89c6\u9891\u4e25\u683c\u5750\u6807\u5bf9\u9f50 ===");
            Log.i((String)rtsp_view.TAG, (String)("\u5bb9\u5668\u5c3a\u5bf8: " + viewWidth + "x" + viewHeight));
            Log.i((String)rtsp_view.TAG, (String)("\u89c6\u9891\u663e\u793a\u533a\u57df: " + this.mDstRect.toString()));
            Log.i((String)rtsp_view.TAG, (String)("\u539f\u59cb\u89c6\u9891\u5c3a\u5bf8: " + this.mVideoWidth + "x" + this.mVideoHeight));
            Log.i((String)rtsp_view.TAG, (String)"\u586b\u5145\u6a21\u5f0f: \u5b8c\u5168\u586b\u6ee1\u5bb9\u5668\uff0c\u4e25\u683c\u5750\u6807\u5bf9\u9f50");
            Log.i((String)rtsp_view.TAG, (String)"=== \ud83d\udcfa \u5750\u6807\u5bf9\u9f50\u4fe1\u606f\u7ed3\u675f ===");
        }

        public void submitH264Data(byte[] data) {
            if (this.mDecoder != null) {
                this.mDecoder.queueH264Data(data);
            } else {
                Log.e((String)rtsp_view.TAG, (String)"\u65e0\u6cd5\u63d0\u4ea4H.264\u6570\u636e\uff0c\u89e3\u7801\u5668\u672a\u521d\u59cb\u5316");
            }
        }

        public void surfaceCreated(@NonNull SurfaceHolder holder) {
            Log.i((String)rtsp_view.TAG, (String)"SurfaceView\u521b\u5efa");
            try {
                Surface surface = holder.getSurface();
                if (surface == null) {
                    Log.e((String)rtsp_view.TAG, (String)"Surface\u4e3anull\uff0c\u65e0\u6cd5\u521b\u5efa\u89e3\u7801\u5668");
                    return;
                }
                if (!surface.isValid()) {
                    Log.e((String)rtsp_view.TAG, (String)"Surface\u65e0\u6548\uff0c\u65e0\u6cd5\u521b\u5efa\u89e3\u7801\u5668");
                    return;
                }
                Log.i((String)rtsp_view.TAG, (String)("Surface\u5df2\u521b\u5efa\u5e76\u6709\u6548: " + surface));
                if (this.mDecoder != null) {
                    this.mDecoder.stop();
                    this.mDecoder = null;
                }
                this.mDecoder = new H264Decoder(surface);
                this.mDecoder.setCallback(this);
                this.mDecoder.setVideoSize(this.mVideoWidth, this.mVideoHeight, this.mFps);
                this.mDecoder.setAsyncMode(true);
                this.mDecoder.start();
                Log.i((String)rtsp_view.TAG, (String)("\u89e3\u7801\u5668\u5df2\u521b\u5efa\u5e76\u542f\u52a8\uff0c\u4f7f\u7528\u5f02\u6b65\u6a21\u5f0f\uff0cSurface: " + surface));
                if (!surface.isValid()) {
                    Log.e((String)rtsp_view.TAG, (String)"\u89e3\u7801\u5668\u542f\u52a8\u540eSurface\u53d8\u4e3a\u65e0\u6548\uff0c\u5c1d\u8bd5\u91cd\u65b0\u521b\u5efa");
                    this.stopDecoder();
                    surface = holder.getSurface();
                    if (surface != null && surface.isValid()) {
                        this.mDecoder = new H264Decoder(surface);
                        this.mDecoder.setCallback(this);
                        this.mDecoder.setVideoSize(this.mVideoWidth, this.mVideoHeight, this.mFps);
                        this.mDecoder.setAsyncMode(true);
                        this.mDecoder.start();
                        Log.i((String)rtsp_view.TAG, (String)"\u89e3\u7801\u5668\u5df2\u91cd\u65b0\u521b\u5efa\u5e76\u542f\u52a8");
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)rtsp_view.TAG, (String)("\u521b\u5efa\u89e3\u7801\u5668\u5931\u8d25: " + e.getMessage()), (Throwable)e);
            }
        }

        public void surfaceChanged(@NonNull SurfaceHolder holder, int format, int width, int height) {
            Log.i((String)rtsp_view.TAG, (String)("SurfaceView\u6539\u53d8: " + width + "x" + height));
            this.updateDestinationRect();
        }

        public void surfaceDestroyed(@NonNull SurfaceHolder holder) {
            Log.i((String)rtsp_view.TAG, (String)"SurfaceView\u9500\u6bc1");
            this.stopDecoder();
        }

        public void stopDecoder() {
            if (this.mDecoder != null) {
                this.mDecoder.stop();
                this.mDecoder = null;
            }
        }

        public float getCurrentFps() {
            return this.mDecoder != null ? this.mDecoder.getCurrentFps() : 0.0f;
        }

        public float getCurrentDynamicFps() {
            return this.mDecoder != null ? this.mDecoder.getCurrentDynamicFps() : 0.0f;
        }

        @Override
        public void onFrameRateUpdate(float fps) {
            Log.d((String)rtsp_view.TAG, (String)("\u5e27\u7387\u66f4\u65b0\u56de\u8c03: " + fps + " fps"));
        }

        @Override
        public void onVideoSizeChanged(int width, int height) {
            if (width != this.mVideoWidth || height != this.mVideoHeight) {
                this.mVideoWidth = width;
                this.mVideoHeight = height;
                this.updateDestinationRect();
                Log.i((String)rtsp_view.TAG, (String)("\u89c6\u9891\u5c3a\u5bf8\u53d8\u5316\u56de\u8c03: " + width + "x" + height));
            }
        }
    }
}

