/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.Redirector;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.LogLevel;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ant.KotlinAntTaskUtil;
import org.jetbrains.kotlin.ant.KotlinAntTaskUtilKt;
import org.jetbrains.kotlin.ant.KotlinCompilerBaseTask;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001bJ\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001bJ\b\u0010#\u001a\u00020\u001dH\u0016J\b\u0010$\u001a\u00020\u001dH\u0016J\b\u0010%\u001a\u00020\u001dH\u0002J\u0006\u0010&\u001a\u00020'R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0007\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000b\"\u0004\b\u0014\u0010\rR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000b\"\u0004\b\u0019\u0010\rR\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/ant/Kotlin2JvmTask;", "Lorg/jetbrains/kotlin/ant/KotlinCompilerBaseTask;", "<init>", "()V", "compilerFqName", "", "getCompilerFqName", "()Ljava/lang/String;", "includeRuntime", "", "getIncludeRuntime", "()Z", "setIncludeRuntime", "(Z)V", "moduleName", "getModuleName", "setModuleName", "(Ljava/lang/String;)V", "noReflect", "getNoReflect", "setNoReflect", "cmdl", "Lorg/apache/tools/ant/types/CommandlineJava;", "fork", "getFork", "setFork", "compileClasspath", "Lorg/apache/tools/ant/types/Path;", "setClasspath", "", "classpath", "setClasspathRef", "ref", "Lorg/apache/tools/ant/types/Reference;", "addConfiguredClasspath", "fillSpecificArguments", "execute", "exec", "createJvmarg", "Lorg/apache/tools/ant/types/Commandline$Argument;", "kotlin-ant"})
@SourceDebugExtension(value={"SMAP\nKotlin2JvmTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Kotlin2JvmTask.kt\norg/jetbrains/kotlin/ant/Kotlin2JvmTask\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,127:1\n37#2:128\n36#2,3:129\n*S KotlinDebug\n*F\n+ 1 Kotlin2JvmTask.kt\norg/jetbrains/kotlin/ant/Kotlin2JvmTask\n*L\n113#1:128\n113#1:129,3\n*E\n"})
public final class Kotlin2JvmTask
extends KotlinCompilerBaseTask {
    @NotNull
    private final String compilerFqName;
    private boolean includeRuntime;
    @Nullable
    private String moduleName;
    private boolean noReflect;
    @NotNull
    private final CommandlineJava cmdl = new CommandlineJava();
    private boolean fork;
    @Nullable
    private Path compileClasspath;

    public Kotlin2JvmTask() {
        this.compilerFqName = "org.jetbrains.kotlin.cli.jvm.K2JVMCompiler";
    }

    @Override
    @NotNull
    protected String getCompilerFqName() {
        return this.compilerFqName;
    }

    public final boolean getIncludeRuntime() {
        return this.includeRuntime;
    }

    public final void setIncludeRuntime(boolean bl) {
        this.includeRuntime = bl;
    }

    @Nullable
    public final String getModuleName() {
        return this.moduleName;
    }

    public final void setModuleName(@Nullable String string) {
        this.moduleName = string;
    }

    public final boolean getNoReflect() {
        return this.noReflect;
    }

    public final void setNoReflect(boolean bl) {
        this.noReflect = bl;
    }

    public final boolean getFork() {
        return this.fork;
    }

    public final void setFork(boolean bl) {
        this.fork = bl;
    }

    public final void setClasspath(@NotNull Path classpath) {
        Intrinsics.checkNotNullParameter((Object)classpath, (String)"classpath");
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            Path path = this.compileClasspath;
            Intrinsics.checkNotNull((Object)path);
            path.append(classpath);
        }
    }

    public final void setClasspathRef(@NotNull Reference ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        Path path = this.compileClasspath;
        Intrinsics.checkNotNull((Object)path);
        path.createPath().setRefid(ref);
    }

    public final void addConfiguredClasspath(@NotNull Path classpath) {
        Intrinsics.checkNotNullParameter((Object)classpath, (String)"classpath");
        this.setClasspath(classpath);
    }

    @Override
    public void fillSpecificArguments() {
        Object it;
        this.getArgs().add("-d");
        List<String> list = this.getArgs();
        File file = this.getOutput();
        Intrinsics.checkNotNull((Object)file);
        String string = file.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalPath(...)");
        list.add(string);
        Path path = this.compileClasspath;
        if (path != null) {
            it = path;
            boolean bl = false;
            this.getArgs().add("-classpath");
            List<String> list2 = this.getArgs();
            String[] stringArray = it.list();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"list(...)");
            Object[] objectArray = stringArray;
            String string2 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathSeparator");
            list2.add(ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null));
        }
        if (this.moduleName == null) {
            this.moduleName = KotlinAntTaskUtilKt.getDefaultModuleName(this);
        }
        String string3 = this.moduleName;
        if (string3 != null) {
            it = string3;
            boolean bl = false;
            this.getArgs().add("-module-name");
            List<String> list3 = this.getArgs();
            String string4 = this.moduleName;
            Intrinsics.checkNotNull((Object)string4);
            list3.add(string4);
        }
        if (this.getNoStdlib()) {
            this.getArgs().add("-no-stdlib");
        }
        if (this.noReflect) {
            this.getArgs().add("-no-reflect");
        }
        if (this.includeRuntime) {
            this.getArgs().add("-include-runtime");
        }
    }

    @Override
    public void execute() {
        if (!this.fork) {
            super.execute();
        } else {
            this.warnAntDeprecation$kotlin_ant();
            this.exec();
        }
    }

    private final void exec() {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        Redirector redirector = new Redirector((Task)this);
        this.fillArguments();
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaBin);
        Collection collection = command;
        String[] stringArray = this.cmdl.getVmCommand().getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getArguments(...)");
        CollectionsKt.addAll((Collection)collection, (Object[])stringArray);
        command.add("-Dorg.jetbrains.kotlin.cliMessageRenderer=FullPath");
        command.add("-cp");
        command.add(KotlinAntTaskUtil.INSTANCE.getCompilerJar().getCanonicalPath());
        command.add(this.getCompilerFqName());
        command.addAll((Collection)this.getArgs());
        Execute exe = new Execute(redirector.createHandler(), null);
        exe.setAntRun(this.getProject());
        Collection $this$toTypedArray$iv = command;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        exe.setCommandline(thisCollection$iv.toArray(new String[0]));
        this.log("Executing command: " + CollectionsKt.joinToString$default((Iterable)command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), LogLevel.DEBUG.getLevel());
        StringBuilder stringBuilder = new StringBuilder().append("Compiling ");
        Path path = this.getSrc();
        Intrinsics.checkNotNull((Object)path);
        String[] stringArray2 = path.list();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"list(...)");
        StringBuilder stringBuilder2 = stringBuilder.append(ArraysKt.toList((Object[])stringArray2)).append(" => [");
        File file = this.getOutput();
        Intrinsics.checkNotNull((Object)file);
        this.log(stringBuilder2.append(file.getCanonicalPath()).append(']').toString());
        int exitCode = exe.execute();
        redirector.complete();
        if (this.getFailOnError() && exitCode != 0) {
            throw new BuildException("Compile failed; see the compiler error output for details.");
        }
    }

    @NotNull
    public final Commandline.Argument createJvmarg() {
        Commandline.Argument argument = this.cmdl.createVmArgument();
        Intrinsics.checkNotNullExpressionValue((Object)argument, (String)"createVmArgument(...)");
        return argument;
    }
}

