/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.proxy;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import oracle.kv.FaultException;
import oracle.kv.proxy.IteratorTimeoutException;
import oracle.kv.table.TableIterator;

public class IteratorManager {
    public static final long TIMER_CLEANUP_INTERVAL = 5000L;
    private static final Logger logger = Logger.getLogger(IteratorManager.class.getName());
    private static IteratorManager INSTANCE;
    private final int maxOpenedIterators;
    private final AtomicLong counter = new AtomicLong(0L);
    private final Map<Long, IteratorInfo> iterators = new ConcurrentHashMap<Long, IteratorInfo>();
    private final long expirationIntervalMs;
    private final Timer timer;

    private IteratorManager(long expirationIntervalMs, int maxOpenedIterators) {
        this.expirationIntervalMs = expirationIntervalMs;
        this.maxOpenedIterators = maxOpenedIterators;
        this.timer = new Timer("Timer to cleanup unclosed iterators", true);
        this.timer.scheduleAtFixedRate((TimerTask)new IteratorCleanupTask(this), 5000L, 5000L);
    }

    static synchronized IteratorManager getInstance(long expirationIntervalMs, int maxOpenedIterators) {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = new IteratorManager(expirationIntervalMs, maxOpenedIterators);
        return INSTANCE;
    }

    long getNewIteratorId(TableIterator<?> iterator, long max) {
        long c;
        long initialCounter = this.counter.get();
        do {
            c = this.counter.incrementAndGet();
            assert (c != Long.MAX_VALUE) : "Iterator counter reached Long.MAX_VALUE";
            if (initialCounter != c) continue;
            throw new IllegalStateException("No new iteratorId value available.");
        } while (this.iterators.containsKey(c));
        if (this.iterators.size() > this.maxOpenedIterators) {
            throw new FaultException("Number of opened iterators exceed configured -max-opened-iterators. Modify the value or -max-opened-iterators it's very likely an application bug.", false);
        }
        this.iterators.put(c, new IteratorInfo(System.currentTimeMillis(), iterator, max));
        return c;
    }

    TableIterator<?> getIterator(long iteratorId) throws IteratorTimeoutException {
        IteratorInfo iterInfo = this.getIteratorInfo(iteratorId);
        return iterInfo.iterator;
    }

    long getMaxResults(long iteratorId) throws IteratorTimeoutException {
        IteratorInfo iterInfo = this.getIteratorInfo(iteratorId);
        return iterInfo.maxResults;
    }

    void touch(long iteratorId) throws IteratorTimeoutException {
        this.getIteratorInfo(iteratorId);
    }

    private IteratorInfo getIteratorInfo(long iteratorId) throws IteratorTimeoutException {
        IteratorInfo iterInfo = this.iterators.get(iteratorId);
        if (iterInfo == null) {
            throw new IteratorTimeoutException("No iterator is available for iteratorId: " + iteratorId + ". Iterator was already closed or time " + "expired.");
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime > iterInfo.timestamp + this.expirationIntervalMs) {
            this.closeIterator(iteratorId);
            throw new IteratorTimeoutException("Time expired for iteratorId: " + iteratorId);
        }
        iterInfo.timestamp = currentTime;
        return iterInfo;
    }

    void closeIterator(long iteratorId) {
        IteratorInfo iterInfo = this.iterators.remove(iteratorId);
        if (iterInfo != null) {
            iterInfo.iterator.close();
        }
    }

    void runCleanup() {
        long currentTime = System.currentTimeMillis();
        for (Map.Entry<Long, IteratorInfo> entry : this.iterators.entrySet()) {
            IteratorInfo iterInfo = entry.getValue();
            if (currentTime <= iterInfo.timestamp + this.expirationIntervalMs) continue;
            try {
                this.closeIterator(entry.getKey());
            }
            catch (Exception e) {
                logger.warning(e.getMessage());
            }
        }
    }

    private static class IteratorCleanupTask
    extends TimerTask {
        private final IteratorManager iteratorManager;

        private IteratorCleanupTask(IteratorManager iteratorManager) {
            this.iteratorManager = iteratorManager;
        }

        @Override
        public void run() {
            this.iteratorManager.runCleanup();
        }
    }

    private static class IteratorInfo {
        final TableIterator<?> iterator;
        final long maxResults;
        volatile long timestamp;

        IteratorInfo(long ts, TableIterator<?> it, long max) {
            this.timestamp = ts;
            this.iterator = it;
            this.maxResults = max;
        }
    }
}

