/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.proxy;

import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import oracle.kv.KVStore;
import oracle.kv.KVStoreConfig;
import oracle.kv.KVStoreFactory;
import oracle.kv.RequestLimitConfig;
import oracle.kv.proxy.ONDBHandler;
import oracle.kv.proxy.Options;
import oracle.kv.proxy.gen.ONDB;
import oracle.kv.table.TableAPI;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class KVProxy {
    public static final String VERSION = "3.2.5";
    static final int DEFAULT_TIMEOUT_MS = 200;
    private static final Logger logger = Logger.getLogger(KVProxy.class.getName());
    private final TNonblockingServerTransport serverTransport;
    private final TServer server;
    private final TableAPI tableAPI;
    private final KVStore store;
    private final Options options;

    private KVProxy(String[] args) throws TTransportException {
        this.options = new Options(args);
        if (!this.options.isExit()) {
            logger.info("PS: Starting KVProxy server");
            logger.info("PS: Connect to Oracle NoSQL Database " + this.options.getStoreName() + " nodes : " + this.options.getHelperHostsString());
            if (this.options.getSecurityFilePath() != null) {
                System.setProperty("oracle.kv.security", this.options.getSecurityFilePath());
                System.setProperty("oracle.kv.auth.username", this.options.getUsername());
            }
            KVStoreConfig config = new KVStoreConfig(this.options.getStoreName(), this.options.getHelperHosts());
            RequestLimitConfig requestLimitConfig = new RequestLimitConfig(this.options.getMaxActiveRequests(), this.options.getRequestThresholdPercent(), this.options.getRequestThresholdPercent());
            config.setRequestLimit(requestLimitConfig);
            config.setRequestTimeout(this.options.getRequestTimeout(), TimeUnit.MILLISECONDS);
            config.setSocketOpenTimeout(this.options.getSocketOpenTimeout(), TimeUnit.MILLISECONDS);
            config.setSocketReadTimeout(this.options.getSocketReadTimeout(), TimeUnit.MILLISECONDS);
            config.setReadZones(this.options.getReadZones());
            this.store = KVStoreFactory.getStore((KVStoreConfig)config);
            this.tableAPI = this.getStore().getTableAPI();
            logger.info("PS:   ... connected successfully");
            this.serverTransport = new TNonblockingServerSocket(this.options.getProxyPortNumber());
            THsHaServer.Args serverArgs = new THsHaServer.Args(this.serverTransport);
            ONDBProcessorFactory processorFactory = new ONDBProcessorFactory(this);
            serverArgs.processorFactory((TProcessorFactory)processorFactory);
            serverArgs.workerThreads(this.options.getNumPoolThreads());
            this.server = new THsHaServer(serverArgs);
        } else {
            this.store = null;
            this.tableAPI = null;
            this.serverTransport = null;
            this.server = null;
        }
    }

    public static void main(String[] args) throws TTransportException {
        KVProxy.startServer(args);
    }

    public static KVProxy startServer(String[] args) throws TTransportException {
        KVProxy server = new KVProxy(args);
        if (server.getOptions().isExit()) {
            return null;
        }
        logger.info("PS: Starting listener ( Half-Sync/Half-Async server - " + server.getOptions().getNumPoolThreads() + " no of threads on port " + server.getOptions().getProxyPortNumber() + ")");
        server.server.serve();
        logger.info("PS: Proxy server stopped.");
        return server;
    }

    public void stopServer() {
        logger.info("PS: Stopping proxy server ...");
        this.server.stop();
        this.serverTransport.close();
    }

    TableAPI getTableAPI() {
        return this.tableAPI;
    }

    KVStore getStore() {
        return this.store;
    }

    Logger getLogger() {
        return logger;
    }

    Options getOptions() {
        return this.options;
    }

    private static class ONDBProcessorFactory
    extends TProcessorFactory {
        private final KVProxy kvProxy;
        private final ONDB.Processor<ONDBHandler> processor;

        public ONDBProcessorFactory(KVProxy kvProxy) {
            super(null);
            this.kvProxy = kvProxy;
            this.processor = new ONDB.Processor<ONDBHandler>(new ONDBHandler(this.kvProxy));
        }

        public TProcessor getProcessor(TTransport trans) {
            return this.processor;
        }
    }
}

