/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.proxy;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import oracle.kv.AuthenticationFailureException;
import oracle.kv.AuthenticationRequiredException;
import oracle.kv.Consistency;
import oracle.kv.ConsistencyException;
import oracle.kv.Direction;
import oracle.kv.Durability;
import oracle.kv.DurabilityException;
import oracle.kv.FaultException;
import oracle.kv.KVStore;
import oracle.kv.KVVersion;
import oracle.kv.RequestLimitException;
import oracle.kv.RequestTimeoutException;
import oracle.kv.UnauthorizedException;
import oracle.kv.Version;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.Topology;
import oracle.kv.proxy.IteratorManager;
import oracle.kv.proxy.IteratorTimeoutException;
import oracle.kv.proxy.KVProxy;
import oracle.kv.proxy.gen.ONDB;
import oracle.kv.proxy.gen.TAuthenticationFailureException;
import oracle.kv.proxy.gen.TAuthenticationRequiredException;
import oracle.kv.proxy.gen.TCancellationException;
import oracle.kv.proxy.gen.TConsistency;
import oracle.kv.proxy.gen.TConsistencyException;
import oracle.kv.proxy.gen.TDirection;
import oracle.kv.proxy.gen.TDurability;
import oracle.kv.proxy.gen.TDurabilityException;
import oracle.kv.proxy.gen.TExecutionException;
import oracle.kv.proxy.gen.TFaultException;
import oracle.kv.proxy.gen.TFieldRange;
import oracle.kv.proxy.gen.TGetResult;
import oracle.kv.proxy.gen.TIllegalArgumentException;
import oracle.kv.proxy.gen.TInterruptedException;
import oracle.kv.proxy.gen.TIteratorResult;
import oracle.kv.proxy.gen.TIteratorTimeoutException;
import oracle.kv.proxy.gen.TModuleInfo;
import oracle.kv.proxy.gen.TMultiGetResult;
import oracle.kv.proxy.gen.TOperation;
import oracle.kv.proxy.gen.TOperationType;
import oracle.kv.proxy.gen.TProxyException;
import oracle.kv.proxy.gen.TReadOptions;
import oracle.kv.proxy.gen.TReplicaAckPolicy;
import oracle.kv.proxy.gen.TRequestLimitException;
import oracle.kv.proxy.gen.TRequestTimeoutException;
import oracle.kv.proxy.gen.TReturnChoice;
import oracle.kv.proxy.gen.TRow;
import oracle.kv.proxy.gen.TRowAndMetadata;
import oracle.kv.proxy.gen.TSimpleConsistency;
import oracle.kv.proxy.gen.TStatementResult;
import oracle.kv.proxy.gen.TSyncPolicy;
import oracle.kv.proxy.gen.TTableOpExecutionException;
import oracle.kv.proxy.gen.TTimeConsistency;
import oracle.kv.proxy.gen.TTimeoutException;
import oracle.kv.proxy.gen.TUnauthorizedException;
import oracle.kv.proxy.gen.TUnverifiedConnectionException;
import oracle.kv.proxy.gen.TVerifyProperties;
import oracle.kv.proxy.gen.TVerifyResult;
import oracle.kv.proxy.gen.TVersionConsistency;
import oracle.kv.proxy.gen.TWriteOptions;
import oracle.kv.proxy.gen.TWriteResult;
import oracle.kv.table.ExecutionFuture;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldRange;
import oracle.kv.table.FieldValue;
import oracle.kv.table.Index;
import oracle.kv.table.IndexKey;
import oracle.kv.table.KeyPair;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.ReadOptions;
import oracle.kv.table.ReturnRow;
import oracle.kv.table.Row;
import oracle.kv.table.StatementResult;
import oracle.kv.table.Table;
import oracle.kv.table.TableAPI;
import oracle.kv.table.TableIterator;
import oracle.kv.table.TableIteratorOptions;
import oracle.kv.table.TableOpExecutionException;
import oracle.kv.table.TableOperation;
import oracle.kv.table.TableOperationFactory;
import oracle.kv.table.TableOperationResult;
import oracle.kv.table.WriteOptions;
import org.apache.thrift.TException;

public class ONDBHandler
implements ONDB.Iface {
    private static volatile IteratorManager iteratorManager;
    private final KVProxy kvProxy;
    private final TableAPI tableAPI;
    private final KVStore store;
    private final Logger logger;
    private final boolean verbose;
    private volatile TableMetadata tableCache;

    ONDBHandler(KVProxy kvProxy) {
        this.kvProxy = kvProxy;
        this.store = kvProxy.getStore();
        this.tableAPI = kvProxy.getTableAPI();
        this.logger = kvProxy.getLogger();
        this.verbose = this.kvProxy.getOptions().isVerbose();
        if (iteratorManager == null) {
            iteratorManager = IteratorManager.getInstance(this.kvProxy.getOptions().getIteratorExpiration(), this.kvProxy.getOptions().getMaxOpenIterators());
        }
        this.tableCache = ((TableAPIImpl)this.tableAPI).getTableMetadata();
        assert (this.tableCache != null) : "TableCache should never be null.";
    }

    private boolean matchHelperHosts(List<String> drvHlprHosts, List<String> starterHlprHosts) {
        assert (starterHlprHosts != null) : "Starting helper host list should not be null.";
        assert (starterHlprHosts.size() > 0) : "Starting helper host list should always contain something.";
        if (drvHlprHosts == null || drvHlprHosts.size() == 0) {
            return false;
        }
        if (drvHlprHosts.size() == 1 && drvHlprHosts.get(0) != null && starterHlprHosts.size() == 1 && starterHlprHosts.get(0) != null && drvHlprHosts.get(0).startsWith("localhost:") && drvHlprHosts.get(0).equals(starterHlprHosts.get(0))) {
            return true;
        }
        Topology topo = ((KVStoreImpl)this.store).getDispatcher().getTopologyManager().getTopology();
        HashSet<String> topoHostPorts = new HashSet<String>();
        for (StorageNode sn : topo.getSortedStorageNodes()) {
            topoHostPorts.add(sn.getHostname() + ":" + sn.getRegistryPort());
        }
        drvHlprHosts.retainAll(topoHostPorts);
        return drvHlprHosts.size() > 0;
    }

    private static TStatementResult getTStatementResult(StatementResult sr) {
        assert (sr != null) : "The statement result should never be null.";
        return new TStatementResult(sr.getPlanId(), sr.getInfo(), sr.getInfoAsJson(), sr.isSuccessful(), sr.getErrorMessage(), sr.isCancelled(), sr.isDone());
    }

    private static Version getVersion(ByteBuffer versionBB) {
        if (versionBB == null) {
            return null;
        }
        byte[] byteArray = new byte[versionBB.remaining()];
        versionBB.get(byteArray);
        return Version.fromByteArray((byte[])byteArray);
    }

    private static WriteOptions getWriteOptions(TWriteOptions writeOptions) {
        if (writeOptions == null) {
            return null;
        }
        Durability durability = null;
        if (writeOptions.isSetDurability()) {
            durability = ONDBHandler.getDurability(writeOptions.getDurability());
        }
        long timeoutMs = 200L;
        if (writeOptions.isSetTimeoutMs()) {
            timeoutMs = writeOptions.getTimeoutMs();
        }
        return new WriteOptions(durability, timeoutMs, TimeUnit.MILLISECONDS);
    }

    private static Durability getDurability(TDurability d) {
        Durability.SyncPolicy masterSync = Durability.SyncPolicy.NO_SYNC;
        Durability.SyncPolicy replicaSync = Durability.SyncPolicy.NO_SYNC;
        Durability.ReplicaAckPolicy replicaAck = Durability.ReplicaAckPolicy.NONE;
        if (d.isSetMasterSync()) {
            masterSync = ONDBHandler.getSyncPolicy(d.getMasterSync());
        }
        if (d.isSetReplicaSync()) {
            replicaSync = ONDBHandler.getSyncPolicy(d.getReplicaSync());
        }
        if (d.isSetReplicaAck()) {
            replicaAck = ONDBHandler.getReplicaAckPolicy(d.getReplicaAck());
        }
        return new Durability(masterSync, replicaSync, replicaAck);
    }

    private static Durability.SyncPolicy getSyncPolicy(TSyncPolicy syncPolicy) {
        if (syncPolicy == null) {
            return Durability.SyncPolicy.NO_SYNC;
        }
        switch (syncPolicy) {
            case NO_SYNC: {
                return Durability.SyncPolicy.NO_SYNC;
            }
            case SYNC: {
                return Durability.SyncPolicy.SYNC;
            }
            case WRITE_NO_SYNC: {
                return Durability.SyncPolicy.WRITE_NO_SYNC;
            }
        }
        throw new IllegalStateException("Unknown TSyncPolicy type.");
    }

    private static Durability.ReplicaAckPolicy getReplicaAckPolicy(TReplicaAckPolicy replicaAckPolicy) {
        if (replicaAckPolicy == null) {
            return Durability.ReplicaAckPolicy.NONE;
        }
        switch (replicaAckPolicy) {
            case ALL: {
                return Durability.ReplicaAckPolicy.ALL;
            }
            case NONE: {
                return Durability.ReplicaAckPolicy.NONE;
            }
            case SIMPLE_MAJORITY: {
                return Durability.ReplicaAckPolicy.SIMPLE_MAJORITY;
            }
        }
        throw new IllegalStateException("Unknown TReplicaAckPolicy type.");
    }

    private static TReplicaAckPolicy getTReplicaAckPolicy(Durability.ReplicaAckPolicy replicaAckPolicy) {
        if (replicaAckPolicy == null) {
            return TReplicaAckPolicy.NONE;
        }
        switch (replicaAckPolicy) {
            case ALL: {
                return TReplicaAckPolicy.ALL;
            }
            case NONE: {
                return TReplicaAckPolicy.NONE;
            }
            case SIMPLE_MAJORITY: {
                return TReplicaAckPolicy.SIMPLE_MAJORITY;
            }
        }
        throw new IllegalStateException("Unknown TReplicaAckPolicy type.");
    }

    private static ReturnRow.Choice getReturnRowChoice(TWriteOptions writeOptions) {
        TReturnChoice choice = TReturnChoice.NONE;
        if (writeOptions != null && writeOptions.isSetReturnChoice()) {
            choice = writeOptions.getReturnChoice();
        }
        switch (choice) {
            case ALL: {
                return ReturnRow.Choice.ALL;
            }
            case NONE: {
                return ReturnRow.Choice.NONE;
            }
            case VALUE: {
                return ReturnRow.Choice.VALUE;
            }
            case VERSION: {
                return ReturnRow.Choice.VERSION;
            }
        }
        throw new IllegalStateException("Unknown TReturnChoice type.");
    }

    private static ByteBuffer getBBVersion(Version version2) {
        ByteBuffer bbPrevVersion = null;
        if (version2 != null) {
            bbPrevVersion = ByteBuffer.wrap(version2.toByteArray());
        }
        return bbPrevVersion;
    }

    private static Row mergeKeys(PrimaryKey pk, IndexKey ik) {
        if (pk == null && ik == null) {
            return null;
        }
        if (pk == null) {
            return ik.asPrimaryKey();
        }
        if (ik == null) {
            return pk;
        }
        Row r = pk.getTable().createRow();
        for (String f : pk.getFields()) {
            r.put(f, pk.get(f));
        }
        for (String f : ik.getFields()) {
            r.put(f, ik.get(f));
        }
        return r;
    }

    private static MultiRowOptions getMultiRowOptions(Table t, TFieldRange tFieldRange, List<String> includedTables, Index index) {
        FieldRange fr = ONDBHandler.getFieldRange(tFieldRange, t, index);
        if (fr == null && (includedTables == null || includedTables.size() == 0)) {
            return null;
        }
        return t.createMultiRowOptions(includedTables, fr);
    }

    private static FieldRange getFieldRange(TFieldRange tFieldRange, Table table, Index index) {
        if (tFieldRange == null) {
            return null;
        }
        String fieldName = null;
        if (tFieldRange.getFieldName() != null && tFieldRange.getFieldName().length() > 0) {
            fieldName = tFieldRange.getFieldName();
        }
        if (fieldName == null) {
            return null;
        }
        FieldRange res = index != null ? index.createFieldRange(fieldName) : table.createFieldRange(fieldName);
        if (tFieldRange.isSetStartValue()) {
            res.setStart(ONDBHandler.getFieldValue(tFieldRange.getStartValue(), res.getField(), fieldName), tFieldRange.isStartIsInclusive());
        }
        if (tFieldRange.isSetEndValue()) {
            res.setEnd(ONDBHandler.getFieldValue(tFieldRange.getEndValue(), res.getField(), fieldName), tFieldRange.isEndIsInclusive());
        }
        return res;
    }

    private static FieldValue getFieldValue(String tValue, FieldDef fieldDef, String fieldName) {
        try {
            switch (fieldDef.getType()) {
                case BOOLEAN: {
                    boolean boolValue = "true".equals(tValue);
                    if (!boolValue && !"false".equals(tValue)) {
                        throw new IllegalArgumentException("Not a valid BOOLEAN value: " + tValue);
                    }
                    return fieldDef.createBoolean(boolValue);
                }
                case DOUBLE: {
                    double doubleValue = Double.parseDouble(tValue);
                    return fieldDef.createDouble(doubleValue);
                }
                case ENUM: {
                    return fieldDef.createEnum(tValue);
                }
                case FLOAT: {
                    float floatValue = Float.parseFloat(tValue);
                    return fieldDef.createFloat(floatValue);
                }
                case INTEGER: {
                    int intValue = Integer.parseInt(tValue);
                    return fieldDef.createInteger(intValue);
                }
                case LONG: {
                    long longValue = Long.parseLong(tValue);
                    return fieldDef.createLong(longValue);
                }
                case STRING: {
                    return fieldDef.createString(tValue);
                }
                case BINARY: 
                case FIXED_BINARY: 
                case ARRAY: 
                case MAP: 
                case RECORD: {
                    throw new IllegalArgumentException("Unsupported range type: " + fieldDef.getType());
                }
            }
            throw new IllegalStateException("Unknown FieldDef type: " + fieldDef.getType());
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Unable to create value of type " + fieldDef.getType() + " for field " + fieldName + "from string value " + tValue + ": " + nfe.getMessage());
        }
    }

    private static ReadOptions getReadOptions(TReadOptions readOptions) {
        if (readOptions == null) {
            return null;
        }
        Consistency consistency = Consistency.NONE_REQUIRED;
        long timeout = 200L;
        if (readOptions.isSetConsistency()) {
            consistency = ONDBHandler.getConsistency(readOptions.getConsistency());
        }
        if (readOptions.isSetTimeoutMs()) {
            timeout = readOptions.getTimeoutMs();
        }
        return new ReadOptions(consistency, timeout, TimeUnit.MILLISECONDS);
    }

    private static TableIteratorOptions getIteratorOptions(TReadOptions tReadOptions, TDirection tDirection) {
        if (tReadOptions == null) {
            return null;
        }
        Consistency consistency = Consistency.NONE_REQUIRED;
        long timeout = 200L;
        if (tReadOptions.isSetConsistency()) {
            consistency = ONDBHandler.getConsistency(tReadOptions.getConsistency());
        }
        if (tReadOptions.isSetTimeoutMs()) {
            timeout = tReadOptions.getTimeoutMs();
        }
        return new TableIteratorOptions(ONDBHandler.getDirection(tDirection), consistency, timeout, TimeUnit.MILLISECONDS);
    }

    private static Direction getDirection(TDirection tDirection) {
        if (tDirection == null) {
            return Direction.UNORDERED;
        }
        switch (tDirection) {
            case FORWARD: {
                return Direction.FORWARD;
            }
            case REVERSE: {
                return Direction.REVERSE;
            }
            case UNORDERED: {
                return Direction.UNORDERED;
            }
        }
        throw new IllegalStateException("Unknown TDirection value.");
    }

    private static Consistency getConsistency(TConsistency consistency) {
        if (consistency == null) {
            return null;
        }
        if (consistency.isSetSimple()) {
            switch (consistency.getSimple()) {
                case ABSOLUTE: {
                    return Consistency.ABSOLUTE;
                }
                case NONE_REQUIRED: {
                    return Consistency.NONE_REQUIRED;
                }
                case NONE_REQUIRED_NO_MASTER: {
                    return Consistency.NONE_REQUIRED_NO_MASTER;
                }
            }
            throw new IllegalStateException("Unknown TConsistency type.");
        }
        if (consistency.isSetTime()) {
            if (!consistency.getTime().isSetPermissibleLag() || !consistency.getTime().isSetTimeoutMs()) {
                throw new IllegalArgumentException("Time consistency must set both permissibleLag and timeout.");
            }
            long permissibleLag = consistency.getTime().getPermissibleLag();
            long timeout = consistency.getTime().getTimeoutMs();
            return new Consistency.Time(permissibleLag, TimeUnit.MILLISECONDS, timeout, TimeUnit.MILLISECONDS);
        }
        if (consistency.isSetVersion()) {
            if (!consistency.getVersion().isSetVersion() || !consistency.getVersion().isSetTimeoutMs()) {
                throw new IllegalArgumentException("Version consistency must set both version and timeout.");
            }
            Version v = ONDBHandler.getVersion(consistency.getVersion().bufferForVersion());
            long timeout = consistency.getVersion().getTimeoutMs();
            return new Consistency.Version(v, timeout, TimeUnit.MILLISECONDS);
        }
        throw new IllegalStateException("Unknown consistency union field.");
    }

    private static TConsistency getTConsistency(Consistency consistency) {
        if (consistency == null) {
            return TConsistency.simple(TSimpleConsistency.NONE_REQUIRED);
        }
        if (Consistency.ABSOLUTE.equals(consistency)) {
            return TConsistency.simple(TSimpleConsistency.ABSOLUTE);
        }
        if (Consistency.NONE_REQUIRED.equals(consistency)) {
            return TConsistency.simple(TSimpleConsistency.NONE_REQUIRED);
        }
        if (Consistency.NONE_REQUIRED_NO_MASTER.equals(consistency)) {
            return TConsistency.simple(TSimpleConsistency.NONE_REQUIRED_NO_MASTER);
        }
        if (consistency instanceof Consistency.Time) {
            Consistency.Time tc = (Consistency.Time)consistency;
            return TConsistency.time(new TTimeConsistency(tc.getPermissibleLag(TimeUnit.MILLISECONDS), tc.getTimeout(TimeUnit.MILLISECONDS)));
        }
        if (consistency instanceof Consistency.Version) {
            Consistency.Version vc = (Consistency.Version)consistency;
            return TConsistency.version(new TVersionConsistency(ONDBHandler.getBBVersion(vc.getVersion()), vc.getTimeout(TimeUnit.MILLISECONDS)));
        }
        throw new IllegalStateException("Unknown TConsistency type.");
    }

    @Override
    public void ping() throws TException {
    }

    @Override
    public String version(TModuleInfo whichModule) throws TIllegalArgumentException {
        switch (whichModule) {
            case JAVA_CLIENT: {
                return KVVersion.CURRENT_VERSION.getVersionString();
            }
            case PROXY_SERVER: {
                return "3.2.5";
            }
        }
        throw new TIllegalArgumentException("Unknown module");
    }

    @Override
    public String status(TModuleInfo whichModule) throws TIllegalArgumentException {
        switch (whichModule) {
            case JAVA_CLIENT: {
                return this.store.getStats(false).toString();
            }
            case PROXY_SERVER: {
                return "Connection to KVProxy server established.";
            }
        }
        throw new TIllegalArgumentException("Unknown module");
    }

    @Override
    public void shutdown() throws TException {
        this.debug("PS: Received shutdown message.");
        this.debug("PS: Shutting down the Proxy Server.");
        this.kvProxy.stopServer();
    }

    @Override
    public TVerifyResult verify(TVerifyProperties properties) throws TUnverifiedConnectionException, TException {
        this.debug("PS: verify:" + properties);
        if (!properties.isSetKvStoreName()) {
            this.logger.warning("PS: TUnverifiedConnectionException: kvStoreName not set.");
            throw new TUnverifiedConnectionException("kvStoreName not set.");
        }
        if (!properties.getKvStoreName().equals(this.kvProxy.getOptions().getStoreName())) {
            this.logger.warning("PS: TUnverifiedConnectionException: kvStoreName does not match: " + properties.getKvStoreName());
            throw new TUnverifiedConnectionException("kvStoreName does not match.");
        }
        if (!properties.isSetKvStoreHelperHosts()) {
            this.logger.warning("PS: TUnverifiedConnectionException: kvStoreHelperHosts not set.");
            throw new TUnverifiedConnectionException("kvStoreHelperHosts not set.");
        }
        if (!this.matchHelperHosts(properties.getKvStoreHelperHosts(), Arrays.asList(this.kvProxy.getOptions().getHelperHosts()))) {
            this.logger.warning("PS: TUnverifiedConnectionException: kvStoreHelperHosts list does not match." + properties.getKvStoreHelperHosts());
            throw new TUnverifiedConnectionException("kvStoreHelperHosts list does not match, use the exact names from the cluster topology.");
        }
        String username = this.kvProxy.getOptions().getUsername();
        if (username != null) {
            if (!properties.isSetUsername() || !username.equals(properties.getUsername())) {
                throw new TUnverifiedConnectionException("username does not match.");
            }
        } else if (properties.isSetUsername() && properties.getUsername() != null) {
            throw new TUnverifiedConnectionException("Trying to use a secured server without a username.");
        }
        if (!this.checkReadZonesMatch(this.kvProxy.getOptions().getReadZones(), properties.getReadZones())) {
            throw new TUnverifiedConnectionException("Read zones list doesn't match.");
        }
        TVerifyResult res = new TVerifyResult();
        res.setIsConnected(true);
        return res;
    }

    private boolean checkReadZonesMatch(String[] proxyReadZones, List<String> clientReadZones) {
        if (!(proxyReadZones != null && proxyReadZones.length != 0 || clientReadZones != null && clientReadZones.size() != 0)) {
            return true;
        }
        if (proxyReadZones == null || proxyReadZones.length == 0) {
            return false;
        }
        if (clientReadZones == null || clientReadZones.size() == 0) {
            return false;
        }
        HashSet przSet = new HashSet();
        Collections.addAll(przSet, proxyReadZones);
        return przSet.containsAll(clientReadZones) && clientReadZones.containsAll(przSet);
    }

    @Override
    public TWriteResult put(String tableName, TRow row, TWriteOptions writeOptions) throws TDurabilityException, TRequestTimeoutException, TFaultException, TIllegalArgumentException, TProxyException, TException {
        try {
            if (this.verbose) {
                this.debug("PS: put( " + tableName + ", " + row + ", " + writeOptions + ")");
            }
            Table t = this.getTable(tableName);
            if (row == null) {
                throw new IllegalArgumentException("Null is not a valid row value.");
            }
            String jsonRow = row.getJsonRow();
            Row r = t.createRowFromJson(jsonRow, false);
            ReturnRow prevRow = t.createReturnRow(ONDBHandler.getReturnRowChoice(writeOptions));
            Version v = this.tableAPI.put(r, prevRow, ONDBHandler.getWriteOptions(writeOptions));
            ByteBuffer bbCurrentVersion = null;
            if (v != null) {
                bbCurrentVersion = ByteBuffer.wrap(v.toByteArray());
            }
            ByteBuffer bbPrevVersion = ONDBHandler.getBBVersion(prevRow.getVersion());
            TRow tPrevRow = new TRow();
            tPrevRow.setJsonRow(prevRow.toJsonString(false));
            return new TWriteResult(bbCurrentVersion, tPrevRow, bbPrevVersion, false);
        }
        catch (Throwable ex) {
            this.checkException(ex);
            return null;
        }
    }

    @Override
    public TWriteResult putIfAbsent(String tableName, TRow row, TWriteOptions writeOptions) throws TDurabilityException, TRequestTimeoutException, TFaultException, TIllegalArgumentException, TProxyException, TException {
        try {
            if (this.verbose) {
                this.debug("PS: putIfAbsent( " + tableName + ", " + row + ", " + writeOptions + ")");
            }
            Table t = this.getTable(tableName);
            if (row == null) {
                throw new IllegalArgumentException("Null is not a valid row value.");
            }
            String jsonRow = row.getJsonRow();
            Row r = t.createRowFromJson(jsonRow, false);
            ReturnRow prevRow = t.createReturnRow(ONDBHandler.getReturnRowChoice(writeOptions));
            Version v = this.tableAPI.putIfAbsent(r, prevRow, ONDBHandler.getWriteOptions(writeOptions));
            ByteBuffer bbCurrentVersion = null;
            if (v != null) {
                bbCurrentVersion = ByteBuffer.wrap(v.toByteArray());
            }
            ByteBuffer bbPrevVersion = ONDBHandler.getBBVersion(prevRow.getVersion());
            TRow tPrevRow = new TRow();
            tPrevRow.setJsonRow(prevRow.toJsonString(false));
            return new TWriteResult(bbCurrentVersion, tPrevRow, bbPrevVersion, false);
        }
        catch (Throwable ex) {
            this.checkException(ex);
            return null;
        }
    }

    @Override
    public TWriteResult putIfPresent(String tableName, TRow row, TWriteOptions writeOptions) throws TDurabilityException, TRequestTimeoutException, TFaultException, TIllegalArgumentException, TProxyException, TException {
        try {
            if (this.verbose) {
                this.debug("PS: putIfPresent( " + tableName + ", " + row + ", " + writeOptions + ")");
            }
            Table t = this.getTable(tableName);
            if (row == null) {
                throw new IllegalArgumentException("Null is not a valid row value.");
            }
            String jsonRow = row.getJsonRow();
            Row r = t.createRowFromJson(jsonRow, false);
            ReturnRow prevRow = t.createReturnRow(ONDBHandler.getReturnRowChoice(writeOptions));
            Version v = this.tableAPI.putIfPresent(r, prevRow, ONDBHandler.getWriteOptions(writeOptions));
            ByteBuffer bbCurrentVersion = null;
            if (v != null) {
                bbCurrentVersion = ByteBuffer.wrap(v.toByteArray());
            }
            ByteBuffer bbPrevVersion = ONDBHandler.getBBVersion(prevRow.getVersion());
            TRow tPrevRow = new TRow();
            tPrevRow.setJsonRow(prevRow.toJsonString(false));
            return new TWriteResult(bbCurrentVersion, tPrevRow, bbPrevVersion, false);
        }
        catch (Throwable ex) {
            this.checkException(ex);
            return null;
        }
    }

    @Override
    public TWriteResult putIfVersion(String tableName, TRow row, ByteBuffer matchVersion, TWriteOptions writeOptions) throws TDurabilityException, TRequestTimeoutException, TFaultException, TIllegalArgumentException, TProxyException, TException {
        try {
            if (this.verbose) {
                this.debug("PS: putIfVersion( " + tableName + ", " + row + ", " + writeOptions + ")");
            }
            Table t = this.getTable(tableName);
            if (row == null) {
                throw new IllegalArgumentException("Null is not a valid row value.");
            }
            String jsonRow = row.getJsonRow();
            Row r = t.createRowFromJson(jsonRow, false);
            ReturnRow prevRow = t.createReturnRow(ONDBHandler.getReturnRowChoice(writeOptions));
            Version v = this.tableAPI.putIfVersion(r, ONDBHandler.getVersion(matchVersion), prevRow, ONDBHandler.getWriteOptions(writeOptions));
            ByteBuffer bbCurrentVersion = null;
            if (v != null) {
                bbCurrentVersion = ByteBuffer.wrap(v.toByteArray());
            }
            ByteBuffer bbPrevVersion = ONDBHandler.getBBVersion(prevRow.getVersion());
            TRow tPrevRow = new TRow();
            tPrevRow.setJsonRow(prevRow.toJsonString(false));
            return new TWriteResult(bbCurrentVersion, tPrevRow, bbPrevVersion, false);
        }
        catch (Throwable ex) {
            this.checkException(ex);
            return null;
        }
    }

    private Table getTable(String tableName) {
        TableImpl t = this.tableCache.getTable(tableName);
        if (t == null) {
            throw new IllegalArgumentException("Not a valid table name: " + tableName);
        }
        return t;
    }

    @Override
    public synchronized void refreshTables() throws TFaultException, TProxyException, TException {
        try {
            this.tableCache = ((TableAPIImpl)this.tableAPI).getTableMetadata();
        }
        catch (Throwable ex) {
            this.checkException(ex);
        }
    }

    @Override
    public TStatementResult executeSync(String statement) throws TFaultException, TIllegalArgumentException, TProxyException, TException {
        if (this.verbose) {
            this.debug("PS: executeSync( " + statement + ")");
        }
        try {
            StatementResult sr = this.tableAPI.executeSync(statement);
            return ONDBHandler.getTStatementResult(sr);
        }
        catch (Throwable ex) {
            this.checkException(ex);
            return null;
        }
    }

    @Override
    public TStatementResult execute(String statement) throws TFaultException, TIllegalArgumentException, TIllegalArgumentException, TProxyException, TException {
        if (this.verbose) {
            this.debug("PS: execute( " + statement + ")");
        }
        try {
            ExecutionFuture ef = this.tableAPI.execute(statement);
            return ONDBHandler.getTStatementResult(ef.getLastStatus());
        }
        catch (Throwable ex) {
            this.checkException(ex);
            return null;
        }
    }

    @Override
    public boolean executionFutureCancel(int planId, boolean mayInterruptIfRunning) throws TFaultException, TIllegalArgumentException, TProxyException, TException {
        if (this.verbose) {
            this.debug("PS: executionFutureCancel( " + planId + ", " + mayInterruptIfRunning + ")");
        }
        try {
            ExecutionFuture ef = this.tableAPI.getFuture(planId);
            return ef.cancel(mayInterruptIfRunning);
        }
        catch (Throwable ex) {
            this.checkException(ex);
            return false;
        }
    }

    @Override
    public TStatementResult executionFutureGet(int planId) throws TFaultException, TIllegalArgumentException, TProxyException, TCancellationException, TExecutionException, TInterruptedException, TException {
        if (this.verbose) {
            this.debug("PS: executionFutureGet( " + planId + ")");
        }
        try {
            ExecutionFuture ef = this.tableAPI.getFuture(planId);
            StatementResult sr = ef.get();
            return ONDBHandler.getTStatementResult(sr);
        }
        catch (Throwable ex) {
            this.checkException(ex);
            return null;
        }
    }

    @Override
    public TStatementResult executionFutureGetTimeout(int planId, long timeoutMs) throws TFaultException, TIllegalArgumentException, TProxyException, TInterruptedException, TTimeoutException, TExecutionException, TException {
        if (this.verbose) {
            this.debug("PS: executionFutureGetTimeout( " + planId + "," + ", " + timeoutMs + ")");
        }
        try {
            ExecutionFuture ef = this.tableAPI.getFuture(planId);
            StatementResult sr = ef.get(timeoutMs, TimeUnit.MILLISECONDS);
            return ONDBHandler.getTStatementResult(sr);
        }
        catch (Throwable ex) {
            this.checkException(ex);
            return null;
        }
    }

    @Override
    public TStatementResult executionFutureUpdateStatus(int planId) throws TFaultException, TIllegalArgumentException, TProxyException, TException {
        if (this.verbose) {
            this.debug("PS: executionFutureUpdateStatus( " + planId + ")");
        }
        try {
            ExecutionFuture ef = this.tableAPI.getFuture(planId);
            StatementResult sr = ef.updateStatus();
            return ONDBHandler.getTStatementResult(sr);
        }
        catch (Throwable ex) {
            this.checkException(ex);
            return null;
        }
    }

    @Override
    public List<TWriteResult> executeUpdates(List<TOperation> operations, TWriteOptions writeOptions) throws TDurabilityException, TTableOpExecutionException, TFaultException, TIllegalArgumentException, TProxyException, TException {
        try {
            if (this.verbose) {
                this.debug("PS: executeUpdates( " + operations + ", " + writeOptions + ")");
            }
            if (operations == null) {
                return new ArrayList<TWriteResult>();
            }
            ArrayList<TableOperation> tops = new ArrayList<TableOperation>();
            WriteOptions wo = ONDBHandler.getWriteOptions(writeOptions);
            TableOperationFactory factory = this.tableAPI.getTableOperationFactory();
            block10: for (TOperation op : operations) {
                if (op == null) {
                    tops.add(null);
                    continue;
                }
                Table table = this.getTable(op.getTableName());
                switch (op.getType()) {
                    case PUT: {
                        Row r1 = table.createRowFromJson(op.getRow().getJsonRow(), false);
                        tops.add(factory.createPut(r1, this.getChoice(op.getReturnChoice()), op.isAbortIfUnsuccessful()));
                        continue block10;
                    }
                    case PUT_IF_ABSENT: {
                        Row r2 = table.createRowFromJson(op.getRow().getJsonRow(), false);
                        tops.add(factory.createPutIfAbsent(r2, this.getChoice(op.getReturnChoice()), op.isAbortIfUnsuccessful()));
                        continue block10;
                    }
                    case PUT_IF_PRESENT: {
                        Row r3 = table.createRowFromJson(op.getRow().getJsonRow(), false);
                        tops.add(factory.createPutIfPresent(r3, this.getChoice(op.getReturnChoice()), op.isAbortIfUnsuccessful()));
                        continue block10;
                    }
                    case PUT_IF_VERSION: {
                        Row r4 = table.createRowFromJson(op.getRow().getJsonRow(), false);
                        tops.add(factory.createPutIfVersion(r4, Version.fromByteArray((byte[])op.getMatchVersion()), this.getChoice(op.getReturnChoice()), op.isAbortIfUnsuccessful()));
                        continue block10;
                    }
                    case DELETE: {
                        PrimaryKey k1 = table.createPrimaryKeyFromJson(op.getRow().getJsonRow(), false);
                        tops.add(factory.createDelete(k1, this.getChoice(op.getReturnChoice()), op.isAbortIfUnsuccessful()));
                        continue block10;
                    }
                    case DELETE_IF_VERSION: {
                        PrimaryKey k2 = table.createPrimaryKeyFromJson(op.getRow().getJsonRow(), false);
                        tops.add(factory.createDeleteIfVersion(k2, Version.fromByteArray((byte[])op.getMatchVersion()), this.getChoice(op.getReturnChoice()), op.isAbortIfUnsuccessful()));
                        continue block10;
                    }
                }
                throw new IllegalStateException("Unknown TUpdateOperationType: " + (Object)((Object)op.getType()));
            }
            List execResults = this.tableAPI.execute(tops, wo);
            ArrayList<TWriteResult> results = new ArrayList<TWriteResult>();
            for (int i = 0; i < execResults.size(); ++i) {
                TableOperationResult r = (TableOperationResult)execResults.get(i);
                TRow tPrevRow = null;
                if (r.getPreviousRow() != null) {
                    tPrevRow = new TRow(r.getPreviousRow().toJsonString(false));
                }
                ByteBuffer newVer = null;
                TOperationType t = operations.get(i).getType();
                if (!TOperationType.DELETE.equals((Object)t) && !TOperationType.DELETE_IF_VERSION.equals((Object)t)) {
                    newVer = ONDBHandler.getBBVersion(r.getNewVersion());
                }
                results.add(new TWriteResult(newVer, tPrevRow, ONDBHandler.getBBVersion(r.getPreviousVersion()), r.getSuccess()));
            }
            return results;
        }
        catch (Throwable ex) {
            this.checkException(ex);
            return null;
        }
    }

    private TOperation getTOperation(TableOperation tableOp) {
        if (tableOp == null) {
            return null;
        }
        Row row = tableOp.getRow();
        TRow tRowRes = null;
        if (row != null) {
            tRowRes = new TRow();
            tRowRes.setJsonRow(row.toJsonString(false));
        }
        ByteBuffer bb = ONDBHandler.getBBVersion(row.getVersion());
        TReturnChoice returnChoice = TReturnChoice.NONE;
        if (bb != null && tRowRes != null) {
            returnChoice = TReturnChoice.ALL;
        } else if (bb != null) {
            returnChoice = TReturnChoice.VERSION;
        } else if (tRowRes != null) {
            returnChoice = TReturnChoice.VALUE;
        }
        TOperation res = new TOperation(row.getTable().getName(), this.getTOperationType(tableOp.getType()), tRowRes, returnChoice, tableOp.getAbortIfUnsuccessful());
        res.setMatchVersion(bb);
        return res;
    }

    private TOperationType getTOperationType(TableOperation.Type operationType) {
        if (operationType == null) {
            return null;
        }
        switch (operationType) {
            case PUT: {
                return TOperationType.PUT;
            }
            case PUT_IF_ABSENT: {
                return TOperationType.PUT_IF_ABSENT;
            }
            case PUT_IF_PRESENT: {
                return TOperationType.PUT_IF_PRESENT;
            }
            case PUT_IF_VERSION: {
                return TOperationType.PUT_IF_VERSION;
            }
            case DELETE: {
                return TOperationType.DELETE;
            }
            case DELETE_IF_VERSION: {
                return TOperationType.DELETE_IF_VERSION;
            }
        }
        throw new IllegalStateException("Unknown Operation.Type: " + operationType);
    }

    private TWriteResult getTWriteResult(TableOperationResult tableOpRes) {
        TRow tPrevRow = null;
        if (tableOpRes.getPreviousRow() != null) {
            tPrevRow = new TRow();
            tPrevRow.setJsonRow(tableOpRes.getPreviousRow().toJsonString(false));
        }
        return new TWriteResult(ONDBHandler.getBBVersion(tableOpRes.getNewVersion()), tPrevRow, ONDBHandler.getBBVersion(tableOpRes.getPreviousVersion()), tableOpRes.getSuccess());
    }

    private ReturnRow.Choice getChoice(TReturnChoice returnChoice) {
        if (returnChoice == null) {
            return null;
        }
        switch (returnChoice) {
            case ALL: {
                return ReturnRow.Choice.ALL;
            }
            case NONE: {
                return ReturnRow.Choice.NONE;
            }
            case VALUE: {
                return ReturnRow.Choice.VALUE;
            }
            case VERSION: {
                return ReturnRow.Choice.VERSION;
            }
        }
        throw new IllegalStateException("Unknown returnChoice value: " + (Object)((Object)returnChoice));
    }

    @Override
    public TGetResult get(String tableName, TRow key, TReadOptions readOptions) throws TConsistencyException, TRequestTimeoutException, TFaultException, TIllegalArgumentException, TProxyException, TException {
        try {
            if (this.verbose) {
                this.debug("PS: get( " + tableName + ", " + key + ", " + "" + readOptions + ")");
            }
            Table t = this.getTable(tableName);
            if (key == null) {
                throw new IllegalArgumentException("Null is not a valid key value.");
            }
            PrimaryKey pk = t.createPrimaryKeyFromJson(key.getJsonRow(), false);
            Row resRow = this.tableAPI.get(pk, ONDBHandler.getReadOptions(readOptions));
            TRow tRowRes = null;
            ByteBuffer tRowVersion = null;
            if (resRow != null) {
                tRowRes = new TRow();
                tRowRes.setJsonRow(resRow.toJsonString(false));
                tRowVersion = ByteBuffer.wrap(resRow.getVersion().toByteArray());
            }
            return new TGetResult(tRowRes, tRowVersion);
        }
        catch (Throwable ex) {
            this.checkException(ex);
            return null;
        }
    }

    private void debug(String s) {
        if (this.kvProxy.getOptions().isVerbose()) {
            this.logger.info(s);
        }
    }

    @Override
    public TWriteResult deleteRow(String tableName, TRow key, TWriteOptions writeOptions) throws TDurabilityException, TRequestTimeoutException, TFaultException, TIllegalArgumentException, TProxyException, TException {
        try {
            this.debug("PS: deleteRow( " + tableName + ", " + key + ", " + writeOptions + ")");
            Table t = this.getTable(tableName);
            if (key == null) {
                throw new IllegalArgumentException("Null is not a valid key value.");
            }
            String jsonKey = key.getJsonRow();
            PrimaryKey pk = t.createPrimaryKeyFromJson(jsonKey, false);
            ReturnRow prevRow = t.createReturnRow(ONDBHandler.getReturnRowChoice(writeOptions));
            boolean wasDeleted = this.tableAPI.delete(pk, prevRow, ONDBHandler.getWriteOptions(writeOptions));
            ByteBuffer bbPrevVersion = ONDBHandler.getBBVersion(prevRow.getVersion());
            TRow tPrevRow = new TRow();
            tPrevRow.setJsonRow(prevRow.toJsonString(false));
            return new TWriteResult(null, tPrevRow, bbPrevVersion, wasDeleted);
        }
        catch (Throwable ex) {
            this.checkException(ex);
            return null;
        }
    }

    @Override
    public TWriteResult deleteRowIfVersion(String tableName, TRow key, ByteBuffer matchVersion, TWriteOptions writeOptions) throws TDurabilityException, TRequestTimeoutException, TFaultException, TIllegalArgumentException, TProxyException, TException {
        try {
            this.debug("PS: deleteRowIfVersion( " + tableName + ", " + key + ", " + matchVersion + ", " + writeOptions + ")");
            Table t = this.getTable(tableName);
            if (key == null) {
                throw new IllegalArgumentException("Null is not a valid row value.");
            }
            String jsonKey = key.getJsonRow();
            PrimaryKey pk = t.createPrimaryKeyFromJson(jsonKey, false);
            ReturnRow prevRow = t.createReturnRow(ONDBHandler.getReturnRowChoice(writeOptions));
            boolean wasDeleted = this.tableAPI.deleteIfVersion(pk, ONDBHandler.getVersion(matchVersion), prevRow, ONDBHandler.getWriteOptions(writeOptions));
            ByteBuffer bbPrevVersion = ONDBHandler.getBBVersion(prevRow.getVersion());
            TRow tPrevRow = new TRow();
            tPrevRow.setJsonRow(prevRow.toJsonString(false));
            return new TWriteResult(null, tPrevRow, bbPrevVersion, wasDeleted);
        }
        catch (Throwable ex) {
            this.checkException(ex);
            return null;
        }
    }

    @Override
    public int multiDelete(String tableName, TRow tKey, TFieldRange tFieldRange, List<String> includedTables, TWriteOptions tWriteOptions) throws TDurabilityException, TRequestTimeoutException, TFaultException, TIllegalArgumentException, TProxyException, TException {
        try {
            this.debug("PS: multiDelete( " + tableName + ", " + "" + tKey + ", " + tFieldRange + ", " + includedTables + ", " + "" + tWriteOptions + ")");
            Table t = this.getTable(tableName);
            if (tKey == null) {
                throw new IllegalArgumentException("Null is not a valid key value.");
            }
            String jsonKey = tKey.getJsonRow();
            PrimaryKey pk = t.createPrimaryKeyFromJson(jsonKey, false);
            MultiRowOptions multiRowOptions = ONDBHandler.getMultiRowOptions(t, tFieldRange, includedTables, null);
            int result = this.tableAPI.multiDelete(pk, multiRowOptions, ONDBHandler.getWriteOptions(tWriteOptions));
            return result;
        }
        catch (Throwable ex) {
            this.checkException(ex);
            return -1;
        }
    }

    @Override
    public TMultiGetResult multiGet(String tableName, TRow tKey, TFieldRange tFieldRange, List<String> includedTables, TReadOptions tReadOptions) throws TConsistencyException, TRequestTimeoutException, TFaultException, TIllegalArgumentException, TProxyException, TException {
        try {
            this.debug("PS: multiGet( " + tableName + ", " + "" + tKey + ", " + tFieldRange + ", " + includedTables + ", " + "" + tReadOptions + ")");
            Table t = this.getTable(tableName);
            if (tKey == null) {
                throw new IllegalArgumentException("Key cannot be null");
            }
            String jsonKey = tKey.getJsonRow();
            PrimaryKey pk = t.createPrimaryKeyFromJson(jsonKey, false);
            MultiRowOptions multiRowOptions = ONDBHandler.getMultiRowOptions(t, tFieldRange, includedTables, null);
            List rows = this.tableAPI.multiGet(pk, multiRowOptions, ONDBHandler.getReadOptions(tReadOptions));
            ArrayList<TRowAndMetadata> rowsAndMetadata = new ArrayList<TRowAndMetadata>();
            HashMap<Integer, String> idToTableNames = new HashMap<Integer, String>();
            HashMap<String, Integer> nameToTableIds = new HashMap<String, Integer>();
            int counter = 1;
            for (Row row : rows) {
                String json = row.toJsonString(false);
                ByteBuffer v = ONDBHandler.getBBVersion(row.getVersion());
                String rowTableName = row.getTable().getFullName();
                Integer tableId = (Integer)nameToTableIds.get(rowTableName);
                if (tableId == null) {
                    tableId = counter++;
                    nameToTableIds.put(rowTableName, tableId);
                    idToTableNames.put(tableId, rowTableName);
                }
                rowsAndMetadata.add(new TRowAndMetadata(json, v, tableId));
            }
            return new TMultiGetResult(idToTableNames, rowsAndMetadata);
        }
        catch (Throwable ex) {
            this.checkException(ex);
            return null;
        }
    }

    @Override
    public TMultiGetResult multiGetKeys(String tableName, TRow tKey, TFieldRange tFieldRange, List<String> includedTables, TReadOptions readOptions) throws TConsistencyException, TRequestTimeoutException, TFaultException, TIllegalArgumentException, TProxyException, TException {
        try {
            this.debug("PS: multiGetKeys( " + tableName + ", " + "" + tKey + ", " + tFieldRange + ", " + includedTables + ", " + "" + readOptions + ")");
            Table t = this.getTable(tableName);
            if (tKey == null) {
                throw new IllegalArgumentException("Key cannot be null");
            }
            String jsonKey = tKey.getJsonRow();
            PrimaryKey pk = t.createPrimaryKeyFromJson(jsonKey, false);
            MultiRowOptions multiRowOptions = ONDBHandler.getMultiRowOptions(t, tFieldRange, includedTables, null);
            List rows = this.tableAPI.multiGetKeys(pk, multiRowOptions, ONDBHandler.getReadOptions(readOptions));
            ArrayList<TRowAndMetadata> rowsAndMetadata = new ArrayList<TRowAndMetadata>();
            HashMap<Integer, String> idToTableNames = new HashMap<Integer, String>();
            HashMap<String, Integer> nameToTableIds = new HashMap<String, Integer>();
            int counter = 1;
            for (Row row : rows) {
                String json = row.toJsonString(false);
                ByteBuffer v = ONDBHandler.getBBVersion(row.getVersion());
                String rowTableName = row.getTable().getFullName();
                Integer tableId = (Integer)nameToTableIds.get(rowTableName);
                if (tableId == null) {
                    tableId = counter++;
                    nameToTableIds.put(rowTableName, tableId);
                    idToTableNames.put(tableId, rowTableName);
                }
                rowsAndMetadata.add(new TRowAndMetadata(json, v, tableId));
            }
            return new TMultiGetResult(idToTableNames, rowsAndMetadata);
        }
        catch (Throwable ex) {
            this.checkException(ex);
            return null;
        }
    }

    @Override
    public TIteratorResult tableIterator(String tableName, TRow tKey, TFieldRange tFieldRange, List<String> includedTables, TReadOptions tReadOptions, TDirection tDirection, long maxResults) throws TConsistencyException, TRequestTimeoutException, TFaultException, TIllegalArgumentException, TProxyException, TException {
        try {
            PrimaryKey pk;
            this.debug("PS: tableIterator( " + tableName + ", " + "" + tKey + ", " + tFieldRange + ", " + includedTables + ", " + "" + tReadOptions + ", " + maxResults + ")");
            long max = this.getMax(maxResults);
            Table t = this.getTable(tableName);
            if (tKey == null || tKey.getJsonRow() == null) {
                pk = t.createPrimaryKey();
            } else {
                String jsonKey = tKey.getJsonRow();
                pk = t.createPrimaryKeyFromJson(jsonKey, false);
            }
            MultiRowOptions multiRowOptions = ONDBHandler.getMultiRowOptions(t, tFieldRange, includedTables, null);
            TableIterator iter = this.tableAPI.tableIterator(pk, multiRowOptions, ONDBHandler.getIteratorOptions(tReadOptions, tDirection));
            if (iter == null) {
                return null;
            }
            long i = 0L;
            int counter = 1;
            ArrayList<TRowAndMetadata> rowsAndMetadata = new ArrayList<TRowAndMetadata>();
            HashMap<Integer, String> idToTableNames = new HashMap<Integer, String>();
            HashMap<String, Integer> nameToTableIds = new HashMap<String, Integer>();
            while (i++ < max && iter.hasNext()) {
                Row row = (Row)iter.next();
                String json = row.toJsonString(false);
                ByteBuffer v = ONDBHandler.getBBVersion(row.getVersion());
                String rowTableName = row.getTable().getFullName();
                Integer tableId = (Integer)nameToTableIds.get(rowTableName);
                if (tableId == null) {
                    tableId = counter++;
                    nameToTableIds.put(rowTableName, tableId);
                    idToTableNames.put(tableId, rowTableName);
                }
                rowsAndMetadata.add(new TRowAndMetadata(json, v, tableId));
            }
            TMultiGetResult multiGetResult = new TMultiGetResult(idToTableNames, rowsAndMetadata);
            long iterId = iteratorManager.getNewIteratorId(iter, max);
            TIteratorResult res = new TIteratorResult(iterId, multiGetResult, iter.hasNext());
            if (!iter.hasNext()) {
                iteratorManager.closeIterator(iterId);
            }
            return res;
        }
        catch (Throwable ex) {
            this.checkException(ex);
            return null;
        }
    }

    private long getMax(long maxResults) {
        return maxResults < 1L || maxResults > this.kvProxy.getOptions().getMaxIteratorResults() ? this.kvProxy.getOptions().getMaxIteratorResults() : maxResults;
    }

    @Override
    public TIteratorResult iteratorNext(long iteratorId) throws TConsistencyException, TRequestTimeoutException, TFaultException, TIteratorTimeoutException, TIllegalArgumentException, TProxyException, TException {
        try {
            this.debug("PS: iteratorNext (" + iteratorId + ")");
            TableIterator<?> iter = iteratorManager.getIterator(iteratorId);
            assert (iter != null) : "iteratorManager.getIterator should never return null.";
            long i = 0L;
            int counter = 1;
            ArrayList<TRowAndMetadata> rowsAndMetadata = new ArrayList<TRowAndMetadata>();
            HashMap<Integer, String> idToTableNames = new HashMap<Integer, String>();
            HashMap<String, Integer> nameToTableIds = new HashMap<String, Integer>();
            long max = iteratorManager.getMaxResults(iteratorId);
            while (i++ < max && iter.hasNext()) {
                String rowTableName;
                ByteBuffer v;
                String json;
                Object obj = iter.next();
                if (obj instanceof Row) {
                    Row row = (Row)obj;
                    json = row.toJsonString(false);
                    v = ONDBHandler.getBBVersion(row.getVersion());
                    rowTableName = row.getTable().getFullName();
                } else if (obj instanceof KeyPair) {
                    KeyPair keyPair = (KeyPair)obj;
                    IndexKey ik = keyPair.getIndexKey();
                    PrimaryKey pk = keyPair.getPrimaryKey();
                    Row r = ONDBHandler.mergeKeys(pk, ik);
                    json = r.toJsonString(false);
                    v = ONDBHandler.getBBVersion(pk.getVersion());
                    rowTableName = r.getTable().getFullName();
                } else {
                    throw new IllegalStateException("Object of unexpected instance: " + obj.getClass().getName());
                }
                Integer tableId = (Integer)nameToTableIds.get(rowTableName);
                if (tableId == null) {
                    tableId = counter++;
                    nameToTableIds.put(rowTableName, tableId);
                    idToTableNames.put(tableId, rowTableName);
                }
                rowsAndMetadata.add(new TRowAndMetadata(json, v, tableId));
            }
            TMultiGetResult multiGetResult = new TMultiGetResult(idToTableNames, rowsAndMetadata);
            TIteratorResult res = new TIteratorResult(iteratorId, multiGetResult, iter.hasNext());
            iteratorManager.touch(iteratorId);
            if (!iter.hasNext()) {
                iteratorManager.closeIterator(iteratorId);
            }
            return res;
        }
        catch (Throwable ex) {
            this.checkException(ex);
            return null;
        }
    }

    @Override
    public void iteratorClose(long iteratorId) throws TException {
        try {
            this.debug("PS: iteratorClose( " + iteratorId + ")");
            iteratorManager.closeIterator(iteratorId);
        }
        catch (Throwable ex) {
            this.checkException(ex);
        }
    }

    @Override
    public TIteratorResult tableKeyIterator(String tableName, TRow tKey, TFieldRange tFieldRange, List<String> includedTables, TReadOptions tReadOptions, TDirection tDirection, long maxResults) throws TConsistencyException, TRequestTimeoutException, TFaultException, TIllegalArgumentException, TProxyException, TException {
        try {
            PrimaryKey pk;
            this.debug("PS: tableKeyIterator( " + tableName + ", " + "" + tKey + ", " + tFieldRange + ", " + includedTables + ", " + "" + tReadOptions + ", " + maxResults + ")");
            long max = this.getMax(maxResults);
            Table t = this.getTable(tableName);
            if (tKey == null || tKey.getJsonRow() == null) {
                pk = t.createPrimaryKey();
            } else {
                String jsonKey = tKey.getJsonRow();
                pk = t.createPrimaryKeyFromJson(jsonKey, false);
            }
            MultiRowOptions multiRowOptions = ONDBHandler.getMultiRowOptions(t, tFieldRange, includedTables, null);
            TableIterator iter = this.tableAPI.tableKeysIterator(pk, multiRowOptions, ONDBHandler.getIteratorOptions(tReadOptions, tDirection));
            assert (iter != null) : "tableAPI.tableKeysIterator should never return null.";
            long i = 0L;
            int counter = 1;
            ArrayList<TRowAndMetadata> rowsAndMetadata = new ArrayList<TRowAndMetadata>();
            HashMap<Integer, String> idToTableNames = new HashMap<Integer, String>();
            HashMap<String, Integer> nameToTableIds = new HashMap<String, Integer>();
            while (i++ < max && iter.hasNext()) {
                PrimaryKey row = (PrimaryKey)iter.next();
                String json = row.toJsonString(false);
                ByteBuffer v = ONDBHandler.getBBVersion(row.getVersion());
                String rowTableName = row.getTable().getFullName();
                Integer tableId = (Integer)nameToTableIds.get(rowTableName);
                if (tableId == null) {
                    tableId = counter++;
                    nameToTableIds.put(rowTableName, tableId);
                    idToTableNames.put(tableId, rowTableName);
                }
                rowsAndMetadata.add(new TRowAndMetadata(json, v, tableId));
            }
            TMultiGetResult multiGetResult = new TMultiGetResult(idToTableNames, rowsAndMetadata);
            long iterId = iteratorManager.getNewIteratorId(iter, max);
            TIteratorResult res = new TIteratorResult(iterId, multiGetResult, iter.hasNext());
            if (!iter.hasNext()) {
                iteratorManager.closeIterator(iterId);
            }
            return res;
        }
        catch (Throwable ex) {
            this.checkException(ex);
            return null;
        }
    }

    @Override
    public TIteratorResult indexIterator(String tableName, String indexName, TRow tKey, TFieldRange tFieldRange, List<String> includedTables, TReadOptions tReadOptions, TDirection tDirection, long maxResults) throws TConsistencyException, TRequestTimeoutException, TFaultException, TIllegalArgumentException, TProxyException, TException {
        try {
            IndexKey indexKey;
            this.debug("PS: indexIterator( " + tableName + ", " + indexName + ", " + "" + tKey + ", " + tFieldRange + ", " + includedTables + ", " + "" + tReadOptions + ", " + maxResults + ")");
            long max = this.getMax(maxResults);
            Table t = this.getTable(tableName);
            Index index = t.getIndex(indexName);
            if (index == null) {
                throw new IllegalArgumentException("Not a valid index name: " + indexName);
            }
            if (tKey == null || tKey.getJsonRow() == null) {
                indexKey = index.createIndexKey();
            } else {
                String jsonKey = tKey.getJsonRow();
                indexKey = index.createIndexKeyFromJson(jsonKey, false);
            }
            MultiRowOptions multiRowOptions = ONDBHandler.getMultiRowOptions(t, tFieldRange, includedTables, index);
            TableIterator iter = this.tableAPI.tableIterator(indexKey, multiRowOptions, ONDBHandler.getIteratorOptions(tReadOptions, tDirection));
            assert (iter != null) : "tableAPI.tableIterator should never return null.";
            long i = 0L;
            int counter = 1;
            ArrayList<TRowAndMetadata> rowsAndMetadata = new ArrayList<TRowAndMetadata>();
            HashMap<Integer, String> idToTableNames = new HashMap<Integer, String>();
            HashMap<String, Integer> nameToTableIds = new HashMap<String, Integer>();
            while (i++ < max && iter.hasNext()) {
                Row row = (Row)iter.next();
                String json = row.toJsonString(false);
                ByteBuffer v = ONDBHandler.getBBVersion(row.getVersion());
                String rowTableName = row.getTable().getFullName();
                Integer tableId = (Integer)nameToTableIds.get(rowTableName);
                if (tableId == null) {
                    tableId = counter++;
                    nameToTableIds.put(rowTableName, tableId);
                    idToTableNames.put(tableId, rowTableName);
                }
                rowsAndMetadata.add(new TRowAndMetadata(json, v, tableId));
            }
            TMultiGetResult multiGetResult = new TMultiGetResult(idToTableNames, rowsAndMetadata);
            long iterId = iteratorManager.getNewIteratorId(iter, max);
            TIteratorResult res = new TIteratorResult(iterId, multiGetResult, iter.hasNext());
            if (!iter.hasNext()) {
                iteratorManager.closeIterator(iterId);
            }
            return res;
        }
        catch (Throwable ex) {
            this.checkException(ex);
            return null;
        }
    }

    @Override
    public TIteratorResult indexKeyIterator(String tableName, String indexName, TRow tKey, TFieldRange tFieldRange, List<String> includedTables, TReadOptions tReadOptions, TDirection tDirection, long maxResults) throws TConsistencyException, TRequestTimeoutException, TFaultException, TIllegalArgumentException, TProxyException, TException {
        try {
            IndexKey indexKey;
            this.debug("PS: indexKeyIterator( " + tableName + ", " + indexName + ", " + tKey + ", " + tFieldRange + ", " + includedTables + ", " + tReadOptions + ", " + maxResults + ")");
            long max = this.getMax(maxResults);
            Table t = this.getTable(tableName);
            Index index = t.getIndex(indexName);
            if (index == null) {
                throw new IllegalArgumentException("Not a valid index name: " + indexName);
            }
            if (tKey == null || tKey.getJsonRow() == null) {
                indexKey = index.createIndexKey();
            } else {
                String jsonKey = tKey.getJsonRow();
                indexKey = index.createIndexKeyFromJson(jsonKey, false);
            }
            MultiRowOptions multiRowOptions = ONDBHandler.getMultiRowOptions(t, tFieldRange, includedTables, index);
            TableIterator iter = this.tableAPI.tableKeysIterator(indexKey, multiRowOptions, ONDBHandler.getIteratorOptions(tReadOptions, tDirection));
            assert (iter != null) : "tableAPI.tableKeysIterator should never return null.";
            long i = 0L;
            int counter = 1;
            ArrayList<TRowAndMetadata> rowsAndMetadata = new ArrayList<TRowAndMetadata>();
            HashMap<Integer, String> idToTableNames = new HashMap<Integer, String>();
            HashMap<String, Integer> nameToTableIds = new HashMap<String, Integer>();
            while (i++ < max && iter.hasNext()) {
                KeyPair keyPair = (KeyPair)iter.next();
                IndexKey ik = keyPair.getIndexKey();
                PrimaryKey pk = keyPair.getPrimaryKey();
                Row r = ONDBHandler.mergeKeys(pk, ik);
                String json = r.toJsonString(false);
                ByteBuffer v = ONDBHandler.getBBVersion(pk.getVersion());
                String rowTableName = r.getTable().getFullName();
                Integer tableId = (Integer)nameToTableIds.get(rowTableName);
                if (tableId == null) {
                    tableId = counter++;
                    nameToTableIds.put(rowTableName, tableId);
                    idToTableNames.put(tableId, rowTableName);
                }
                rowsAndMetadata.add(new TRowAndMetadata(json, v, tableId));
            }
            TMultiGetResult multiGetResult = new TMultiGetResult(idToTableNames, rowsAndMetadata);
            long iterId = iteratorManager.getNewIteratorId(iter, max);
            TIteratorResult res = new TIteratorResult(iterId, multiGetResult, iter.hasNext());
            if (!iter.hasNext()) {
                iteratorManager.closeIterator(iterId);
            }
            return res;
        }
        catch (Throwable ex) {
            this.checkException(ex);
            return null;
        }
    }

    private void checkException(Throwable ex) throws TDurabilityException, TRequestTimeoutException, TFaultException, TIllegalArgumentException, TProxyException, TCancellationException, TExecutionException, TInterruptedException, TTimeoutException, TTableOpExecutionException, TConsistencyException, TIteratorTimeoutException, TRequestLimitException, TAuthenticationFailureException, TAuthenticationRequiredException, TUnauthorizedException {
        try {
            throw ex;
        }
        catch (ConsistencyException ce) {
            throw new TConsistencyException(ONDBHandler.getTConsistency(ce.getConsistency()), ce.getMessage());
        }
        catch (DurabilityException de) {
            throw new TDurabilityException(new ArrayList<String>(de.getAvailableReplicas()), ONDBHandler.getTReplicaAckPolicy(de.getCommitPolicy()), de.getRequiredNodeCount(), de.getMessage());
        }
        catch (RequestTimeoutException rte) {
            throw new TRequestTimeoutException(rte.getMessage(), rte.getTimeoutMs());
        }
        catch (RequestLimitException rle) {
            throw new TRequestLimitException(rle.getMessage());
        }
        catch (AuthenticationFailureException afe) {
            throw new TAuthenticationFailureException(afe.getMessage());
        }
        catch (AuthenticationRequiredException are) {
            throw new TAuthenticationRequiredException(are.getMessage());
        }
        catch (UnauthorizedException ae) {
            throw new TUnauthorizedException(ae.getMessage());
        }
        catch (FaultException fe) {
            this.logger.info("FaultException: " + (Object)((Object)fe));
            throw new TFaultException(fe.getFaultClassName(), fe.getRemoteStackTrace(), fe.wasLoggedRemotely(), fe.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new TIllegalArgumentException(iae.getMessage());
        }
        catch (CancellationException ce) {
            throw new TCancellationException(ce.getMessage());
        }
        catch (ExecutionException ee) {
            throw new TExecutionException(ee.getMessage());
        }
        catch (InterruptedException ie) {
            throw new TInterruptedException(ie.getMessage());
        }
        catch (IteratorTimeoutException ite) {
            this.logger.warning("IteratorTimeoutException: " + ite.getMessage() + "\n" + ite);
            throw new TIteratorTimeoutException(ite.getMessage());
        }
        catch (TimeoutException te) {
            throw new TTimeoutException(te.getMessage());
        }
        catch (TableOpExecutionException toee) {
            throw new TTableOpExecutionException(this.getTOperation(toee.getFailedOperation()), toee.getFailedOperationIndex(), this.getTWriteResult(toee.getFailedOperationResult()), toee.getMessage());
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            this.logger.severe("PS: Exception: " + e.getMessage() + "\n" + sw);
            throw new TProxyException(e.getMessage());
        }
    }
}

