/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.proxy;

public class Options {
    public static final int DEFAULT_PROXY_PORT = 5010;
    private volatile int proxyPortNumber = 5010;
    public static final String DEFAULT_STORE_NAME = "kvstore";
    private volatile String storeName = "kvstore";
    public static final long MAX_ITERATOR_RESULTS = 100L;
    private volatile long maxIteratorResults = 100L;
    public static final long MAX_PORT_NUMBER = 65535L;
    public static final long DEFAULT_ITERATOR_EXPIRATION_INTERVAL = 300000L;
    private volatile long iterExpiration = 300000L;
    public static final int DEFAULT_MAX_OPENED_ITERATORS = 10000;
    private volatile int maxOpenIterators = 10000;
    public static final int DEFAULT_NUM_POOL_THREADS = 20;
    private volatile int numPoolThreads = 20;
    private static final String PORT_FLAG = "-port";
    private static final String STORE_FLAG = "-store";
    private static final String HELPER_HOSTS_FLAG = "-helper-hosts";
    private static final String USAGE_FLAG = "-usage";
    private static final String HELP_FLAG = "-help";
    private static final String HELP2_FLAG = "--help";
    private static final String VERBOSE_FLAG = "-verbose";
    private static final String VERSION_FLAG = "-version";
    private static final String MAX_IT_FLAG = "-max-iterator-results";
    private static final String ITER_EXP_FLAG = "-iterator-expiration";
    private static final String MAX_OPEN_ITERATORS_FLAG = "-max-open-iterators";
    private static final String NO_OF_POOL_THREADS_FLAG = "-num-pool-threads";
    private static final String SECURITY_FLAG = "-security";
    private static final String USERNAME_FLAG = "-username";
    private static final String MAX_ACTIVE_REQUESTS_FLAG = "-max-active-requests";
    private static final String NODE_LIMIT_PERCENT_FLAG = "-node-limit-percent";
    private static final String REQUEST_THRESHOLD_PERCENT_FLAG = "-request-threshold-percent";
    private static final String REQUEST_TIMEOUT_FLAG = "-request-timeout";
    private static final String SOCKET_OPEN_TIMEOUT_FLAG = "-socket-open-timeout";
    private static final String SOCKET_READ_TIMEOUT_FLAG = "-socket-read-timeout";
    private static final String READ_ZONES_FLAG = "-read-zones";
    private volatile String[] helperHosts = null;
    private volatile boolean verbose = false;
    private volatile boolean exit = false;
    private volatile String securityFilePath = null;
    private volatile String username = null;
    private volatile int maxActiveRequests = 100;
    private volatile int nodeLimitPercent = 80;
    private volatile int requestThresholdPercent = 90;
    private volatile long requestTimeout = 5000L;
    private volatile long socketOpenTimeout = 5000L;
    private volatile long socketReadTimeout = 30000L;
    private volatile String[] readZones = null;
    private String[] argArray;
    private int argc;

    Options(String[] args) {
        this.argArray = args;
        this.parseArgs();
    }

    private void parseArgs() {
        this.argc = 0;
        int nArgs = this.argArray.length;
        while (this.argc < nArgs) {
            String thisArg;
            if ((thisArg = this.argArray[this.argc++]).equals(PORT_FLAG)) {
                this.proxyPortNumber = this.nextIntArg(thisArg);
                if (this.proxyPortNumber >= 1 && (long)this.proxyPortNumber <= 65535L) continue;
                throw new IllegalArgumentException("Not a valid value for -port: " + thisArg + ".");
            }
            if (thisArg.equals(USAGE_FLAG) || thisArg.equals(HELP_FLAG) || thisArg.equals(HELP2_FLAG)) {
                this.usage(null);
                continue;
            }
            if (thisArg.equals(VERBOSE_FLAG)) {
                this.verbose = true;
                continue;
            }
            if (thisArg.equals(VERSION_FLAG)) {
                System.out.print("Oracle NoSQL Database Proxy Server 3.2.5");
                this.exit = true;
                continue;
            }
            if (thisArg.equals(STORE_FLAG)) {
                this.storeName = this.nextArg(thisArg);
                continue;
            }
            if (thisArg.equals(HELPER_HOSTS_FLAG)) {
                this.parseHelperHosts(this.nextArg(thisArg));
                continue;
            }
            if (thisArg.equals(MAX_IT_FLAG)) {
                this.maxIteratorResults = this.nextLongArg(thisArg);
                continue;
            }
            if (thisArg.equals(ITER_EXP_FLAG)) {
                this.iterExpiration = this.nextLongArg(thisArg);
                continue;
            }
            if (thisArg.equals(MAX_OPEN_ITERATORS_FLAG)) {
                this.maxOpenIterators = this.nextIntArg(thisArg);
                continue;
            }
            if (thisArg.equals(NO_OF_POOL_THREADS_FLAG)) {
                this.numPoolThreads = this.nextIntArg(thisArg);
                continue;
            }
            if (thisArg.equals(SECURITY_FLAG)) {
                this.securityFilePath = this.nextArg(thisArg);
                continue;
            }
            if (thisArg.equals(USERNAME_FLAG)) {
                this.username = this.nextArg(thisArg);
                continue;
            }
            if (thisArg.equals(MAX_ACTIVE_REQUESTS_FLAG)) {
                this.maxActiveRequests = this.nextIntArg(thisArg);
                continue;
            }
            if (thisArg.equals(NODE_LIMIT_PERCENT_FLAG)) {
                this.nodeLimitPercent = this.nextIntArg(thisArg);
                continue;
            }
            if (thisArg.equals(REQUEST_THRESHOLD_PERCENT_FLAG)) {
                this.requestThresholdPercent = this.nextIntArg(thisArg);
                continue;
            }
            if (thisArg.equals(REQUEST_TIMEOUT_FLAG)) {
                this.requestTimeout = this.nextIntArg(thisArg);
                continue;
            }
            if (thisArg.equals(SOCKET_OPEN_TIMEOUT_FLAG)) {
                this.socketOpenTimeout = this.nextIntArg(thisArg);
                continue;
            }
            if (thisArg.equals(SOCKET_READ_TIMEOUT_FLAG)) {
                this.socketReadTimeout = this.nextIntArg(thisArg);
                continue;
            }
            if (thisArg.equals(READ_ZONES_FLAG)) {
                this.readZones = this.nextStringListArg(thisArg);
                continue;
            }
            this.unknownArg(thisArg);
            this.exit = true;
        }
        this.exit = !this.verifyArgs();
    }

    private String[] nextStringListArg(String arg) {
        String readZonesList = this.nextArg(arg);
        if (readZonesList == null || readZonesList.length() == 0) {
            this.usage("-read-zones param must contain at least one valid zone name.");
        }
        return readZonesList.split(",");
    }

    private void parseHelperHosts(String arg) {
        if (arg == null || arg.length() == 0) {
            this.usage("-helper-hosts param must contain at least one hostName:portNumber pair.");
        }
        this.helperHosts = arg.split(",");
    }

    private String nextArg(String arg) {
        if (this.argc >= this.argArray.length) {
            this.usage("Flag " + arg + " requires an argument.");
        }
        return this.argArray[this.argc++];
    }

    private int nextIntArg(String arg) {
        String next = this.nextArg(arg);
        try {
            return Integer.parseInt(next);
        }
        catch (NumberFormatException e) {
            this.usage("Flag " + arg + " requires an integer argument.");
            return 0;
        }
    }

    private long nextLongArg(String arg) {
        String next = this.nextArg(arg);
        try {
            return Long.parseLong(next);
        }
        catch (NumberFormatException e) {
            this.usage("Flag " + arg + " requires a long argument.");
            return 0L;
        }
    }

    public void usage(String errorMsg) {
        if (errorMsg != null) {
            System.err.println(errorMsg + "\n\n");
        }
        System.out.println("USAGE for Oracle NoSQL Database KVProxy Server 3.2.5\n  -port <port-number> \tPort number of the proxy server. Default: 5010\n  -store <store-name> \tKVStore name. Default: kvstore\n  -helper-hosts <host:port,host:port,...>   Required list of KVStore hosts\n\t  and ports (comma separated).\n  -security <security-file-path>  Identifies the security file used to specify\n\t  properties for login. Required for connecting to a secure store.\n  -username <user>  Identifies the name of the user to login to the secured\n\t  store. Required for connecting to a secure store.\n  -read-zones <zone,zone,...>  List of read zone names.\n  -max-active-requests <int> Maximum number of active requests towards\n\t  the store.\n  -node-limit-percent <int> Limit on the number of requests, as a percentage of\n\t  the requested maximum active requests.\n  -request-threshold-percent <int> Threshold for activating request limiting,\n\t  as a percentage of the requested maximum active requests.\n  -request-timeout <long> Configures the default request timeout in\n\t  milliseconds.\n  -socket-open-timeout <long> Configures the open timeout in milliseconds used\n\t  when establishing sockets to the store.\n  -socket-read-timeout <long> Configures the read timeout in milliseconds\n\t  associated with the underlying sockets to the store.\n  -max-iterator-results <long> A long representing the maximum number of results\n\t  returned in one single iterator call. Default: 100\n  -iterator-expiration <long>  Iterator expiration interval in milliseconds.\n  -max-open-iterators <int>    Maximum concurrent opened iterators.\n\t  Default: 10000\n  -num-pool-threads <int>      Number of proxy threads. Default: 20\n  -help  \tUsage instructions.\n  -version  \tPrint KVProxy server version number.\n  -verbose  \tTurn verbose flag on.\n");
        System.exit(-1);
    }

    private void unknownArg(String arg) {
        this.usage("\nUnknown argument: " + arg);
    }

    private boolean verifyArgs() {
        String msg = "";
        boolean res = true;
        if (this.helperHosts == null || this.helperHosts.length == 0) {
            msg = msg + "\n-helper-hosts is required.";
            res = false;
        }
        if (this.maxIteratorResults < 0L) {
            msg = msg + "\nInvalid value for -max-iterator-results.";
            res = false;
        }
        if (this.iterExpiration < 0L) {
            msg = msg + "\nInvalid value for -iterator-expiration.";
            res = false;
        }
        if (this.maxOpenIterators < 0) {
            msg = msg + "\nInvalid value for -max-open-iterators.";
            res = false;
        }
        if (this.numPoolThreads < 0) {
            msg = msg + "\nInvalid value for -num-pool-threads.";
            res = false;
        }
        if (this.securityFilePath != null && this.securityFilePath.length() == 0) {
            msg = msg + "\nInvalid value for -security.";
            res = false;
        }
        if (this.securityFilePath != null && (this.username == null || this.username.length() == 0)) {
            msg = msg + "\nFlag -username is required when -security is used.";
            res = false;
        }
        if (this.maxActiveRequests < 0) {
            msg = msg + "\nInvalid value for -max-active-requests.";
            res = false;
        }
        if (this.nodeLimitPercent < 0 || this.nodeLimitPercent > 100) {
            msg = msg + "\nInvalid value for -node-limit-percent.";
            res = false;
        }
        if (this.requestThresholdPercent < 0 || this.requestThresholdPercent > 100) {
            msg = msg + "\nInvalid value for -request-threshold-percent.";
            res = false;
        }
        if (this.requestTimeout < 0L) {
            msg = msg + "\nInvalid value for -request-timeout.";
            res = false;
        }
        if (this.socketOpenTimeout < 0L) {
            msg = msg + "\nInvalid value for -socket-open-timeout.";
            res = false;
        }
        if (this.socketReadTimeout < 0L) {
            msg = msg + "\nInvalid value for -socket-read-timeout.";
            res = false;
        }
        if (this.readZones != null) {
            for (int i = 0; i < this.readZones.length; ++i) {
                String readZone = this.readZones[i];
                if (readZone != null && readZone.length() != 0 && !readZone.contains(" ")) continue;
                msg = msg + "\nInvalid value for -read-zones: '" + readZone + "'.";
                res = false;
            }
        }
        if (!res) {
            this.usage(msg);
        }
        return res;
    }

    public int getProxyPortNumber() {
        return this.proxyPortNumber;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public String[] getHelperHosts() {
        return this.helperHosts;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    boolean isExit() {
        return this.exit;
    }

    public String getHelperHostsString() {
        String[] hosts = this.getHelperHosts();
        StringBuilder sb = new StringBuilder();
        for (String h : hosts) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(h);
        }
        return sb.toString();
    }

    public long getMaxIteratorResults() {
        return this.maxIteratorResults;
    }

    public long getIteratorExpiration() {
        return this.iterExpiration;
    }

    public int getMaxOpenIterators() {
        return this.maxOpenIterators;
    }

    public int getNumPoolThreads() {
        return this.numPoolThreads;
    }

    public String getSecurityFilePath() {
        return this.securityFilePath;
    }

    public String getUsername() {
        return this.username;
    }

    public int getMaxActiveRequests() {
        return this.maxActiveRequests;
    }

    public int getNodeLimitPercent() {
        return this.nodeLimitPercent;
    }

    public int getRequestThresholdPercent() {
        return this.requestThresholdPercent;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public long getSocketOpenTimeout() {
        return this.socketOpenTimeout;
    }

    public long getSocketReadTimeout() {
        return this.socketReadTimeout;
    }

    public String[] getReadZones() {
        return this.readZones;
    }
}

