/*
 * Decompiled with CFR 0.152.
 */
package org.ngui;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.BatteryManager;
import android.os.Build;
import android.os.Debug;
import android.os.Process;
import android.telephony.TelephonyManager;
import android.util.Log;
import java.util.List;
import java.util.Locale;
import org.ngui.NGUIActivity;

public class Android {
    private static String TAG = "Ngui";
    private static NGUIActivity activity = null;
    private static int battery_status = 1;
    private static boolean is_ac_power_connected = false;
    private static NGUIActivity.PrivateAPI api = null;
    private static BroadcastReceiver receiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction() == "android.intent.action.BATTERY_CHANGED") {
                Log.d((String)TAG, (String)"ACTION_BATTERY_CHANGED");
                battery_status = intent.getIntExtra("status", 1);
            } else if (intent.getAction() == "android.intent.action.ACTION_POWER_CONNECTED") {
                is_ac_power_connected = true;
                Log.d((String)TAG, (String)"ACTION_POWER_CONNECTED");
            } else {
                Log.d((String)TAG, (String)"ACTION_POWER_DISCONNECTED");
                is_ac_power_connected = false;
            }
        }
    };

    public static void initialize(NGUIActivity nGUIActivity, NGUIActivity.PrivateAPI privateAPI) {
        if (!((Object)((Object)nGUIActivity)).equals((Object)activity)) {
            activity = nGUIActivity;
            api = privateAPI;
            activity.registerReceiver(receiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
            activity.registerReceiver(receiver, new IntentFilter("android.intent.action.ACTION_POWER_CONNECTED"));
            activity.registerReceiver(receiver, new IntentFilter("android.intent.action.ACTION_POWER_DISCONNECTED"));
        }
    }

    public static void uninitialize(NGUIActivity nGUIActivity) {
        if (((Object)((Object)nGUIActivity)).equals((Object)activity)) {
            activity.unregisterReceiver(receiver);
            activity = null;
            api = null;
        }
    }

    private static void ime_keyboard_open(final boolean bl, final int n, final int n2) {
        activity.post(new Runnable(){

            @Override
            public void run() {
                api.ime_keyboard_open(bl, n, n2);
            }
        });
    }

    private static void ime_keyboard_can_backspace(final boolean bl, final boolean bl2) {
        activity.post(new Runnable(){

            @Override
            public void run() {
                api.ime_keyboard_can_backspace(bl, bl2);
            }
        });
    }

    private static void ime_keyboard_close() {
        activity.post(new Runnable(){

            @Override
            public void run() {
                api.ime_keyboard_close();
            }
        });
    }

    private static void keep_screen(final boolean bl) {
        activity.post(new Runnable(){

            @Override
            public void run() {
                api.keep_screen(bl);
            }
        });
    }

    private static int get_status_bar_height() {
        return api.get_status_bar_height();
    }

    private static void set_visible_status_bar(final boolean bl) {
        activity.post(new Runnable(){

            @Override
            public void run() {
                api.set_visible_status_bar(bl);
            }
        });
    }

    private static void set_status_bar_style(final int n) {
        activity.post(new Runnable(){

            @Override
            public void run() {
                api.set_status_bar_style(n);
            }
        });
    }

    private static void request_fullscreen(final boolean bl) {
        activity.post(new Runnable(){

            @Override
            public void run() {
                api.request_fullscreen(bl);
            }
        });
    }

    private static int get_orientation() {
        return api.get_orientation();
    }

    private static void set_orientation(final int n) {
        activity.post(new Runnable(){

            @Override
            public void run() {
                api.set_orientation(n);
            }
        });
    }

    private static float get_display_scale() {
        return api.get_display_scale();
    }

    private static boolean is_screen_on() {
        return api.is_screen_on();
    }

    private static void set_volume_up() {
        activity.post(new Runnable(){

            @Override
            public void run() {
                api.set_volume_up();
            }
        });
    }

    private static void set_volume_down() {
        activity.post(new Runnable(){

            @Override
            public void run() {
                api.set_volume_down();
            }
        });
    }

    private static void open_url(final String string) {
        activity.post(new Runnable(){

            @Override
            public void run() {
                api.open_url(string);
            }
        });
    }

    private static void send_email(final String string, final String string2, final String string3, final String string4, final String string5) {
        activity.post(new Runnable(){

            @Override
            public void run() {
                api.send_email(string, string2, string3, string4, string5);
            }
        });
    }

    private static String start_path() {
        return activity.start_path();
    }

    private static String package_code_path() {
        return activity.getPackageCodePath();
    }

    private static String files_dir_path() {
        return activity.getFilesDir().getPath();
    }

    private static String cache_dir_path() {
        return activity.getCacheDir().getPath();
    }

    private static String version() {
        return Build.VERSION.RELEASE;
    }

    private static String brand() {
        return Build.BRAND;
    }

    private static String subsystem() {
        return Build.MODEL;
    }

    private static int network_status() {
        ConnectivityManager connectivityManager = (ConnectivityManager)activity.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isAvailable()) {
            int n = networkInfo.getType();
            if (n == 1) {
                return 2;
            }
            if (n == 0) {
                int n2 = networkInfo.getSubtype();
                TelephonyManager telephonyManager = (TelephonyManager)activity.getSystemService("phone");
                if (n2 == 13) {
                    return 5;
                }
                if (n2 == 3 || n2 == 8 || n2 == 5) {
                    return 5;
                }
                if (n2 == 1 || n2 == 2 || n2 == 4) {
                    return 4;
                }
                return 4;
            }
        }
        return 0;
    }

    private static boolean is_ac_power() {
        if (Android.is_battery()) {
            switch (battery_status) {
                case 2: {
                    return true;
                }
                case 3: {
                    return false;
                }
            }
            return is_ac_power_connected;
        }
        return true;
    }

    private static boolean is_battery() {
        BatteryManager batteryManager = (BatteryManager)activity.getSystemService("batterymanager");
        int n = batteryManager.getIntProperty(1);
        return n > 0;
    }

    private static float battery_level() {
        if (Android.is_battery()) {
            BatteryManager batteryManager = (BatteryManager)activity.getSystemService("batterymanager");
            float f = (float)batteryManager.getIntProperty(4) / 100.0f;
            return f;
        }
        return 0.0f;
    }

    private static String language() {
        return Locale.getDefault().toString();
    }

    private static ActivityManager.MemoryInfo memory_info() {
        ActivityManager activityManager = (ActivityManager)activity.getSystemService("activity");
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(memoryInfo);
        return memoryInfo;
    }

    private static long available_memory() {
        return Android.memory_info().availMem;
    }

    private static long memory() {
        return Android.memory_info().totalMem;
    }

    private static long used_memory() {
        ActivityManager activityManager = (ActivityManager)activity.getSystemService("activity");
        List list = activityManager.getRunningAppProcesses();
        int n = Process.myPid();
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
            if (runningAppProcessInfo.pid != n) continue;
            Debug.MemoryInfo[] memoryInfoArray = activityManager.getProcessMemoryInfo(new int[]{n});
            return memoryInfoArray[0].dalvikPrivateDirty * 1024;
        }
        return 0L;
    }
}

