/*
 * Decompiled with CFR 0.152.
 */
package org.ngui;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import java.util.Date;

public class IMEReceiver
extends EditText {
    private boolean m_has_open = false;
    private long m_action_time = 0L;
    private InputMethodManager m_imm = null;
    private ImplementsInputConnection m_ic = null;
    private boolean m_can_backspace = false;
    private boolean m_can_delete = false;
    private int m_keyboard_type = 0;
    private int m_keyboard_return_type = 0;
    private int m_inputType = 1;
    private int m_imeOptions = 1;
    private StringBuilder m_text = new StringBuilder();
    private CharSequence m_marked = null;

    private static native void dispatchIMEDelete(int var0);

    private static native void dispatchIMEInsert(String var0);

    private static native void dispatchIMEMarked(String var0);

    private static native void dispatchIMEUnmark(String var0);

    private static native void dispatchKeyboardInput(int var0, boolean var1, boolean var2, int var3, int var4, int var5);

    public IMEReceiver(Context context) {
        super(context);
        this.m_imm = (InputMethodManager)context.getSystemService("input_method");
    }

    public void open() {
        this.m_has_open = true;
        this.m_action_time = new Date().getTime();
        this.setVisibility(0);
        this.requestFocus();
        this.m_imm.showSoftInput((View)this, 0);
    }

    public void close() {
        this.m_has_open = false;
        this.setVisibility(4);
        this.clearFocus();
        this.m_imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
    }

    private void finish() {
        if (this.m_marked != null) {
            IMEReceiver.dispatchIMEUnmark(this.m_marked.toString());
            this.m_marked = null;
        }
    }

    public void clear() {
        this.m_text = new StringBuilder();
        this.m_marked = null;
        this.m_can_backspace = true;
        this.m_can_delete = true;
        this.m_keyboard_type = 0;
        this.m_keyboard_return_type = 0;
        this.m_inputType = 1;
        this.m_imeOptions = 1;
        this.setInputType(this.m_inputType);
        this.setImeOptions(this.m_imeOptions);
    }

    void set_can_backspace(boolean bl, boolean bl2) {
        this.m_can_backspace = bl;
        this.m_can_delete = bl2;
    }

    void set_keyboard_type(int n) {
        if (n == this.m_keyboard_type) {
            return;
        }
        this.m_action_time = new Date().getTime();
        this.m_keyboard_type = n;
        switch (n) {
            default: {
                this.m_inputType = 1;
                break;
            }
            case 53: 
            case 63: {
                this.m_inputType = 1;
                this.m_imeOptions = Integer.MIN_VALUE;
                break;
            }
            case 54: 
            case 56: {
                this.m_inputType = 2;
                break;
            }
            case 60: {
                this.m_inputType = 12290;
            }
            case 55: {
                this.m_inputType = 17;
                break;
            }
            case 57: {
                this.m_inputType = 3;
                break;
            }
            case 58: {
                this.m_inputType = 97;
                break;
            }
            case 59: {
                this.m_inputType = 33;
                break;
            }
            case 61: {
                this.m_inputType = 65;
                break;
            }
            case 62: {
                this.m_inputType = 1;
                this.m_imeOptions = 2;
            }
        }
        this.setInputType(this.m_inputType);
        this.setInputType(this.m_imeOptions);
    }

    void set_keyboard_return_type(int n) {
        if (n == this.m_keyboard_return_type) {
            return;
        }
        this.m_action_time = new Date().getTime();
        this.m_keyboard_return_type = n;
        switch (n) {
            default: {
                this.m_imeOptions = 1;
                break;
            }
            case 64: {
                this.m_imeOptions = 2;
                break;
            }
            case 65: {
                this.m_imeOptions = 1;
                break;
            }
            case 66: {
                this.m_imeOptions = 5;
                break;
            }
            case 67: {
                this.m_imeOptions = 1;
                break;
            }
            case 68: {
                this.m_imeOptions = 3;
                break;
            }
            case 69: {
                this.m_imeOptions = 4;
                break;
            }
            case 70: {
                this.m_imeOptions = 6;
                break;
            }
            case 71: {
                this.m_imeOptions = 1;
                break;
            }
            case 72: {
                this.m_imeOptions = 1;
            }
        }
        this.setImeOptions(this.m_imeOptions);
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        super.onKeyDown(n, keyEvent);
        return true;
    }

    public boolean onCheckIsTextEditor() {
        return this.m_has_open;
    }

    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        if (this.m_ic == null) {
            this.m_ic = new ImplementsInputConnection(this);
        }
        editorInfo.inputType = this.m_inputType;
        editorInfo.imeOptions = this.m_imeOptions | 0x2000000 | 0x10000000;
        return this.m_ic;
    }

    private static class ImplementsInputConnection
    implements InputConnection {
        private IMEReceiver m_host = null;

        ImplementsInputConnection(IMEReceiver iMEReceiver) {
            this.m_host = iMEReceiver;
        }

        public CharSequence getTextBeforeCursor(int n, int n2) {
            if (this.m_host.m_text.length() > 4) {
                return this.m_host.m_text.substring(this.m_host.m_text.length() - 4, this.m_host.m_text.length());
            }
            return this.m_host.m_text;
        }

        public CharSequence getTextAfterCursor(int n, int n2) {
            return "";
        }

        public CharSequence getSelectedText(int n) {
            return "";
        }

        public int getCursorCapsMode(int n) {
            return 0;
        }

        public ExtractedText getExtractedText(ExtractedTextRequest extractedTextRequest, int n) {
            return null;
        }

        public boolean deleteSurroundingText(int n, int n2) {
            if (this.m_host.m_text.length() > n) {
                this.m_host.m_text.delete(this.m_host.m_text.length() - n, this.m_host.m_text.length());
            } else {
                this.m_host.m_text.delete(0, this.m_host.m_text.length());
            }
            if (n == 1) {
                IMEReceiver.dispatchIMEDelete(-1);
            } else {
                IMEReceiver.dispatchIMEDelete(-n);
            }
            return true;
        }

        public boolean deleteSurroundingTextInCodePoints(int n, int n2) {
            return true;
        }

        public boolean setComposingText(CharSequence charSequence, int n) {
            this.m_host.m_marked = charSequence;
            IMEReceiver.dispatchIMEMarked(charSequence.toString());
            return true;
        }

        public boolean setComposingRegion(int n, int n2) {
            return true;
        }

        public boolean finishComposingText() {
            this.m_host.finish();
            return true;
        }

        private void ime_insert(String string) {
            this.m_host.m_text.append(string);
            if (this.m_host.m_marked == null) {
                IMEReceiver.dispatchIMEInsert(string.toString());
            } else {
                this.m_host.m_marked = null;
                IMEReceiver.dispatchIMEUnmark(string.toString());
            }
        }

        public boolean commitText(CharSequence charSequence, int n) {
            boolean bl;
            boolean bl2 = bl = charSequence.length() == 1 && charSequence.charAt(0) < '\u0080';
            if (bl) {
                IMEReceiver.dispatchKeyboardInput(charSequence.charAt(0), true, true, 0, -1, 0);
            }
            this.ime_insert(charSequence.toString());
            if (bl) {
                IMEReceiver.dispatchKeyboardInput(charSequence.charAt(0), true, false, 0, -1, 0);
            }
            return true;
        }

        public boolean commitCompletion(CompletionInfo completionInfo) {
            return true;
        }

        public boolean commitCorrection(CorrectionInfo correctionInfo) {
            return true;
        }

        public boolean setSelection(int n, int n2) {
            return true;
        }

        public boolean performEditorAction(int n) {
            this.m_host.m_text.append("\n");
            IMEReceiver.dispatchKeyboardInput(13, true, true, 0, -1, 0);
            IMEReceiver.dispatchIMEInsert("\n");
            IMEReceiver.dispatchKeyboardInput(13, true, false, 0, -1, 0);
            return true;
        }

        public boolean performContextMenuAction(int n) {
            return true;
        }

        public boolean beginBatchEdit() {
            return false;
        }

        public boolean endBatchEdit() {
            return false;
        }

        public boolean sendKeyEvent(KeyEvent keyEvent) {
            IMEReceiver.dispatchKeyboardInput(keyEvent.getKeyCode(), false, keyEvent.getAction() == 0, keyEvent.getRepeatCount(), keyEvent.getDeviceId(), keyEvent.getSource());
            if (keyEvent.getAction() == 0) {
                if (keyEvent.getKeyCode() == 67) {
                    if (this.m_host.m_text.length() > 0) {
                        this.m_host.m_text.deleteCharAt(this.m_host.m_text.length() - 1);
                    }
                    IMEReceiver.dispatchIMEDelete(-1);
                } else if (keyEvent.getKeyCode() >= 7 && keyEvent.getKeyCode() <= 16) {
                    char c = '0';
                    c = (char)(c + (keyEvent.getKeyCode() - 7));
                    this.ime_insert(Character.toString(c));
                } else if (keyEvent.getKeyCode() >= 29 && keyEvent.getKeyCode() <= 54) {
                    char c = 'A';
                    c = (char)(c + (keyEvent.getKeyCode() - 29));
                    this.ime_insert(Character.toString(c));
                } else {
                    Log.d((String)"IMEReceiver", (String)String.format("keycode:%s", keyEvent.getKeyCode()));
                }
            }
            return true;
        }

        public boolean clearMetaKeyStates(int n) {
            return true;
        }

        public boolean reportFullscreenMode(boolean bl) {
            return true;
        }

        public boolean performPrivateCommand(String string, Bundle bundle) {
            return true;
        }

        public boolean requestCursorUpdates(int n) {
            return true;
        }

        public Handler getHandler() {
            return null;
        }

        public void closeConnection() {
            this.m_host.finish();
        }
    }
}

