/*
 * Decompiled with CFR 0.152.
 */
package org.ngui;

import android.app.NativeActivity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.res.Configuration;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.widget.FrameLayout;
import org.ngui.Android;
import org.ngui.IMEReceiver;

public class NGUIActivity
extends NativeActivity
implements View.OnSystemUiVisibilityChangeListener {
    private static String TAG = "NGUI";
    private IMEReceiver m_receiver = null;
    private Handler m_handler = null;
    private PowerManager pm = null;
    private AudioManager am = null;
    private static boolean visible_status_bar = true;
    private static int status_bar_style = 0;
    private static boolean is_fullscreen = false;
    private static int screen_orientation = 2;
    private static boolean virtual_navigation_device;

    private static native void onStatucBarVisibleChange();

    private void set_system_ui_flags() {
        Window window = this.getWindow();
        int n = 1024;
        n |= 0x100;
        if (is_fullscreen || !visible_status_bar) {
            n |= 4;
            window.addFlags(1024);
        } else {
            window.clearFlags(1024);
        }
        if (is_fullscreen) {
            n |= 2;
            n |= 0x200;
            n |= 0x1000;
            n |= 0x800;
        }
        if (status_bar_style == 1) {
            n |= 0x2000;
        }
        window.getDecorView().setSystemUiVisibility(n);
        window.addFlags(Integer.MIN_VALUE);
        window.clearFlags(0x4000000);
        window.clearFlags(0x8000000);
        window.setStatusBarColor(0);
        window.setNavigationBarColor(0);
    }

    private boolean is_virtual_navigation_device() {
        Display display = this.getWindowManager().getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        DisplayMetrics displayMetrics2 = new DisplayMetrics();
        display.getRealMetrics(displayMetrics);
        display.getMetrics(displayMetrics2);
        return displayMetrics.widthPixels != displayMetrics2.widthPixels || displayMetrics.heightPixels != displayMetrics2.heightPixels;
    }

    public void post(Runnable runnable) {
        this.m_handler.post(runnable);
    }

    public void onSystemUiVisibilityChange(int n) {
        this.set_system_ui_flags();
    }

    protected void onCreate(Bundle bundle) {
        virtual_navigation_device = this.is_virtual_navigation_device();
        this.m_handler = new Handler(Looper.getMainLooper());
        this.pm = (PowerManager)this.getSystemService("power");
        this.am = (AudioManager)this.getSystemService("audio");
        Android.initialize(this, new PrivateAPI(this));
        this.set_system_ui_flags();
        this.getWindow().getDecorView().setOnSystemUiVisibilityChangeListener((View.OnSystemUiVisibilityChangeListener)this);
        this.setRequestedOrientation(screen_orientation);
        super.onCreate(bundle);
    }

    protected void onDestroy() {
        Android.uninitialize(this);
        super.onDestroy();
    }

    public void onConfigurationChanged(Configuration configuration) {
        Log.d((String)TAG, (String)"onConfigurationChanged");
        super.onConfigurationChanged(configuration);
    }

    protected String start_path() {
        return "";
    }

    protected boolean is_debugger() {
        ApplicationInfo applicationInfo = this.getApplicationInfo();
        return (applicationInfo.flags & 2) != 0;
    }

    public static class PrivateAPI {
        private NGUIActivity host = null;

        private PrivateAPI(NGUIActivity nGUIActivity) {
            this.host = nGUIActivity;
        }

        public void ime_keyboard_open(boolean bl, int n, int n2) {
            Log.d((String)TAG, (String)"ime_keyboard_open");
            if (this.host.m_receiver == null) {
                this.host.m_receiver = new IMEReceiver((Context)this.host);
                ((FrameLayout)this.host.findViewById(0x1020002)).addView((View)this.host.m_receiver);
            }
            if (bl) {
                this.host.m_receiver.clear();
            }
            this.host.m_receiver.set_keyboard_return_type(n2);
            this.host.m_receiver.set_keyboard_type(n);
            this.host.m_receiver.open();
        }

        public void ime_keyboard_can_backspace(boolean bl, boolean bl2) {
            Log.d((String)TAG, (String)"ime_keyboard_can_backspace");
            if (this.host.m_receiver != null) {
                this.host.m_receiver.set_can_backspace(bl, bl2);
            }
        }

        public void ime_keyboard_close() {
            Log.d((String)TAG, (String)"ime_keyboard_close");
            if (this.host.m_receiver != null) {
                this.host.m_receiver.close();
            }
        }

        public void keep_screen(boolean bl) {
            if (bl) {
                this.host.getWindow().addFlags(128);
            } else {
                this.host.getWindow().clearFlags(128);
            }
        }

        public int get_status_bar_height() {
            int n;
            int n2 = 0;
            if (visible_status_bar && !is_fullscreen && (n = this.host.getResources().getIdentifier("status_bar_height", "dimen", "android")) > 0) {
                n2 = this.host.getResources().getDimensionPixelSize(n);
            }
            return n2;
        }

        public void set_visible_status_bar(boolean bl) {
            if (visible_status_bar != bl) {
                int n = this.get_status_bar_height();
                visible_status_bar = bl;
                this.host.set_system_ui_flags();
                int n2 = this.get_status_bar_height();
                if (n != n2) {
                    NGUIActivity.onStatucBarVisibleChange();
                }
            }
        }

        public void set_status_bar_style(int n) {
            if (status_bar_style != n) {
                status_bar_style = n;
                this.host.set_system_ui_flags();
            }
        }

        public void request_fullscreen(boolean bl) {
            if (is_fullscreen != bl) {
                int n = virtual_navigation_device ? 0 : this.get_status_bar_height();
                is_fullscreen = bl;
                this.host.set_system_ui_flags();
                int n2 = this.get_status_bar_height();
                if (!virtual_navigation_device && n != n2) {
                    NGUIActivity.onStatucBarVisibleChange();
                }
            }
        }

        public int get_orientation() {
            int n = this.host.getWindowManager().getDefaultDisplay().getRotation();
            switch (n) {
                default: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: 
            }
            return 3;
        }

        public void set_orientation(int n) {
            switch (n) {
                case 0: {
                    screen_orientation = 1;
                    break;
                }
                case 1: {
                    screen_orientation = 0;
                    break;
                }
                case 2: {
                    screen_orientation = 9;
                    break;
                }
                case 3: {
                    screen_orientation = 8;
                    break;
                }
                default: {
                    screen_orientation = 2;
                    break;
                }
                case 5: {
                    screen_orientation = 12;
                    break;
                }
                case 6: {
                    screen_orientation = 11;
                    break;
                }
                case 7: {
                    screen_orientation = 14;
                }
            }
            this.host.setRequestedOrientation(screen_orientation);
        }

        public float get_display_scale() {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            this.host.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
            return displayMetrics.scaledDensity;
        }

        public boolean is_screen_on() {
            boolean bl = this.host.pm.isScreenOn();
            return bl;
        }

        public void set_volume_up() {
            this.host.am.adjustVolume(1, 5);
        }

        public void set_volume_down() {
            this.host.am.adjustVolume(-1, 5);
        }

        public void open_url(String string) {
            Intent intent = new Intent();
            intent.setAction("android.intent.action.VIEW");
            Uri uri = Uri.parse((String)string);
            intent.setData(uri);
            this.host.startActivity(intent);
        }

        public void send_email(String string, String string2, String string3, String string4, String string5) {
            Intent intent = new Intent("android.intent.action.SENDTO");
            String string6 = "mailto:" + string;
            string6 = string6 + "?cc=" + string3;
            string6 = string6 + "&bcc=" + string4;
            intent.setData(Uri.parse((String)string6));
            intent.putExtra("android.intent.extra.SUBJECT", string2);
            intent.putExtra("android.intent.extra.TEXT", string5);
            this.host.startActivity(intent);
        }
    }
}

