/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DriverManager;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class JdbcConnection {
    public static final int TYPE_TIME_STAMP = 93;
    public static final int TYPE_DATE = 91;
    public static final int NUMBER_OF_THREADS = 5;
    String connectionString;
    String username;
    String password;
    String timezone;
    Properties props;
    Connection conn;
    DateFormat df;
    ExecutorService executor = Executors.newFixedThreadPool(5);

    public JdbcConnection(String connectionString, String username, String password, String timezone) {
        this(connectionString, username, password, timezone, new Properties());
    }

    public JdbcConnection(String connectionString, String username, String password, String timezone, Properties props) {
        this.connectionString = connectionString;
        this.username = username;
        this.password = password;
        this.timezone = timezone;
        this.props = props;
        this.props.put("USER", username);
        this.props.put("PASSWORD", password);
        if (timezone.isEmpty()) {
            this.df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        } else {
            this.df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            this.df.setTimeZone(TimeZone.getTimeZone(timezone));
        }
    }

    public boolean connect() {
        try {
            this.conn = DriverManager.getConnection(this.connectionString, this.props);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return false;
        }
    }

    public void execSQL(SQLRequest request) {
        Future<String> f = this.executor.submit(new ExecSQLCallable(this.conn, this.df, request));
    }

    public boolean close() {
        try {
            this.conn.close();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return false;
        }
    }
}

