/*
 * Decompiled with CFR 0.152.
 */
import java.util.LinkedHashMap;
import java.util.Map;
import net.minidev.json.JSONObject;

public class Main
implements SQLRequestListener {
    Map dbMap = new LinkedHashMap();
    int connectCount = 0;
    StdInputReader input = new StdInputReader();

    public static void main(String[] args) {
        Main m = new Main();
    }

    public Main() {
        this.input.addListener(this);
        this.input.startReadLoop();
    }

    @Override
    public void connect(ConnectRequest request) {
        JSONObject response = new JSONObject();
        response.put((Object)"msgId", (Object)request.msgId);
        MyProperties props = new MyProperties("sybaseConfig.properties");
        JdbcConnection db = new JdbcConnection(request.connectionString, request.username, request.password, request.timezone, props.properties);
        if (!db.connect()) {
            response.put((Object)"error", (Object)"connect failed");
        } else {
            ++this.connectCount;
            this.dbMap.put(this.connectCount, db);
            response.put((Object)"result", (Object)"connected");
            response.put((Object)"dbId", (Object)this.connectCount);
        }
        response.put((Object)"javaStartTime", (Object)request.javaStartTime);
        long beforeParse = System.currentTimeMillis();
        response.put((Object)"javaEndTime", (Object)beforeParse);
        System.out.println(response.toJSONString());
    }

    @Override
    public void sqlRequest(SQLRequest request) {
        JdbcConnection db = (JdbcConnection)this.dbMap.get(request.dbId);
        db.execSQL(request);
    }

    @Override
    public void close(CloseRequest request) {
        JdbcConnection db = (JdbcConnection)this.dbMap.get(request.dbId);
        db.close();
        this.dbMap.remove(request.dbId);
        JSONObject response = new JSONObject();
        response.put((Object)"msgId", (Object)request.msgId);
        response.put((Object)"dbId", (Object)request.dbId);
        response.put((Object)"result", (Object)"closed");
        System.out.println(response.toJSONString());
        db = null;
    }
}

