/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;

public class StdInputReader {
    private List<SQLRequestListener> listeners = new ArrayList<SQLRequestListener>();
    private BufferedReader inputBuffer = new BufferedReader(new InputStreamReader(System.in));

    public void startReadLoop() {
        try {
            String nextLine;
            while ((nextLine = this.inputBuffer.readLine()) != null) {
                nextLine = nextLine.replaceAll("\\n", "\n");
                this.sendEvent(nextLine);
            }
        }
        catch (IOException ex) {
            System.err.println("IO exception: " + ex);
        }
    }

    private void sendEvent(String sqlRequest) {
        long startTime = System.currentTimeMillis();
        try {
            JSONObject val = (JSONObject)JSONValue.parse((String)sqlRequest);
            String type = (String)val.get((Object)"type");
            if (type.equals("connect")) {
                ConnectRequest request = new ConnectRequest();
                request.msgId = (Integer)val.get((Object)"msgId");
                request.connectionString = (String)val.get((Object)"connectionString");
                request.username = (String)val.get((Object)"username");
                request.password = (String)val.get((Object)"password");
                request.timezone = (String)val.get((Object)"timezone");
                request.javaStartTime = startTime;
                for (SQLRequestListener l : this.listeners) {
                    l.connect(request);
                }
            } else if (type.equals("close")) {
                CloseRequest request = new CloseRequest();
                request.msgId = (Integer)val.get((Object)"msgId");
                request.dbId = (Integer)val.get((Object)"dbId");
                for (SQLRequestListener l : this.listeners) {
                    l.close(request);
                }
            } else {
                SQLRequest request = new SQLRequest();
                request.msgId = (Integer)val.get((Object)"msgId");
                request.dbId = (Integer)val.get((Object)"dbId");
                request.sql = (String)val.get((Object)"sql");
                request.javaStartTime = startTime;
                for (SQLRequestListener l : this.listeners) {
                    l.sqlRequest(request);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.err.println("Error parsing json not a valid SQLRequest object.");
        }
    }

    public boolean addListener(SQLRequestListener l) {
        if (this.listeners.contains(l)) {
            return false;
        }
        this.listeners.add(l);
        return true;
    }

    public boolean removeListener(SQLRequestListener l) {
        return this.listeners.remove(l);
    }
}

