/*
 * Decompiled with CFR 0.152.
 */
package club.garimpeiro.keysender;

import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.util.OptionalLong;
import java.util.stream.IntStream;
import org.apache.commons.cli.CommandLine;

public class Processor {
    protected CommandLine cmd;
    protected static Robot robot;

    public Processor(CommandLine cmd) {
        this.cmd = cmd;
        try {
            robot = new Robot();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void process() {
        try {
            String pdelay = this.cmd.getOptionValue("pdelay");
            String sdelay = this.cmd.getOptionValue("sdelay");
            String delay = this.cmd.getOptionValue("delay");
            if (pdelay != null) {
                robot.setAutoDelay(Integer.parseInt(pdelay));
            }
            if (sdelay != null) {
                robot.delay(Integer.parseInt(sdelay));
            }
            for (String arg : this.cmd.getArgList()) {
                int localDelay = this.getDelayArgument(arg);
                String keyArg = this.getKeyArgument(arg);
                Boolean isUp = this.getUpArgument(arg);
                Boolean isDown = this.getDownArgument(arg);
                Boolean hold = true;
                Boolean release = true;
                if (isUp.booleanValue() || isDown.booleanValue()) {
                    hold = isDown;
                    release = isUp;
                }
                if (arg.contains("-")) {
                    this.processCombination(keyArg, hold, release);
                } else {
                    this.processKey(keyArg, hold, release);
                }
                if (delay == null && localDelay == 0) continue;
                robot.delay(localDelay != 0 ? localDelay : Integer.parseInt(delay));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getKeyArgument(String arg) {
        String[] args = arg.split("\\.");
        if (args.length > 0) {
            return args[0];
        }
        return "";
    }

    protected int getDelayArgument(String arg) {
        String[] args = arg.split("\\.");
        OptionalLong delay = IntStream.range(1, args.length).filter(i -> args[i].startsWith("w")).mapToLong(i -> Long.parseLong(args[i].substring(1))).findFirst();
        if (delay.isPresent()) {
            return (int)delay.getAsLong();
        }
        return 0;
    }

    protected Boolean getUpArgument(String arg) {
        String[] args = arg.split("\\.");
        long count = IntStream.range(1, args.length).filter(i -> args[i].equals("up")).count();
        return count > 0L;
    }

    protected Boolean getDownArgument(String arg) {
        String[] args = arg.split("\\.");
        long count = IntStream.range(1, args.length).filter(i -> args[i].equals("down")).count();
        return count > 0L;
    }

    protected void processKey(String arg, Boolean hold, Boolean release) {
        if (arg.startsWith("@")) {
            String[] args = arg.split("@");
            int keyCode = Integer.parseInt(args[1]);
            this.typeKey(keyCode, false, hold, release);
        } else {
            int keyCode = this.getKeyConstantValue(arg);
            this.typeKey(keyCode, this.isUpperCase(arg), hold, release);
        }
    }

    protected void processCombination(String args, Boolean hold, Boolean release) {
        if (hold.booleanValue()) {
            for (String arg : args.split("-")) {
                this.processKey(arg, true, false);
            }
        }
        if (release.booleanValue()) {
            for (String arg : args.split("-")) {
                this.processKey(arg, false, true);
            }
        }
    }

    protected void typeKey(int key, Boolean upperCase, Boolean hold, Boolean release) {
        if (key == 0 || !hold.booleanValue() && !release.booleanValue()) {
            return;
        }
        String caseCorrection = this.cmd.getOptionValue("case-correction", "1");
        Boolean isLetter = key >= 65 && key <= 90;
        Boolean holdShift = upperCase != false && this.isCapsLockOff() != false || upperCase == false && this.isCapsLockOff() == false;
        if (holdShift.booleanValue() && caseCorrection.equals("1") && isLetter.booleanValue()) {
            robot.keyPress(16);
        }
        if (hold.booleanValue()) {
            robot.keyPress(key);
        }
        if (release.booleanValue()) {
            robot.keyRelease(key);
        }
        if (holdShift.booleanValue() && caseCorrection.equals("1") && isLetter.booleanValue()) {
            robot.keyRelease(16);
        }
    }

    protected int getKeyConstantValue(String letter) {
        int keyCode = 0;
        try {
            String keyConstant = "VK_" + letter.toUpperCase();
            keyCode = KeyEvent.class.getField(keyConstant).getInt(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return keyCode;
    }

    protected Boolean isUpperCase(String letter) {
        return Character.isUpperCase(letter.charAt(0));
    }

    protected Boolean isCapsLockOff() {
        return !Toolkit.getDefaultToolkit().getLockingKeyState(20);
    }
}

